/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.util.Vector;
import sk.adonikeoffice.epicchat.lib.EntityUtil;
import sk.adonikeoffice.epicchat.lib.MathUtil;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.RandomUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

public final class BlockUtil {
    private static final Pattern SLAB_PATTERN = Pattern.compile("(?!DOUBLE).*STEP");
    private static final BlockFace[] TREE_TRUNK_FACES = new BlockFace[]{BlockFace.UP, BlockFace.WEST, BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH};
    private static final Set<String> TREE_GROUND_BLOCKS = Sets.newHashSet((Object[])new String[]{"GRASS_BLOCK", "COARSE_DIRT", "DIRT", "MYCELIUM", "PODZOL"});
    public static double BOUNDING_VERTICAL_GAP = 1.0;
    public static double BOUNDING_HORIZONTAL_GAP = 1.0;

    public static boolean isWithinCuboid(Location location, Location primary, Location secondary) {
        double locX = location.getX();
        double locY = location.getY();
        double locZ = location.getZ();
        int x = primary.getBlockX();
        int y = primary.getBlockY();
        int z = primary.getBlockZ();
        int x1 = secondary.getBlockX();
        int y1 = secondary.getBlockY();
        int z1 = secondary.getBlockZ();
        return (locX >= (double)x && locX <= (double)x1 || locX <= (double)x && locX >= (double)x1) && (locZ >= (double)z && locZ <= (double)z1 || locZ <= (double)z && locZ >= (double)z1) && (locY >= (double)y && locY <= (double)y1 || locY <= (double)y && locY >= (double)y1);
    }

    public static Set<Location> getBoundingBox(@NonNull Chunk chunk) {
        if (chunk == null) {
            throw new NullPointerException("chunk is marked non-null but is null");
        }
        int minX = chunk.getX() << 4;
        boolean minY = false;
        int minZ = chunk.getZ() << 4;
        int maxX = minX | 0xF;
        int maxY = chunk.getWorld().getMaxHeight();
        int maxZ = minZ | 0xF;
        Location primary = new Location(chunk.getWorld(), (double)minX, 0.0, (double)minZ);
        Location secondary = new Location(chunk.getWorld(), (double)maxX, (double)maxY, (double)maxZ);
        return BlockUtil.getBoundingBox(primary, secondary);
    }

    public static Set<Location> getBoundingBox(Location primary, Location secondary) {
        ArrayList<VectorHelper> shape = new ArrayList<VectorHelper>();
        VectorHelper min = BlockUtil.getMinimumPoint(primary, secondary);
        VectorHelper max = BlockUtil.getMaximumPoint(primary, secondary).add(1.0, 0.0, 1.0);
        int height = BlockUtil.getHeight(primary, secondary);
        ArrayList<VectorHelper> bottomCorners = new ArrayList<VectorHelper>();
        bottomCorners.add(new VectorHelper(min.getX(), min.getY(), min.getZ()));
        bottomCorners.add(new VectorHelper(max.getX(), min.getY(), min.getZ()));
        bottomCorners.add(new VectorHelper(max.getX(), min.getY(), max.getZ()));
        bottomCorners.add(new VectorHelper(min.getX(), min.getY(), max.getZ()));
        for (int i = 0; i < bottomCorners.size(); ++i) {
            VectorHelper p1 = (VectorHelper)bottomCorners.get(i);
            VectorHelper p2 = i + 1 < bottomCorners.size() ? (VectorHelper)bottomCorners.get(i + 1) : (VectorHelper)bottomCorners.get(0);
            VectorHelper p3 = p1.add(0.0, height, 0.0);
            VectorHelper p4 = p2.add(0.0, height, 0.0);
            shape.addAll(BlockUtil.plotLine(p1, p2));
            shape.addAll(BlockUtil.plotLine(p3, p4));
            shape.addAll(BlockUtil.plotLine(p1, p3));
            for (double offset = BOUNDING_VERTICAL_GAP; offset < (double)height; offset += BOUNDING_VERTICAL_GAP) {
                VectorHelper p5 = p1.add(0.0, offset, 0.0);
                VectorHelper p6 = p2.add(0.0, offset, 0.0);
                shape.addAll(BlockUtil.plotLine(p5, p6));
            }
        }
        HashSet<Location> locations = new HashSet<Location>();
        for (VectorHelper vector : shape) {
            locations.add(new Location(primary.getWorld(), vector.getX(), vector.getY(), vector.getZ()));
        }
        return locations;
    }

    private static List<VectorHelper> plotLine(VectorHelper p1, VectorHelper p2) {
        ArrayList<VectorHelper> ShapeVectors = new ArrayList<VectorHelper>();
        int points = (int)(p1.distance(p2) / BOUNDING_HORIZONTAL_GAP) + 1;
        double length = p1.distance(p2);
        double gap = length / (double)(points - 1);
        VectorHelper gapShapeVector = p2.subtract(p1).normalize().multiply(gap);
        for (int i = 0; i < points; ++i) {
            VectorHelper currentPoint = p1.add(gapShapeVector.multiply(i));
            ShapeVectors.add(currentPoint);
        }
        return ShapeVectors;
    }

    public static Set<Location> getSphere(Location location, int radius, boolean hollow) {
        HashSet<Location> blocks = new HashSet<Location>();
        World world = location.getWorld();
        int X = location.getBlockX();
        int Y = location.getBlockY();
        int Z = location.getBlockZ();
        int radiusSquared = radius * radius;
        if (hollow) {
            for (int x = X - radius; x <= X + radius; ++x) {
                for (int y = Y - radius; y <= Y + radius; ++y) {
                    for (int z = Z - radius; z <= Z + radius; ++z) {
                        if ((X - x) * (X - x) + (Y - y) * (Y - y) + (Z - z) * (Z - z) > radiusSquared) continue;
                        blocks.add(new Location(world, (double)x, (double)y, (double)z));
                    }
                }
            }
            return BlockUtil.makeHollow(blocks, true);
        }
        for (int x = X - radius; x <= X + radius; ++x) {
            for (int y = Y - radius; y <= Y + radius; ++y) {
                for (int z = Z - radius; z <= Z + radius; ++z) {
                    if ((X - x) * (X - x) + (Y - y) * (Y - y) + (Z - z) * (Z - z) > radiusSquared) continue;
                    blocks.add(new Location(world, (double)x, (double)y, (double)z));
                }
            }
        }
        return blocks;
    }

    public static Set<Location> getCircle(Location location, int radius, boolean hollow) {
        HashSet<Location> blocks = new HashSet<Location>();
        World world = location.getWorld();
        int initialX = location.getBlockX();
        int initialY = location.getBlockY();
        int initialZ = location.getBlockZ();
        int radiusSquared = radius * radius;
        if (hollow) {
            for (int x = initialX - radius; x <= initialX + radius; ++x) {
                for (int z = initialZ - radius; z <= initialZ + radius; ++z) {
                    if ((initialX - x) * (initialX - x) + (initialZ - z) * (initialZ - z) > radiusSquared) continue;
                    blocks.add(new Location(world, (double)x, (double)initialY, (double)z));
                }
            }
            return BlockUtil.makeHollow(blocks, false);
        }
        for (int x = initialX - radius; x <= initialX + radius; ++x) {
            for (int z = initialZ - radius; z <= initialZ + radius; ++z) {
                if ((initialX - x) * (initialX - x) + (initialZ - z) * (initialZ - z) > radiusSquared) continue;
                blocks.add(new Location(world, (double)x, (double)initialY, (double)z));
            }
        }
        return blocks;
    }

    private static Set<Location> makeHollow(Set<Location> blocks, boolean sphere) {
        HashSet<Location> edge = new HashSet<Location>();
        if (!sphere) {
            for (Location location : blocks) {
                World world = location.getWorld();
                int x = location.getBlockX();
                int y = location.getBlockY();
                int z = location.getBlockZ();
                Location front = new Location(world, (double)(x + 1), (double)y, (double)z);
                Location back = new Location(world, (double)(x - 1), (double)y, (double)z);
                Location left = new Location(world, (double)x, (double)y, (double)(z + 1));
                Location right = new Location(world, (double)x, (double)y, (double)(z - 1));
                if (blocks.contains(front) && blocks.contains(back) && blocks.contains(left) && blocks.contains(right)) continue;
                edge.add(location);
            }
            return edge;
        }
        for (Location location : blocks) {
            World world = location.getWorld();
            int x = location.getBlockX();
            int y = location.getBlockY();
            int z = location.getBlockZ();
            Location front = new Location(world, (double)(x + 1), (double)y, (double)z);
            Location back = new Location(world, (double)(x - 1), (double)y, (double)z);
            Location left = new Location(world, (double)x, (double)y, (double)(z + 1));
            Location right = new Location(world, (double)x, (double)y, (double)(z - 1));
            Location top = new Location(world, (double)x, (double)(y + 1), (double)z);
            Location bottom = new Location(world, (double)x, (double)(y - 1), (double)z);
            if (blocks.contains(front) && blocks.contains(back) && blocks.contains(left) && blocks.contains(right) && blocks.contains(top) && blocks.contains(bottom)) continue;
            edge.add(location);
        }
        return edge;
    }

    public static List<Block> getBlocks(Location primary, Location secondary) {
        Valid.checkNotNull(primary, "Primary region point must be set!");
        Valid.checkNotNull(secondary, "Secondary region point must be set!");
        ArrayList<Block> blocks = new ArrayList<Block>();
        int topBlockX = primary.getBlockX() < secondary.getBlockX() ? secondary.getBlockX() : primary.getBlockX();
        int bottomBlockX = primary.getBlockX() > secondary.getBlockX() ? secondary.getBlockX() : primary.getBlockX();
        int topBlockY = primary.getBlockY() < secondary.getBlockY() ? secondary.getBlockY() : primary.getBlockY();
        int bottomBlockY = primary.getBlockY() > secondary.getBlockY() ? secondary.getBlockY() : primary.getBlockY();
        int topBlockZ = primary.getBlockZ() < secondary.getBlockZ() ? secondary.getBlockZ() : primary.getBlockZ();
        int bottomBlockZ = primary.getBlockZ() > secondary.getBlockZ() ? secondary.getBlockZ() : primary.getBlockZ();
        for (int x = bottomBlockX; x <= topBlockX; ++x) {
            for (int z = bottomBlockZ; z <= topBlockZ; ++z) {
                for (int y = bottomBlockY; y <= topBlockY; ++y) {
                    Block block = primary.getWorld().getBlockAt(x, y, z);
                    if (block == null) continue;
                    blocks.add(block);
                }
            }
        }
        return blocks;
    }

    public static List<Block> getBlocks(@NonNull Chunk chunk) {
        if (chunk == null) {
            throw new NullPointerException("chunk is marked non-null but is null");
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        int minX = chunk.getX() << 4;
        int minZ = chunk.getZ() << 4;
        int maxX = minX | 0xF;
        int maxY = chunk.getWorld().getMaxHeight();
        int maxZ = minZ | 0xF;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = 0; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    blocks.add(chunk.getBlock(x, y, z));
                }
            }
        }
        return blocks;
    }

    public static List<Block> getBlocks(Location loc, int height, int radius) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int y = 0; y < height; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    Block checkBlock = loc.getBlock().getRelative(x, y, z);
                    if (checkBlock == null || checkBlock.getType() == Material.AIR) continue;
                    blocks.add(checkBlock);
                }
            }
        }
        return blocks;
    }

    public static List<Chunk> getChunks(Location location, int radius) {
        HashSet<Chunk> addedChunks = new HashSet<Chunk>();
        World world = location.getWorld();
        int chunkX = location.getBlockX() >> 4;
        int chunkZ = location.getBlockZ() >> 4;
        for (int x = chunkX - radius; x <= chunkX + radius; ++x) {
            for (int z = chunkZ - radius; z <= chunkZ + radius; ++z) {
                if (!world.isChunkLoaded(x, z)) continue;
                addedChunks.add(world.getChunkAt(x, z));
            }
        }
        return new ArrayList<Chunk>(addedChunks);
    }

    public static List<Location> getXZLocations(Chunk chunk) {
        ArrayList<Location> found = new ArrayList<Location>();
        int chunkX = chunk.getX() << 4;
        int chunkZ = chunk.getZ() << 4;
        for (int x = chunkX; x < chunkX + 16; ++x) {
            for (int z = chunkZ; z < chunkZ + 16; ++z) {
                found.add(new Location(chunk.getWorld(), (double)x, 0.0, (double)z));
            }
        }
        return found;
    }

    public static List<Block> getTreePartsUp(Block treeBase) {
        Material baseMaterial = treeBase.getState().getType();
        String logType = MinecraftVersion.atLeast(MinecraftVersion.V.v1_13) ? baseMaterial.toString() : "LOG";
        String leaveType = MinecraftVersion.atLeast(MinecraftVersion.V.v1_13) ? logType.replace("_LOG", "") + "_LEAVES" : "LEAVES";
        HashSet<Block> treeParts = new HashSet<Block>();
        HashSet<Block> toSearch = new HashSet<Block>();
        HashSet<Block> searched = new HashSet<Block>();
        toSearch.add(treeBase.getRelative(BlockFace.UP));
        searched.add(treeBase);
        for (int cycle = 0; cycle < 1000 && !toSearch.isEmpty(); ++cycle) {
            Block block = (Block)toSearch.iterator().next();
            toSearch.remove(block);
            searched.add(block);
            if (block.getType().toString().equals(logType) || block.getType().toString().equals(leaveType)) {
                treeParts.add(block);
                for (BlockFace face : TREE_TRUNK_FACES) {
                    Block relative = block.getRelative(face);
                    if (searched.contains(relative)) continue;
                    toSearch.add(relative);
                }
                continue;
            }
            if (block.getType().isTransparent()) continue;
            return new ArrayList<Block>();
        }
        return new ArrayList<Block>(treeParts);
    }

    public static boolean isLogOnGround(Block treeBaseBlock) {
        if (!CompMaterial.isLog(treeBaseBlock.getType())) {
            return false;
        }
        while (CompMaterial.isLog(treeBaseBlock.getType())) {
            treeBaseBlock = treeBaseBlock.getRelative(BlockFace.DOWN);
        }
        return TREE_GROUND_BLOCKS.contains(CompMaterial.fromMaterial(treeBaseBlock.getType()).toString());
    }

    public static boolean isBreakingFallingBlock(Material material) {
        return material.isTransparent() && material != CompMaterial.NETHER_PORTAL.getMaterial() && material != CompMaterial.END_PORTAL.getMaterial() || material == CompMaterial.COBWEB.getMaterial() || material == Material.DAYLIGHT_DETECTOR || CompMaterial.isTrapDoor(material) || material == CompMaterial.OAK_SIGN.getMaterial() || CompMaterial.isWallSign(material) || SLAB_PATTERN.matcher(material.name()).matches();
    }

    public static boolean isTool(Material material) {
        return material.name().endsWith("AXE") || material.name().endsWith("SPADE") || material.name().endsWith("SWORD") || material.name().endsWith("HOE") || material.name().endsWith("BUCKET") || material == CompMaterial.BOW.getMaterial() || material == CompMaterial.FISHING_ROD.getMaterial() || material == CompMaterial.CLOCK.getMaterial() || material == CompMaterial.COMPASS.getMaterial() || material == CompMaterial.FLINT_AND_STEEL.getMaterial();
    }

    public static boolean isArmor(Material material) {
        return material.name().endsWith("HELMET") || material.name().endsWith("CHESTPLATE") || material.name().endsWith("LEGGINGS") || material.name().endsWith("BOOTS");
    }

    public static boolean isForBlockSelection(Material material) {
        if (!material.isBlock() || material == Material.AIR) {
            return false;
        }
        try {
            if (material.isInteractable()) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (material.hasGravity()) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return material.isSolid();
    }

    public static int findHighestBlockNoSnow(Location location) {
        return BlockUtil.findHighestBlockNoSnow(location.getWorld(), location.getBlockX(), location.getBlockZ());
    }

    public static int findHighestBlockNoSnow(World world, int x, int z) {
        for (int y = world.getMaxHeight() - 1; y > 0; --y) {
            Block block = world.getBlockAt(x, y, z);
            if (CompMaterial.isAir(block)) continue;
            if (block.getType() == CompMaterial.SNOW_BLOCK.getMaterial()) {
                return -1;
            }
            if (block.getType() == CompMaterial.SNOW.getMaterial()) continue;
            return y + 1;
        }
        return -1;
    }

    public static int findHighestBlock(Location location, Predicate<Material> predicate) {
        return BlockUtil.findHighestBlock(location.getWorld(), location.getBlockX(), location.getBlockZ(), predicate);
    }

    public static int findHighestBlock(World world, int x, int z, Predicate<Material> predicate) {
        int minHeight = MinecraftVersion.atLeast(MinecraftVersion.V.v1_18) ? world.getMinHeight() : 0;
        for (int y = world.getMaxHeight() - 1; y > minHeight; --y) {
            Block block = world.getBlockAt(x, y, z);
            if (block == null || CompMaterial.isAir(block) || !predicate.test(block.getType())) continue;
            return y + 1;
        }
        return -1;
    }

    public static int findAirBlock(Location location, boolean topDown, Predicate<Material> predicate) {
        return BlockUtil.findAirBlock(location.getWorld(), location.getBlockX(), location.getBlockZ(), topDown, predicate);
    }

    public static int findAirBlock(World world, int x, int z, boolean topDown, Predicate<Material> predicate) {
        int minHeight = (MinecraftVersion.atLeast(MinecraftVersion.V.v1_18) ? world.getMinHeight() : 0) + 1;
        if (topDown) {
            for (int y = world.getMaxHeight() - 1; y > minHeight; --y) {
                Block block = world.getBlockAt(x, y, z);
                if (block == null || CompMaterial.isAir(block) || !predicate.test(block.getType())) continue;
                return y + 1;
            }
        } else {
            for (int y = minHeight; y < world.getMaxHeight() - 1; ++y) {
                Block block = world.getBlockAt(x, y, z);
                Block blockAbove = block.getRelative(BlockFace.UP);
                Block blockTwoAbove = blockAbove.getRelative(BlockFace.UP);
                if (block == null || !CompMaterial.isAir(blockAbove) || !CompMaterial.isAir(blockTwoAbove) || !predicate.test(block.getType())) continue;
                return y + 1;
            }
        }
        return -1;
    }

    public static int findHighestNetherAirBlock(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return BlockUtil.findHighestNetherAirBlock(location.getWorld(), location.getBlockX(), location.getBlockZ());
    }

    public static int findHighestNetherAirBlock(@NonNull World world, int x, int z) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        Valid.checkBoolean(world.getEnvironment() == World.Environment.NETHER, "findHighestNetherAirBlock must be called in nether worlds, " + world.getName() + " is of type " + world.getEnvironment(), new Object[0]);
        for (int y = 0; y < world.getMaxHeight(); ++y) {
            Block block = world.getBlockAt(x, y, z);
            Block above = block.getRelative(BlockFace.UP);
            Block below = block.getRelative(BlockFace.DOWN);
            if (block == null || !CompMaterial.isAir(block) || !CompMaterial.isAir(above) || CompMaterial.isAir(below) || !below.getType().isSolid()) continue;
            return y;
        }
        return -1;
    }

    public static Location findClosestLocation(Location location, List<Location> locations) {
        locations = new ArrayList<Location>(locations);
        Location playerLocation = location;
        Collections.sort(locations, (f, s) -> Double.compare(f.distance(playerLocation), s.distance(playerLocation)));
        return locations.get(0);
    }

    public static FallingBlock shootBlock(Block block, Vector velocity) {
        return BlockUtil.shootBlock(block, velocity, 0.0);
    }

    public static FallingBlock shootBlock(Block block, Vector velocity, double burnOnFallChance) {
        if (!BlockUtil.canShootBlock(block)) {
            return null;
        }
        FallingBlock falling = Remain.spawnFallingBlock(block.getLocation().clone().add(0.5, 0.0, 0.5), block.getType());
        double x = MathUtil.range(velocity.getX(), -2.0, 2.0) * 0.5;
        double y = Math.random();
        double z = MathUtil.range(velocity.getZ(), -2.0, 2.0) * 0.5;
        falling.setVelocity(new Vector(x, y, z));
        if (RandomUtil.chanceD(burnOnFallChance) && block.getType().isBurnable()) {
            BlockUtil.scheduleBurnOnFall(falling);
        }
        falling.setDropItem(false);
        block.setType(Material.AIR);
        return falling;
    }

    public static FallingBlock spawnFallingBlock(Block block, Vector velocity) {
        FallingBlock falling = Remain.spawnFallingBlock(block.getLocation().clone().add(0.5, 0.0, 0.5), block.getType());
        falling.setVelocity(velocity);
        falling.setDropItem(false);
        block.setType(Material.AIR);
        return falling;
    }

    private static boolean canShootBlock(Block block) {
        Material material = block.getType();
        return !CompMaterial.isAir(material) && (material.toString().contains("STEP") || material.toString().contains("SLAB") || BlockUtil.isForBlockSelection(material));
    }

    private static void scheduleBurnOnFall(FallingBlock block) {
        EntityUtil.trackFalling((Entity)block, () -> {
            Block upperBlock = block.getLocation().getBlock().getRelative(BlockFace.UP);
            if (upperBlock.getType() == Material.AIR) {
                upperBlock.setType(Material.FIRE);
            }
        });
    }

    private static VectorHelper getMinimumPoint(Location pos1, Location pos2) {
        return new VectorHelper(Math.min(pos1.getX(), pos2.getX()), Math.min(pos1.getY(), pos2.getY()), Math.min(pos1.getZ(), pos2.getZ()));
    }

    private static VectorHelper getMaximumPoint(Location pos1, Location pos2) {
        return new VectorHelper(Math.max(pos1.getX(), pos2.getX()), Math.max(pos1.getY(), pos2.getY()), Math.max(pos1.getZ(), pos2.getZ()));
    }

    private static int getHeight(Location pos1, Location pos2) {
        VectorHelper min = BlockUtil.getMinimumPoint(pos1, pos2);
        VectorHelper max = BlockUtil.getMaximumPoint(pos1, pos2);
        return (int)(max.getY() - min.getY() + 1.0);
    }

    private BlockUtil() {
    }

    private static final class VectorHelper {
        protected final double x;
        protected final double y;
        protected final double z;

        public VectorHelper add(VectorHelper other) {
            return this.add(other.x, other.y, other.z);
        }

        public VectorHelper add(double x, double y, double z) {
            return new VectorHelper(this.x + x, this.y + y, this.z + z);
        }

        public VectorHelper subtract(VectorHelper other) {
            return this.subtract(other.x, other.y, other.z);
        }

        public VectorHelper subtract(double x, double y, double z) {
            return new VectorHelper(this.x - x, this.y - y, this.z - z);
        }

        public VectorHelper multiply(double n) {
            return new VectorHelper(this.x * n, this.y * n, this.z * n);
        }

        public VectorHelper divide(double n) {
            return new VectorHelper(this.x / n, this.y / n, this.z / n);
        }

        public double length() {
            return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        }

        public double distance(VectorHelper other) {
            return Math.sqrt(Math.pow(other.x - this.x, 2.0) + Math.pow(other.y - this.y, 2.0) + Math.pow(other.z - this.z, 2.0));
        }

        public VectorHelper normalize() {
            return this.divide(this.length());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof VectorHelper)) {
                return false;
            }
            VectorHelper other = (VectorHelper)obj;
            return other.x == this.x && other.y == this.y && other.z == this.z;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ", " + this.z + ")";
        }

        public VectorHelper(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getZ() {
            return this.z;
        }
    }
}

