/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.PlayerUtil;
import sk.adonikeoffice.epicchat.lib.model.SimpleScoreboard;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.CompBarColor;
import sk.adonikeoffice.epicchat.lib.remain.CompBarStyle;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

public class AnimationUtil {
    public static List<String> leftToRight(String message, ChatColor firstColor, @Nullable ChatColor middleColor, ChatColor lastColor) {
        ArrayList<String> result = new ArrayList<String>();
        String msg = Common.colorize(message);
        for (int frame = 0; frame < message.length(); ++frame) {
            String first = msg.substring(0, frame);
            String middle = frame == msg.length() ? "" : String.valueOf(msg.charAt(frame));
            String last = frame == msg.length() ? "" : msg.substring(frame + 1);
            ChatColor middleColorFinal = middleColor != null ? middleColor : firstColor;
            result.add(firstColor + first + middleColorFinal + middle + lastColor + last);
        }
        return result;
    }

    public static List<String> rightToLeft(String message, ChatColor firstColor, @Nullable ChatColor middleColor, ChatColor lastColor) {
        String msg = Common.colorize(message);
        ArrayList<String> result = new ArrayList<String>();
        for (int frame = msg.length(); frame >= 0; --frame) {
            String first = msg.substring(0, frame);
            String middle = frame == msg.length() ? "" : String.valueOf(msg.charAt(frame));
            String last = frame == msg.length() ? "" : msg.substring(frame + 1);
            ChatColor middleColorFinal = middleColor != null ? middleColor : firstColor;
            result.add(firstColor + first + middleColorFinal + middle + lastColor + last);
        }
        return result;
    }

    public static List<String> leftToRightFull(String message, ChatColor firstColor, @Nullable ChatColor middleColor, ChatColor lastColor) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(AnimationUtil.leftToRight(message, firstColor, middleColor, lastColor));
        result.addAll(AnimationUtil.leftToRight(message, lastColor, middleColor, firstColor));
        return result;
    }

    public static List<String> rightToLeftFull(String message, ChatColor firstColor, @Nullable ChatColor middleColor, ChatColor lastColor) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(AnimationUtil.rightToLeft(message, firstColor, middleColor, lastColor));
        result.addAll(AnimationUtil.rightToLeft(message, lastColor, middleColor, firstColor));
        return result;
    }

    public static List<String> flicker(String message, int amount, int duration, ChatColor[] colors) {
        ArrayList<String> result = new ArrayList<String>();
        for (int frame = 0; frame < amount; ++frame) {
            for (int i = 0; i < duration; ++i) {
                result.add(colors[amount % colors.length] + message);
            }
        }
        return result;
    }

    public static List<String> duplicate(List<String> frames, int amount) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < frames.size(); ++i) {
            for (int j = 0; j < amount; ++j) {
                String duplicated = frames.get(i);
                result.add(i, duplicated);
            }
        }
        return result;
    }

    public static List<String> duplicateFrame(int frame, List<String> frames, int amount) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < amount; ++i) {
            String duplicated = frames.get(frame);
            result.add(frame, duplicated);
        }
        return result;
    }

    public static List<String> shuffle(List<String> animatedFrames) {
        Collections.shuffle(animatedFrames);
        return animatedFrames;
    }

    public static List<String> combine(@NonNull List<String>[] animationsToCombine) {
        if (animationsToCombine == null) {
            throw new NullPointerException("animationsToCombine is marked non-null but is null");
        }
        ArrayList<String> combined = new ArrayList<String>();
        for (List<String> animation : animationsToCombine) {
            combined.addAll(animation);
        }
        return combined;
    }

    public static BukkitTask animateBossBar(final Player player, final List<String> animatedFrames, long delay, long period) {
        return new BukkitRunnable(){
            int frame = 0;

            public void run() {
                Remain.sendBossbarPercent(player, (String)animatedFrames.get(this.frame), 100.0f);
                ++this.frame;
                if (this.frame == animatedFrames.size()) {
                    this.frame = 0;
                }
            }
        }.runTaskTimer((Plugin)SimplePlugin.getInstance(), delay, period);
    }

    public static BukkitTask animateBossBar(final Player player, final List<String> animatedFrames, final @Nullable List<CompBarColor> animatedColors, long delay, long period, final boolean animateOnce, final @Nullable CountdownBar countdownBar) {
        int smoothnessLevel = 1;
        if (countdownBar != null && countdownBar.isSmooth) {
            smoothnessLevel = 10;
        }
        final int finalSmoothnessLevel = smoothnessLevel;
        return new BukkitRunnable(){
            boolean run = true;
            int frame = 0;
            float health = 1.0f;

            public void run() {
                if (!this.run) {
                    return;
                }
                String title = (String)animatedFrames.get(this.frame % (animatedFrames.size() * finalSmoothnessLevel));
                if (animatedColors != null) {
                    Remain.sendBossbarPercent(player, title, this.health, (CompBarColor)((Object)animatedColors.get(this.frame % (animatedColors.size() * finalSmoothnessLevel))), CompBarStyle.SOLID);
                } else {
                    Remain.sendBossbarPercent(player, title, this.health);
                }
                if (countdownBar != null) {
                    this.health = countdownBar.isSmooth ? (float)((double)this.health - (double)countdownBar.duration / (10.0 * (double)finalSmoothnessLevel)) : (float)((double)this.health - (double)countdownBar.duration / 10.0);
                }
                ++this.frame;
                if (this.frame >= animatedFrames.size()) {
                    this.frame = 0;
                    this.health = 1.0f;
                    if (animateOnce) {
                        this.run = false;
                        Remain.removeBossbar(player);
                    }
                }
            }
        }.runTaskTimer((Plugin)SimplePlugin.getInstance(), delay, period / (long)smoothnessLevel);
    }

    public static BukkitTask animateScoreboardTitle(final SimpleScoreboard scoreboard, final List<String> animatedFrames, long delay, long period) {
        return new BukkitRunnable(){
            int frame = 0;

            public void run() {
                scoreboard.setTitle((String)animatedFrames.get(this.frame));
                ++this.frame;
                if (this.frame == animatedFrames.size()) {
                    this.frame = 0;
                }
            }
        }.runTaskTimer((Plugin)SimplePlugin.getInstance(), delay, period);
    }

    public static BukkitTask animateTitle(final Player who, final @Nullable List<String> titleFrames, final @Nullable List<String> subtitleFrames, long period) {
        return new BukkitRunnable(){
            int frame = 0;
            String title = "";
            String subtitle = "";

            public void run() {
                if (titleFrames != null) {
                    this.title = (String)titleFrames.get(this.frame % titleFrames.size());
                }
                if (subtitleFrames != null) {
                    this.subtitle = (String)subtitleFrames.get(this.frame % subtitleFrames.size());
                }
                Remain.sendTitle(who, 10, 70, 20, this.title, this.subtitle);
                ++this.frame;
                if (this.frame == Math.max(titleFrames != null ? titleFrames.size() : 0, subtitleFrames != null ? subtitleFrames.size() : 0) || SimplePlugin.isReloading()) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)SimplePlugin.getInstance(), 0L, period);
    }

    public static BukkitTask animateItemTitle(final ItemStack item, final List<String> animatedFrames, long delay, long period) {
        return new BukkitRunnable(){
            int frame = 0;

            public void run() {
                ItemMeta meta = AnimationUtil.checkMeta(item);
                meta.setDisplayName((String)animatedFrames.get(this.frame));
                item.setItemMeta(meta);
                ++this.frame;
                if (this.frame > animatedFrames.size()) {
                    this.frame = 0;
                }
            }
        }.runTaskTimer((Plugin)SimplePlugin.getInstance(), delay, period);
    }

    public static BukkitTask animateItemLore(final ItemStack item, final int line, final List<String> animatedFrames, long delay, long period) {
        return new BukkitRunnable(){
            int frame = 0;

            public void run() {
                String frameText = (String)animatedFrames.get(this.frame % animatedFrames.size());
                ItemMeta meta = AnimationUtil.checkMeta(item);
                ArrayList<String> lore = meta.getLore();
                if (lore == null) {
                    lore = new ArrayList<String>();
                }
                if (lore.size() < line) {
                    throw new IndexOutOfBoundsException("line #" + line + " is out of range!");
                }
                lore.set(line, frameText);
                meta.setLore(lore);
                item.setItemMeta(meta);
                ++this.frame;
                if (this.frame > animatedFrames.size()) {
                    this.frame = 0;
                }
            }
        }.runTaskTimer((Plugin)SimplePlugin.getInstance(), delay, period);
    }

    public static BukkitTask animateInventoryTitle(final Player viewer, final List<String> animatedFrames, long delay, long period) {
        return new BukkitRunnable(){
            int frame = 0;

            public void run() {
                PlayerUtil.updateInventoryTitle(viewer, (String)animatedFrames.get(this.frame));
                ++this.frame;
                if (this.frame > animatedFrames.size()) {
                    this.frame = 0;
                }
            }
        }.runTaskTimer((Plugin)SimplePlugin.getInstance(), delay, period);
    }

    private static ItemMeta checkMeta(@NonNull ItemStack item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !item.hasItemMeta()) {
            meta = Bukkit.getItemFactory().getItemMeta(item.getType());
        }
        return meta;
    }

    public static class CountdownBar {
        private final long duration;
        private final boolean isSmooth;

        public CountdownBar(long duration, boolean isSmooth) {
            this.duration = duration;
            this.isSmooth = isSmooth;
        }
    }
}

