/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.data;

import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.model.ConfigSerializable;
import sk.adonikeoffice.epicchat.lib.remain.CompSound;

public final class QuestionData
implements ConfigSerializable {
    private final String question;
    private final String answer;
    private final CompSound sound;

    @Override
    public SerializedMap serialize() {
        return SerializedMap.ofArray(new Object[]{"Question", this.question, "Answer", this.answer, "Sound", this.sound});
    }

    public static QuestionData deserialize(SerializedMap map) {
        String question = map.getString("Question");
        String answer = map.getString("Answer");
        CompSound sound = map.get("Sound", CompSound.class);
        return new QuestionData(question, answer, sound);
    }

    public String getQuestion() {
        return this.question;
    }

    public String getAnswer() {
        return this.answer;
    }

    public CompSound getSound() {
        return this.sound;
    }

    public QuestionData(String question, String answer, CompSound sound) {
        this.question = question;
        this.answer = answer;
        this.sound = sound;
    }
}

