/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.data;

import java.util.Collection;
import org.bukkit.entity.Player;
import sk.adonikeoffice.epicchat.lib.settings.ConfigItems;
import sk.adonikeoffice.epicchat.lib.settings.YamlConfig;

public class PlayerData
extends YamlConfig {
    private static final ConfigItems<PlayerData> loadedPlayers = ConfigItems.fromFolder("players", PlayerData.class);
    private int reactedTimes;

    private PlayerData(String name) {
        this.loadConfiguration(NO_DEFAULT, "players/" + name + ".yml");
    }

    @Override
    protected void onLoad() {
        this.reactedTimes = this.getInteger("Reacted_Times", 0);
    }

    @Override
    protected void onSave() {
        this.set("Reacted_Times", this.reactedTimes);
    }

    public void increaseReactedTimes() {
        ++this.reactedTimes;
        this.save();
    }

    public static void createPlayer(String name) {
        PlayerData player = loadedPlayers.loadOrCreateItem(name, () -> new PlayerData(name));
        player.save();
    }

    public static boolean isLoaded(Player player) {
        return PlayerData.isLoaded(player.getName());
    }

    public static boolean isLoaded(String name) {
        return loadedPlayers.isItemLoaded(name);
    }

    public static void loadPlayers() {
        loadedPlayers.loadItems();
    }

    public static PlayerData findPlayer(Player player) {
        return PlayerData.findPlayer(player.getName());
    }

    public static PlayerData findPlayer(String name) {
        for (PlayerData player : PlayerData.getLoadedPlayers()) {
            String playerName = player.getName();
            if (!playerName.equals(name) || !PlayerData.isLoaded(playerName)) continue;
            return player;
        }
        return null;
    }

    public static Collection<PlayerData> getLoadedPlayers() {
        return loadedPlayers.getItems();
    }

    public int getReactedTimes() {
        return this.reactedTimes;
    }
}

