/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.data;

import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.model.ConfigSerializable;
import sk.adonikeoffice.epicchat.lib.remain.CompChatColor;

public final class GroupData
implements ConfigSerializable {
    private final String name;
    private final String format;
    private final CompChatColor messageColor;

    @Override
    public SerializedMap serialize() {
        return SerializedMap.ofArray("Name", this.name, "Format", this.format, "Message_Color", this.messageColor);
    }

    public static GroupData deserialize(SerializedMap map) {
        String name = map.getString("Name");
        String format = map.getString("Format");
        CompChatColor messageColor = map.get("Message_Color", CompChatColor.class);
        return new GroupData(name, format, messageColor);
    }

    public String getName() {
        return this.name;
    }

    public String getFormat() {
        return this.format;
    }

    public CompChatColor getMessageColor() {
        return this.messageColor;
    }

    public GroupData(String name, String format, CompChatColor messageColor) {
        this.name = name;
        this.format = format;
        this.messageColor = messageColor;
    }
}

