/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.data;

import java.util.List;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.model.ConfigSerializable;
import sk.adonikeoffice.epicchat.lib.remain.CompSound;

public final class AnnouncementData
implements ConfigSerializable {
    private final CompSound sound;
    private final String permission;
    private final List<String> chatMessage;

    @Override
    public SerializedMap serialize() {
        return SerializedMap.ofArray(new Object[]{"Sound", this.sound, "Permission", this.permission, "Chat_Message", this.chatMessage});
    }

    public static AnnouncementData deserialize(SerializedMap map) {
        CompSound sound = map.get("Sound", CompSound.class);
        String permission = map.getString("Permission");
        List<String> chatMessage = map.getStringList("Chat_Message");
        return new AnnouncementData(sound, permission, chatMessage);
    }

    public CompSound getSound() {
        return this.sound;
    }

    public String getPermission() {
        return this.permission;
    }

    public List<String> getChatMessage() {
        return this.chatMessage;
    }

    public AnnouncementData(CompSound sound, String permission, List<String> chatMessage) {
        this.sound = sound;
        this.permission = permission;
        this.chatMessage = chatMessage;
    }
}

