/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.command;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.command.SimpleCommand;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.settings.Settings;
import sk.adonikeoffice.epicchat.util.Util;

public final class ReloadCommand
extends SimpleCommand {
    public ReloadCommand() {
        super("epicchat");
        this.setAliases(Settings.Chat.ALIASES);
        this.setPermission(null);
        this.setAutoHandleHelp(false);
    }

    @Override
    protected void onCommand() {
        if (!this.isPlayer()) {
            this.returnTell(Settings.Message.NO_CONSOLE);
        }
        Player player = this.getPlayer();
        boolean hasAccess = Util.hasPermission(player, Settings.Command.Reload.PERMISSION);
        if (this.args.length == 0) {
            ArrayList<String> helpMessage = new ArrayList<String>();
            helpMessage.add("&8" + Common.chatLine());
            helpMessage.add(Settings.PLUGIN_PREFIX + "Running EpicChat\u1d40\u1d39 &f" + SimplePlugin.getVersion());
            helpMessage.add(Settings.PLUGIN_PREFIX + "Made by &fAdoNikeOFFICE &7in &4\u00b2\u2070\u00b2\u00b2");
            helpMessage.add(Settings.PLUGIN_PREFIX);
            helpMessage.add(Settings.PLUGIN_PREFIX + "Premium version of the plugin &fhttps://bit.ly/3xTAW4C.");
            if (hasAccess) {
                helpMessage.add(" ");
                helpMessage.add(Settings.PLUGIN_PREFIX + "&7Type &4/" + this.getCurrentLabel() + " reload &7to reload this plugin.");
            }
            helpMessage.add("&8" + Common.chatLine());
            this.returnTell(helpMessage);
        }
        String param = this.args[0].toLowerCase();
        if (hasAccess) {
            if ("reload".equals(param)) {
                try {
                    SimplePlugin.getInstance().reload();
                    this.tell("Plugin has been reloaded.");
                }
                catch (Throwable t) {
                    Common.error(t, "Join Epic Chat discord, create a ticket and report this to the author (AdoNikeOFFICE).");
                }
            } else {
                this.tell(Settings.Message.INVALID_ARGS);
            }
        } else {
            this.tell(Settings.Message.NO_PERMISSION.replace("{0}", Settings.Command.Reload.PERMISSION));
        }
    }

    @Override
    protected List<String> tabComplete() {
        if (this.args.length == 1 && Util.hasPermission(this.getPlayer(), Settings.Command.Reload.PERMISSION)) {
            return this.completeLastWord("reload");
        }
        return NO_COMPLETE;
    }
}

