/*
 * Decompiled with CFR 0.152.
 */
package de.qvbe.endlessflight.manager;

import de.qvbe.endlessflight.log.Log;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    public static ConfigManager configManager;
    private File file = new File("plugins/EndlessFlight", "config.yml");
    private FileConfiguration fileCfg = YamlConfiguration.loadConfiguration((File)this.file);
    public Double velocityMultiplier;
    public boolean playSoundEffects;
    public String usePermission;
    public String adminPermission;

    public ConfigManager() {
        this.createDefaults();
        this.getContent();
    }

    private void saveFile() {
        try {
            this.fileCfg.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
            new Log(Log.LogType.ERROR, "An error occurred while saving the configuration file.");
        }
    }

    private void createDefaults() {
        this.fileCfg.options().copyDefaults(true);
        this.fileCfg.addDefault("options.velocityMultiplier", (Object)1.0);
        this.fileCfg.addDefault("options.playSoundEffects", (Object)true);
        this.fileCfg.addDefault("permissions.use", (Object)"endlessflight.use");
        this.fileCfg.addDefault("permissions.admin", (Object)"endlessflight.admin");
        this.saveFile();
    }

    public void getContent() {
        this.velocityMultiplier = this.fileCfg.getDouble("options.velocityMultiplier");
        this.playSoundEffects = this.fileCfg.getBoolean("options.playSoundEffects");
        this.usePermission = this.fileCfg.getString("permissions.use");
        this.adminPermission = this.fileCfg.getString("permissions.admin");
    }

    public static ConfigManager get() {
        return configManager;
    }
}

