/*
 * Decompiled with CFR 0.152.
 */
package com.lojosho.enchantnow.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.lojosho.enchantnow.util.SendDebugUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;

public class StringToEnchantUtil {
    private static BiMap<String, Enchantment> enchantMap = HashBiMap.create();
    private static HashMap<Enchantment, Integer> enchantMaxLevel = new HashMap();

    public static void setup() {
        enchantMap.clear();
        for (Enchantment ench : Enchantment.values()) {
            enchantMap.put((Object)ench.getKey().toString().toUpperCase(Locale.ROOT).replaceAll(".+:", ""), (Object)ench);
            SendDebugUtil.sendDebugMessage(ench + " has been detected and added!", Level.INFO);
        }
        for (Enchantment ench : StringToEnchantUtil.values()) {
            enchantMaxLevel.put(ench, ench.getMaxLevel());
        }
    }

    public static Enchantment getEnchantment(String stringEnchant) {
        return Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)stringEnchant));
    }

    public static String getEnchantment(Enchantment enchant) {
        return (String)enchantMap.inverse().get((Object)enchant);
    }

    public static Boolean contains(String enchantment) {
        return enchantment.contains(enchantment);
    }

    public static List<String> keys() {
        return ImmutableList.copyOf((Collection)enchantMap.keySet());
    }

    public static List<Enchantment> values() {
        return ImmutableList.copyOf((Collection)enchantMap.values());
    }
}

