/*
 * Decompiled with CFR 0.152.
 */
package com.lojosho.enchantnow.util;

import com.lojosho.enchantnow.EnchantNow;
import com.lojosho.enchantnow.kyori.adventure.audience.Audience;
import com.lojosho.enchantnow.kyori.adventure.platform.bukkit.BukkitAudiences;
import com.lojosho.enchantnow.kyori.adventure.text.Component;
import com.lojosho.enchantnow.kyori.adventure.text.minimessage.MiniMessage;
import com.lojosho.enchantnow.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SendMessageUtil {
    public static void sendStringMessage(Player player, String message) {
        SendMessageUtil.sendStringMessage(player, message, TagResolver.empty());
    }

    public static void sendStringMessage(Player player, String message, TagResolver placeholder) {
        if (message == null) {
            return;
        }
        if (message.length() == 0) {
            return;
        }
        Component chatMessage = MiniMessage.miniMessage().deserialize(message, placeholder);
        Audience target = BukkitAudiences.create((Plugin)EnchantNow.getInstance()).player(player);
        target.sendMessage(chatMessage);
    }

    public static void sendConfigMessage(Player player, String location) {
        SendMessageUtil.sendConfigMessage(player, location, TagResolver.empty());
    }

    public static void sendConfigMessage(Player player, String location, TagResolver placeholder) {
        String message = EnchantNow.getInstance().getConfig().getString(location);
        if (message == null) {
            return;
        }
        if (message.length() == 0) {
            return;
        }
        Component chatMessage = MiniMessage.miniMessage().deserialize(message, placeholder);
        Audience target = BukkitAudiences.create((Plugin)EnchantNow.getInstance()).player(player);
        target.sendMessage(chatMessage);
    }

    public static void sendConfigMessage(CommandSender sender, String location) {
        SendMessageUtil.sendConfigMessage(sender, location, TagResolver.empty());
    }

    public static void sendConfigMessage(CommandSender sender, String location, TagResolver placeholders) {
        String message = EnchantNow.getInstance().getConfig().getString(location);
        if (message == null) {
            return;
        }
        if (message.length() == 0) {
            return;
        }
        Component chatMessage = MiniMessage.miniMessage().deserialize(message, placeholders);
        Audience target = BukkitAudiences.create((Plugin)EnchantNow.getInstance()).sender(sender);
        target.sendMessage(chatMessage);
    }
}

