/*
 * Decompiled with CFR 0.152.
 */
package com.lojosho.enchantnow;

import com.lojosho.enchantnow.commands.EnchantBookCommand;
import com.lojosho.enchantnow.commands.EnchantBookTabComplete;
import com.lojosho.enchantnow.commands.EnchantCommand;
import com.lojosho.enchantnow.commands.EnchantReload;
import com.lojosho.enchantnow.commands.EnchantTabComplete;
import com.lojosho.enchantnow.util.StringToEnchantUtil;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.java.JavaPlugin;

public final class EnchantNow
extends JavaPlugin {
    private static boolean hasEcoEnchants = false;
    private static EnchantNow instance;

    public void onEnable() {
        this.saveDefaultConfig();
        instance = this;
        if (this.getServer().getPluginManager().getPlugin("EcoEnchants") != null) {
            hasEcoEnchants = true;
            this.getLogger().info("Found EcoEnchants, enabling EcoEnchants integration...");
        }
        StringToEnchantUtil.setup();
        this.getServer().getPluginCommand("enchantbook").setExecutor((CommandExecutor)new EnchantBookCommand());
        this.getServer().getPluginCommand("enchantbook").setTabCompleter((TabCompleter)new EnchantBookTabComplete());
        if (this.getServer().getPluginCommand("enchant") != null) {
            this.getServer().getPluginCommand("enchant").setExecutor((CommandExecutor)new EnchantCommand());
            this.getServer().getPluginCommand("enchant").setTabCompleter((TabCompleter)new EnchantTabComplete());
        } else {
            this.getLogger().severe("Another plugin is currently using /enchant, use /enchantitem for usage of the plugin.");
        }
        this.getServer().getPluginCommand("enchantitem").setExecutor((CommandExecutor)new EnchantCommand());
        this.getServer().getPluginCommand("enchantitem").setTabCompleter((TabCompleter)new EnchantTabComplete());
        this.getServer().getPluginCommand("enchantreload").setExecutor((CommandExecutor)new EnchantReload());
    }

    public void onDisable() {
    }

    public static Boolean hasEcoEnchantments() {
        return hasEcoEnchants;
    }

    public static EnchantNow getInstance() {
        return instance;
    }

    public void reload() {
        instance = this;
        StringToEnchantUtil.setup();
        this.reloadConfig();
    }
}

