/*
 * Decompiled with CFR 0.152.
 */
package com.viayxempire;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class Configs {
    private String name;
    private Plugin plug;
    private static FileConfiguration newConfig = null;
    private static File configFile = null;

    public Configs(String name, Plugin plug) {
        this.plug = plug;
        this.name = name;
        configFile = new File(plug.getDataFolder() + File.separator + name + ".yml");
    }

    public void createConfig() {
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public FileConfiguration getConfig() {
        if (newConfig == null) {
            this.reloadConfig();
        }
        return newConfig;
    }

    public void reloadConfig() {
        newConfig = YamlConfiguration.loadConfiguration((File)configFile);
        InputStream defConfigStream = this.plug.getResource(this.name + ".yml");
        if (defConfigStream == null) {
            return;
        }
        newConfig.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream, Charsets.UTF_8)));
    }

    public void saveConfig() {
        try {
            this.getConfig().save(configFile);
        }
        catch (IOException ex) {
            System.out.println("Could not save config to " + configFile);
        }
    }

    public void saveDefaultConfig() {
        InputStream data = this.plug.getClass().getResourceAsStream("/" + this.name + ".yml");
        this.getConfig().setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(data, Charsets.UTF_8)));
    }
}

