/*
 * Decompiled with CFR 0.152.
 */
package com.golfing8.elevatorsigns.config;

import com.golfing8.elevatorsigns.Color;
import com.golfing8.elevatorsigns.config.annotation.Configurable;
import com.golfing8.elevatorsigns.signhandler.SignHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigManager {
    private final SignHandler mainClass;
    private final Plugin plugin;
    private final FileConfiguration defConfig;
    private final FileConfiguration pluginConfig;
    private File pluginFile;

    public ConfigManager(SignHandler mainClass, Plugin plugin) {
        this.mainClass = mainClass;
        this.plugin = plugin;
        InputStream inputStream = this.getClass().getResourceAsStream("/config.yml");
        this.defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(inputStream));
        this.pluginFile = new File(plugin.getDataFolder(), "config.yml");
        this.pluginConfig = YamlConfiguration.loadConfiguration((File)this.pluginFile);
    }

    public void reloadConfig() {
        try {
            this.pluginConfig.load(this.pluginFile);
            boolean needSave = false;
            for (Field field : this.mainClass.getClass().getSuperclass().getDeclaredFields()) {
                Configurable configurable = null;
                field.setAccessible(true);
                if (!field.isAnnotationPresent(Configurable.class)) continue;
                try {
                    String path;
                    configurable = field.getAnnotation(Configurable.class);
                    String name = configurable.name().equals("") ? field.getName() : configurable.name();
                    String string = path = configurable.path().endsWith(".") || configurable.path().length() == 0 ? configurable.path() : configurable.path() + ".";
                    if (!this.pluginConfig.contains(path + name)) {
                        throw new IllegalArgumentException();
                    }
                    Object thing = this.pluginConfig.get(path + name);
                    field.set(this.mainClass, thing);
                }
                catch (IllegalAccessException | IllegalArgumentException | NullPointerException e2) {
                    if (configurable == null) continue;
                    String name2 = configurable.name().equals("") ? field.getName() : configurable.name();
                    String path2 = configurable.path().endsWith(".") || configurable.path().length() == 0 ? configurable.path() : configurable.path() + ".";
                    Object value = this.defConfig.get(path2 + name2);
                    this.pluginConfig.set(path2 + name2, value);
                    Bukkit.getConsoleSender().sendMessage(Color.c(String.format("[%s] - Error setting " + field.getName() + " due to a config error! (Setting default value: " + value + ")", this.plugin.getName())));
                    needSave = true;
                }
            }
            if (needSave) {
                this.plugin.saveConfig();
                this.pluginConfig.save(this.pluginFile);
                this.reloadConfig();
            }
        }
        catch (IOException | InvalidConfigurationException ex5) {
            this.plugin.saveDefaultConfig();
            this.pluginFile = new File(this.plugin.getDataFolder(), "config.yml");
            this.reloadConfig();
        }
    }
}

