/*
 * Decompiled with CFR 0.152.
 */
package robrobproductions.eggdropdeluxe.functions;

import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import robrobproductions.eggdropdeluxe.EggDropDeluxe;

public class CreateSpawnEgg {
    private EggDropDeluxe plugin;
    private Random random = new Random();
    private static final String SPAWN_EGG_STRING = "_SPAWN_EGG";
    private static final Object[][] eggTable = new Object[][]{{EntityType.MUSHROOM_COW, Material.MOOSHROOM_SPAWN_EGG}};

    public CreateSpawnEgg(EggDropDeluxe plugin) {
        this.plugin = plugin;
    }

    public void give(Entity entity) {
        Location location = entity.getLocation();
        if (this.chance()) {
            Objects.requireNonNull(Bukkit.getWorld((UUID)Objects.requireNonNull(location.getWorld()).getUID())).dropItemNaturally(location, this.createItem(entity));
        }
    }

    private ItemStack createItem(Entity entity) {
        return new ItemStack(this.getMaterial(entity));
    }

    private Material getMaterial(Entity entity) {
        String conversionAttempt = entity.getType().toString() + SPAWN_EGG_STRING;
        Material ret = null;
        try {
            ret = Material.valueOf((String)conversionAttempt);
        }
        catch (IllegalArgumentException e) {
            for (Object[] objArr : eggTable) {
                if (objArr[0] != entity.getType()) continue;
                return (Material)objArr[1];
            }
        }
        return ret;
    }

    private boolean chance() {
        return this.random.nextInt(100) <= this.plugin.getConfig().getInt("settings.drop_chance");
    }
}

