/*
 * Decompiled with CFR 0.152.
 */
package robrobproductions.eggdropdeluxe.commands;

import java.util.Objects;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import robrobproductions.eggdropdeluxe.EggDropDeluxe;
import robrobproductions.eggdropdeluxe.functions.EggDropCommand;
import robrobproductions.eggdropdeluxe.messages.PlayerMessages;

public class EggDrop
implements CommandExecutor {
    private EggDropCommand functions;
    private PlayerMessages playerMessages;

    public EggDrop(EggDropDeluxe plugin, EggDropCommand functions) {
        this.functions = functions;
        this.playerMessages = new PlayerMessages(plugin);
        Objects.requireNonNull(plugin.getCommand("eggdrop")).setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players may execute this command!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("eggdrop.admin")) {
            this.playerMessages.noPermission(player);
            return false;
        }
        if (command.getName().equalsIgnoreCase("eggdrop")) {
            if (args.length == 0) {
                this.playerMessages.egHelp(player);
            } else if (args[0].equals("help")) {
                this.playerMessages.egHelp(player);
            } else if (args[0].equals("enable")) {
                if (this.functions.enable()) {
                    this.playerMessages.egEnableSuccess(player);
                } else {
                    this.playerMessages.egEnableFailed(player);
                }
            } else if (args[0].equals("disable")) {
                if (this.functions.disable()) {
                    this.playerMessages.egDisableSuccess(player);
                } else {
                    this.playerMessages.egDisableFailed(player);
                }
            } else if (args[0].equals("drop") && args[1].equals("chance")) {
                this.playerMessages.egDisplayDropChance(player);
            } else if (args[0].equals("change") && args[1].equals("drop") && args[2].equals("chance")) {
                if (this.functions.setDropChance(Integer.parseInt(args[3]))) {
                    this.playerMessages.egChangeDropChanceSuccess(player);
                } else {
                    this.playerMessages.egChangeDropChanceFailed(player);
                }
            }
        }
        return true;
    }
}

