/*
 * Decompiled with CFR 0.152.
 */
package fuji.ecoapi.economy;

import fuji.ecoapi.main.EconomyAPI;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.bukkit.OfflinePlayer;

public class Account {
    OfflinePlayer player;
    int amount;
    int id;

    public Account(OfflinePlayer op, int startingAmount) {
        if (!this.hasRegistered(op)) {
            EconomyAPI.getConfigManager().get().set("Accounts." + op.getUniqueId().toString() + ".money", (Object)startingAmount);
            EconomyAPI.getConfigManager().get().set("Accounts." + op.getUniqueId().toString() + ".id", (Object)EconomyAPI.getConfigManager().get().getInt("Accounts.IDCount"));
            this.id = EconomyAPI.getConfigManager().get().getInt("Accounts." + op.getUniqueId().toString() + ".id");
            EconomyAPI.getConfigManager().get().set("Accounts.IDCount", (Object)(EconomyAPI.getConfigManager().get().getInt("Accounts.IDCount") + 1));
            EconomyAPI.getConfigManager().save();
            this.player = op;
            this.amount = startingAmount;
        }
    }

    public Account(OfflinePlayer player) {
        this.player = player;
        this.amount = EconomyAPI.getConfigManager().get().getInt("Accounts." + player.getUniqueId().toString() + ".money");
        this.id = EconomyAPI.getConfigManager().get().getInt("Accounts." + player.getUniqueId().toString() + ".id");
    }

    public int getID() {
        return this.id;
    }

    public void setAmount(int amount) {
        if (this.hasRegistered(this.player)) {
            EconomyAPI.getConfigManager().get().set("Accounts." + this.player.getUniqueId().toString() + ".money", (Object)amount);
            EconomyAPI.getConfigManager().save();
            this.amount = amount;
        }
    }

    public int getAmount() {
        if (this.hasRegistered(this.player)) {
            return EconomyAPI.getConfigManager().get().getInt("Accounts." + this.player.getUniqueId().toString() + ".money");
        }
        return 0;
    }

    public void addAmount(int amount) {
        if (this.hasRegistered(this.player)) {
            EconomyAPI.getConfigManager().get().set("Accounts." + this.player.getUniqueId().toString() + ".money", (Object)(EconomyAPI.getConfigManager().get().getInt("Accounts." + this.player.getUniqueId().toString() + ".money") + amount));
        }
    }

    public void subtractAmount(int amount) {
        if (this.hasRegistered(this.player)) {
            EconomyAPI.getConfigManager().get().set("Accounts." + this.player.getUniqueId().toString() + ".money", (Object)(EconomyAPI.getConfigManager().get().getInt("Accounts." + this.player.getUniqueId().toString() + ".money") - amount));
        }
    }

    public void resetAmount() {
        if (this.hasRegistered(this.player)) {
            EconomyAPI.getConfigManager().get().set("Accounts." + this.player.getUniqueId().toString() + ".money", (Object)0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasRegistered(OfflinePlayer player) {
        try {
            Set set = EconomyAPI.getConfigManager().get().getConfigurationSection("Accounts").getKeys(false);
            Iterator iter = set.iterator();
            do {
                if (iter.hasNext()) continue;
                return false;
            } while (!((String)iter.next()).equals(player.getUniqueId().toString()));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public OfflinePlayer getUser() {
        return this.player;
    }

    public UUID getUserUUID() {
        return this.player.getUniqueId();
    }

    public String getUserName() {
        return this.player.getName();
    }
}

