/*
 * Decompiled with CFR 0.152.
 */
package me.filliravaz.ezunsafeenchants;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import me.filliravaz.ezunsafeenchants.EnchantEvents;
import me.filliravaz.ezunsafeenchants.MetricsLite;
import org.bukkit.ChatColor;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    private File configFile = new File(this.getDataFolder(), "config.yml");
    public YamlConfiguration config = new YamlConfiguration();
    private boolean enabled;

    public void onEnable() {
        this.initConfigFile();
        try {
            this.config.load(this.configFile);
        }
        catch (IOException e) {
            this.printToConsole(ChatColor.RED + "IOException when loading config");
        }
        catch (InvalidConfigurationException e) {
            this.printToConsole(ChatColor.RED + "Invalid Configuration File");
        }
        try {
            this.enabled = this.config.getString("enable_easy_unsafe").toLowerCase().equals("true");
        }
        catch (Error e) {
            this.printToConsole(ChatColor.RED + "Could not get config, disabling EasyUnsafeEnchants");
            this.enabled = false;
        }
        if (this.enabled) {
            EnchantEvents eventHandler = new EnchantEvents(this);
            this.printToConsole(ChatColor.GREEN + "Enabled");
        } else {
            this.printToConsole(ChatColor.RED + "Disabled");
        }
        int pluginId = 8228;
        MetricsLite metrics = new MetricsLite((Plugin)this, pluginId);
    }

    public void onDisable() {
    }

    private void initConfigFile() {
        if (!this.configFile.exists()) {
            this.configFile.getParentFile().mkdirs();
            this.copyFile(this.getResource("default.config.yml"), this.configFile);
        }
    }

    private void copyFile(InputStream in, File file) {
        try {
            int len;
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String chatPrepend() {
        return ChatColor.DARK_GRAY + "[" + ChatColor.AQUA + "EasyUnsafeEnchants" + ChatColor.DARK_GRAY + "]" + ChatColor.RESET + " ";
    }

    public void printToConsole(String msg) {
        this.getServer().getConsoleSender().sendMessage(String.valueOf(this.chatPrepend()) + msg);
    }
}

