/*
 * Decompiled with CFR 0.152.
 */
package me.filliravaz.ezunsafeenchants;

import java.util.HashMap;
import java.util.Map;
import me.filliravaz.ezunsafeenchants.Main;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class EnchantEvents
implements Listener {
    private Main plugin;
    private Map<String, Object> limits;
    private boolean debug;
    private boolean canproceed;
    private boolean ignore;

    public EnchantEvents(Main plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        ConfigurationSection section = plugin.config.getConfigurationSection("limits");
        try {
            this.limits = section.getValues(false);
        }
        catch (Error e) {
            e.printStackTrace();
            plugin.printToConsole(ChatColor.RED + "ERROR: could not get limits from config");
        }
        try {
            this.debug = plugin.config.getString("debug").toLowerCase().equals("true");
            this.ignore = plugin.config.getString("allownonenchantableitems").toLowerCase().equals("true");
        }
        catch (Error e) {
            this.debug = false;
            plugin.printToConsole("debug: false");
        }
    }

    @EventHandler
    public void onPrepareAnvilEvent(PrepareAnvilEvent event) {
        AnvilInventory inventory = event.getInventory();
        HashMap limits = new HashMap();
        inventory.setMaximumRepairCost(Integer.MAX_VALUE);
        ItemStack leftItem = inventory.getItem(0);
        ItemStack rightItem = inventory.getItem(1);
        if (leftItem != null && rightItem != null) {
            boolean leftIsBook = leftItem.getItemMeta() instanceof EnchantmentStorageMeta;
            boolean rightIsBook = rightItem.getItemMeta() instanceof EnchantmentStorageMeta;
            if (leftItem.getType() == rightItem.getType() || leftIsBook || rightIsBook) {
                HashMap<Object, Integer> resultingEnchantments = leftIsBook ? new HashMap(((EnchantmentStorageMeta)leftItem.getItemMeta()).getStoredEnchants()) : new HashMap<Enchantment, Integer>(leftItem.getItemMeta().getEnchants());
                HashMap addedEnchantments = rightIsBook ? new HashMap(((EnchantmentStorageMeta)rightItem.getItemMeta()).getStoredEnchants()) : rightItem.getItemMeta().getEnchants();
                for (Map.Entry entry : addedEnchantments.entrySet()) {
                    Enchantment rightEnchantment = (Enchantment)entry.getKey();
                    if (!rightEnchantment.canEnchantItem(leftItem) && !this.ignore) {
                        this.canproceed = false;
                        break;
                    }
                    int rightEnchantmentLevel = (Integer)entry.getValue();
                    if (!resultingEnchantments.containsKey(rightEnchantment)) {
                        resultingEnchantments.put(rightEnchantment, rightEnchantmentLevel);
                        continue;
                    }
                    int leftEnchantmentLevel = (Integer)resultingEnchantments.get(rightEnchantment);
                    if (leftEnchantmentLevel < rightEnchantmentLevel) {
                        resultingEnchantments.put(rightEnchantment, rightEnchantmentLevel);
                        continue;
                    }
                    if (leftEnchantmentLevel != rightEnchantmentLevel) continue;
                    int newLevel = rightEnchantmentLevel;
                    if (this.isValidEnchantLevel(rightEnchantment, newLevel + 1)) {
                        ++newLevel;
                    }
                    resultingEnchantments.put(rightEnchantment, newLevel);
                }
                ItemStack resultItem = leftItem.clone();
                if (this.debug && event.getView().getPlayer().isOp()) {
                    this.plugin.printToConsole(ChatColor.AQUA + "DEBUG INFO FOR " + event.getView().getPlayer().getName());
                    for (Map.Entry entry : resultingEnchantments.entrySet()) {
                        this.plugin.printToConsole("Enchantment found: " + ChatColor.GREEN + ((Enchantment)entry.getKey()).getKey().getKey());
                    }
                }
                if (leftIsBook) {
                    EnchantmentStorageMeta resultItemMeta = (EnchantmentStorageMeta)resultItem.getItemMeta();
                    Map originalEnchantments = resultItemMeta.getStoredEnchants();
                    for (Map.Entry entry : originalEnchantments.entrySet()) {
                        resultItemMeta.removeStoredEnchant((Enchantment)entry.getKey());
                    }
                    for (Map.Entry entry : resultingEnchantments.entrySet()) {
                        if (!((Enchantment)entry.getKey()).canEnchantItem(resultItem) && !this.ignore) {
                            this.canproceed = false;
                            break;
                        }
                        resultItemMeta.addStoredEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
                    }
                    resultItem.setItemMeta((ItemMeta)resultItemMeta);
                } else {
                    for (Map.Entry entry : resultItem.getItemMeta().getEnchants().entrySet()) {
                        resultItem.removeEnchantment((Enchantment)entry.getKey());
                    }
                    resultItem.addUnsafeEnchantments(resultingEnchantments);
                }
                if (leftIsBook) {
                    int repairCost = 0;
                    for (Map.Entry entry : resultingEnchantments.entrySet()) {
                        repairCost += ((Integer)entry.getValue()).intValue();
                    }
                    inventory.setRepairCost(repairCost);
                }
                event.setResult(resultItem);
                int finalRepairCost = inventory.getRepairCost();
                this.canproceed = false;
                if (false) {
                    finalRepairCost = 0;
                }
                if (finalRepairCost > 40) {
                    event.getView().getPlayer().sendMessage(String.valueOf(this.plugin.chatPrepend()) + ChatColor.RED + "This repair costs: " + ChatColor.GREEN + finalRepairCost + ChatColor.RED + " levels.");
                }
                inventory.setRepairCost(finalRepairCost);
                event.getView().setProperty(InventoryView.Property.REPAIR_COST, finalRepairCost);
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity;
        if (!event.isCancelled() && (humanEntity = event.getWhoClicked()) instanceof Player) {
            Player player = (Player)humanEntity;
            if (event.getInventory() instanceof AnvilInventory) {
                ItemStack[] items;
                AnvilInventory anvilInventory = (AnvilInventory)event.getInventory();
                InventoryView view = event.getView();
                int rawSlot = event.getRawSlot();
                if (rawSlot == view.convertSlot(rawSlot) && rawSlot == 2 && (items = anvilInventory.getContents())[0] != null && items[1] != null && event.getCurrentItem().getType() != Material.AIR && event.getCurrentItem() != items[0] && event.getCurrentItem() != items[1]) {
                    if (this.plugin.config.getString("allownonenchantableitems").toLowerCase().equals("false") && !this.canproceed) {
                        player.sendMessage(ChatColor.RED + "This item cannot be enchanted");
                        player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
                        event.setCancelled(true);
                        return;
                    }
                    if (player.getLevel() >= anvilInventory.getRepairCost()) {
                        int repairCost = anvilInventory.getRepairCost();
                        int playerLevel = player.getLevel();
                        int resultantLevel = playerLevel - repairCost;
                        ItemStack itemToGive = event.getCurrentItem().clone();
                        if (itemToGive.getAmount() > 1) {
                            itemToGive.setAmount(1);
                        }
                        if (items[0].getAmount() > 1) {
                            ItemStack returnedStack = items[0].clone();
                            returnedStack.setAmount(returnedStack.getAmount() - 1);
                            if (player.getInventory().addItem(new ItemStack[]{returnedStack}).size() != 0) {
                                player.getWorld().dropItem(player.getLocation(), returnedStack);
                            }
                        }
                        anvilInventory.remove(anvilInventory.getItem(0));
                        anvilInventory.remove(anvilInventory.getItem(1));
                        anvilInventory.remove(anvilInventory.getItem(2));
                        if (player.getInventory().addItem(new ItemStack[]{itemToGive}).size() != 0) {
                            player.getWorld().dropItem(player.getLocation(), itemToGive);
                        }
                        player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_USE, 1.0f, 1.0f);
                        player.giveExpLevels(resultantLevel - playerLevel);
                    }
                }
            }
        }
    }

    private boolean isValidEnchantLevel(Enchantment enchantment, int level) {
        int limit = Integer.MAX_VALUE;
        String enchanmentName = enchantment.getKey().getKey();
        if (this.limits.containsKey(enchanmentName)) {
            limit = 0;
            try {
                limit = (Integer)this.limits.get(enchanmentName);
            }
            catch (Exception e) {
                this.plugin.printToConsole(ChatColor.RED + "ERROR: could not get limit for: " + enchanmentName);
                this.plugin.printToConsole(ChatColor.BLUE + "Defaulting to limit 0 for enchantment: " + enchanmentName);
            }
        }
        return level <= limit;
    }
}

