/*
 * Decompiled with CFR 0.152.
 */
package fr.kakesinfo.easyproxy.models;

import fr.kakesinfo.easyproxy.Main;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class Config {
    private Main main;
    private File file;
    private ConfigurationProvider provider;
    private Configuration configuration;

    public Config(String name, Main main) {
        this.main = main;
        if (!main.getDataFolder().exists()) {
            main.getDataFolder().mkdir();
        }
        this.file = new File(main.getDataFolder(), name);
        if (!this.file.exists()) {
            this.copyDefaults();
        }
    }

    public String getString(String path) {
        return this.configuration.getString(path).replace("&", "\u00a7");
    }

    public boolean getBoolean(String path) {
        return this.configuration.getBoolean(path);
    }

    public void load() {
        try {
            this.configuration = this.getProvider().load(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void copyDefaults() {
        InputStream stream = this.main.getResourceAsStream(this.file.getName());
        Path path = this.file.toPath();
        CopyOption[] options = new CopyOption[]{};
        try {
            Files.copy(stream, path, options);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            this.getProvider().save(this.configuration, this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Main getMain() {
        return this.main;
    }

    public File getFile() {
        return this.file;
    }

    public ConfigurationProvider getProvider() {
        if (this.provider == null) {
            this.provider = ConfigurationProvider.getProvider(YamlConfiguration.class);
        }
        return this.provider;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

