/*
 * Decompiled with CFR 0.152.
 */
package com.headgam3z.easyitemrename.commands;

import com.headgam3z.easyitemrename.Main;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PasteLore
implements CommandExecutor {
    private Main plugin;
    private Player player;
    private String pPerm;
    private String pasteLoreAir;
    private String console;
    private String invalidSyntax;
    private String noPermission;
    private String pasteLoreSuccess;
    private String pasteLoreNone;
    private String pasteLoreCurrent;
    private String name;
    private File dataFolder;
    private File playerFile;
    private YamlConfiguration playerConfig;
    private ItemStack item;
    private ItemMeta meta;

    public PasteLore(Main instance) {
        this.plugin = instance;
        this.pPerm = "easyitemrename.pasteLore";
        this.pasteLoreAir = "Messages.PasteLore-Air";
        this.console = "Messages.Not-A-Player";
        this.invalidSyntax = "Messages.PasteLore-Failure";
        this.noPermission = "Messages.No-Permission";
        this.pasteLoreSuccess = "Messages.PasteLore-Success";
        this.pasteLoreNone = "Messages.PasteLore-None";
        this.pasteLoreCurrent = "Messages.PasteLore-Current";
    }

    public boolean onCommand(CommandSender sender, Command cmd, String s, String[] args) {
        if (sender instanceof Player) {
            this.player = (Player)sender;
            if (this.getPlayer().hasPermission(this.pPerm)) {
                if (args.length == 0) {
                    if (this.playerIsNotHoldingAir()) {
                        if (this.playerFileExists()) {
                            this.playerConfig = YamlConfiguration.loadConfiguration((File)this.playerFile);
                            this.item = this.getPlayer().getItemInHand();
                            this.meta = this.item.getItemMeta();
                            this.meta.setLore(this.getCopiedName());
                            this.item.setItemMeta(this.meta);
                            this.getPlayer().sendMessage(this.getString(this.pasteLoreSuccess).replace("%lore%", this.name));
                            return true;
                        }
                        this.getPlayer().sendMessage(this.getString(this.pasteLoreNone));
                        return false;
                    }
                    this.getPlayer().sendMessage(this.getString(this.pasteLoreAir));
                    return false;
                }
                if (args.length == 1 && args[0].equals("?")) {
                    if (this.playerFileExists()) {
                        this.playerConfig = YamlConfiguration.loadConfiguration((File)this.playerFile);
                        this.getPlayer().sendMessage(this.getString(this.pasteLoreCurrent).replace("%lore%", this.getCopiedName().toString().substring(1, this.getCopiedName().toString().length() - 1)));
                        return true;
                    }
                    this.getPlayer().sendMessage(this.getString(this.pasteLoreNone));
                    return false;
                }
                this.getPlayer().sendMessage(this.getString(this.invalidSyntax));
                return false;
            }
            this.getPlayer().sendMessage(this.getString(this.noPermission));
            return false;
        }
        sender.sendMessage(this.getString(this.console));
        return false;
    }

    private boolean playerFileExists() {
        this.dataFolder = new File(this.getPlugin().getDataFolder(), "Data");
        this.playerFile = new File(this.getFolder(), this.getPlayer().getUniqueId() + ".yml");
        if (!this.getFolder().exists()) {
            this.getFolder().mkdir();
        }
        return this.getFile().exists();
    }

    private boolean playerIsNotHoldingAir() {
        return this.getPlayer().getItemInHand().getType() != Material.AIR;
    }

    private Main getPlugin() {
        return this.plugin;
    }

    private Player getPlayer() {
        return this.player;
    }

    private File getFolder() {
        return this.dataFolder;
    }

    private File getFile() {
        return this.playerFile;
    }

    private String getString(String path) {
        return this.color(String.valueOf(this.getPrefix()) + this.plugin.getConfig().getString(path));
    }

    private String getPrefix() {
        return String.valueOf(this.getPlugin().getConfig().getString("Messages.Prefix")) + " ";
    }

    private String color(String stringToColor) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)stringToColor);
    }

    private List<String> getCopiedName() {
        ArrayList<String> lore = new ArrayList<String>();
        this.name = this.color(this.playerConfig.getString("CopiedLore"));
        lore.add(this.name);
        return lore;
    }
}

