/*
 * Decompiled with CFR 0.152.
 */
package com.headgam3z.easyitemrename.commands;

import com.headgam3z.easyitemrename.Logger;
import com.headgam3z.easyitemrename.Main;
import java.util.ArrayList;
import java.util.List;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Lore
implements CommandExecutor {
    private Main plugin;
    private String lPerm;
    private String newLore;
    private String loreSuccess;
    private String loreAir;
    private String console;
    private String invalidSyntax;
    private String noPermission;
    private String amount;
    private String transactionSuccess;
    private String transactionFailure;
    private String bPerm;
    private String currency;
    private String experience;
    private String currencyPath;
    private Player player;
    private ItemStack item;
    private ItemMeta meta;
    private Logger log;
    private EconomyResponse response;
    private int x;
    private List<String> oldLore;
    private List<String> lore;

    public Lore(Main instance) {
        this.plugin = instance;
        this.lPerm = "easyitemrename.lore";
        this.bPerm = "easyitemrename.bypass.lore";
        this.loreSuccess = "Messages.Lore-Success";
        this.loreAir = "Messages.Lore-Air";
        this.console = "Messages.Not-A-Player";
        this.invalidSyntax = "Messages.Lore-Failure";
        this.noPermission = "Messages.No-Permission";
        this.amount = "Settings.Cost-To-Lore";
        this.experience = "Settings.Experience-To-Lore";
        this.transactionSuccess = "Messages.Transaction-Success";
        this.transactionFailure = "Messages.Transaction-Failure";
        this.currencyPath = "Settings.Currency";
        this.log = new Logger(this.plugin);
        this.oldLore = new ArrayList<String>();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String s, String[] args) {
        if (sender instanceof Player) {
            this.player = (Player)sender;
            if (this.player.hasPermission(this.lPerm)) {
                if (args.length != 0) {
                    if (this.playerIsNotHoldingAir()) {
                        this.item = this.player.getItemInHand();
                        this.resetName();
                        this.add(args);
                        this.newLore = this.color(this.newLore);
                        if (this.getCurrency().equalsIgnoreCase("money")) {
                            if (this.vaultExists()) {
                                if (this.takeMoney()) {
                                    this.loreItem();
                                    return true;
                                }
                                return false;
                            }
                            this.setToExperience();
                            return false;
                        }
                        if (this.getCurrency().equalsIgnoreCase("experience")) {
                            if (this.takeExperience()) {
                                this.loreItem();
                                return true;
                            }
                            return false;
                        }
                        this.loreItem();
                        return true;
                    }
                    this.player.sendMessage(this.getString(this.loreAir));
                    return false;
                }
                this.player.sendMessage(this.getString(this.invalidSyntax));
                return false;
            }
            this.player.sendMessage(this.getString(this.noPermission));
            return false;
        }
        sender.sendMessage(this.getString(this.console));
        return false;
    }

    private int getInt(String pathToInt) {
        return this.plugin.getConfig().getInt(pathToInt);
    }

    private String getString(String path) {
        return this.color(String.valueOf(this.getPrefix()) + this.plugin.getConfig().getString(path));
    }

    private String getBareString(String path) {
        return this.plugin.getConfig().getString(path);
    }

    private String getPrefix() {
        return String.valueOf(this.plugin.getConfig().getString("Messages.Prefix")) + " ";
    }

    private String getCurrency() {
        this.currency = this.getBareString(this.currencyPath);
        return this.currency;
    }

    private String color(String stringToColor) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)stringToColor);
    }

    private boolean playerIsNotHoldingAir() {
        return this.player.getItemInHand().getType() != Material.AIR;
    }

    private void resetName() {
        this.newLore = "";
        if (!this.oldLore.isEmpty()) {
            this.oldLore.clear();
        }
    }

    private void loreItem() {
        this.meta = this.item.getItemMeta();
        if (this.meta.hasLore()) {
            this.oldLore = this.meta.getLore();
        }
        this.lore = new ArrayList<String>();
        this.lore.add(ChatColor.RESET + this.newLore);
        this.meta.setLore(this.lore);
        this.item.setItemMeta(this.meta);
        this.player.sendMessage(this.getString(this.loreSuccess).replace("%lore%", this.newLore));
        if (this.oldLore.size() == 0) {
            this.log.logLore(this.player.getName(), this.item.getType(), null, this.newLore);
        } else {
            this.log.logLore(this.player.getName(), this.item.getType(), this.oldLore.get(0), this.newLore);
        }
    }

    private void add(String[] args) {
        this.x = 0;
        while (this.x < args.length) {
            this.newLore = this.x == args.length - 1 ? String.valueOf(this.newLore) + args[this.x] : String.valueOf(this.newLore) + args[this.x] + " ";
            ++this.x;
        }
    }

    private void setToExperience() {
        this.plugin.getConfig().set(this.currencyPath, (Object)"experience");
        this.plugin.getLogger().warning("Currency was set to \"money\" but Vault was not found! Setting currency to \"experience\" for the new currency");
        this.plugin.saveConfig();
        this.player.sendMessage(this.color(String.valueOf(this.getPrefix()) + "&4Error: &cWe're sorry, something went wrong. Try again!"));
    }

    private boolean vaultExists() {
        return this.plugin.getServer().getPluginManager().getPlugin("Vault") != null;
    }

    private boolean takeMoney() {
        if (this.player.hasPermission(this.bPerm)) {
            return true;
        }
        this.response = this.plugin.econ.withdrawPlayer((OfflinePlayer)this.player, (double)this.getInt(this.amount));
        if (this.response.transactionSuccess()) {
            this.player.sendMessage(this.getString(this.transactionSuccess).replace("%cost%", String.valueOf(this.getInt(this.amount))).replace(" %currency%", ""));
            return true;
        }
        this.player.sendMessage(this.getString(this.transactionFailure).replace("%cost%", String.valueOf(this.getInt(this.amount))).replace(" %currency%", ""));
        return false;
    }

    private boolean takeExperience() {
        if (this.player.hasPermission(this.bPerm)) {
            return true;
        }
        if (this.player.getLevel() >= this.getInt(this.experience)) {
            this.player.setLevel(this.player.getLevel() - this.getInt(this.experience));
            this.player.sendMessage(this.getString(this.transactionSuccess).replace("$%cost%", String.valueOf(this.getInt(this.experience))).replace("%currency%", "experience levels"));
            return true;
        }
        this.player.sendMessage(this.getString(this.transactionFailure).replace("$%cost%", String.valueOf(this.getInt(this.experience))).replace("%currency%", "experience levels"));
        return false;
    }
}

