/*
 * Decompiled with CFR 0.152.
 */
package com.headgam3z.easyitemrename.commands;

import com.headgam3z.easyitemrename.Main;
import java.io.File;
import java.io.IOException;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CopyRename
implements CommandExecutor {
    private Main plugin;
    private Player player;
    private String cPerm;
    private String copyRenameAir;
    private String console;
    private String invalidSyntax;
    private String noPermission;
    private String copyRenameSuccess;
    private String copyRenameTip;
    private String copyRenameNone;
    private String name;
    private File dataFolder;
    private File playerFile;
    private YamlConfiguration playerConfig;
    private ItemStack item;
    private ItemMeta meta;

    public CopyRename(Main instance) {
        this.plugin = instance;
        this.cPerm = "easyitemrename.copyrename";
        this.copyRenameAir = "Messages.CopyRename-Air";
        this.console = "Messages.Not-A-Player";
        this.invalidSyntax = "Messages.CopyRename-Failure";
        this.noPermission = "Messages.No-Permission";
        this.copyRenameSuccess = "Messages.CopyRename-Success";
        this.copyRenameTip = "Messages.CopyRename-Tip";
        this.copyRenameNone = "Messages.CopyRename-None";
    }

    public boolean onCommand(CommandSender sender, Command cmd, String s, String[] args) {
        if (sender instanceof Player) {
            this.player = (Player)sender;
            if (this.getPlayer().hasPermission(this.cPerm)) {
                if (args.length == 0) {
                    if (this.playerIsNotHoldingAir()) {
                        if (this.playerIsHoldingRenamedItem()) {
                            if (this.makeFiles()) {
                                this.playerConfig = YamlConfiguration.loadConfiguration((File)this.playerFile);
                                this.item = this.getPlayer().getItemInHand();
                                this.meta = this.item.getItemMeta();
                                this.name = this.meta.getDisplayName().replace("\u00a7", "&");
                                this.playerConfig.set("CopiedName", (Object)this.name);
                                this.save();
                                this.getPlayer().sendMessage(this.getString(this.copyRenameSuccess).replace("%name%", this.meta.getDisplayName()));
                                this.getPlayer().sendMessage(this.getString(this.copyRenameTip));
                                return true;
                            }
                            this.getPlugin().getLogger().warning("Uht oh - something went wrong; files could not get created!");
                            return false;
                        }
                        this.getPlayer().sendMessage(this.getString(this.copyRenameNone));
                        return false;
                    }
                    this.getPlayer().sendMessage(this.getString(this.copyRenameAir));
                    return false;
                }
                this.getPlayer().sendMessage(this.getString(this.invalidSyntax));
                return false;
            }
            this.getPlayer().sendMessage(this.getString(this.noPermission));
            return false;
        }
        sender.sendMessage(this.getString(this.console));
        return false;
    }

    private boolean makeFiles() {
        this.dataFolder = new File(this.getPlugin().getDataFolder(), "Data");
        this.playerFile = new File(this.getFolder(), this.getPlayer().getUniqueId() + ".yml");
        if (!this.getFolder().exists()) {
            this.getFolder().mkdir();
        }
        if (!this.getFile().exists()) {
            try {
                this.getFile().createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private boolean playerIsNotHoldingAir() {
        return this.getPlayer().getItemInHand().getType() != Material.AIR;
    }

    private boolean playerIsHoldingRenamedItem() {
        return this.getPlayer().getItemInHand().getItemMeta().hasDisplayName();
    }

    private void save() {
        try {
            this.playerConfig.save(this.playerFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Main getPlugin() {
        return this.plugin;
    }

    private Player getPlayer() {
        return this.player;
    }

    private File getFolder() {
        return this.dataFolder;
    }

    private File getFile() {
        return this.playerFile;
    }

    private String getString(String path) {
        return this.color(String.valueOf(this.getPrefix()) + this.plugin.getConfig().getString(path));
    }

    private String getPrefix() {
        return String.valueOf(this.getPlugin().getConfig().getString("Messages.Prefix")) + " ";
    }

    private String color(String stringToColor) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)stringToColor);
    }
}

