/*
 * Decompiled with CFR 0.152.
 */
package com.headgam3z.easyitemrename;

import com.headgam3z.easyitemrename.Metrics;
import com.headgam3z.easyitemrename.commands.CopyLore;
import com.headgam3z.easyitemrename.commands.CopyRename;
import com.headgam3z.easyitemrename.commands.Lore;
import com.headgam3z.easyitemrename.commands.PasteLore;
import com.headgam3z.easyitemrename.commands.PasteRename;
import com.headgam3z.easyitemrename.commands.Reload;
import com.headgam3z.easyitemrename.commands.Rename;
import java.io.IOException;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    public Economy econ = null;
    public String currency = "none";
    private PluginDescriptionFile pdf = this.getDescription();

    public void onEnable() {
        this.setupVault();
        this.setupConfig();
        this.addCommands();
        this.setupMetrics();
        this.getLogger().info(this.getMessage("enabled"));
    }

    public void onDisable() {
        this.getLogger().info(this.getMessage("disabled"));
    }

    private void setupMetrics() {
        try {
            Metrics metrics = new Metrics((Plugin)this);
            metrics.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean setupVault() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().info("Vault was not found! Players can not be charged in-game money when using EasyItemRename.");
            this.setCurrency("experience");
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.getLogger().info("Hooked into Vault");
        this.setCurrency("money");
        this.econ = (Economy)rsp.getProvider();
        return this.econ != null;
    }

    private void setupConfig() {
        this.addHeader();
        this.addDefaults();
        this.saveConfig();
    }

    private void addHeader() {
        this.getConfig().options().header("Currency ## Type of cost for using either /rename or /lore (Available types: Money, Experience, and None).\nCost-To-Rename ## Cost to use /rename (Currency must be set to Money).\nCost-To-Lore ## Cost to use /lore (Currency must be set to Money).\nExperience-To-Rename ## Experience to use /rename (Currency must be set to Experience).\nExperience-To-Lore ## Experience to use /lore (Currency must be set to Experience).\nPrefix ## Message that appears before all other messages.\nRename-Success ## Message that gets sent to the player that successfully renames an item (%name% = the player's new item name).\nRename-Failure ## Message that gets sent to the player that does not successfully rename an item.\nRename-Air ## Message that gets sent to the player that tries to rename air.\nLore-Success ## Message that gets sent to the player that successfully lores an item (%lore% = the player's new item lore).\nLore-Failure ## Message that gets sent to the player that does not successfully lore an item.\nLore-Air ## Message that gets sent to the player that tries to lore air.\nReload-Success ## Message that gets sent to the player that successfully reloads the getConfig().yml file.\nReload-Failure ## Message that gets sent to the player that does not successfully reload the getConfig().yml file.\nTransaction-Success ## Message that gets sent to the player that has a successful transaction using either /rename or /lore (Currency must be set to either Money or Experience).\nTransaction-Failure ## Message that gets sent to the player that does not have a successful transaction using either /rename or /lore (Currency must be set to either Money or Experience).\nNot-A-Player ## Message that gets sent to the console when it tries to use either /rename or /lore.\nNo-Permission ## Message that gets sent to the player that does not have permission to either /rename, /lore, or /easyitemrenamereload.\n");
        this.getConfig().options().copyHeader(true);
    }

    private void addDefaults() {
        this.getConfig().addDefault("Settings.Currency", (Object)this.currency);
        this.getConfig().addDefault("Settings.Cost-To-Rename", (Object)1000);
        this.getConfig().addDefault("Settings.Cost-To-Lore", (Object)1000);
        this.getConfig().addDefault("Settings.Experience-To-Rename", (Object)5);
        this.getConfig().addDefault("Settings.Experience-To-Lore", (Object)5);
        this.getConfig().addDefault("Messages.Prefix", (Object)"&8[&6EasyItemRename&8]");
        this.getConfig().addDefault("Messages.Rename-Success", (Object)"&aSuccessfully renamed to &r%name%&a.");
        this.getConfig().addDefault("Messages.Rename-Failure", (Object)"&4Error: &cInvalid syntax. &4Usage: &c/rename <name>");
        this.getConfig().addDefault("Messages.Rename-Air", (Object)"&4Error: &cYou cannot rename air.");
        this.getConfig().addDefault("Messages.Lore-Success", (Object)"&aSuccessfully lored to &r%lore%&a.");
        this.getConfig().addDefault("Messages.Lore-Failure", (Object)"&4Error: &cInvalid syntax. &4Usage: &c/lore <lore>");
        this.getConfig().addDefault("Messages.Lore-Air", (Object)"&4Error: &cYou cannot lore air.");
        this.getConfig().addDefault("Messages.Reload-Success", (Object)"&agetConfig()uration reloaded.");
        this.getConfig().addDefault("Messages.Reload-Failure", (Object)"&4Error: &cInvalid syntax. &4Usage: &c/reload");
        this.getConfig().addDefault("Messages.CopyRename-Success", (Object)"&aSuccessfully copied rename &r%name%&a.");
        this.getConfig().addDefault("Messages.CopyRename-Failure", (Object)"&4Error: &cInvalid syntax. &4Usage: &c/copyrename");
        this.getConfig().addDefault("Messages.CopyRename-Air", (Object)"&4Error: &cYou cannot copy air.");
        this.getConfig().addDefault("Messages.CopyRename-Tip", (Object)"&aUse &2/pasterename &ato paste your copied rename onto an item.");
        this.getConfig().addDefault("Messages.CopyRename-None", (Object)"&4Error: &cYou are not holding a renamed item.");
        this.getConfig().addDefault("Messages.CopyLore-Success", (Object)"&aSuccessfully copied lore &r%lore%");
        this.getConfig().addDefault("Messages.CopyLore-Failure", (Object)"&4Error: Invalid syntax. &4Usage: /copylore");
        this.getConfig().addDefault("Messages.CopyLore-Air", (Object)"&4Error: &cYou cannot copy air");
        this.getConfig().addDefault("Messages.CopyLore-Tip", (Object)"&aUse &2/pastelore &ato paste your copied lore onto an item.");
        this.getConfig().addDefault("Messages.CopyLore-None", (Object)"&4Error: &cYou are not holding an item with a lore on it.");
        this.getConfig().addDefault("Messages.PasteRename-Success", (Object)"&aSuccessfully pasted rename &r%name%&a.");
        this.getConfig().addDefault("Messages.PasteRename-Failure", (Object)"&4Error: &cInvalid syntax. &4Usage: /pasterename [?]");
        this.getConfig().addDefault("Messages.PasteRename-Air", (Object)"&4Error: &cYou cannot paste air.");
        this.getConfig().addDefault("Messages.PasteRename-None", (Object)"&4Error: &cYou do not have a rename copied.");
        this.getConfig().addDefault("Messages.PasteRename-Current", (Object)"&aYour current rename paste is: &r%name%");
        this.getConfig().addDefault("Messages.PasteLore-Success", (Object)"&aSuccessfully pasted lore &r%lore%&a.");
        this.getConfig().addDefault("Messages.PasteLore-Failure", (Object)"&4Error: &cInvalid syntax. &4Usage: /pastelore [?]");
        this.getConfig().addDefault("Messages.PasteLore-Air", (Object)"&4Error: &cYou cannot paste air.");
        this.getConfig().addDefault("Messages.PasteLore-None", (Object)"&4Error: &cYou do not have a lore copied.");
        this.getConfig().addDefault("Messages.PasteLore-Current", (Object)"&aYour current lore paste is: &r%lore%");
        this.getConfig().addDefault("Messages.Transaction-Success", (Object)"&aYou were charged &2$%cost%&a %currency%.");
        this.getConfig().addDefault("Messages.Transaction-Failure", (Object)"&4Error: &cYou do not have &4$%cost%&c %currency%.");
        this.getConfig().addDefault("Messages.Not-A-Player", (Object)"&4Error: &cYou must be a logged in player to use this command.");
        this.getConfig().addDefault("Messages.No-Permission", (Object)"&4Error: &cYou do not have permission to use this command.");
        this.getConfig().options().copyDefaults(true);
    }

    private void addCommands() {
        this.getCommand("rename").setExecutor((CommandExecutor)new Rename(this));
        this.getCommand("lore").setExecutor((CommandExecutor)new Lore(this));
        this.getCommand("easyitemrenamereload").setExecutor((CommandExecutor)new Reload(this));
        this.getCommand("copyrename").setExecutor((CommandExecutor)new CopyRename(this));
        this.getCommand("pasterename").setExecutor((CommandExecutor)new PasteRename(this));
        this.getCommand("copylore").setExecutor((CommandExecutor)new CopyLore(this));
        this.getCommand("pastelore").setExecutor((CommandExecutor)new PasteLore(this));
    }

    private String getMessage(String type) {
        return "Successfully " + type + " " + this.pdf.getName() + " v" + this.pdf.getVersion();
    }

    private String setCurrency(String currency) {
        this.currency = currency;
        return this.currency;
    }
}

