/*
 * Decompiled with CFR 0.152.
 */
package com.headgam3z.easyitemrename;

import com.headgam3z.easyitemrename.Main;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bukkit.Material;

public class Logger {
    private Main plugin;
    private File saveTo;

    public Logger(Main instance) {
        this.plugin = instance;
        this.saveTo = new File(this.plugin.getDataFolder(), "log.txt");
    }

    public void logToFile(String message) {
        try {
            if (!this.saveTo.exists()) {
                this.saveTo.createNewFile();
            }
            FileWriter fw = new FileWriter(this.saveTo, true);
            PrintWriter pw = new PrintWriter(fw);
            pw.println(message);
            pw.flush();
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void logRename(String player, Material itemType, String oldName, String newName) {
        long milliseconds = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("[MMM dd, yyyy - HH:mm:ss] ");
        Date resultdate = new Date(milliseconds);
        if (oldName != null) {
            oldName = this.clean(oldName, 2);
            newName = this.clean(newName, 0);
            this.logToFile(String.valueOf(sdf.format(resultdate)) + player + " renamed " + itemType + " with the name of \"" + oldName + "\" to \"" + newName + "\".");
            this.plugin.getLogger().info(String.valueOf(player) + " renamed " + itemType + " with the name of \"" + oldName + "\" to \"" + newName + "\".");
        } else {
            this.logToFile(String.valueOf(sdf.format(resultdate)) + player + " renamed " + itemType + " with the name of \"" + itemType + "\" to \"" + newName + "\".");
            this.plugin.getLogger().info(String.valueOf(player) + " renamed " + itemType + " with the name of \"" + itemType + "\" to \"" + newName + "\".");
        }
    }

    public void logLore(String player, Material itemType, String oldName, String newName) {
        long milliseconds = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("[MMM dd, yyyy - HH:mm:ss] ");
        Date resultdate = new Date(milliseconds);
        if (oldName != null) {
            oldName = this.clean(oldName, 2);
            newName = this.clean(newName, 0);
            this.logToFile(String.valueOf(sdf.format(resultdate)) + player + " lored " + itemType + " with the lore of \"" + oldName + "\" to \"" + newName + "\".");
            this.plugin.getLogger().info(String.valueOf(player) + " lored " + itemType + " with the lore of \"" + oldName + "\" to \"" + newName + "\".");
            return;
        }
        this.logToFile(String.valueOf(sdf.format(resultdate)) + player + " lored " + itemType + " with the lore of \"no lore\" to \"" + newName + "\".");
        this.plugin.getLogger().info(String.valueOf(player) + " lored " + itemType + " with the lore of \"no lore\" to \"" + newName + "\".");
    }

    private String clean(String stringToClean, int number) {
        stringToClean = stringToClean.substring(number, stringToClean.length()).replace("\u00a7", "&");
        return stringToClean;
    }
}

