/*
 * Decompiled with CFR 0.152.
 */
package de.jeppa.DragonSlayer;

import de.jeppa.DragonSlayer.DragonRespawn;
import de.jeppa.DragonSlayer.DragonSlayer;
import de.jeppa.DragonSlayer.WorldRefreshOrReset;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class TimerManager {
    DragonSlayer plugin;
    ArrayList<DragonRespawn> RespawnList = new ArrayList();
    private FileConfiguration Timer = null;
    private File TimerFile = null;

    public TimerManager(DragonSlayer instance) {
        this.plugin = instance;
    }

    private void reloadTimers() {
        if (this.TimerFile == null) {
            this.TimerFile = new File(this.plugin.getDataFolder(), "TimerList.yml");
        }
        this.Timer = YamlConfiguration.loadConfiguration((File)this.TimerFile);
    }

    FileConfiguration getTimerlist() {
        if (this.Timer == null) {
            this.reloadTimers();
        }
        return this.Timer;
    }

    void saveTimerlist() {
        if (this.Timer == null || this.TimerFile == null) {
            return;
        }
        try {
            this.getTimerlist().save(this.TimerFile);
        }
        catch (IOException ex) {
            this.plugin.logger.warning("Could not save timerlist to " + this.TimerFile);
        }
    }

    void RestartTimers() {
        String Mapname;
        if (this.Timer.contains("Timerlist.1")) {
            int i = 1;
            while (this.Timer.getConfigurationSection("Timerlist." + i) != null) {
                long Resttime = this.Timer.getLong("Timerlist." + i + ".Resttime");
                Mapname = this.Timer.getString("Timerlist." + i + ".Mapname");
                this.StartTimer(Mapname, Resttime);
                if (this.plugin.configManager.getVerbosity()) {
                    this.plugin.logger.info("Restarting a timer for dragonspawn on: " + Mapname);
                }
                ++i;
            }
        }
        for (String Mapname2 : this.plugin.configManager.getMaplist()) {
            boolean found = false;
            int Resttime = 6000;
            for (DragonRespawn Resp : this.RespawnList) {
                if (!Mapname2.equals(Resp.Mapname)) continue;
                found = true;
                break;
            }
            if (found || !this.plugin.configManager.getAutofix(Mapname2) || this.plugin.configManager.getDelay(Mapname2.toLowerCase()) <= 0) continue;
            this.StartTimer(Mapname2, Resttime);
            if (!this.plugin.configManager.getVerbosity()) continue;
            this.plugin.logger.info("Start of an additional fix-timer on: " + Mapname2);
        }
        if (this.Timer.contains("ResetTimerlist.1")) {
            int i = 1;
            while (this.Timer.getConfigurationSection("ResetTimerlist." + i) != null) {
                long Resttime = this.Timer.getLong("ResetTimerlist." + i + ".Resttime");
                Mapname = this.Timer.getString("ResetTimerlist." + i + ".Mapname");
                this.plugin.StartWorldResetTimer(Mapname, Resttime, this.plugin.configManager.getWarnTime(Mapname));
                if (this.plugin.configManager.getVerbosity()) {
                    this.plugin.logger.info("Restarting a reset-timer on: " + Mapname);
                }
                ++i;
            }
        }
    }

    public void StartTimer(String Mapname, long Resttime) {
        DragonRespawn Resp = this.createStartTimer(Mapname, Resttime);
        Resp.taskId = this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)Resp, Resttime).getTaskId();
    }

    DragonRespawn createStartTimer(String Mapname, long Resttime) {
        DragonRespawn Resp = new DragonRespawn(this.plugin);
        Resp.Mapname = Mapname;
        Resp.OrigRuntime = Resttime;
        return Resp;
    }

    public void clearTimers() {
        this.Timer.set("Timerlist", null);
        this.Timer.set("ResetTimerlist", null);
        for (DragonRespawn Resp : this.RespawnList) {
            this.plugin.getServer().getScheduler().cancelTask(Resp.taskId);
            Resp = null;
        }
        for (WorldRefreshOrReset Res : this.plugin.ResetimerList) {
            this.plugin.getServer().getScheduler().cancelTask(Res.taskId);
            Object var1_2 = null;
        }
        this.RespawnList.clear();
        this.plugin.ResetimerList.clear();
        this.saveTimerlist();
    }

    void updateTimerList() {
        this.Timer.set("Timerlist", null);
        this.Timer.set("ResetTimerlist", null);
        int i = 1;
        for (DragonRespawn Resp : this.RespawnList) {
            Long Resttime = this.plugin.remainingTimerDuration(Resp);
            if (Resttime == null || Resttime <= 0L) continue;
            this.Timer.set("Timerlist." + i + ".Mapname", (Object)Resp.Mapname);
            this.Timer.set("Timerlist." + i + ".Resttime", (Object)Resttime);
            ++i;
        }
        i = 1;
        while (i <= this.plugin.ResetimerList.size()) {
            WorldRefreshOrReset Res = this.plugin.ResetimerList.get(i - 1);
            Long Resttime = this.plugin.remainingResetDuration(Res);
            if (Resttime != null && Resttime > 0L) {
                this.Timer.set("ResetTimerlist." + i + ".Mapname", (Object)Res.Mapname);
                this.Timer.set("ResetTimerlist." + i + ".Resttime", (Object)Resttime);
            }
            ++i;
        }
    }
}

