/*
 * Decompiled with CFR 0.152.
 */
package de.jeppa.DragonSlayer;

import de.jeppa.DragonSlayer.DragonRespawn;
import de.jeppa.DragonSlayer.DragonSlayer;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Bed;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.EndGateway;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    DragonSlayer plugin;

    public PlayerListener(DragonSlayer instance) {
        this.plugin = instance;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player p = event.getPlayer();
        World TheWorld = p.getWorld();
        if (this.plugin.checkWorld(TheWorld.getName().toLowerCase())) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.setDragsKilledAndTeleport(TheWorld, false);
                this.plugin.handleBossbar(TheWorld);
                this.checkMissingTimers(TheWorld.getName().toLowerCase());
                this.plugin.setTimerdisplayToPlayer(p);
            }, 120L);
        }
        this.plugin.setTabListName(p);
        this.sendNPCClientPackets(TheWorld, p);
    }

    @EventHandler
    public void onPlayerUseTransferportal(PlayerTeleportEvent event) {
        World TheWorld;
        String worldname;
        if (this.plugin.MinVersion19 && event.getCause().compareTo((Enum)PlayerTeleportEvent.TeleportCause.END_GATEWAY) == 0 && this.plugin.checkWorld(worldname = (TheWorld = event.getFrom().getWorld()).getName().toLowerCase())) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.setDragsKilledAndTeleport(TheWorld, false);
                this.plugin.handleBossbar(TheWorld);
            }, 60L);
            Location getFromLoc = event.getFrom();
            Location teleportTargetLoc = event.getTo();
            Location mapCenter = new Location(TheWorld, 0.0, (double)teleportTargetLoc.getBlockY(), 0.0);
            if (teleportTargetLoc.distance(mapCenter) > 127.0) {
                boolean found = false;
                int x = -1;
                while (x <= 1) {
                    int z = -1;
                    while (z <= 1) {
                        BlockState[] tileEnts;
                        Chunk gwChunk = getFromLoc.getBlock().getRelative(x * 16, 0, z * 16).getChunk();
                        BlockState[] blockStateArray = tileEnts = gwChunk.getTileEntities();
                        int n = tileEnts.length;
                        int n2 = 0;
                        while (n2 < n) {
                            BlockState tileEnt = blockStateArray[n2];
                            if (tileEnt instanceof EndGateway) {
                                Location sourceGWLoc = tileEnt.getLocation();
                                Location targetLoc = ((EndGateway)tileEnt).getExitLocation();
                                if (targetLoc != null) {
                                    if (this.plugin.configManager.getFixGateways(worldname) && mapCenter.distance(sourceGWLoc) > 127.0) {
                                        Location testExitLoc2;
                                        Location exitLoc = this.plugin.getClosestGateway(TheWorld, sourceGWLoc);
                                        if (exitLoc == null) {
                                            exitLoc = new Location(TheWorld, 20.0, (double)teleportTargetLoc.getBlockY(), 20.0);
                                        }
                                        if (targetLoc.getBlock().getType() == Material.END_GATEWAY && (testExitLoc2 = ((EndGateway)targetLoc.getBlock().getState()).getExitLocation()) != null && testExitLoc2.distance(exitLoc) < 90.0) {
                                            exitLoc = testExitLoc2;
                                        }
                                        ((EndGateway)tileEnt).setExitLocation(exitLoc);
                                        if (this.plugin.configManager.getVerbosity()) {
                                            this.plugin.logger.info("Gateway target updated/fixed for teleport to center island!");
                                        }
                                        if (this.plugin.configManager.debugOn()) {
                                            this.plugin.logger.info("New target:" + exitLoc);
                                        }
                                        ((EndGateway)tileEnt).update();
                                    }
                                    if (targetLoc.distance(teleportTargetLoc) < 50.0 && !targetLoc.equals((Object)sourceGWLoc)) {
                                        if (targetLoc.getBlock().getType() == Material.END_GATEWAY) {
                                            if (targetLoc.getBlock().getRelative(0, -12, 0).getType() == Material.END_GATEWAY) {
                                                targetLoc.setY(targetLoc.getY() - 2.0);
                                                ((EndGateway)tileEnt).setExitLocation(targetLoc.getBlock().getRelative(0, -10, 0).getLocation());
                                                ((EndGateway)tileEnt).update();
                                            } else {
                                                targetLoc.setY(targetLoc.getY() + 10.0);
                                            }
                                        } else {
                                            targetLoc.setY(targetLoc.getY() + 3.0);
                                        }
                                        this.removeStackedGateway(targetLoc);
                                        found = true;
                                        break;
                                    }
                                }
                            }
                            ++n2;
                        }
                        if (found) break;
                        ++z;
                    }
                    if (found) break;
                    ++x;
                }
            }
        }
    }

    private void removeStackedGateway(Location removeArea) {
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (removeArea != null) {
                int y;
                int y2 = y = removeArea.getBlockY();
                while (y2 <= (y + 6 <= 255 ? y + 6 : 255)) {
                    removeArea.setY((double)y2);
                    int x2 = -1;
                    while (x2 <= 1) {
                        int z2 = -1;
                        while (z2 <= 1) {
                            if (x2 == 0 || z2 == 0) {
                                removeArea.getBlock().getRelative(x2, 0, z2).setType(Material.AIR);
                            }
                            ++z2;
                        }
                        ++x2;
                    }
                    ++y2;
                }
            }
        }, 0L);
    }

    private void setDragsKilledAndTeleport(World TheWorld, boolean teleport) {
        Collection EntityList = TheWorld.getEntitiesByClass(EnderDragon.class);
        String Mapname = TheWorld.getName().toLowerCase();
        int y = 0;
        int Playercount = teleport ? this.plugin.getPlayerCount(TheWorld.getName().toLowerCase()) : 0;
        for (EnderDragon Dragon : EntityList) {
            if (!Dragon.isValid()) continue;
            if (this.plugin.configManager.getDragonTeleport(Mapname) && Playercount == 1) {
                int dragonId = this.plugin.getDragonIDMeta(Dragon);
                if (this.plugin.checkDSLDragon(Dragon)) {
                    Dragon.teleport(new Location(TheWorld, (double)this.plugin.configManager.getPortalX(Mapname, dragonId), (double)(75 + y), (double)this.plugin.configManager.getPortalZ(Mapname, dragonId)));
                    y += 8;
                }
            }
            this.plugin.OrigEnderDragonSetKilled(Dragon);
        }
    }

    @EventHandler
    public void worldChange(PlayerChangedWorldEvent event) {
        World TheWorld;
        String TogoWorld;
        Player p = event.getPlayer();
        String ThisWorld = event.getFrom().getName();
        if (this.plugin.checkWorld(ThisWorld)) {
            this.plugin.deletePlayersBossBars(p);
            this.plugin.delTimerdisplayFromPlayer(p);
        }
        if (this.plugin.checkWorld(TogoWorld = (TheWorld = p.getWorld()).getName().toLowerCase())) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                int ExistentDragons = this.plugin.getDragonCount(TogoWorld);
                this.setDragsKilledAndTeleport(TheWorld, true);
                String ProtectMessage = this.plugin.configManager.getProtectMessage(TheWorld.getName());
                if (!ProtectMessage.equals("")) {
                    if (ProtectMessage.contains("$amount")) {
                        p.sendMessage(ChatColor.DARK_PURPLE + ProtectMessage.replace("$amount", String.valueOf(ExistentDragons)));
                    } else {
                        p.sendMessage(ChatColor.DARK_PURPLE + ExistentDragons + " " + ProtectMessage);
                    }
                }
                this.checkMissingTimers(TogoWorld);
            }, 10L);
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.setDragsKilledAndTeleport(TheWorld, false);
                this.plugin.handleBossbar(TheWorld);
                this.plugin.setTimerdisplayToPlayer(p);
            }, 120L);
        }
        this.sendNPCClientPackets(TheWorld, p);
    }

    private void sendNPCClientPackets(World TheWorld, Player p) {
        if (this.plugin.getStatueVersion() != 2) {
            return;
        }
        World statueWorld = this.plugin.getArmorstandWorld();
        if (TheWorld.equals(statueWorld)) {
            this.plugin.sendNPCClientPacket(p);
        }
    }

    private void checkMissingTimers(String TogoWorld) {
        int missingDragons;
        if (this.plugin.configManager.getAutofix(TogoWorld.toLowerCase()) && this.plugin.configManager.getDelay(TogoWorld.toLowerCase()) > 0 && (missingDragons = this.plugin.missingDragons(TogoWorld)) > 0) {
            int i = 0;
            while (i < missingDragons) {
                DragonRespawn Resp = new DragonRespawn(this.plugin);
                Resp.Mapname = TogoWorld;
                int runduration = this.plugin.configManager.getDelay(TogoWorld) + i * 60;
                Resp.OrigRuntime = runduration;
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)Resp, (long)runduration);
                this.plugin.getLogger().info("Additional timer for dragonrespawn in world " + TogoWorld + " started...");
                ++i;
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void playerChat(AsyncPlayerChatEvent e) {
        if (!this.plugin.EssChEnabled) {
            Player p = e.getPlayer();
            if (this.plugin.configManager.getPrefixEnabled() && this.plugin.getSlayerUUIDString().equals(p.getUniqueId().toString())) {
                String prefix = this.plugin.configManager.getPrefix();
                if (!p.getDisplayName().contains(this.plugin.configManager.getPrefix().trim()) && (!this.plugin.UCenabled && !this.plugin.PAPIenabled || this.plugin.configManager.getForcePrefix())) {
                    if (!this.plugin.configManager.getPrefixAsSuffix()) {
                        e.setFormat(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(prefix) + "%s: %s")));
                    } else {
                        e.setFormat(ChatColor.translateAlternateColorCodes((char)'&', (String)("%s" + prefix + ": %s")));
                    }
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void playerEssentialsChat(AsyncPlayerChatEvent e) {
        if (this.plugin.EssChEnabled) {
            Player p = e.getPlayer();
            if (this.plugin.configManager.getPrefixEnabled() && this.plugin.getSlayerUUIDString().equals(p.getUniqueId().toString())) {
                String prefix = this.plugin.configManager.getPrefix();
                if (!p.getDisplayName().contains(this.plugin.configManager.getPrefix().trim()) && (!this.plugin.UCenabled && !this.plugin.PAPIenabled || this.plugin.configManager.getForcePrefix())) {
                    e.setFormat(e.getFormat().replace("{DRAGONSLAYER}", ChatColor.translateAlternateColorCodes((char)'&', (String)prefix)));
                }
            } else {
                e.setFormat(e.getFormat().replace("{DRAGONSLAYER}", ChatColor.translateAlternateColorCodes((char)'&', (String)"")));
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void ArmorStandInteract1(PlayerArmorStandManipulateEvent e) {
        ArmorStand armorStand;
        if (e.getRightClicked() instanceof ArmorStand && (armorStand = e.getRightClicked()).hasMetadata("DSL-AS")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onArmorStandDamage(EntityDamageEvent event) {
        ArmorStand armorStand;
        if (event.getEntity() instanceof ArmorStand && (armorStand = (ArmorStand)event.getEntity()).hasMetadata("DSL-AS") && event.getDamage() > 0.0) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onCrystalDamage1(EntityDamageEvent event) {
        String world;
        if (!this.plugin.MinVersion19) {
            return;
        }
        Entity ent = event.getEntity();
        if (ent instanceof EnderCrystal && this.plugin.checkWorld(world = ent.getWorld().getName().toLowerCase()) && this.plugin.configManager.getRefreshWorld(world)) {
            Location loc = ent.getLocation();
            int portX = this.plugin.configManager.getPortalXdef(world);
            int portZ = this.plugin.configManager.getPortalZdef(world);
            if (loc.getX() == (double)portX + 0.5 && (loc.getZ() == (double)portZ - 2.5 || loc.getZ() == (double)portZ + 3.5) || loc.getZ() == (double)portZ + 0.5 && (loc.getX() == (double)portX - 2.5 || loc.getX() == (double)portX + 3.5)) {
                if (this.plugin.isRefreshRunning(ent.getWorld())) {
                    event.setCancelled(true);
                    ent.setInvulnerable(true);
                } else {
                    ent.setInvulnerable(false);
                }
            }
        }
    }

    @EventHandler
    public void onCrystalDamage2(ExplosionPrimeEvent event) {
        String world;
        if (!this.plugin.MinVersion19) {
            return;
        }
        Entity ent = event.getEntity();
        if (ent.getType().equals((Object)EntityType.PRIMED_TNT) && this.plugin.checkWorld(world = ent.getWorld().getName().toLowerCase()) && this.plugin.configManager.getRefreshWorld(world) && this.plugin.isRefreshRunning(ent.getWorld())) {
            Location loc = ent.getLocation();
            int portX = this.plugin.configManager.getPortalXdef(world);
            int portZ = this.plugin.configManager.getPortalZdef(world);
            if (loc.getX() <= (double)(portX + 5) && loc.getX() >= (double)(portX - 5) && loc.getZ() <= (double)(portZ + 5) && loc.getZ() >= (double)(portZ - 5)) {
                event.setCancelled(true);
                ent.setInvulnerable(true);
            }
        }
    }

    @EventHandler
    public void CancelEggTeleport(BlockFromToEvent e) {
        boolean DisableEggTeleport;
        String world = e.getBlock().getWorld().getName().toLowerCase();
        if (this.plugin.checkWorld(world) && (DisableEggTeleport = this.plugin.configManager.getEggCancel(world)) && e.getBlock().getType() == Material.DRAGON_EGG) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void CancelEggTeleport(BlockBreakEvent e) {
        boolean DisableEggTeleport;
        String world = e.getBlock().getWorld().getName().toLowerCase();
        if (this.plugin.checkWorld(world) && (DisableEggTeleport = this.plugin.configManager.getEggCancel(world)) && e.getBlock().getType() == Material.DRAGON_EGG) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void CancelCrystalPlace(PlayerInteractEvent event) {
        if (!this.plugin.MinVersion19) {
            return;
        }
        Player p = event.getPlayer();
        World ThisWorld = p.getWorld();
        Block bl = event.getClickedBlock();
        String world = ThisWorld.getName().toLowerCase();
        if (this.plugin.checkWorld(world)) {
            if ((this.plugin.configManager.getCrystalDeny(world) || this.plugin.configManager.getMultiPortal()) && event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && (bl.getType().equals((Object)Material.BEDROCK) || bl.getType().equals((Object)Material.OBSIDIAN))) {
                Material EndCrystal;
                try {
                    EndCrystal = Material.valueOf((String)"END_CRYSTAL");
                }
                catch (Exception ex) {
                    EndCrystal = Material.valueOf((String)"ENDER_CRYSTAL");
                }
                if (event.getMaterial().equals((Object)EndCrystal)) {
                    Location loc = bl.getLocation();
                    int portX = this.plugin.configManager.getPortalXdef(world);
                    int portZ = this.plugin.configManager.getPortalZdef(world);
                    if (this.plugin.configManager.getCrystalDeny(world) && loc.getX() <= (double)(portX + 5) && loc.getX() >= (double)(portX - 5) && loc.getZ() <= (double)(portZ + 5) && loc.getZ() >= (double)(portZ - 5)) {
                        event.setCancelled(true);
                        p.sendMessage(this.plugin.replaceValues(this.plugin.configManager.getCrystalDenyString(), world));
                    }
                    if (this.plugin.configManager.getMultiPortal()) {
                        int i = 1;
                        while (i <= this.plugin.configManager.getMaxdragons(world)) {
                            int portX2 = this.plugin.configManager.getPortalX(world, i, true, true);
                            int portZ2 = this.plugin.configManager.getPortalZ(world, i, true, true);
                            if (portX2 != portX && portZ2 != portZ && loc.getX() <= (double)(portX2 + 5) && loc.getX() >= (double)(portX2 - 5) && loc.getZ() <= (double)(portZ2 + 5) && loc.getZ() >= (double)(portZ2 - 5)) {
                                event.setCancelled(true);
                                p.sendMessage(String.valueOf(this.plugin.replaceValues(this.plugin.configManager.getCrystalDenyString(), world)) + "!");
                            }
                            ++i;
                        }
                        this.plugin.setExitPortalLocation(ThisWorld, portX, null, portZ, true, false);
                    }
                }
            }
            if (ThisWorld.getEnvironment() == World.Environment.THE_END && this.plugin.configManager.getDenyBedExplosion(world) && event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                boolean foundBed = false;
                if (bl.getState() != null) {
                    try {
                        if (bl.getState() instanceof Bed) {
                            foundBed = true;
                        }
                    }
                    catch (Exception | NoClassDefFoundError e) {
                        try {
                            if (bl.getState().getData() instanceof org.bukkit.material.Bed) {
                                foundBed = true;
                            }
                        }
                        catch (Exception portX) {
                            // empty catch block
                        }
                    }
                }
                if (DragonSlayer.getSubVersion() >= 14 && !foundBed && bl.getType() != null) {
                    foundBed = this.plugin.newRoutines14.getBedTag(bl.getType());
                }
                if (foundBed) {
                    Collection<EnderDragon> dragonList = this.plugin.getDragonList(ThisWorld, world);
                    for (EnderDragon drag : dragonList) {
                        if (!(drag.getLocation().distance(bl.getLocation()) < 20.0)) continue;
                        event.setCancelled(true);
                        bl.breakNaturally();
                    }
                }
            }
        }
    }

    @EventHandler
    public void CancelCrystalPlace2a(BlockPistonExtendEvent event) {
        if (!this.plugin.MinVersion19) {
            return;
        }
        ArrayList<Block> blocklist = new ArrayList<Block>();
        blocklist.addAll(event.getBlocks());
        this.blockPistonEvent((BlockPistonEvent)event, blocklist);
    }

    @EventHandler
    public void CancelCrystalPlace2b(BlockPistonRetractEvent event) {
        if (!this.plugin.MinVersion19) {
            return;
        }
        ArrayList<Block> blocklist = new ArrayList<Block>();
        blocklist.addAll(event.getBlocks());
        this.blockPistonEvent((BlockPistonEvent)event, blocklist);
    }

    private void blockPistonEvent(BlockPistonEvent event, ArrayList<Block> blocklist) {
        BlockFace dir = event.getDirection();
        Block movedOne = event.getBlock().getRelative(dir);
        World ThisWorld = movedOne.getWorld();
        String world = ThisWorld.getName().toLowerCase();
        if (this.plugin.checkWorld(world) && (this.plugin.configManager.getCrystalDeny(world) || this.plugin.configManager.getMultiPortal())) {
            int portX = this.plugin.configManager.getPortalXdef(world);
            int portZ = this.plugin.configManager.getPortalZdef(world);
            if (blocklist.size() == 0) {
                blocklist.add(movedOne);
            } else {
                Block addOne = event.getBlock().getRelative(dir, blocklist.size() + 1);
                if (addOne.getType() == Material.AIR) {
                    blocklist.add(addOne);
                }
            }
            for (Block block : blocklist) {
                Entity[] entList = block.getChunk().getEntities();
                Entity foundCrystal = null;
                Location loc = block.getLocation();
                Entity[] entityArray = entList;
                int n = entList.length;
                int n2 = 0;
                while (n2 < n) {
                    Location entLoc;
                    Entity ent = entityArray[n2];
                    if (ent instanceof EnderCrystal && loc.distance(entLoc = ent.getLocation().add(0.1, 0.0, 0.1).getBlock().getLocation()) <= 1.5) {
                        foundCrystal = ent;
                        loc = block.getRelative(dir).getLocation();
                        break;
                    }
                    ++n2;
                }
                if (foundCrystal == null) continue;
                if (this.plugin.configManager.getCrystalDeny(world) && loc.getX() <= (double)(portX + 5) && loc.getX() >= (double)(portX - 5) && loc.getZ() <= (double)(portZ + 5) && loc.getZ() >= (double)(portZ - 5)) {
                    event.setCancelled(true);
                    return;
                }
                if (!this.plugin.configManager.getMultiPortal()) continue;
                int i = 1;
                while (i <= this.plugin.configManager.getMaxdragons(world)) {
                    int portX2 = this.plugin.configManager.getPortalX(world, i, true, true);
                    int portZ2 = this.plugin.configManager.getPortalZ(world, i, true, true);
                    if (portX2 != portX && portZ2 != portZ && loc.getX() <= (double)(portX2 + 5) && loc.getX() >= (double)(portX2 - 5) && loc.getZ() <= (double)(portZ2 + 5) && loc.getZ() >= (double)(portZ2 - 5)) {
                        event.setCancelled(true);
                        return;
                    }
                    ++i;
                }
                this.plugin.setExitPortalLocation(ThisWorld, portX, null, portZ, true, false);
            }
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (this.plugin.getStatueVersion() == 2) {
            double dist;
            Player p = event.getPlayer();
            Location p_loc = event.getTo();
            Location as_loc = this.plugin.armorStandLoc(true);
            if (as_loc != null && p_loc.getWorld().equals(as_loc.getWorld()) && (dist = as_loc.distance(p_loc)) <= 10.0 && dist > 9.84) {
                this.plugin.sendNPCClientPacket(p);
            }
        }
    }
}

