/*
 * Decompiled with CFR 0.152.
 */
package de.jeppa.DragonSlayer;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.Pair;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.onarandombox.MultiverseCore.MultiverseCore;
import de.jeppa.DragonSlayer.ConfigManager;
import de.jeppa.DragonSlayer.DragonCommands;
import de.jeppa.DragonSlayer.DragonEvents;
import de.jeppa.DragonSlayer.DragonEventsOld;
import de.jeppa.DragonSlayer.DragonLChatEvents;
import de.jeppa.DragonSlayer.DragonPlaceholderAPI;
import de.jeppa.DragonSlayer.DragonPlaceholderAPIold;
import de.jeppa.DragonSlayer.DragonRespawn;
import de.jeppa.DragonSlayer.DragonUChatEvents;
import de.jeppa.DragonSlayer.EssentialsListener;
import de.jeppa.DragonSlayer.FourteenPlusOnlyRoutines;
import de.jeppa.DragonSlayer.LeaderManager;
import de.jeppa.DragonSlayer.PlayerListener;
import de.jeppa.DragonSlayer.TimerManager;
import de.jeppa.DragonSlayer.WorldRefreshOrReset;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import net.milkbowl.vault.economy.Economy;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.v1_10_R1.WorldProviderTheEnd;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.SkullType;
import org.bukkit.UnsafeValues;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.material.Torch;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.EulerAngle;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class DragonSlayer
extends JavaPlugin {
    static final String Copyright = "Copyright by Jeppa (A.F.)! You are NOT allowed to decompile this plugin and/or use any parts of its code !!!";
    final Logger logger = this.getLogger();
    ConfigManager configManager = new ConfigManager(this);
    TimerManager timerManager = new TimerManager(this);
    LeaderManager leaderManager = new LeaderManager(this);
    DragonEvents dragonListener = null;
    DragonEventsOld dragonListenerOld = null;
    DragonUChatEvents dragonUChatListener = new DragonUChatEvents(this);
    DragonLChatEvents dragonLChatListener = new DragonLChatEvents(this);
    PlayerListener playerListener = new PlayerListener(this);
    EssentialsListener essentialsListener = new EssentialsListener(this);
    DragonCommands dragonCommandExecutor = new DragonCommands(this);
    FourteenPlusOnlyRoutines newRoutines14 = null;
    static Economy econ = null;
    boolean UCenabled = false;
    private boolean LegendChatenabled = false;
    boolean PAPIenabled = false;
    private boolean EssentialsEnabled = false;
    private boolean ProtocolLibEnabled = false;
    boolean EssChEnabled = false;
    boolean MinVersion19 = false;
    boolean MinVersion117 = false;
    boolean spigot = false;
    private boolean serverStarted = false;
    private ArrayList<BossBar> BossBars = new ArrayList();
    private static HashMap<EnderDragon, BossBar> DragonBarList = new HashMap();
    HashMap<String, Scoreboard> timerDisplays = new HashMap();
    ArrayList<WorldRefreshOrReset> ResetimerList = new ArrayList();
    private ArrayList<Location> Endgateways = new ArrayList();
    final ArrayList<World> ProtectResetWorlds = new ArrayList();
    List<Map.Entry<String, Object>> sortKillList = new ArrayList<Map.Entry<String, Object>>();
    private HashMap<String, Integer> healTickCounterList = new HashMap();
    private Method db_a = null;
    private Method db_e = null;
    private Method db_d = null;
    private Method endgatewayMethod = null;
    private Field OrigGateways = null;
    private Field DragonKilled = null;
    private Field DragonUUID = null;
    private Field PortLoc_f = null;
    private Field naviField = null;
    private Method fillArray = null;
    private Method getEDBMethod = null;
    private Class<?> CraftWorldClass = null;
    private Class<?> CraftEnderDragonClass = null;
    private Field CrystalAmount_f = null;
    private Object dId = null;
    private Constructor<?> newBlockPosition = null;
    private Constructor<?> newPathPoint = null;
    private Method pp_geta_func = null;
    private Field pp_geta_x = null;
    private Field pp_getb_y = null;
    private Field pp_getc_z = null;
    private Method bbp_getX = null;
    private Method bbp_getY = null;
    private Method bbp_getZ = null;
    private static String versionString = "";
    private static String simpleVersionString = "";
    private static int subVer = -1;
    private static String mapVers = null;
    double Pi = Math.PI;
    double ZwPi = this.Pi / 20.0;
    private Field respawnPhase_f = null;
    private Constructor<?> pim_const = null;
    private Constructor<?> entp_const = null;
    private Class<?> ENT_Class = null;
    Object NPCStatue = null;
    private Team team_NPC = null;
    private Object[] showNPCPackets = null;
    private Object[] showNPCPackets2 = null;
    private boolean headHelmet = false;
    static String[] NPCtexture;
    Method enth_getProfile = null;
    Class<?> CraftPlayerClass = null;
    Method getTileEntity = null;
    Method saveNBT = null;
    int RunCounter = 0;
    int RunCounter2 = 0;
    private String ScoreBoardName_1 = "" + ChatColor.BLACK + ChatColor.WHITE;
    private String ScoreBoardName_2 = "" + ChatColor.BLUE + ChatColor.WHITE;

    public void onEnable() {
        this.configManager.loadConfiguration();
        this.configManager.checkOldConfig();
        this.setupEconomy();
        this.UChat();
        this.LegendChat();
        this.PlaceholderApi();
        this.Essentials();
        this.EssentialsChat();
        this.Protocollib();
        DragonSlayer.getVersion(true);
        this.checkUpdate();
        if (DragonSlayer.getSubVersion() >= 9) {
            this.dragonListener = new DragonEvents(this);
            this.getServer().getPluginManager().registerEvents((Listener)this.dragonListener, (Plugin)this);
            if (this.configManager.getVerbosity()) {
                this.logger.info("Events 1.9+ enabled!");
            }
            this.MinVersion19 = true;
            if (DragonSlayer.getSubVersion() >= 17) {
                this.MinVersion117 = true;
            }
        } else {
            this.dragonListenerOld = new DragonEventsOld(this);
            this.getServer().getPluginManager().registerEvents((Listener)this.dragonListenerOld, (Plugin)this);
            if (this.configManager.getVerbosity()) {
                this.logger.info("Events 1.8- enabled!");
            }
        }
        try {
            Class.forName("org.spigotmc.SpigotConfig");
            this.spigot = true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
        if (DragonSlayer.getSubVersion() >= 14) {
            try {
                this.newRoutines14 = new FourteenPlusOnlyRoutines(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.getServer().getPluginManager().registerEvents((Listener)this.playerListener, (Plugin)this);
        if (this.EssentialsEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)this.essentialsListener, (Plugin)this);
        }
        if (this.UCenabled) {
            this.getServer().getPluginManager().registerEvents((Listener)this.dragonUChatListener, (Plugin)this);
        }
        if (this.LegendChatenabled) {
            this.getServer().getPluginManager().registerEvents((Listener)this.dragonLChatListener, (Plugin)this);
        }
        if (this.PAPIenabled) {
            int version2;
            String ver = this.getServer().getPluginManager().getPlugin("PlaceholderAPI").getDescription().getVersion();
            String vers2 = "";
            String[] stringArray = ver.split("\\.");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String split = stringArray[n2];
                vers2 = String.valueOf(vers2) + (split.length() == 2 ? split : "0" + split);
                ++n2;
            }
            if (vers2.contains("-")) {
                vers2 = vers2.substring(0, vers2.indexOf("-"));
            }
            if ((version2 = Integer.parseInt(vers2)) <= 21006) {
                new DragonPlaceholderAPIold(this).register();
            } else {
                new DragonPlaceholderAPI(this).register();
            }
        }
        if (this.ProtocolLibEnabled) {
            if (this.configManager.getVerbosity()) {
                this.logger.info("ProtocolLib found...");
            }
        } else if (this.getStatueVersion() >= 2) {
            this.getConfig().set("global.statue_version", (Object)1);
            this.saveConfig();
            if (this.configManager.getVerbosity()) {
                this.logger.info("No ProtocolLib found... resetting statue_version to 1!");
            }
        }
        this.getCommand("dragonslayer").setExecutor((CommandExecutor)this.dragonCommandExecutor);
        if (!this.setupEconomy()) {
            if (this.configManager.getVerbosity()) {
                this.logger.warning("No Vault dependency found, rewards will be disabled!");
            }
        } else {
            this.logger.info("Vault dependency found, rewards will be enabled!");
        }
        for (String DragonWorld : this.configManager.getMaplist()) {
            World MyWorld = this.getDragonWorldFromString(DragonWorld);
            this.activateChunksAroundPosition(new Location(MyWorld, 0.0, 75.0, 0.0), MyWorld, 7, false);
        }
        if (this.UCenabled) {
            this.logger.info("UChat found, tag will be used!");
        }
        if (this.LegendChatenabled) {
            this.logger.info("LegendChat found, tag will be used!");
        }
        if (this.PAPIenabled) {
            this.logger.info("PlaceholderAPI found, will be used!");
        }
        if (this.configManager.getVerbosity() && this.EssentialsEnabled) {
            this.logger.info("Essentials found, will be used!");
        }
        if (this.configManager.getVerbosity() && this.EssChEnabled) {
            this.logger.info("EssentialsChat found, will be used!");
        }
        this.serverStarted = !this.configManager.getMultiPortal();
        this.countEndGatewaysAndContinue();
        this.setTestPortal();
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
            this.configManager.setDragonDefaults();
            this.timerManager.getTimerlist();
            this.timerManager.RestartTimers();
            this.leaderManager.getLeaderlist();
            this.leaderManager.sortLeaderList();
            this.refreshTextureArray(null, false);
            this.getServer().getScheduler().runTaskLater((Plugin)this, () -> this.resetArmorStand(), 30L);
            this.StartRepeatingTimer();
            this.StartSecondRepeatingTimer();
            if (DragonSlayer.getSubVersion() >= 9) {
                for (String DragonWorld : this.configManager.getMaplist()) {
                    this.getDragonCount(DragonWorld);
                }
            }
        }, 20L);
        if (DragonSlayer.getSubVersion() >= 14) {
            this.dId = new NamespacedKey((Plugin)this, "DragonID");
        }
    }

    public void onDisable() {
        this.timerManager.getTimerlist();
        if (this.MinVersion19) {
            for (String DragonWorld : this.configManager.getMaplist()) {
                World world = this.getDragonWorldFromString(DragonWorld);
                try {
                    boolean pendingRefresh = this.isRefreshRunning(world);
                    long resetTimerNotRunning = this.getResetTime(DragonWorld);
                    long timerValue = 60L;
                    if (!pendingRefresh || resetTimerNotRunning != -1L || !this.configManager.getRefreshWorld(DragonWorld)) continue;
                    this.createWorldResetTimer(DragonWorld, timerValue, timerValue / 3L);
                    if (this.configManager.getVerbosity()) {
                        this.logger.info("Adding a Refresh-Timer for server restart for world " + DragonWorld);
                    }
                    if (this.ProtectResetWorlds.contains(world)) continue;
                    this.timerManager.createStartTimer(DragonWorld, timerValue);
                    if (!this.configManager.getVerbosity()) continue;
                    this.logger.info("This refresh will also spawn a dragon...");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.timerManager.updateTimerList();
        this.timerManager.saveTimerlist();
        this.leaderManager.saveLeaderlist();
        this.saveConfig();
    }

    private void UChat() {
        this.UCenabled = this.getServer().getPluginManager().getPlugin("UltimateChat") != null;
    }

    private void LegendChat() {
        this.LegendChatenabled = this.getServer().getPluginManager().getPlugin("Legendchat") != null;
    }

    private void PlaceholderApi() {
        this.PAPIenabled = this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    private void Essentials() {
        if (this.getServer().getPluginManager().getPlugin("Essentials") != null) {
            this.EssentialsEnabled = true;
        }
    }

    private void EssentialsChat() {
        this.EssChEnabled = this.getServer().getPluginManager().getPlugin("EssentialsChat") != null;
    }

    private void Protocollib() {
        if (this.getServer().getPluginManager().getPlugin("ProtocolLib") != null) {
            this.ProtocolLibEnabled = true;
        }
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        econ = (Economy)rsp.getProvider();
        return true;
    }

    boolean checkServerStarted() {
        return this.serverStarted;
    }

    private int countRespawnTimers(String ThisWorld) {
        int Count = 0;
        for (DragonRespawn Resp : this.timerManager.RespawnList) {
            if (!Resp.Mapname.toLowerCase().equals(ThisWorld)) continue;
            ++Count;
        }
        return Count;
    }

    public int missingDragons(String ThisWorld) {
        int MaxDragons = this.configManager.getMaxdragons(ThisWorld);
        int Count = this.getDragonCount(ThisWorld);
        int runningTimers = this.countRespawnTimers(ThisWorld);
        if (runningTimers + Count < MaxDragons) {
            return MaxDragons - (runningTimers + Count);
        }
        return 0;
    }

    private long getNextRespawn(String ThisWorld) {
        long Resttime = -1L;
        for (DragonRespawn Resp : this.timerManager.RespawnList) {
            Long check;
            if (!Resp.Mapname.equals(ThisWorld) || (check = this.remainingTimerDuration(Resp)) == null || check >= Resttime && Resttime != -1L) continue;
            Resttime = check;
        }
        return Resttime;
    }

    Long remainingTimerDuration(DragonRespawn Resp) {
        long Runtime = System.currentTimeMillis() / 50L - Resp.StartTime;
        long Resttime = Resp.OrigRuntime - Runtime;
        if (Resttime > 0L) {
            return Resttime;
        }
        return null;
    }

    private long getResetTime(String ThisWorld) {
        long Resttime = -1L;
        for (WorldRefreshOrReset Res : this.ResetimerList) {
            Long check;
            if (!Res.Mapname.equals(ThisWorld) || (check = this.remainingResetDuration(Res)) == null || check >= Resttime && Resttime != -1L) continue;
            Resttime = check;
        }
        return Resttime;
    }

    Long remainingResetDuration(WorldRefreshOrReset Res) {
        long Runtime = System.currentTimeMillis() / 50L - Res.StartTime;
        long Resttime = Res.OrigRuntime - Runtime;
        return Resttime > 0L ? Long.valueOf(Resttime) : null;
    }

    void stopResetTimer(String ThisWorld) {
        ArrayList<WorldRefreshOrReset> killList = new ArrayList<WorldRefreshOrReset>();
        for (WorldRefreshOrReset Res_ : this.ResetimerList) {
            if (!Res_.Mapname.toLowerCase().equals(ThisWorld)) continue;
            this.getServer().getScheduler().cancelTask(Res_.taskId);
            killList.add(Res_);
        }
        for (WorldRefreshOrReset Res_ : killList) {
            this.getServer().getScheduler().cancelTask(Res_.taskId);
            this.ResetimerList.remove(Res_);
            Object var3_4 = null;
        }
        killList.clear();
    }

    public void StartWorldResetTimer(String Mapname, long Runtime, long Warntime) {
        WorldRefreshOrReset Res = this.createWorldResetTimer(Mapname, Runtime, Warntime);
        if (Runtime < Warntime) {
            Res.Warntime = Runtime;
            Runtime = 0L;
        } else {
            Runtime -= Warntime;
        }
        Res.taskId = this.getServer().getScheduler().runTaskLater((Plugin)this, (Runnable)Res, Runtime).getTaskId();
    }

    private WorldRefreshOrReset createWorldResetTimer(String Mapname, long Runtime, long Warntime) {
        WorldRefreshOrReset Res = new WorldRefreshOrReset(this);
        Res.Mapname = Mapname;
        Res.OrigRuntime = Runtime;
        Res.Warntime = Warntime;
        return Res;
    }

    public HashMap<Double, Player> sortDamagersRanks(HashMap<Double, Player> orderList) {
        ArrayList<Double> percentList = new ArrayList<Double>(orderList.keySet());
        Collections.sort(percentList);
        Collections.reverse(percentList);
        HashMap<Double, Player> newOrderList = new HashMap<Double, Player>();
        double r = 1.0;
        for (Double val : percentList) {
            double d = r;
            r = d + 1.0;
            newOrderList.put(d, orderList.get(val));
        }
        return newOrderList;
    }

    Integer getPlayerCount(String Mapname) {
        World MyWorld = this.getDragonWorldFromString(Mapname);
        if (MyWorld == null) {
            return 0;
        }
        return MyWorld.getPlayers().size();
    }

    Integer getDragonCount(String Mapname) {
        World MyWorld = this.getDragonWorldFromString(Mapname);
        int Counter = 0;
        if (MyWorld == null) {
            return 0;
        }
        Collection<EnderDragon> dragons = this.getDragonList(MyWorld, Mapname);
        Counter = dragons.size();
        for (EnderDragon dr : dragons) {
            if (dr.isValid() && !dr.isDead() && (!this.MinVersion19 || dr.getPhase() != EnderDragon.Phase.DYING) && this.checkDSLDragon(dr)) continue;
            --Counter;
        }
        return Counter;
    }

    public Collection<EnderDragon> getDragonList(World myWorld, String mapname) {
        if (this.checkWorld(mapname)) {
            Location DragSpawnPos = this.findPosForPortal(this.configManager.getPortalXdef(mapname), this.configManager.getPortalZdef(mapname), myWorld, Material.BEDROCK);
            this.activateChunksAroundPosition(DragSpawnPos, myWorld, 12, false);
            if (this.MinVersion19) {
                int i = 1;
                while (i <= this.configManager.getMaxdragons(mapname)) {
                    Location PortLoc = this.findPosForPortal(this.configManager.getPortalX(mapname, i, true, true), this.configManager.getPortalZ(mapname, i, true, true), myWorld, Material.BEDROCK);
                    if (!DragSpawnPos.equals((Object)PortLoc)) {
                        this.activateChunksAroundPosition(PortLoc, myWorld, 6, false);
                    }
                    ++i;
                }
            }
        }
        Collection dragons = myWorld.getEntitiesByClass(EnderDragon.class);
        return dragons;
    }

    void activateChunksAroundPosition(Location StartPos, World World2, int Radius, boolean forceTicket) {
        if (World2 == null) {
            return;
        }
        int baseX = (int)(StartPos.getX() / 16.0);
        int baseZ = (int)(StartPos.getZ() / 16.0);
        int x = -1 * Radius;
        while (x <= Radius) {
            int ChunkX = baseX + x;
            int z = -1 * Radius;
            while (z <= Radius) {
                int ChunkZ = baseZ + z;
                if ((this.configManager.keepChunksLoaded() || forceTicket) && (DragonSlayer.getSubVersion() == 13 || DragonSlayer.getSubVersion() > 13 && World2.isChunkGenerated(ChunkX, ChunkZ))) {
                    try {
                        World2.addPluginChunkTicket(ChunkX, ChunkZ, (Plugin)this);
                    }
                    catch (NoSuchMethodError e) {
                        try {
                            World2.setChunkForceLoaded(ChunkX, ChunkZ, true);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            // empty catch block
                        }
                    }
                }
                Chunk testChunk = World2.getChunkAt(ChunkX, ChunkZ);
                if (!World2.isChunkLoaded(ChunkX, ChunkZ)) {
                    boolean load;
                    try {
                        load = World2.loadChunk(ChunkX, ChunkZ, true);
                    }
                    catch (RuntimeException e) {
                        load = false;
                    }
                    if (!load && this.configManager.getVerbosity()) {
                        this.logger.warning("Failed to load and activate Chunk at X: " + ChunkX * 16 + " Z: " + ChunkZ * 16 + " in " + World2.getName());
                    }
                }
                try {
                    testChunk.getEntities();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++z;
            }
            ++x;
        }
    }

    public void RemoveDragons(World ThisWorld, boolean deadOnly, boolean forceAll) {
        String Mapname = ThisWorld.getName().toLowerCase();
        Collection<EnderDragon> EntityList = this.getDragonList(ThisWorld, Mapname);
        for (EnderDragon Dragon : EntityList) {
            if (!this.checkDSLDragon(Dragon) && !forceAll) continue;
            if (deadOnly) {
                if (Dragon.isValid()) continue;
                Dragon.remove();
                continue;
            }
            Dragon.remove();
        }
    }

    boolean SpawnForceDragon(String w) {
        int maxDragons;
        int ExistentDragons;
        if (this.checkWorld(w) && (ExistentDragons = this.getDragonCount(w).intValue()) < (maxDragons = this.configManager.getMaxdragons(w))) {
            this.SpawnXDragons(maxDragons - ExistentDragons, w);
            return true;
        }
        return false;
    }

    void SpawnForceAllDragons() {
        for (String DragonWorld : this.configManager.getMaplist()) {
            int MaxDragons;
            int ExistentDragons = this.getDragonCount(DragonWorld);
            if (ExistentDragons >= (MaxDragons = this.configManager.getMaxdragons(DragonWorld))) continue;
            this.SpawnXDragons(MaxDragons - ExistentDragons, DragonWorld);
        }
    }

    void SpawnXDragons(int x, String World2) {
        int i = 0;
        while (i < x) {
            DragonRespawn Resp = new DragonRespawn(this);
            Resp.Mapname = World2;
            this.getServer().getScheduler().runTaskLater((Plugin)this, (Runnable)Resp, (long)(60 + i * 40));
            ++i;
        }
    }

    public String getSlayer() {
        String name = null;
        try {
            name = this.getOfflineSlayer().getName();
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return name;
    }

    OfflinePlayer getOfflineSlayer() {
        OfflinePlayer player = null;
        try {
            player = Bukkit.getOfflinePlayer((UUID)this.getSlayerUUID());
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return player;
    }

    public String getSlayerUUIDString() {
        return this.getConfig().getString("global.slayer");
    }

    private UUID getSlayerUUID() {
        UUID uuid;
        try {
            uuid = UUID.fromString(this.getSlayerUUIDString());
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            uuid = null;
        }
        return uuid;
    }

    World getDragonWorldFromString(String Mapname) {
        return Bukkit.getServer().getWorld(Mapname);
    }

    public void setSlayer(Player p) {
        this.resetTabListName();
        String uuid = p.getUniqueId().toString();
        this.getConfig().set("global.slayer", (Object)uuid);
        this.saveConfig();
        int oldScore = 0;
        if (this.leaderManager.Leader.getConfigurationSection("Scores") != null && this.leaderManager.Leader.getConfigurationSection("Scores").contains(uuid)) {
            oldScore = this.leaderManager.Leader.getInt("Scores." + uuid + ".score");
        }
        this.leaderManager.Leader.set("Scores." + uuid + ".score", (Object)(oldScore + 1));
        this.leaderManager.saveLeaderlist();
        this.leaderManager.sortLeaderList();
        this.setTabListName(p);
        this.refreshTextureArray(p, false);
    }

    private void resetTabListName() {
        OfflinePlayer oldSlayer;
        if (this.configManager.getTabListEnable() && (oldSlayer = this.getOfflineSlayer()) != null && oldSlayer.isOnline()) {
            Player oldSlayer_ = (Player)oldSlayer;
            oldSlayer_.setPlayerListName(oldSlayer_.getDisplayName());
        }
    }

    void setTabListName(Player p) {
        if (this.configManager.getTabListEnable()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
                if (p.getUniqueId().toString().equals(this.getSlayerUUIDString())) {
                    p.setPlayerListName(String.valueOf(!this.configManager.getPrefixAsSuffix() ? this.configManager.getPrefix() : "") + p.getDisplayName() + (this.configManager.getPrefixAsSuffix() ? this.configManager.getPrefix() : ""));
                }
            }, 10L);
        }
    }

    String replaceValues(String s, String world, Integer id) {
        s = s.replace('&', '\u00a7');
        if (this.configManager.getSlayerPAPINick() != null) {
            s = s.replace("$slayername", this.configManager.getSlayerPAPINick());
        }
        if (this.getSlayer() != null) {
            s = s.replace("$slayer", this.getSlayer());
        }
        if (world != null) {
            String baseworld = world.replace("_the_end", "");
            int dragonID = id != null ? id : 0;
            s = s.replace("$world", world).replace("$baseworld", baseworld).replace("$dragon", String.valueOf(this.configManager.getDragonDefaultName(world.toLowerCase(), dragonID)) + "\u00a7r").replace("$reward", String.valueOf(this.configManager.getReward_double(world.toLowerCase(), dragonID)));
        } else {
            s = s.replace("$world", "-No World-").replace("$dragon", String.valueOf(this.getConfig().getString("dragon._default.name")) + "\u00a7r").replace("$reward", this.getConfig().getString("dragon._default.reward"));
        }
        return s;
    }

    String replaceValues(String s, String world) {
        return this.replaceValues(s, world, null);
    }

    public boolean checkWorld(String world) {
        return this.configManager.getMaplist().contains(world.toLowerCase());
    }

    boolean checkDSLDragon(EnderDragon dragon) {
        boolean checkDSLDragon = dragon.hasMetadata("DSL-Location");
        if (!checkDSLDragon) {
            checkDSLDragon = this.getDragonIDMeta(dragon) > 0;
        }
        return checkDSLDragon;
    }

    boolean checkOrigDragon(EnderDragon dragon) {
        Object newDragEnt = this.getEntityEnderDragon(dragon);
        return newDragEnt.getClass().getSimpleName().equals("EntityEnderDragon") && newDragEnt.getClass().getTypeName().contains("net.minecraft");
    }

    void FindPlayerAndAddToBossBar(BossBar BossBar2, Entity ThisDrag) {
        List AddedPlayers = BossBar2.getPlayers();
        int distancePlayer = this.configManager.getBossbarDistance(ThisDrag.getWorld().getName().toLowerCase());
        for (Player player : ThisDrag.getWorld().getPlayers()) {
            if (!AddedPlayers.contains(player)) {
                if (!(player.getLocation().distance(ThisDrag.getLocation()) < (double)distancePlayer)) continue;
                BossBar2.addPlayer(player);
                continue;
            }
            if (!(player.getLocation().distance(ThisDrag.getLocation()) >= (double)distancePlayer)) continue;
            BossBar2.removePlayer(player);
        }
    }

    BossBar findFreeBar(String worldname) {
        for (BossBar BB : this.BossBars) {
            if (BB.isVisible()) continue;
            BB.setVisible(true);
            this.setBBdark(BB, worldname);
            BB.removeAll();
            return BB;
        }
        BossBar BossBar2 = Bukkit.getServer().createBossBar("EnderDragon", BarColor.PURPLE, BarStyle.SOLID, new BarFlag[]{BarFlag.PLAY_BOSS_MUSIC});
        this.setBBdark(BossBar2, worldname);
        BossBar2.setVisible(true);
        this.BossBars.add(BossBar2);
        return BossBar2;
    }

    private void setBBdark(BossBar BossBar2, String worldname) {
        if (this.configManager.getDark(worldname)) {
            BossBar2.addFlag(BarFlag.CREATE_FOG);
            BossBar2.addFlag(BarFlag.DARKEN_SKY);
        } else {
            BossBar2.removeFlag(BarFlag.CREATE_FOG);
            BossBar2.removeFlag(BarFlag.DARKEN_SKY);
        }
    }

    void handleBossbar(World TheWorld) {
        Collection EntityList = TheWorld.getEntitiesByClass(EnderDragon.class);
        for (EnderDragon ThisDrag : EntityList) {
            if (!this.MinVersion19 || !this.checkDSLDragon(ThisDrag)) continue;
            BossBar BossBar2 = DragonSlayer.getBossBarFromDragon(ThisDrag);
            if (BossBar2 != null) {
                this.FindPlayerAndAddToBossBar(BossBar2, (Entity)ThisDrag);
                this.setBossBarAmountNOW(ThisDrag, BossBar2);
            } else if (ThisDrag.isValid() && !ThisDrag.isDead() && ThisDrag.getPhase() != EnderDragon.Phase.DYING && (BossBar2 = this.findFreeBar(TheWorld.getName().toLowerCase())) != null) {
                BossBar2.setTitle(ThisDrag.getName());
                this.setBossBarAmountNOW(ThisDrag, BossBar2);
                this.putBossBarToDragon(ThisDrag, BossBar2);
                this.FindPlayerAndAddToBossBar(BossBar2, (Entity)ThisDrag);
            }
            this.OrigEnderDragonSetKilled(ThisDrag);
        }
    }

    int findDragonID(String Mapname, String dragonName) {
        int maxD = this.configManager.getMaxdragons(Mapname);
        int i = 0;
        while (i <= maxD) {
            String TestName = this.getConfig().getString(i == 0 ? "dragon." + Mapname + ".name" : "dragon." + Mapname + ".name_" + i);
            if (TestName != null && dragonName != null) {
                TestName = TestName.replace('&', '\u00a7');
                if ((dragonName = dragonName.replaceAll("\u00a7[f0r]", "")).equals(TestName = TestName.replaceAll("\u00a7[f0r]", ""))) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    void putBossBarToDragon(EnderDragon ThisDragon, BossBar BossBar2) {
        DragonBarList.put(ThisDragon, BossBar2);
    }

    static void delBossBarFromDragon(EnderDragon ThisDragon) {
        DragonBarList.remove(ThisDragon);
    }

    static BossBar getBossBarFromDragon(EnderDragon ThisDragon) {
        BossBar BossBar2 = null;
        try {
            BossBar2 = DragonBarList.get(ThisDragon);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BossBar2;
    }

    public static void resetDragonsBossbar(Entity Dragon) {
        BossBar BossBar2 = DragonSlayer.getBossBarFromDragon((EnderDragon)Dragon);
        if (BossBar2 != null) {
            BossBar2.setProgress(0.0);
            BossBar2.removeAll();
            DragonSlayer.delBossBarFromDragon((EnderDragon)Dragon);
            BossBar2.setVisible(false);
        }
    }

    public void cleanupDragons() {
        Set<EnderDragon> testdrags = DragonBarList.keySet();
        HashSet<EnderDragon> listDelDrags = new HashSet<EnderDragon>();
        for (EnderDragon testdrag : testdrags) {
            if (testdrag.isValid()) continue;
            BossBar tobedeleted = DragonSlayer.getBossBarFromDragon(testdrag);
            tobedeleted.setVisible(false);
            listDelDrags.add(testdrag);
        }
        for (EnderDragon testdrag : listDelDrags) {
            DragonBarList.remove(testdrag);
        }
    }

    public void deletePlayersBossBars(Player player) {
        for (BossBar BB : this.BossBars) {
            if (!BB.getPlayers().contains(player)) continue;
            BB.removePlayer(player);
        }
    }

    void setBossBarAmount(EnderDragon e) {
        BossBar bossBar;
        String w = e.getWorld().getName();
        if (this.checkWorld(w) && (bossBar = DragonSlayer.getBossBarFromDragon(e)) != null) {
            this.setBossBarAmountNOW(e, bossBar);
        }
    }

    void setBossBarAmountNOW(EnderDragon e, BossBar bossBar) {
        this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
            double maxHealth = e.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
            double dragHealth = e.getHealth();
            double barHealthValue = dragHealth / maxHealth;
            if (barHealthValue < 0.0) {
                barHealthValue = 0.0;
            }
            if (barHealthValue > 1.0) {
                barHealthValue = 1.0;
            }
            bossBar.setProgress(barHealthValue);
        }, 0L);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    Location findPosForPortal(double tempX, double tempZ, World world, Material checkMat) {
        Location portLoc = new Location(world, tempX, 60.0, tempZ);
        double y = 200.0;
        while (y > 35.0) {
            portLoc.setY(y);
            Material testMat = portLoc.getBlock().getType();
            switch (testMat.toString()) {
                default: {
                    if (testMat.equals((Object)checkMat)) {
                        portLoc.setY(y - 3.0);
                    }
                    return portLoc;
                }
                case "STATIONARY_WATER": 
                case "DRAGON_EGG": 
                case "AIR": 
                case "WATER": 
            }
            y -= 1.0;
        }
        return portLoc;
    }

    private void PlaceEmptyPortal(World ThisWorld) {
        String worldname = ThisWorld.getName().toLowerCase();
        if (!this.configManager.getOldPortal(worldname) && this.configManager.getDisableOrigDragonRespawn(worldname) && this.MinVersion19) {
            Location PortLoc = this.findPosForPortal(this.configManager.getPortalXdef(worldname), this.configManager.getPortalZdef(worldname), ThisWorld, Material.BEDROCK);
            this.PlacePortal(PortLoc, 0);
        }
    }

    private void PlaceEmptyPortals(World ThisWorld, boolean place) {
        String worldname;
        if (this.configManager.getMultiPortal() && this.MinVersion19 && !this.configManager.getOldPortal(worldname = ThisWorld.getName().toLowerCase())) {
            Location defPortLoc = this.findPosForPortal(this.configManager.getPortalXdef(worldname), this.configManager.getPortalZdef(worldname), ThisWorld, Material.BEDROCK);
            int i = 1;
            while (i <= this.configManager.getMaxdragons(worldname)) {
                Location PortLoc = this.findPosForPortal(this.configManager.getPortalX(worldname, i), this.configManager.getPortalZ(worldname, i), ThisWorld, Material.BEDROCK);
                if (!defPortLoc.equals((Object)PortLoc)) {
                    this.PlacePortal(PortLoc, place ? 0 : -1);
                }
                ++i;
            }
        }
    }

    void PlacePortal(Location Position, int Endportal) {
        Random random;
        int i;
        Material PortalStone = Material.BEDROCK;
        if (Endportal < 0) {
            try {
                PortalStone = Material.valueOf((String)"ENDER_STONE");
            }
            catch (Exception ex) {
                PortalStone = Material.END_STONE;
            }
        }
        int y = 0;
        while (y <= 10) {
            int maxXZ = y < 2 ? y + 1 : 3;
            int x = -maxXZ;
            while (x <= maxXZ) {
                int z = -maxXZ;
                while (z <= maxXZ) {
                    if (Math.abs(x * z) < maxXZ * 2) {
                        if (y <= 2) {
                            if (Math.abs(x * z) < (maxXZ - 1) * 2 && Math.abs(x) <= maxXZ - 1 && Math.abs(z) <= maxXZ - 1) {
                                if (y == 2) {
                                    if (Endportal > 0) {
                                        try {
                                            Material EndPortal = Material.valueOf((String)"ENDER_PORTAL");
                                            if (EndPortal != null) {
                                                Position.getBlock().getRelative(x, y - 2, z).setType(EndPortal);
                                            }
                                        }
                                        catch (Exception ex) {
                                            Position.getBlock().getRelative(x, y - 2, z).setType(Material.END_PORTAL);
                                        }
                                    } else {
                                        Position.getBlock().getRelative(x, y - 2, z).setType(Material.AIR);
                                    }
                                } else {
                                    Position.getBlock().getRelative(x, y - 2, z).setType(PortalStone);
                                }
                            } else {
                                Position.getBlock().getRelative(x, y - 2, z).setType(PortalStone);
                            }
                        } else {
                            Position.getBlock().getRelative(x, y - 2, z).setType(Material.AIR);
                        }
                    }
                    ++z;
                }
                ++x;
            }
            ++y;
        }
        Position.getBlock().setType(PortalStone);
        Position = Position.getBlock().getRelative(0, 1, 0).getLocation();
        World world = Position.getWorld();
        Position.getBlock().setType(Endportal < 0 ? Material.AIR : PortalStone);
        Position.getBlock().getRelative(0, 1, 0).setType(Endportal < 0 ? Material.AIR : PortalStone);
        Position.getBlock().getRelative(0, 2, 0).setType(Endportal < 0 ? Material.AIR : PortalStone);
        if (Endportal > 0 && (i = (random = new Random()).nextInt(100)) < this.configManager.getPortalEggChance(world.getName().toLowerCase())) {
            Position.getBlock().getRelative(0, 3, 0).setType(Material.DRAGON_EGG);
        }
        if (Endportal >= 0) {
            Position.getBlock().getRelative(BlockFace.NORTH).setType(Material.BEDROCK);
            Position.getBlock().getRelative(BlockFace.SOUTH).setType(Material.BEDROCK);
            Position.getBlock().getRelative(BlockFace.EAST).setType(Material.BEDROCK);
            Position.getBlock().getRelative(BlockFace.WEST).setType(Material.BEDROCK);
            Position = Position.getBlock().getRelative(0, 1, 0).getLocation();
            this.SetTorch(Position, BlockFace.NORTH);
            this.SetTorch(Position, BlockFace.SOUTH);
            this.SetTorch(Position, BlockFace.EAST);
            this.SetTorch(Position, BlockFace.WEST);
            Position = Position.getBlock().getRelative(0, -1, 0).getLocation();
            this.delSurroundingBlocks(Position);
        }
        Collection entListItems = world.getEntitiesByClass(Item.class);
        for (Item current : entListItems) {
            if (current.getType() != EntityType.DROPPED_ITEM || !(current.getLocation().distance(Position) <= 3.0) || !current.getItemStack().getType().equals((Object)Material.TORCH)) continue;
            current.remove();
        }
    }

    private void delSurroundingBlocks(Location Position2) {
        Position2.getBlock().getRelative(BlockFace.NORTH).setType(Material.AIR);
        Position2.getBlock().getRelative(BlockFace.SOUTH).setType(Material.AIR);
        Position2.getBlock().getRelative(BlockFace.EAST).setType(Material.AIR);
        Position2.getBlock().getRelative(BlockFace.WEST).setType(Material.AIR);
    }

    private void SetTorch(Location Baseblock, BlockFace Face) {
        Block TorchBlock = Baseblock.getBlock().getRelative(Face);
        try {
            Material Torch2 = Material.valueOf((String)"WALL_TORCH");
            if (Torch2 != null) {
                TorchBlock.setType(Torch2);
                BlockData BlData = TorchBlock.getBlockData();
                ((Directional)BlData).setFacing(TorchBlock.getFace(Baseblock.getBlock()).getOppositeFace());
                TorchBlock.setBlockData(BlData);
            }
        }
        catch (Exception ex) {
            TorchBlock.setType(Material.TORCH);
            BlockState state = TorchBlock.getState();
            ((Torch)state.getData()).setFacingDirection(TorchBlock.getFace(Baseblock.getBlock()).getOppositeFace());
            state.update(true);
        }
    }

    private void WorldRefresh2(String ThisWorldsName) {
        World ThisWorld = this.getDragonWorldFromString(ThisWorldsName);
        try {
            Object edb = this.getEnderDragonBattle(ThisWorld);
            if (this.db_a == null) {
                this.db_a = edb.getClass().getDeclaredMethod("a", List.class);
            }
            if (this.db_a != null) {
                this.db_a.setAccessible(true);
                this.db_a.invoke(edb, Collections.emptyList());
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException e) {
            this.logger.info("Can not handle world refresh..");
        }
        this.PlaceEmptyPortals(ThisWorld, true);
        this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
            Location PortLoc = this.findPosForPortal(this.configManager.getPortalXdef(ThisWorldsName), this.configManager.getPortalZdef(ThisWorldsName), ThisWorld, Material.BEDROCK);
            this.activateChunksAroundPosition(PortLoc, ThisWorld, 2, false);
            Collection entList = PortLoc.getWorld().getEntitiesByClass(EnderCrystal.class);
            for (Entity ent : entList) {
                if (!(PortLoc.distance(ent.getLocation()) <= 4.0)) continue;
                ent.remove();
            }
        }, 1200L);
    }

    public void WorldRefresh(String ThisWorldsName) {
        if (ThisWorldsName != null && this.checkWorld(ThisWorldsName.toLowerCase())) {
            World ThisWorld = this.getDragonWorldFromString(ThisWorldsName);
            if (ThisWorld.getEnvironment() != World.Environment.THE_END) {
                this.logger.info("World refresh not possible! " + ThisWorldsName + " is not an END-World!");
                return;
            }
            this.setWorldRefreshRun(ThisWorldsName);
            Location PortLoc = this.findPosForPortal(this.configManager.getPortalXdef(ThisWorldsName), this.configManager.getPortalZdef(ThisWorldsName), ThisWorld, Material.BEDROCK);
            double x = -3.0;
            while (x <= 3.0) {
                double z = -3.0;
                while (z <= 3.0) {
                    if (x != 0.0) {
                        z = 0.0;
                    }
                    Entity crystal = ThisWorld.spawnEntity(PortLoc.clone().add(x + 0.5, 1.0, z + 0.5), EntityType.ENDER_CRYSTAL);
                    crystal.setInvulnerable(true);
                    z += 6.0;
                }
                x += 3.0;
            }
            String dbename = null;
            dbename = DragonSlayer.getSubVersion() >= 18 ? "e" : (DragonSlayer.getSubVersion() >= 16 ? "initiateRespawn" : "e");
            if (this.configManager.getMultiPortal()) {
                this.setExitPortalLocation(ThisWorld, PortLoc.getBlockX(), PortLoc.getBlockY(), PortLoc.getBlockZ(), true, false);
            }
            this.PlaceEmptyPortals(ThisWorld, false);
            if (dbename != null) {
                try {
                    Object edb = this.getEnderDragonBattle(ThisWorld);
                    if (this.db_e == null) {
                        this.db_e = edb.getClass().getDeclaredMethod(dbename, new Class[0]);
                    }
                    if (this.db_e != null) {
                        this.db_e.setAccessible(true);
                        this.db_e.invoke(edb, new Object[0]);
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException e) {
                    this.logger.warning("Unknown or unsupported Version :" + DragonSlayer.getVersion() + ", can't handle world refresh...(yet?)");
                }
            }
            this.configManager.setCreatePortal(true, ThisWorldsName.toLowerCase());
            this.WorldRefresh2(ThisWorldsName);
        }
    }

    private void setWorldRefreshRun(String ThisWorldsName) {
        World ThisWorld = this.getDragonWorldFromString(ThisWorldsName);
        this.ProtectResetWorlds.add(ThisWorld);
        this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
            if (this.configManager.getRespawnPlayer(ThisWorldsName.toLowerCase())) {
                this.WorldReset(ThisWorldsName, false);
            }
        }, 2400L);
    }

    void WorldReset(String ThisWorldsName, boolean force) {
        if (this.getServer().getPluginManager().getPlugin("Multiverse-Core") != null) {
            if (ThisWorldsName != null && this.checkWorld(ThisWorldsName.toLowerCase())) {
                List<String> command;
                if (this.configManager.getResetWorld(ThisWorldsName.toLowerCase())) {
                    force = true;
                }
                World ThisWorld = this.getDragonWorldFromString(ThisWorldsName);
                List PlayerList = ThisWorld.getPlayers();
                World BaseWorld = this.getDragonWorldFromString(ThisWorldsName.replace("_the_end", ""));
                if (BaseWorld == null) {
                    BaseWorld = this.getMultiverseCore().getMVWorldManager().getMVWorld(ThisWorld).getRespawnToWorld();
                }
                if ((command = this.configManager.getRespawnCommand(ThisWorldsName.toLowerCase())) != null && !command.isEmpty()) {
                    for (String command2 : command) {
                        if (command2.contains("$player")) continue;
                        this.getServer().dispatchCommand((CommandSender)this.getServer().getConsoleSender(), command2);
                    }
                }
                for (Player player : PlayerList) {
                    this.deletePlayersBossBars(player);
                    if (command != null && !command.isEmpty()) {
                        for (String command2 : command) {
                            if (!command2.contains("$player")) continue;
                            command2 = command2.replace("$player", player.getName());
                            this.getServer().dispatchCommand((CommandSender)this.getServer().getConsoleSender(), command2);
                        }
                        continue;
                    }
                    if (BaseWorld == null) continue;
                    Location Spawn = this.getMultiverseCore().getMVWorldManager().getMVWorld(BaseWorld).getSpawnLocation();
                    Spawn.setWorld(BaseWorld);
                    player.teleport(Spawn);
                }
                if (force) {
                    this.RemoveDragons(ThisWorld, false, false);
                    this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                        Location Position;
                        World NewWorld;
                        Long WorldsOldSeed = ThisWorld.getSeed();
                        this.getMultiverseCore().getMVWorldManager().regenWorld(ThisWorldsName, true, false, WorldsOldSeed.toString());
                        if (this.configManager.getVerbosity()) {
                            this.logger.info(ChatColor.GREEN + "The world " + ThisWorld.getName() + " will get recreated!");
                        }
                        if ((NewWorld = this.getDragonWorldFromString(ThisWorldsName)) != null) {
                            Material endstone;
                            this.UpdateEndgatewayPosList(NewWorld);
                            if (!this.configManager.getCreateGateways(ThisWorldsName.toLowerCase())) {
                                this.prepareEndGateways(NewWorld, new ArrayList<Integer>());
                            }
                            Location Spawn = null;
                            Spawn = this.getMultiverseCore().getMVWorldManager().getMVWorld(NewWorld).getSpawnLocation();
                            try {
                                endstone = Material.valueOf((String)"END_STONE");
                            }
                            catch (Exception e) {
                                endstone = Material.valueOf((String)"ENDER_STONE");
                            }
                            Spawn.setY(this.findPosForPortal(Spawn.getX(), Spawn.getZ(), NewWorld, endstone).getY() + 4.0);
                            Spawn.setWorld(NewWorld);
                            this.getMultiverseCore().getMVWorldManager().getMVWorld(NewWorld).setSpawnLocation(Spawn);
                            if (!this.configManager.getRespawnPlayer(ThisWorldsName.toLowerCase())) {
                                for (Player player : PlayerList) {
                                    player.teleport(Spawn);
                                }
                            }
                            this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                                this.PlaceEmptyPortal(NewWorld);
                                this.PlaceEmptyPortals(NewWorld, true);
                            }, 1L);
                        }
                        this.configManager.setCreatePortal(true, ThisWorldsName.toLowerCase());
                        if (this.configManager.getDelay(ThisWorldsName.toLowerCase()) > 0) {
                            if (NewWorld != null) {
                                Position = new Location(NewWorld, 0.0, 1.0, 0.0);
                                if (this.configManager.getDisableOrigDragonRespawn(ThisWorldsName.toLowerCase())) {
                                    this.setTestPortal2(Position);
                                }
                            }
                            this.SpawnXDragons(this.missingDragons(ThisWorldsName.toLowerCase()), ThisWorldsName.toLowerCase());
                        } else if (NewWorld != null) {
                            Position = new Location(NewWorld, 0.0, 1.0, 0.0);
                            this.setTestPortal2(Position);
                            int ExistDrags = this.getDragonCount(ThisWorldsName);
                            if (ExistDrags > 0) {
                                this.RemoveDragons(NewWorld, false, true);
                            }
                        }
                    }, 60L);
                }
            }
        } else {
            this.logger.warning("World reset needs multiverse core installed!");
        }
    }

    private void checkForSleepingDragons() {
        HashSet<EnderDragon> entityList = new HashSet<EnderDragon>();
        for (String mapname : this.configManager.getMaplist()) {
            World theWorld = this.getServer().getWorld(mapname);
            if (theWorld == null) continue;
            Collection entityList_ = theWorld.getEntitiesByClass(EnderDragon.class);
            entityList.addAll(entityList_);
        }
        Set<EnderDragon> entityList_ = DragonBarList.keySet();
        for (EnderDragon ent : entityList_) {
            if (entityList.contains(ent)) continue;
            entityList.add(ent);
        }
        for (EnderDragon dragon : entityList) {
            int dragonId;
            if (!dragon.isValid() || (dragonId = this.getDragonIDMeta(dragon)) < 0) continue;
            Location actLoc = dragon.getLocation();
            Location oldLoc = this.getDragonPosMeta((Entity)dragon);
            if (oldLoc != null && oldLoc.equals((Object)actLoc)) {
                String worldName = dragon.getWorld().getName().toLowerCase();
                if (this.MinVersion19) {
                    EnderDragon.Phase nowPhase = dragon.getPhase();
                    if (nowPhase != EnderDragon.Phase.DYING && nowPhase != EnderDragon.Phase.SEARCH_FOR_BREATH_ATTACK_TARGET && nowPhase != EnderDragon.Phase.BREATH_ATTACK && nowPhase != EnderDragon.Phase.ROAR_BEFORE_ATTACK) {
                        dragon.setPhase(EnderDragon.Phase.CIRCLING);
                        dragon.teleport(new Location(dragon.getWorld(), (double)this.configManager.getPortalX(worldName, dragonId), actLoc.getY(), (double)this.configManager.getPortalZ(worldName, dragonId)));
                    }
                } else {
                    dragon.teleport(new Location(dragon.getWorld(), (double)this.configManager.getPortalX(worldName, dragonId), actLoc.getY(), (double)this.configManager.getPortalZ(worldName, dragonId)));
                }
            }
            this.setDragonPosMeta((Entity)dragon, actLoc);
        }
    }

    private MultiverseCore getMultiverseCore() {
        if (this.getServer().getPluginManager().getPlugin("Multiverse-Core") instanceof MultiverseCore) {
            return (MultiverseCore)this.getServer().getPluginManager().getPlugin("Multiverse-Core");
        }
        throw new RuntimeException("MultiVerse not found!");
    }

    void AtKillCommand(String ThisWorldsName, Player player, EnderDragon ThisDrag) {
        int dragonId;
        if (ThisWorldsName != null && this.checkWorld(ThisWorldsName.toLowerCase()) && (dragonId = this.getDragonIDMeta(ThisDrag)) >= 0) {
            this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                World ThisWorld = this.getDragonWorldFromString(ThisWorldsName);
                String ThisWorldName = ThisWorld.getName();
                List<String> commands = this.configManager.getDragonCommand(ThisWorldsName.toLowerCase(), dragonId);
                if (!commands.isEmpty()) {
                    String pn = player == null ? "" : player.getName();
                    commands.replaceAll(command -> command.replace("$player", pn).replace(ThisWorldsName.toLowerCase(), ThisWorldName));
                    this.myCommandsHandler(commands, ThisWorld);
                }
            }, 60L);
        }
    }

    void myCommandsHandler(List<String> commands, World ThisWorld) {
        if (commands != null && !commands.isEmpty()) {
            String ThisWorldName = ThisWorld.getName();
            List PlayerList = ThisWorld.getPlayers();
            for (String command2 : commands) {
                if (command2 == null || command2.isEmpty()) continue;
                if (!command2.contains("$player")) {
                    this.commandPercentageCall(command2, ThisWorldName);
                    continue;
                }
                for (Player player : PlayerList) {
                    String command3 = command2.replace("$player", player.getName());
                    this.commandPercentageCall(command3, ThisWorldName);
                }
            }
        }
    }

    private void commandPercentageCall(String command, String ThisWorldName) {
        if (command.substring(0, 1).equals("{")) {
            int i;
            int perc2;
            String perc = command.substring(1, command.indexOf("}")).replaceAll("[_a-zA-Z%-]", "");
            command = command.substring(command.indexOf("}") + 1);
            if (perc.length() <= 3 && perc.length() > 0 && (perc2 = Integer.parseInt(perc)) >= 0 && perc2 <= 100 && (i = new Random().nextInt(100)) < perc2) {
                this.getServer().dispatchCommand((CommandSender)this.getServer().getConsoleSender(), command);
                if (this.configManager.getVerbosity()) {
                    this.logger.info(ChatColor.GREEN + "In the world " + ThisWorldName + " Command: '" + command + "' was executed... on a " + perc + "% chance!");
                }
            }
        } else {
            this.getServer().dispatchCommand((CommandSender)this.getServer().getConsoleSender(), command);
            if (this.configManager.getVerbosity()) {
                this.logger.info(ChatColor.GREEN + "In the world " + ThisWorldName + " Command: '" + command + "' was executed...");
            }
        }
    }

    void setEndGatewayPortals(World ThisWorld) {
        Object DrBatt;
        if (this.configManager.getCreateGateways(ThisWorld.getName().toLowerCase()) && (DrBatt = this.getEnderDragonBattle(ThisWorld)) != null) {
            try {
                if (this.endgatewayMethod == null) {
                    String methodeName = null;
                    int subv = DragonSlayer.getSubVersion();
                    if (subv >= 14) {
                        methodeName = "n";
                    } else if (subv == 13) {
                        methodeName = "m";
                    } else if (subv <= 12) {
                        methodeName = "l";
                    }
                    this.endgatewayMethod = DrBatt.getClass().getDeclaredMethod(methodeName, new Class[0]);
                }
                if (this.endgatewayMethod != null) {
                    this.endgatewayMethod.setAccessible(true);
                    this.endgatewayMethod.invoke(DrBatt, new Object[0]);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException e) {
                this.logger.warning("Unknown or unsupported Version :" + DragonSlayer.getVersion() + ", can't handle end-gateways...(yet?)");
            }
        }
    }

    private void prepareEndGateways(World ThisWorld, ArrayList<Integer> remainingGateways) {
        Object DrBatt = this.getEnderDragonBattle(ThisWorld);
        String fieldName = null;
        if (DragonSlayer.getSubVersion() == 16) {
            fieldName = "gateways";
        } else if (this.MinVersion117) {
            fieldName = "m";
        } else if (this.MinVersion19) {
            fieldName = "e";
        }
        if (DrBatt != null && fieldName != null) {
            try {
                if (this.OrigGateways == null) {
                    this.OrigGateways = DrBatt.getClass().getDeclaredField(fieldName);
                }
                if (this.OrigGateways != null) {
                    this.OrigGateways.setAccessible(true);
                    if (DragonSlayer.getSubVersion() < 19) {
                        this.OrigGateways.set(DrBatt, remainingGateways);
                    } else {
                        ObjectArrayList newObjectArray = new ObjectArrayList();
                        newObjectArray.addAll(remainingGateways);
                        this.OrigGateways.set(DrBatt, newObjectArray);
                    }
                }
            }
            catch (IllegalAccessException | NoSuchFieldException | NullPointerException | SecurityException ee) {
                this.logger.warning("Unknown or unsupported Version :" + DragonSlayer.getVersion() + ", can't handle end-gateways...(yet?)");
            }
        }
    }

    static String getVersion() {
        if (simpleVersionString.isEmpty()) {
            simpleVersionString = DragonSlayer.getVersion(false);
        }
        return simpleVersionString;
    }

    static String getVersion(boolean withAlternatives) {
        block9: {
            if (!versionString.isEmpty()) break block9;
            String Version = Bukkit.getServer().getClass().getPackage().getName();
            versionString = Version.substring(Version.lastIndexOf(46) + 1);
            switch (DragonSlayer.getMagicNMSNumber()) {
                case "4cc0cc97cac491651bff3af8b124a214": 
                case "69c84c88aeb92ce9fa9525438b93f4fe": {
                    versionString = String.valueOf(versionString) + "-2";
                }
            }
        }
        return withAlternatives ? versionString : versionString.replace("-2", "");
    }

    static int getSubVersion() {
        if (subVer == -1) {
            String version = DragonSlayer.getVersion();
            subVer = Integer.parseInt(version.substring(version.indexOf("_") + 1, version.lastIndexOf("_")));
        }
        return subVer;
    }

    private static String getMagicNMSNumber() {
        if (mapVers == null) {
            mapVers = "";
            try {
                UnsafeValues craftMagicNumbers = Bukkit.getServer().getUnsafe();
                Method getMapVer = craftMagicNumbers.getClass().getMethod("getMappingsVersion", new Class[0]);
                mapVers = (String)getMapVer.invoke((Object)craftMagicNumbers, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return mapVers;
    }

    private void setTestPortal() {
        for (String DragonWorld : this.configManager.getMaplist()) {
            if (Bukkit.getWorld((String)DragonWorld) == null) continue;
            World W = this.getDragonWorldFromString(DragonWorld);
            Location Position = new Location(W, 0.0, 1.0, 0.0);
            Location Position2 = new Location(W, -2.0, 1.0, 2.0);
            Position.getBlock().setType(Material.AIR);
            Position2.getBlock().setType(Material.AIR);
            if (!this.configManager.getDisableOrigDragonRespawn(DragonWorld)) continue;
            this.setTestPortal2(Position);
            this.setTestPortal2(Position2);
        }
    }

    private void setTestPortal2(Location Position) {
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
            Position.getBlock().getRelative(BlockFace.NORTH).setType(Material.BEDROCK);
            Position.getBlock().getRelative(BlockFace.SOUTH).setType(Material.BEDROCK);
            Position.getBlock().getRelative(BlockFace.WEST).setType(Material.BEDROCK);
            Position.getBlock().getRelative(BlockFace.EAST).setType(Material.BEDROCK);
            Position.getBlock().getRelative(BlockFace.UP).setType(Material.BEDROCK);
            try {
                Position.getBlock().setType(Material.valueOf((String)"ENDER_PORTAL"));
            }
            catch (Exception ex) {
                Position.getBlock().setType(Material.END_PORTAL);
            }
        });
    }

    private void countEndGatewaysAndContinue() {
        for (String DragonWorld : this.configManager.getMaplist()) {
            this.findAndUseEndgateways(DragonWorld);
        }
    }

    void findAndUseEndgateways(String DragonWorld) {
        if (!this.MinVersion19) {
            return;
        }
        World ThisWorld = this.getDragonWorldFromString(DragonWorld);
        if (ThisWorld != null) {
            int Counter = 0;
            long oldSeed = ThisWorld.getSeed();
            ArrayList<Integer> shuffledList = new ArrayList<Integer>();
            shuffledList.addAll((Collection<Integer>)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            Collections.shuffle(shuffledList, new Random(oldSeed));
            String Slots = " free slots...";
            int x = 1;
            while (x <= 20) {
                Block TestBlock;
                Location Testlocation;
                double x2 = 96.0 * Math.cos(2.0 * (-this.Pi + this.ZwPi * (double)x));
                double z2 = 96.0 * Math.sin(2.0 * (-this.Pi + this.ZwPi * (double)x));
                int x1 = (int)x2;
                int z1 = (int)z2;
                if (DragonSlayer.getSubVersion() >= 14) {
                    if (x2 < (double)x1) {
                        --x1;
                    }
                    if (z2 < (double)z1) {
                        --z1;
                    }
                }
                if (!this.Endgateways.contains(Testlocation = new Location(ThisWorld, (double)x1, 75.0, (double)z1))) {
                    this.Endgateways.add(Testlocation);
                }
                if ((TestBlock = Testlocation.getBlock()).getType() == Material.END_GATEWAY) {
                    ++Counter;
                    shuffledList.remove(shuffledList.indexOf(x == 20 ? 0 : x));
                }
                ++x;
            }
            if (!this.configManager.getCreateGateways(DragonWorld.toLowerCase())) {
                shuffledList = new ArrayList();
            }
            this.prepareEndGateways(ThisWorld, shuffledList);
            if (this.configManager.getVerbosity()) {
                this.logger.info(String.valueOf(Counter) + " endgateways found on " + ThisWorld.getName() + " with " + shuffledList.size() + Slots);
            }
        }
    }

    void UpdateEndgatewayPosList(World ThisWorld) {
        int x = 1;
        while (x <= 20) {
            Location Testlocation;
            double x2 = 96.0 * Math.cos(2.0 * (-this.Pi + this.ZwPi * (double)x));
            double z2 = 96.0 * Math.sin(2.0 * (-this.Pi + this.ZwPi * (double)x));
            int x1 = (int)x2;
            int z1 = (int)z2;
            if (DragonSlayer.getSubVersion() >= 14) {
                if (x2 < (double)x1) {
                    --x1;
                }
                if (z2 < (double)z1) {
                    --z1;
                }
            }
            if (!this.Endgateways.contains(Testlocation = new Location(ThisWorld, (double)x1, 75.0, (double)z1))) {
                this.Endgateways.add(Testlocation);
            }
            ++x;
        }
        ArrayList<Location> newEndgateways = new ArrayList<Location>();
        for (Location Loc : this.Endgateways) {
            boolean worldExists = false;
            try {
                if (Loc.isWorldLoaded()) {
                    worldExists = true;
                }
            }
            catch (NoSuchMethodError exp) {
                try {
                    Loc.getBlock().getWorld().getChunkAt(0, 0);
                    worldExists = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!worldExists || !this.checkWorld(Loc.getWorld().getName().toLowerCase())) continue;
            newEndgateways.add(Loc);
        }
        this.Endgateways = newEndgateways;
    }

    void OrigEnderDragonSetKilled(EnderDragon ThisDragon) {
        block13: {
            int sv = DragonSlayer.getSubVersion();
            if (sv <= 8) {
                return;
            }
            Object DrBatt = this.getEnderDragonBattle(ThisDragon);
            if (DrBatt != null) {
                try {
                    if (this.DragonKilled == null) {
                        String DragonKilled_ = "k";
                        if (sv == 16) {
                            DragonKilled_ = "dragonKilled";
                        } else if (sv >= 17) {
                            DragonKilled_ = "s";
                        }
                        this.DragonKilled = DrBatt.getClass().getDeclaredField(DragonKilled_);
                    }
                    if (this.DragonUUID == null) {
                        String DragonUUID_ = "m";
                        if (sv == 16) {
                            DragonUUID_ = "dragonUUID";
                        } else if (sv >= 17) {
                            DragonUUID_ = "u";
                        }
                        this.DragonUUID = DrBatt.getClass().getDeclaredField(DragonUUID_);
                    }
                    if (this.DragonKilled != null && this.DragonUUID != null) {
                        this.DragonKilled.setAccessible(true);
                        this.DragonUUID.setAccessible(true);
                        this.DragonKilled.setBoolean(DrBatt, true);
                        this.DragonUUID.set(DrBatt, null);
                    }
                }
                catch (IllegalAccessException | NoSuchFieldException | NullPointerException | SecurityException e) {
                    this.logger.warning("Unknown or unsupported Version :" + DragonSlayer.getVersion() + " ,can't handle this here... (yet?)");
                    if (!this.configManager.debugOn()) break block13;
                    e.printStackTrace();
                }
            }
        }
    }

    boolean EnderDragonPreviouslyKilled(EnderDragon ThisDragon) {
        block8: {
            if (this.MinVersion117) {
                if (ThisDragon.getWorld().getEnvironment() == World.Environment.THE_END) {
                    return ThisDragon.getDragonBattle().hasBeenPreviouslyKilled();
                }
            } else {
                try {
                    Object edb = this.getEnderDragonBattle(ThisDragon);
                    if (edb != null) {
                        if (this.db_d == null) {
                            String methode_ = "";
                            methode_ = DragonSlayer.getSubVersion() >= 16 ? "isPreviouslyKilled" : "d";
                            this.db_d = edb.getClass().getDeclaredMethod(methode_, new Class[0]);
                        }
                        if (this.db_d != null) {
                            this.db_d.setAccessible(true);
                            return (Boolean)this.db_d.invoke(edb, new Object[0]);
                        }
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException e) {
                    this.logger.warning("Unknown or unsupported Version :" + DragonSlayer.getVersion() + " , can't handle this here...(yet?)!");
                    if (!this.configManager.debugOn()) break block8;
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    void WorldGenEndTrophyPositionSet(EnderDragon ThisDrag, boolean setEDBforce) {
        boolean errored;
        String Worldname;
        int dragonId;
        World ThisWorld;
        block6: {
            if (!this.configManager.getMultiPortal() && !this.serverStarted) {
                return;
            }
            if (this.configManager.getMultiPortal() && this.serverStarted && !this.checkDSLDragon(ThisDrag)) {
                return;
            }
            ThisWorld = ThisDrag.getWorld();
            dragonId = this.getDragonIDMeta(ThisDrag);
            Worldname = ThisWorld.getName().toLowerCase();
            errored = false;
            try {
                if (!this.configManager.getOldPortal(Worldname)) {
                    this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                        block64: {
                            int newY;
                            int newZ;
                            int newX;
                            String newPhase;
                            Object phase_control;
                            String vec3d_m_mult_name;
                            String phaseC_getVec3d_m_name;
                            String phaseController_m_c_name;
                            String landing_vec3d_f_name;
                            String pathPoint_m_name;
                            String pathEnt_m_pathpoint_name;
                            String pathEnt_m_size_name;
                            String pathEnt_f_name;
                            block63: {
                                String phaseController_m_name_1 = "getDragonControllerManager";
                                String phaseController_m_name_2 = "a";
                                String phaseController_m_name_3 = "getControllerPhase";
                                pathEnt_f_name = "c";
                                pathEnt_m_size_name = "e";
                                pathEnt_m_pathpoint_name = "a";
                                pathPoint_m_name = "a";
                                landing_vec3d_f_name = "b";
                                phaseController_m_c_name = "c";
                                phaseC_getVec3d_m_name = "g";
                                vec3d_m_mult_name = "a";
                                switch (DragonSlayer.getVersion(true)) {
                                    case "v1_19_R1-2": {
                                        phaseController_m_name_1 = "fG";
                                        phaseController_m_name_3 = "i";
                                        break;
                                    }
                                    case "v1_19_R1": {
                                        phaseController_m_name_1 = "fH";
                                        phaseController_m_name_3 = "i";
                                        break;
                                    }
                                    case "v1_18_R2": {
                                        phaseController_m_name_1 = "fx";
                                        phaseController_m_name_3 = "i";
                                        break;
                                    }
                                    case "v1_18_R1": {
                                        phaseController_m_name_1 = "fw";
                                        phaseController_m_name_3 = "i";
                                        break;
                                    }
                                    case "v1_10_R1": 
                                    case "v1_11_R1": 
                                    case "v1_12_R1": 
                                    case "v1_13_R1": 
                                    case "v1_13_R2": 
                                    case "v1_9_R2": {
                                        pathEnt_f_name = "b";
                                        pathEnt_m_size_name = "d";
                                        break;
                                    }
                                    case "v1_9_R1": {
                                        phaseController_m_name_1 = "cT";
                                        pathEnt_f_name = "b";
                                        pathEnt_m_size_name = "d";
                                        phaseController_m_name_3 = "i";
                                        break;
                                    }
                                    default: {
                                        this.logger.warning("Unknown or unsupported Version: " + DragonSlayer.getVersion() + " ,can't handle Landing-DragonPhase...(yet?)");
                                    }
                                    case "v1_14_R1": 
                                    case "v1_15_R1": 
                                    case "v1_16_R1": 
                                    case "v1_16_R2": 
                                    case "v1_16_R3": 
                                    case "v1_17_R1": 
                                }
                                Object newDragEnt = this.getEntityEnderDragon(ThisDrag);
                                Object phase_control_m = null;
                                phase_control = null;
                                newPhase = "";
                                newX = this.configManager.getPortalX(Worldname, dragonId);
                                newZ = this.configManager.getPortalZ(Worldname, dragonId);
                                newY = this.findPosForPortal(newX, newZ, ThisWorld, Material.BEDROCK).getBlockY() + 4;
                                try {
                                    phase_control_m = newDragEnt.getClass().getDeclaredMethod(phaseController_m_name_1, new Class[0]).invoke(newDragEnt, new Object[0]);
                                    phase_control = phase_control_m.getClass().getDeclaredMethod(phaseController_m_name_2, new Class[0]).invoke(phase_control_m, new Object[0]);
                                    newPhase = phase_control.getClass().getDeclaredMethod(phaseController_m_name_3, new Class[0]).invoke(phase_control, new Object[0]).toString();
                                }
                                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e2) {
                                    if (!this.configManager.debugOn()) break block63;
                                    e2.printStackTrace();
                                }
                            }
                            if (newPhase.startsWith("LandingApproach")) {
                                try {
                                    Field pathEnt_f = phase_control.getClass().getDeclaredField(pathEnt_f_name);
                                    pathEnt_f.setAccessible(true);
                                    Object pathEnt = pathEnt_f.get(phase_control);
                                    if (pathEnt != null) {
                                        int j = 0;
                                        while (j <= (Integer)pathEnt.getClass().getDeclaredMethod(pathEnt_m_size_name, new Class[0]).invoke(pathEnt, new Object[0]) - 1) {
                                            Object pathPointAusPathEnt = pathEnt.getClass().getDeclaredMethod(pathEnt_m_pathpoint_name, Integer.TYPE).invoke(pathEnt, j);
                                            if (this.checkPositionRange(pathPointAusPathEnt, newX, newZ, 90)) {
                                                Object newPathPoint = pathPointAusPathEnt.getClass().getMethod(pathPoint_m_name, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(pathPointAusPathEnt, newX, newY, newZ);
                                                pathEnt.getClass().getDeclaredMethod("a", Integer.TYPE, pathPointAusPathEnt.getClass()).invoke(pathEnt, j, newPathPoint);
                                            }
                                            ++j;
                                        }
                                    }
                                    break block64;
                                }
                                catch (Exception e) {
                                    if (this.configManager.debugOn()) {
                                        this.logger.warning("Can not handle landing flight (PathEntity)!");
                                        e.printStackTrace();
                                    }
                                    break block64;
                                }
                            }
                            if (newPhase.startsWith("Landing") || newPhase.startsWith("Dying") && this.configManager.getDragonDeathFix(Worldname)) {
                                try {
                                    Object vec3d = phase_control.getClass().getMethod(phaseC_getVec3d_m_name, new Class[0]).invoke(phase_control, new Object[0]);
                                    if (vec3d != null) {
                                        double v_z;
                                        double v_x;
                                        String ved3d_add_name = "add";
                                        if (DragonSlayer.getSubVersion() >= 18) {
                                            v_x = (Double)vec3d.getClass().getMethod("a", new Class[0]).invoke(vec3d, new Object[0]);
                                            v_z = (Double)vec3d.getClass().getMethod("c", new Class[0]).invoke(vec3d, new Object[0]);
                                            ved3d_add_name = "b";
                                        } else if (DragonSlayer.getSubVersion() >= 14) {
                                            v_x = (Double)vec3d.getClass().getMethod("getX", new Class[0]).invoke(vec3d, new Object[0]);
                                            v_z = (Double)vec3d.getClass().getMethod("getZ", new Class[0]).invoke(vec3d, new Object[0]);
                                        } else {
                                            v_x = vec3d.getClass().getDeclaredField("x").getDouble(vec3d);
                                            v_z = vec3d.getClass().getDeclaredField("z").getDouble(vec3d);
                                        }
                                        if (Math.abs(v_x - (double)newX) > 1.0 && Math.abs(v_z - (double)newZ) > 1.0) {
                                            Object vec3d_new1 = vec3d.getClass().getMethod(vec3d_m_mult_name, Double.TYPE).invoke(vec3d, 0);
                                            Object vec3d_new = vec3d_new1.getClass().getMethod(ved3d_add_name, Double.TYPE, Double.TYPE, Double.TYPE).invoke(vec3d_new1, newX, newY, newZ);
                                            Field vec3c_f = phase_control.getClass().getDeclaredField(landing_vec3d_f_name);
                                            vec3c_f.setAccessible(true);
                                            vec3c_f.set(phase_control, vec3d_new);
                                            phase_control.getClass().getDeclaredMethod(phaseController_m_c_name, new Class[0]).invoke(phase_control, new Object[0]);
                                        }
                                    }
                                }
                                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException e) {
                                    if (!this.configManager.debugOn()) break block64;
                                    this.logger.warning("Debug: Can not handle landing vector!");
                                    e.printStackTrace();
                                }
                            }
                        }
                    }, 5L);
                }
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | SecurityException e) {
                errored = true;
                if (!this.configManager.debugOn()) break block6;
                e.printStackTrace();
            }
        }
        if (errored) {
            this.logger.warning("Error while trying to set new portal position! (TrophyClass)");
        }
        this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
            boolean useAll = false;
            if (this.checkServerStarted() ^ this.configManager.getMultiPortal()) {
                this.invertServerstartedAndSetAllNavi();
                useAll = true;
            } else if (ThisDrag.isValid()) {
                this.setDragonNavi(ThisDrag);
            }
            if (this.checkDSLDragon(ThisDrag)) {
                this.setExitPortalLocation(ThisWorld, this.configManager.getPortalX(Worldname, dragonId), null, this.configManager.getPortalZ(Worldname, dragonId), setEDBforce, useAll);
            }
        }, 2L);
    }

    void setDragonNavi(EnderDragon drag) {
        Object entDrag;
        int dragonId;
        String world;
        block67: {
            if (!this.checkDSLDragon(drag)) {
                return;
            }
            String fieldName = "";
            String alt_fieldName = "";
            String funcName = "";
            world = drag.getWorld().getName().toLowerCase();
            dragonId = this.getDragonIDMeta(drag);
            entDrag = this.getEntityEnderDragon(drag);
            if (this.naviField != null) break block67;
            switch (DragonSlayer.getVersion(true)) {
                case "v1_19_R1": 
                case "v1_19_R1-2": {
                    fieldName = "cv";
                    funcName = "q";
                    break;
                }
                case "v1_18_R2": {
                    fieldName = "ct";
                    funcName = "q";
                    break;
                }
                case "v1_18_R1": {
                    fieldName = "cu";
                    funcName = "q";
                    break;
                }
                case "v1_17_R1": {
                    fieldName = "cr";
                    alt_fieldName = "cs";
                    funcName = "p";
                    break;
                }
                case "v1_16_R2": 
                case "v1_16_R3": {
                    fieldName = "bJ";
                    funcName = "eI";
                    break;
                }
                case "v1_16_R1": {
                    fieldName = "bQ";
                    funcName = "eJ";
                    break;
                }
                case "v1_15_R1": {
                    fieldName = "bR";
                    funcName = "l";
                    break;
                }
                case "v1_14_R1": {
                    fieldName = "bT";
                    funcName = "l";
                    break;
                }
                case "v1_13_R1": 
                case "v1_13_R2": {
                    fieldName = "bV";
                    funcName = "l";
                    break;
                }
                case "v1_12_R1": {
                    fieldName = "bO";
                    funcName = "p";
                    break;
                }
                case "v1_11_R1": {
                    fieldName = "bN";
                    funcName = "o";
                    break;
                }
                case "v1_10_R1": {
                    fieldName = "bO";
                    funcName = "o";
                    break;
                }
                case "v1_9_R2": {
                    fieldName = "bN";
                    funcName = "o";
                    break;
                }
                case "v1_9_R1": {
                    fieldName = "bM";
                    funcName = "o";
                    break;
                }
                default: {
                    this.logger.warning("Unknown or unsupported Version :" + DragonSlayer.getVersion() + " ,can't handle EnderDragon...(yet?)");
                }
            }
            try {
                this.naviField = entDrag.getClass().getDeclaredField(fieldName);
                if (this.naviField != null) {
                    this.naviField.setAccessible(true);
                    if (!this.naviField.get(entDrag).getClass().isArray() && !alt_fieldName.isEmpty()) {
                        this.naviField = entDrag.getClass().getDeclaredField(alt_fieldName);
                    }
                }
                this.fillArray = entDrag.getClass().getDeclaredMethod(funcName, new Class[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
                if (this.configManager.debugOn()) {
                    e.printStackTrace();
                }
                this.logger.warning("Unknown or unsupported Version :" + DragonSlayer.getVersion() + ", can't handle EnderDragon's pathpoints...(yet?)");
                if (!this.configManager.debugOn()) break block67;
                this.logger.warning("Dragon is:" + drag.getName());
            }
        }
        if (this.naviField != null && this.fillArray != null) {
            try {
                this.naviField.setAccessible(true);
                Object pathArray = this.naviField.get(entDrag);
                int newX = this.configManager.getPortalX(world, dragonId);
                int newZ = this.configManager.getPortalZ(world, dragonId);
                int n = 20;
                while (n <= 23) {
                    Object path_n = ((Object[])pathArray)[n];
                    if (path_n == null || path_n != null && this.checkPositionRange(path_n, newX, newZ, 20)) {
                        ((Object[])pathArray)[0] = null;
                        this.naviField.set(entDrag, pathArray);
                        this.fillArray.setAccessible(true);
                        this.fillArray.invoke(entDrag, new Object[0]);
                        pathArray = this.naviField.get(entDrag);
                        int i = 0;
                        while (i < ((Object[])pathArray).length) {
                            ((Object[])pathArray)[i] = this.makeMovedPathpointObject(((Object[])pathArray)[i], newX, 0, newZ);
                            ++i;
                        }
                        this.naviField.set(entDrag, pathArray);
                        Location teleLoc = drag.getLocation();
                        if (path_n == null) {
                            path_n = "x=" + teleLoc.getBlockX() + ",y=" + teleLoc.getBlockY() + ",z=" + teleLoc.getBlockZ();
                        }
                        if (this.checkPositionRange(path_n, newX, newZ, 100)) {
                            teleLoc.setX((double)newX);
                            teleLoc.setZ((double)newZ);
                            teleLoc.setY((double)(teleLoc.getBlockY() + new Random().nextInt(50)));
                            drag.teleport(teleLoc);
                        }
                        break;
                    }
                    ++n;
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                if (this.configManager.debugOn()) {
                    e.printStackTrace();
                }
                this.logger.warning("Unknown or unsupported Version :" + DragonSlayer.getVersion() + " ,can't handle EnderDragon's pathpoints...(yet?)");
            }
        }
    }

    private void invertServerstartedAndSetAllNavi() {
        this.serverStarted = !this.checkServerStarted();
        for (String Mapname : this.configManager.getMaplist()) {
            Collection<EnderDragon> dragList;
            World World2 = this.getDragonWorldFromString(Mapname);
            if (World2 == null || (dragList = this.getDragonList(World2, Mapname)) == null) continue;
            for (EnderDragon drag : dragList) {
                if (this.getDragonIDMeta(drag) < 0) continue;
                this.setDragonNavi(drag);
                if (!drag.getPhase().equals((Object)EnderDragon.Phase.HOVER)) continue;
                drag.setPhase(EnderDragon.Phase.CIRCLING);
            }
        }
    }

    void setExitPortalLocation(World ThisWorld, int newX, Integer newY, int newZ, boolean setEDBforce, boolean useAll) {
        Object DragonBattle2;
        block11: {
            DragonBattle2 = this.getEnderDragonBattle(ThisWorld);
            HashMap<Object, World> BattleList = new HashMap<Object, World>();
            if (!useAll) {
                if (DragonBattle2 != null) {
                    BattleList.put(DragonBattle2, ThisWorld);
                }
            } else {
                setEDBforce = true;
                for (String Mapname : this.configManager.getMaplist()) {
                    World World2 = this.getDragonWorldFromString(Mapname);
                    if (World2 == null || World2.getEnvironment() != World.Environment.THE_END) continue;
                    BattleList.put(this.getEnderDragonBattle(World2), World2);
                }
            }
            try {
                if (setEDBforce) {
                    for (String Battle : BattleList.keySet()) {
                        if (this.PortLoc_f == null) {
                            String PortLocName = "";
                            PortLocName = DragonSlayer.getSubVersion() == 16 ? "exitPortalLocation" : (DragonSlayer.getSubVersion() >= 17 ? "w" : "o");
                            this.PortLoc_f = Battle.getClass().getDeclaredField(PortLocName);
                        }
                        this.PortLoc_f.setAccessible(true);
                        Object EDB_PortLoc = this.PortLoc_f.get(Battle);
                        if ((EDB_PortLoc == null || !this.checkPositionRange(EDB_PortLoc, newX, newZ, 0) && newY == null) && EDB_PortLoc != null) continue;
                        if (newY == null) {
                            newY = this.findPosForPortal(newX, newZ, (World)BattleList.get(Battle), Material.BEDROCK).getBlockY();
                        }
                        Object BlockPosN = this.makeBlockPositionObject(newX, newY, newZ);
                        this.PortLoc_f.set(Battle, BlockPosN);
                    }
                }
            }
            catch (IllegalAccessException | NoSuchFieldException | NullPointerException ex) {
                if (!this.configManager.debugOn()) break block11;
                this.logger.warning("Error while trying to set new portal position!!");
                ex.printStackTrace();
            }
        }
        if (DragonBattle2 != null) {
            this.setCrystalAmount(DragonBattle2, this.configManager.getOldPortal(ThisWorld.getName().toLowerCase()));
        }
    }

    private boolean checkPositionRange(Object loc, int newX, int newZ, int dist) {
        String[] locArray = loc.toString().replace("BlockPosition", "").replace("Node", "").replaceAll("[_ }{=]", "").split(",");
        int newX2 = 0;
        int newZ2 = 0;
        if (locArray != null && locArray.length == 3) {
            String[] stringArray = locArray;
            int n = locArray.length;
            int n2 = 0;
            while (n2 < n) {
                String n3 = stringArray[n2];
                if (n3.substring(0, 1).equals("x")) {
                    newX2 = Integer.parseInt(n3.substring(1));
                }
                if (n3.substring(0, 1).equals("z")) {
                    newZ2 = Integer.parseInt(n3.substring(1));
                }
                ++n2;
            }
            if (DragonSlayer.getSubVersion() <= 13 && !locArray[0].startsWith("x")) {
                newX2 = Integer.parseInt(locArray[0]);
                newZ2 = Integer.parseInt(locArray[2]);
            }
        }
        return Math.abs(newX - newX2) > dist || Math.abs(newZ - newZ2) > dist;
    }

    private Object makeBlockPositionObject(int newX, int newY, int newZ) {
        block5: {
            if (DragonSlayer.getSubVersion() <= 8) {
                return null;
            }
            try {
                if (this.newBlockPosition == null) {
                    Class<?> BlockPosition_c = null;
                    BlockPosition_c = DragonSlayer.getSubVersion() <= 16 ? Class.forName("net.minecraft.server." + DragonSlayer.getVersion() + ".BlockPosition") : Class.forName("net.minecraft.core.BlockPosition");
                    this.newBlockPosition = BlockPosition_c.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                }
                if (this.newBlockPosition != null) {
                    return this.newBlockPosition.newInstance(newX, newY, newZ);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException e) {
                this.logger.warning("Unknown or unsupported Version :" + DragonSlayer.getVersion() + " ,can't handle BlockPosition...(yet?)");
                if (!this.configManager.debugOn()) break block5;
                e.printStackTrace();
            }
        }
        return null;
    }

    private void setCrystalAmount(Object DragonBattle2, boolean forceOff) {
        block5: {
            try {
                if (this.CrystalAmount_f == null) {
                    String fieldName = "";
                    fieldName = DragonSlayer.getSubVersion() >= 17 ? "p" : "h";
                    this.CrystalAmount_f = DragonBattle2.getClass().getDeclaredField(fieldName);
                }
                this.CrystalAmount_f.setAccessible(true);
                Object CrystalAmount = this.CrystalAmount_f.get(DragonBattle2);
                if (CrystalAmount != null && this.configManager.getMultiPortal()) {
                    int newCrystalAmount = this.configManager.getPortalAgression(forceOff);
                    if ((Integer)CrystalAmount != newCrystalAmount) {
                        this.CrystalAmount_f.set(DragonBattle2, newCrystalAmount);
                    }
                }
            }
            catch (IllegalAccessException | NoSuchFieldException | NullPointerException ex) {
                if (!this.configManager.debugOn()) break block5;
                this.logger.warning("Error while trying to set new crystal amount !!");
                ex.printStackTrace();
            }
        }
    }

    boolean isRefreshRunning(World ThisWorld) {
        if (DragonSlayer.getSubVersion() >= 16) {
            return !ThisWorld.getEnderDragonBattle().getRespawnPhase().toString().equalsIgnoreCase("NONE");
        }
        Object DragonBattle2 = this.getEnderDragonBattle(ThisWorld);
        try {
            if (this.respawnPhase_f == null) {
                this.respawnPhase_f = DragonBattle2.getClass().getDeclaredField("p");
            }
            this.respawnPhase_f.setAccessible(true);
            Object respawnPhase = this.respawnPhase_f.get(DragonBattle2);
            return respawnPhase != null;
        }
        catch (IllegalAccessException | NoSuchFieldException | NullPointerException ex) {
            if (this.configManager.debugOn()) {
                this.logger.warning("Error while trying to fetch respawnPhase!!");
                ex.printStackTrace();
            }
            return false;
        }
    }

    Object getEntityEnderDragon(EnderDragon dragon) {
        Object returnwert;
        block4: {
            returnwert = null;
            try {
                if (this.CraftEnderDragonClass == null) {
                    this.CraftEnderDragonClass = Class.forName("org.bukkit.craftbukkit." + DragonSlayer.getVersion() + ".entity.CraftEnderDragon");
                }
                if (this.CraftEnderDragonClass.isInstance(dragon)) {
                    Object craftDragon = this.CraftEnderDragonClass.cast(dragon);
                    returnwert = this.CraftEnderDragonClass.getDeclaredMethod("getHandle", new Class[0]).invoke(craftDragon, new Object[0]);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException e) {
                this.logger.warning("Unknown or unsupported Version :" + DragonSlayer.getVersion() + ", can't handle EntityEnderDragon...(yet?)");
                if (!this.configManager.debugOn()) break block4;
                e.printStackTrace();
            }
        }
        return returnwert;
    }

    private Object makeMovedPathpointObject(Object point, int newX, int newY, int newZ) {
        try {
            if (this.newPathPoint == null) {
                Class<?> pathPoint_cl = null;
                pathPoint_cl = DragonSlayer.getSubVersion() <= 16 ? Class.forName("net.minecraft.server." + DragonSlayer.getVersion() + ".PathPoint") : Class.forName("net.minecraft.world.level.pathfinder.PathPoint");
                this.newPathPoint = pathPoint_cl.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                if (DragonSlayer.getSubVersion() >= 16) {
                    this.pp_geta_func = pathPoint_cl.getDeclaredMethod("a", new Class[0]);
                    Class<?> baseBlockPosition_cl = null;
                    baseBlockPosition_cl = DragonSlayer.getSubVersion() == 16 ? Class.forName("net.minecraft.server." + DragonSlayer.getVersion() + ".BaseBlockPosition") : Class.forName("net.minecraft.core.BaseBlockPosition");
                    if (DragonSlayer.getSubVersion() <= 17) {
                        this.bbp_getX = baseBlockPosition_cl.getDeclaredMethod("getX", new Class[0]);
                        this.bbp_getY = baseBlockPosition_cl.getDeclaredMethod("getY", new Class[0]);
                        this.bbp_getZ = baseBlockPosition_cl.getDeclaredMethod("getZ", new Class[0]);
                    } else {
                        this.bbp_getX = baseBlockPosition_cl.getDeclaredMethod("u", new Class[0]);
                        this.bbp_getY = baseBlockPosition_cl.getDeclaredMethod("v", new Class[0]);
                        this.bbp_getZ = baseBlockPosition_cl.getDeclaredMethod("w", new Class[0]);
                    }
                } else {
                    this.pp_geta_x = pathPoint_cl.getDeclaredField("a");
                    this.pp_getb_y = pathPoint_cl.getDeclaredField("b");
                    this.pp_getc_z = pathPoint_cl.getDeclaredField("c");
                }
            }
            if (DragonSlayer.getSubVersion() >= 16) {
                Object baselockPos = this.pp_geta_func.invoke(point, new Object[0]);
                return this.newPathPoint.newInstance((Integer)this.bbp_getX.invoke(baselockPos, new Object[0]) + newX, (Integer)this.bbp_getY.invoke(baselockPos, new Object[0]) + newY, (Integer)this.bbp_getZ.invoke(baselockPos, new Object[0]) + newZ);
            }
            return this.newPathPoint.newInstance(this.pp_geta_x.getInt(point) + newX, this.pp_getb_y.getInt(point) + newY, this.pp_getc_z.getInt(point) + newZ);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.warning("Unknown or unsupported Version :" + DragonSlayer.getVersion() + ", can't handle Pathpoints...(yet?)");
            return null;
        }
    }

    private Object getEnderDragonBattle(EnderDragon ThisDragon) {
        return this.getEnderDragonBattle(ThisDragon.getWorld());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getEnderDragonBattle(World ThisWorld) {
        block66: {
            if (DragonSlayer.getSubVersion() < 16) break block66;
            try {
                Object edb;
                Object worldServer;
                block67: {
                    worldServer = this.getWorldServer(ThisWorld);
                    if (this.getEDBMethod != null) break block67;
                    String getDragonBattle_name = "getDragonBattle";
                    switch (DragonSlayer.getVersion(true)) {
                        case "v1_19_R1": 
                        case "v1_19_R1-2": {
                            getDragonBattle_name = "C";
                            break;
                        }
                        case "v1_18_R2": {
                            getDragonBattle_name = "E";
                            break;
                        }
                        case "v1_18_R1": {
                            getDragonBattle_name = "F";
                        }
                    }
                    this.getEDBMethod = worldServer.getClass().getDeclaredMethod(getDragonBattle_name, new Class[0]);
                }
                if ((edb = this.getEDBMethod.invoke(worldServer, new Object[0])) != null || ThisWorld.getEnvironment() != World.Environment.THE_END) return edb;
                String edb_fieldName = null;
                String worldDataServer_name = null;
                String generatorSettings_name = null;
                String worldServer_long_name = null;
                String ws_nbt_name = null;
                if (DragonSlayer.getSubVersion() == 19) {
                    worldDataServer_name = "N";
                    generatorSettings_name = "A";
                    worldServer_long_name = "a";
                    ws_nbt_name = "C";
                    edb_fieldName = "ac";
                }
                if (worldDataServer_name == null) return edb;
                try {
                    Object ws_wds = worldServer.getClass().getField(worldDataServer_name).get(worldServer);
                    Object ws_gs = ws_wds.getClass().getMethod(generatorSettings_name, new Class[0]).invoke(ws_wds, new Object[0]);
                    long ws_long = (Long)ws_gs.getClass().getMethod(worldServer_long_name, new Class[0]).invoke(ws_gs, new Object[0]);
                    Object ws_nbt = ws_wds.getClass().getMethod(ws_nbt_name, new Class[0]).invoke(ws_wds, new Object[0]);
                    edb = Class.forName("net.minecraft.world.level.dimension.end.EnderDragonBattle").getConstructor(worldServer.getClass(), Long.TYPE, Class.forName("net.minecraft.nbt.NBTTagCompound")).newInstance(worldServer, ws_long, ws_nbt);
                    Field edb_f = worldServer.getClass().getDeclaredField(edb_fieldName);
                    edb_f.setAccessible(true);
                    edb_f.set(worldServer, edb);
                    if (!this.configManager.getVerbosity()) return edb;
                    this.logger.warning("Started Hot-Fix for DragonBattle in world " + ThisWorld.getName());
                    return edb;
                }
                catch (InstantiationException | NoSuchFieldException e) {
                    this.logger.warning("Unknown or unsupported Version :" + DragonSlayer.getVersion() + ", can't create own dragonbattle...");
                    if (!this.configManager.debugOn()) return edb;
                    e.printStackTrace();
                }
                return edb;
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException ee) {
                this.logger.warning("Unknown or unsupported Version :" + DragonSlayer.getVersion() + ", can't handle dragonbattle...(yet?)");
                if (!this.configManager.debugOn()) return null;
                ee.printStackTrace();
                return null;
            }
        }
        switch (DragonSlayer.getVersion(true)) {
            case "v1_15_R1": {
                return ((net.minecraft.server.v1_15_R1.WorldProviderTheEnd)((org.bukkit.craftbukkit.v1_15_R1.CraftWorld)ThisWorld).getHandle().worldProvider).o();
            }
            case "v1_14_R1": {
                return ((net.minecraft.server.v1_14_R1.WorldProviderTheEnd)((org.bukkit.craftbukkit.v1_14_R1.CraftWorld)ThisWorld).getHandle().worldProvider).q();
            }
            case "v1_13_R2": {
                return ((net.minecraft.server.v1_13_R2.WorldProviderTheEnd)((org.bukkit.craftbukkit.v1_13_R2.CraftWorld)ThisWorld).getHandle().worldProvider).r();
            }
            case "v1_13_R1": {
                return ((net.minecraft.server.v1_13_R1.WorldProviderTheEnd)((org.bukkit.craftbukkit.v1_13_R1.CraftWorld)ThisWorld).getHandle().worldProvider).r();
            }
            case "v1_12_R1": {
                return ((net.minecraft.server.v1_12_R1.WorldProviderTheEnd)((CraftWorld)ThisWorld).getHandle().worldProvider).t();
            }
            case "v1_11_R1": {
                return ((net.minecraft.server.v1_11_R1.WorldProviderTheEnd)((org.bukkit.craftbukkit.v1_11_R1.CraftWorld)ThisWorld).getHandle().worldProvider).t();
            }
            case "v1_10_R1": {
                return ((WorldProviderTheEnd)((org.bukkit.craftbukkit.v1_10_R1.CraftWorld)ThisWorld).getHandle().worldProvider).s();
            }
            case "v1_9_R2": {
                return ((net.minecraft.server.v1_9_R2.WorldProviderTheEnd)((org.bukkit.craftbukkit.v1_9_R2.CraftWorld)ThisWorld).getHandle().worldProvider).s();
            }
            case "v1_9_R1": {
                return ((net.minecraft.server.v1_9_R1.WorldProviderTheEnd)((org.bukkit.craftbukkit.v1_9_R1.CraftWorld)ThisWorld).getHandle().worldProvider).s();
            }
            default: {
                this.logger.warning("Unknown or unsupported Version :" + DragonSlayer.getVersion() + " ,can't handle original dragonbattle...(yet?)");
            }
            case "v1_7_R1": 
            case "v1_7_R2": 
            case "v1_7_R3": 
            case "v1_7_R4": 
            case "v1_8_R1": 
            case "v1_8_R2": 
            case "v1_8_R3": 
        }
        return null;
    }

    void PlaceArmorStand(String w, double x, double y, double z, float yaw) {
        Location as_loc = new Location(this.getDragonWorldFromString(w), x, y, z);
        as_loc.setYaw(yaw);
        ArmorStand armorStand = this.spawnArmorStand1(as_loc);
        this.setArmorstandMeta(armorStand);
        if (this.getSlayer() != null && this.getStatueVersion() == 1) {
            this.setArmorStandNameETC(armorStand, as_loc.clone());
        }
        if (this.ProtocolLibEnabled) {
            if (this.getStatueVersion() >= 2) {
                this.changeArmorStand1_NPCValues(armorStand);
                if (DragonSlayer.getSubVersion() < 9) {
                    armorStand.setMarker(false);
                } else {
                    this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                        Location target_l = as_loc.clone().add(0.0, 1.8, 0.0);
                        armorStand.teleport(target_l);
                        this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                            if (as_loc.equals((Object)armorStand.getLocation())) {
                                try {
                                    as_loc.getChunk().load();
                                    as_loc.getChunk().getEntities();
                                    armorStand.teleport(target_l);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                                    if (as_loc.equals((Object)armorStand.getLocation())) {
                                        this.RemoveArmorStand();
                                        ArmorStand armorStand_ = this.spawnArmorStand1(target_l);
                                        this.changeArmorStand1_NPCValues(armorStand_);
                                        this.setArmorstandMeta(armorStand_);
                                    }
                                }, 10L);
                            }
                        }, 10L);
                    }, 10L);
                }
                this.replaceNPCStatue();
            } else {
                this.removeNPCStatue();
            }
        }
    }

    private ArmorStand spawnArmorStand1(Location as_loc) {
        ArmorStand armorStand = (ArmorStand)as_loc.getWorld().spawnEntity(as_loc, EntityType.ARMOR_STAND);
        armorStand.setGravity(false);
        armorStand.setArms(true);
        armorStand.setMarker(true);
        if (this.getSlayer() != null) {
            armorStand.setCustomName(this.getSlayer());
        } else {
            armorStand.setCustomName(this.getName());
        }
        armorStand.setCustomNameVisible(false);
        armorStand.setBasePlate(false);
        armorStand.setCanPickupItems(false);
        if (this.MinVersion19) {
            armorStand.setInvulnerable(true);
        }
        armorStand.setVisible(true);
        if (this.MinVersion19) {
            armorStand.setCollidable(false);
        }
        double pitch = -20.0;
        float headYaw = 20.0f;
        this.setHeadDirection(armorStand, headYaw, pitch);
        double armPitch = Math.toRadians(-100.0);
        double armYaw = Math.toRadians(12.0);
        double armRoll = Math.toRadians(-10.0);
        EulerAngle eangle = new EulerAngle(armPitch, armYaw, armRoll);
        armorStand.setRightArmPose(eangle);
        return armorStand;
    }

    private void changeArmorStand1_NPCValues(ArmorStand armorStand) {
        String playername = this.configManager.getSlayerPAPIFormatNickString();
        if (playername != null) {
            armorStand.setCustomName(playername);
        }
        armorStand.setVisible(false);
        if (this.getSlayer() != null) {
            armorStand.setCustomNameVisible(true);
        }
        if (this.MinVersion19) {
            armorStand.setCollidable(true);
        }
    }

    private void setArmorStandNameETC(ArmorStand armorStand, Location as_loc) {
        Material[] matList = this.getArmorMat();
        EntityEquipment Equip = armorStand.getEquipment();
        if (this.MinVersion19) {
            Equip.setHelmet(this.getPlayerHead());
            Equip.setBoots(new ItemStack(matList[0]));
            Equip.setChestplate(new ItemStack(matList[1]));
            Equip.setLeggings(new ItemStack(matList[2]));
            Equip.setItemInMainHand(new ItemStack(matList[3]));
            Equip.setItemInOffHand(this.getDragonSkull());
        } else {
            armorStand.setHelmet(this.getPlayerHead());
            armorStand.setBoots(new ItemStack(matList[0]));
            armorStand.setChestplate(new ItemStack(matList[1]));
            armorStand.setLeggings(new ItemStack(matList[2]));
            Equip.setItemInHand(new ItemStack(matList[3]));
        }
        ArmorStand armorStand2 = (ArmorStand)as_loc.getWorld().spawnEntity(as_loc, EntityType.ARMOR_STAND);
        armorStand2.setGravity(false);
        armorStand2.setMarker(false);
        String playername = this.configManager.getSlayerPAPIFormatNickString();
        if (playername != null) {
            armorStand2.setCustomName(playername);
        } else {
            armorStand2.setCustomName(this.getName());
        }
        armorStand2.setCustomNameVisible(true);
        armorStand2.setBasePlate(false);
        armorStand2.setCanPickupItems(false);
        if (this.MinVersion19) {
            armorStand2.setInvulnerable(true);
        }
        armorStand2.setVisible(false);
        if (this.MinVersion19) {
            armorStand2.setCollidable(false);
        }
        if (DragonSlayer.getSubVersion() >= 12) {
            armorStand.addPassenger((Entity)armorStand2);
        } else {
            armorStand.setPassenger((Entity)armorStand2);
        }
        this.setArmorstandMeta(armorStand2);
    }

    private ItemStack getDragonSkull() {
        ItemStack DragonSkull = null;
        try {
            Material SkullItem = Material.valueOf((String)"SKULL_ITEM");
            if (SkullItem != null) {
                DragonSkull = new ItemStack(SkullItem, 1, (short)SkullType.DRAGON.ordinal());
            }
        }
        catch (Exception ex) {
            DragonSkull = new ItemStack(Material.DRAGON_HEAD);
        }
        return DragonSkull;
    }

    Material[] getArmorMat() {
        Material[] matList = new Material[5];
        String baseMat = this.getConfig().getString("global.armorstand_material", "DIAMOND").toUpperCase();
        baseMat = Material.getMaterial((String)(String.valueOf(baseMat) + "_BOOTS")) != null ? baseMat : "DIAMOND";
        matList[0] = Material.getMaterial((String)(String.valueOf(baseMat) + "_BOOTS"));
        matList[1] = Material.getMaterial((String)(String.valueOf(baseMat) + "_CHESTPLATE"));
        matList[2] = Material.getMaterial((String)(String.valueOf(baseMat) + "_LEGGINGS"));
        matList[4] = Material.getMaterial((String)(String.valueOf(baseMat) + "_HELMET"));
        baseMat = Material.getMaterial((String)(String.valueOf(baseMat) + "_SWORD")) != null ? baseMat : "DIAMOND";
        matList[3] = Material.getMaterial((String)(String.valueOf(baseMat) + "_SWORD"));
        return matList;
    }

    private void setArmorstandMeta(ArmorStand armorstand) {
        FixedMetadataValue MdV_Armorstand = new FixedMetadataValue((Plugin)this, (Object)true);
        armorstand.setMetadata("DSL-AS", (MetadataValue)MdV_Armorstand);
    }

    private void setNPCStatueMeta(Entity statue, String uuid) {
        FixedMetadataValue mdV_Staue = new FixedMetadataValue((Plugin)this, (Object)uuid);
        statue.setMetadata("DSL-AS", (MetadataValue)mdV_Staue);
    }

    private String getNPCStatueMeta(Entity statue) {
        List list;
        String uuid = "";
        if (statue.hasMetadata("DSL-AS") && (list = statue.getMetadata("DSL-AS")) != null && list.size() != 0) {
            try {
                uuid = (String)((MetadataValue)list.get(0)).value();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return uuid;
    }

    int getStatueVersion() {
        int i = Integer.parseInt(this.getConfig().getString("global.statue_version", "1"));
        return i < 1 || i > 2 ? 1 : i;
    }

    World getArmorstandWorld() {
        Location theArmorStandLoc = this.armorStandLoc(false);
        return theArmorStandLoc != null ? theArmorStandLoc.getWorld() : null;
    }

    private ItemStack getPlayerHead() {
        String offlineslayer = this.getSlayer();
        ItemStack skull = null;
        try {
            Material SkullItem = Material.valueOf((String)"SKULL_ITEM");
            if (SkullItem != null) {
                skull = new ItemStack(SkullItem, 1, (short)SkullType.PLAYER.ordinal());
            }
        }
        catch (Exception ex) {
            skull = new ItemStack(Material.PLAYER_HEAD, 1);
        }
        SkullMeta HeadMetadata = (SkullMeta)skull.getItemMeta();
        if (this.getSlayer() != null) {
            if (DragonSlayer.getSubVersion() >= 12) {
                HeadMetadata.setOwningPlayer(this.getOfflineSlayer());
            } else {
                HeadMetadata.setOwner(offlineslayer);
            }
            HeadMetadata.setDisplayName(offlineslayer);
        }
        skull.setItemMeta((ItemMeta)HeadMetadata);
        return skull;
    }

    private void setHeadDirection(ArmorStand armorStand, float yaw, double pitch) {
        double xint = Math.toRadians(pitch);
        double zint = 0.0;
        double yint = Math.toRadians(yaw);
        EulerAngle eangle = new EulerAngle(xint, yint, zint);
        armorStand.setHeadPose(eangle);
    }

    boolean RemoveArmorStand() {
        Location as_loc = this.armorStandLoc(true);
        if (as_loc != null) {
            World w = as_loc.getWorld();
            double as_x = as_loc.getX();
            double as_z = as_loc.getZ();
            double as_y = as_loc.getY();
            Chunk MyChunk = w.getChunkAt(as_loc);
            if (!MyChunk.isLoaded()) {
                MyChunk.load();
            }
            Entity[] as_list1 = MyChunk.getEntities();
            Collection as_list2 = w.getEntitiesByClass(ArmorStand.class);
            List as_list3 = w.getEntities();
            ArrayList<Entity> as_list4 = new ArrayList<Entity>();
            Entity[] entityArray = as_list1;
            int n = as_list1.length;
            int n2 = 0;
            while (n2 < n) {
                Entity ent = entityArray[n2];
                if (ent instanceof ArmorStand && !as_list4.contains(ent)) {
                    as_list4.add(ent);
                }
                ++n2;
            }
            for (Entity ent : as_list2) {
                if (as_list4.contains(ent)) continue;
                as_list4.add(ent);
            }
            for (Entity ent : as_list3) {
                if (!(ent instanceof ArmorStand) || as_list4.contains(ent)) continue;
                as_list4.add(ent);
            }
            boolean done = false;
            for (Entity armorstand : as_list4) {
                Location checkLoc = armorstand.getLocation();
                double check_x = checkLoc.getX();
                double check_z = checkLoc.getZ();
                double check_y = checkLoc.getY();
                if (!armorstand.hasMetadata("DSL-AS") && (!(Math.abs(check_x - as_x) <= 1.0) || !(Math.abs(check_z - as_z) <= 1.0) || !(Math.abs(check_y - as_y) <= 2.5))) continue;
                armorstand.remove();
                done = true;
            }
            return done;
        }
        return false;
    }

    Location armorStandLoc(boolean simple) {
        if (this.getConfig().getString("armorstand.world") != null) {
            String w = this.getConfig().getString("armorstand.world");
            double x = this.getConfig().getDouble("armorstand.x");
            double y = this.getConfig().getDouble("armorstand.y");
            double z = this.getConfig().getDouble("armorstand.z");
            float yaw = (float)this.getConfig().getDouble("armorstand.yaw");
            World W = this.getDragonWorldFromString(w);
            Location as_loc = new Location(W, x, y, z);
            if (!simple) {
                as_loc.setYaw(yaw);
            }
            return as_loc;
        }
        return null;
    }

    private void resetArmorStand() {
        Location as_loc = this.armorStandLoc(false);
        if (as_loc != null) {
            World W = as_loc.getWorld();
            if (W != null) {
                Chunk MyChunk = W.getChunkAt(as_loc);
                if (!MyChunk.isLoaded()) {
                    MyChunk.load();
                }
                MyChunk.getEntities();
                int delay = 0;
                if (this.MinVersion117) {
                    delay = 10;
                }
                this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                    Entity[] List2 = MyChunk.getEntities();
                    int as_loc_y = as_loc.getBlockY();
                    as_loc.setY(0.0);
                    int amount = 0;
                    Entity[] entityArray = List2;
                    int n = List2.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Entity armorstand = entityArray[n2];
                        if (armorstand instanceof ArmorStand) {
                            Location armstloc = armorstand.getLocation();
                            int armorstand_y = armstloc.getBlockY();
                            armstloc.setY(0.0);
                            if (armstloc.equals((Object)as_loc) && armorstand_y - as_loc_y <= 1 && armorstand_y - as_loc_y >= 0) {
                                if (!armorstand.hasMetadata("DSL-AS")) {
                                    this.setArmorstandMeta((ArmorStand)armorstand);
                                }
                                ++amount;
                            }
                        }
                        ++n2;
                    }
                    if (amount > 1 && this.getStatueVersion() == 1) {
                        return;
                    }
                    if (amount == 0 || amount <= 1 && this.getStatueVersion() == 1 || this.getStatueVersion() >= 2 && this.NPCStatue == null) {
                        if (this.configManager.getVerbosity()) {
                            this.logger.info("Found that the Statue is not where it should be, resetting it!");
                        }
                        this.replaceArmorStand();
                    }
                }, (long)delay);
            } else {
                this.logger.warning("Could not find the world for resetting the ArmorStand! Is your config/setup OK?");
            }
        }
    }

    void replaceArmorStand() {
        Location theArmorStandLoc = this.armorStandLoc(false);
        if (theArmorStandLoc != null) {
            try {
                theArmorStandLoc.getChunk().load();
                theArmorStandLoc.getChunk().getEntities();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                if (!this.RemoveArmorStand() && this.configManager.getVerbosity()) {
                    this.logger.info("No armorstand found to remove...");
                }
                this.PlaceArmorStand(theArmorStandLoc.getWorld().getName(), theArmorStandLoc.getX(), theArmorStandLoc.getY(), theArmorStandLoc.getZ(), theArmorStandLoc.getYaw());
            }, 10L);
        }
    }

    private Object setNPC_Stand(World world, double x, double y, double z, float yaw) {
        block25: {
            Object nmsWorld = this.getWorldServer(world);
            Object nmsServer = this.getMinecraftServer(world);
            GameProfile gameProfile = new GameProfile(UUID.randomUUID(), "");
            Scoreboard _NPC_scoreboard = this.getServer().getScoreboardManager().getMainScoreboard();
            this.team_NPC = _NPC_scoreboard.getTeam("DSL-NPCs");
            if (this.team_NPC == null) {
                this.team_NPC = _NPC_scoreboard.registerNewTeam("DSL-NPCs");
            }
            if (this.MinVersion19) {
                this.team_NPC.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
            } else {
                this.team_NPC.setNameTagVisibility(NameTagVisibility.NEVER);
            }
            if (!this.team_NPC.hasEntry(gameProfile.getName())) {
                for (String ent : this.team_NPC.getEntries()) {
                    this.team_NPC.removeEntry(ent);
                }
                this.team_NPC.addEntry(gameProfile.getName());
            }
            if (NPCtexture != null && NPCtexture[0] != null && NPCtexture[1] != null) {
                this.headHelmet = false;
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", NPCtexture[0], NPCtexture[1]));
            } else {
                this.headHelmet = true;
            }
            Boolean pim = null;
            try {
                Entity ent_;
                if (!this.MinVersion117) {
                    if (this.pim_const == null) {
                        this.pim_const = DragonSlayer.getSubVersion() >= 14 ? Class.forName("net.minecraft.server." + DragonSlayer.getVersion() + ".PlayerInteractManager").getConstructor(nmsWorld.getClass()) : Class.forName("net.minecraft.server." + DragonSlayer.getVersion() + ".PlayerInteractManager").getConstructor(Class.forName("net.minecraft.server." + DragonSlayer.getVersion() + ".World"));
                    }
                    pim = this.pim_const.newInstance(nmsWorld);
                    if (this.ENT_Class == null) {
                        this.ENT_Class = Class.forName("net.minecraft.server." + DragonSlayer.getVersion() + ".Entity");
                    }
                } else {
                    pim = true;
                    if (this.ENT_Class == null) {
                        this.ENT_Class = Class.forName("net.minecraft.world.entity.Entity");
                    }
                }
                if (pim == null) break block25;
                if (!this.MinVersion117) {
                    if (this.entp_const == null) {
                        this.entp_const = Class.forName("net.minecraft.server." + DragonSlayer.getVersion() + ".EntityPlayer").getConstructor(Class.forName("net.minecraft.server." + DragonSlayer.getVersion() + ".MinecraftServer"), nmsWorld.getClass(), gameProfile.getClass(), pim.getClass());
                    }
                    this.NPCStatue = this.entp_const.newInstance(nmsServer, nmsWorld, gameProfile, pim);
                    if (this.NPCStatue != null) {
                        this.ENT_Class.getDeclaredMethod("setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE).invoke(this.NPCStatue, x, y, z, Float.valueOf(yaw), -10);
                    }
                } else {
                    if (this.entp_const == null) {
                        if (DragonSlayer.getSubVersion() < 19) {
                            this.entp_const = Class.forName("net.minecraft.server.level.EntityPlayer").getConstructor(Class.forName("net.minecraft.server.MinecraftServer"), nmsWorld.getClass(), gameProfile.getClass());
                            this.NPCStatue = this.entp_const.newInstance(nmsServer, nmsWorld, gameProfile);
                        } else {
                            this.entp_const = Class.forName("net.minecraft.server.level.EntityPlayer").getConstructor(Class.forName("net.minecraft.server.MinecraftServer"), nmsWorld.getClass(), gameProfile.getClass(), Class.forName("net.minecraft.world.entity.player.ProfilePublicKey"));
                            this.NPCStatue = this.entp_const.newInstance(nmsServer, nmsWorld, gameProfile, null);
                        }
                    }
                    if (this.NPCStatue != null) {
                        try {
                            ((EntityPlayer)this.NPCStatue).forceSetPositionRotation(x, y, z, yaw, -10.0f);
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                }
                if ((ent_ = this.getBukkitEntity(this.NPCStatue)) != null) {
                    ent_.setCustomName(this.configManager.getSlayerPAPIFormatNickString());
                    ent_.setCustomNameVisible(true);
                    this.setNPCStatueMeta(ent_, this.getSlayerUUIDString());
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                if (!this.configManager.debugOn()) break block25;
                e.printStackTrace();
            }
        }
        return this.NPCStatue;
    }

    Object[] createNPCStatuePackets(Object NPCStatue) {
        Object[] packets;
        block33: {
            block34: {
                packets = new Object[12];
                if (NPCStatue == null) break block33;
                if (this.showNPCPackets != null) break block34;
                try {
                    float yaw_2;
                    int NPCStatue_id;
                    Entity ent_;
                    block36: {
                        block35: {
                            ent_ = this.getBukkitEntity(NPCStatue);
                            NPCStatue_id = ent_.getEntityId();
                            PacketContainer addPlayerPacket = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_INFO);
                            addPlayerPacket.getPlayerInfoAction().writeSafely(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
                            WrappedGameProfile wrappedGameprofile = WrappedGameProfile.fromPlayer((Player)((Player)ent_));
                            GameMode gM = ((Player)ent_).getGameMode() != null ? ((Player)ent_).getGameMode() : GameMode.SURVIVAL;
                            PlayerInfoData playerInfoData = new PlayerInfoData(wrappedGameprofile, 0, EnumWrappers.NativeGameMode.fromBukkit((GameMode)gM), WrappedChatComponent.fromText((String)ent_.getCustomName()));
                            addPlayerPacket.getPlayerInfoDataLists().write(0, Collections.singletonList(playerInfoData));
                            packets[0] = addPlayerPacket;
                            if (this.MinVersion117) break block35;
                            yaw_2 = ((Float)this.ENT_Class.getDeclaredField("yaw").get(NPCStatue)).floatValue();
                            break block36;
                        }
                        String yawMethodeName = "getYRot";
                        switch (DragonSlayer.getVersion(true)) {
                            case "v1_19_R1-2": {
                                yawMethodeName = "dq";
                                break;
                            }
                            case "v1_19_R1": {
                                yawMethodeName = "dr";
                                break;
                            }
                            case "v1_18_R2": {
                                yawMethodeName = "dn";
                                break;
                            }
                            case "v1_18_R1": {
                                yawMethodeName = "dm";
                            }
                        }
                        yaw_2 = ((Float)this.ENT_Class.getDeclaredMethod(yawMethodeName, new Class[0]).invoke(NPCStatue, new Object[0])).floatValue();
                    }
                    byte ent_rot_1 = (byte)(yaw_2 * 256.0f / 360.0f);
                    byte ent_rot_2 = (byte)(ent_.getLocation().getPitch() * 256.0f / 360.0f);
                    PacketContainer spawnPacket = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.NAMED_ENTITY_SPAWN);
                    spawnPacket.getIntegers().write(0, (Object)NPCStatue_id);
                    spawnPacket.getUUIDs().write(0, (Object)ent_.getUniqueId());
                    if (this.MinVersion19) {
                        spawnPacket.getDoubles().write(0, (Object)ent_.getLocation().getX()).write(1, (Object)ent_.getLocation().getY()).write(2, (Object)ent_.getLocation().getZ());
                    } else {
                        spawnPacket.getIntegers().write(1, (Object)((int)(ent_.getLocation().getX() * 32.0))).write(2, (Object)((int)(ent_.getLocation().getY() * 32.0))).write(3, (Object)((int)(ent_.getLocation().getZ() * 32.0)));
                    }
                    spawnPacket.getBytes().write(0, (Object)ent_rot_1).write(1, (Object)ent_rot_2);
                    spawnPacket.getDataWatcherModifier().writeSafely(0, (Object)WrappedDataWatcher.getEntityWatcher((Entity)((Player)ent_)));
                    packets[1] = spawnPacket;
                    PacketContainer headRotationPacket = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_HEAD_ROTATION);
                    headRotationPacket.getIntegers().write(0, (Object)NPCStatue_id);
                    headRotationPacket.getBytes().write(0, (Object)ent_rot_1);
                    packets[3] = headRotationPacket;
                    Material[] matList = this.getArmorMat();
                    if (this.MinVersion19) {
                        if (DragonSlayer.getSubVersion() < 16) {
                            PacketContainer equipmentPacket = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_EQUIPMENT);
                            equipmentPacket.getIntegers().write(0, (Object)NPCStatue_id);
                            equipmentPacket.getItemSlots().write(0, (Object)EnumWrappers.ItemSlot.FEET);
                            equipmentPacket.getItemModifier().write(0, (Object)new ItemStack(matList[0]));
                            packets[6] = equipmentPacket;
                            PacketContainer equipmentPacket2 = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_EQUIPMENT);
                            equipmentPacket2.getIntegers().write(0, (Object)NPCStatue_id);
                            equipmentPacket2.getItemSlots().write(0, (Object)EnumWrappers.ItemSlot.LEGS);
                            equipmentPacket2.getItemModifier().write(0, (Object)new ItemStack(matList[2]));
                            packets[7] = equipmentPacket2;
                            PacketContainer equipmentPacket3 = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_EQUIPMENT);
                            equipmentPacket3.getIntegers().write(0, (Object)NPCStatue_id);
                            equipmentPacket3.getItemSlots().write(0, (Object)EnumWrappers.ItemSlot.CHEST);
                            equipmentPacket3.getItemModifier().write(0, (Object)new ItemStack(matList[1]));
                            packets[8] = equipmentPacket3;
                            PacketContainer equipmentPacket4 = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_EQUIPMENT);
                            equipmentPacket4.getIntegers().write(0, (Object)NPCStatue_id);
                            equipmentPacket4.getItemSlots().write(0, (Object)EnumWrappers.ItemSlot.HEAD);
                            if (this.headHelmet) {
                                equipmentPacket4.getItemModifier().write(0, (Object)this.getPlayerHead());
                            } else {
                                equipmentPacket4.getItemModifier().write(0, (Object)new ItemStack(matList[4]));
                            }
                            packets[9] = equipmentPacket4;
                            PacketContainer equipmentPacket5 = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_EQUIPMENT);
                            equipmentPacket5.getIntegers().write(0, (Object)NPCStatue_id);
                            equipmentPacket5.getItemSlots().write(0, (Object)EnumWrappers.ItemSlot.MAINHAND);
                            equipmentPacket5.getItemModifier().write(0, (Object)new ItemStack(matList[3]));
                            packets[10] = equipmentPacket5;
                            if (this.getDragonSkull() != null) {
                                PacketContainer equipmentPacket6 = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_EQUIPMENT);
                                equipmentPacket6.getIntegers().write(0, (Object)NPCStatue_id);
                                equipmentPacket6.getItemSlots().write(0, (Object)EnumWrappers.ItemSlot.OFFHAND);
                                equipmentPacket6.getItemModifier().write(0, (Object)this.getDragonSkull());
                                packets[11] = equipmentPacket6;
                            }
                        } else {
                            ArrayList<Pair> equipItems = new ArrayList<Pair>();
                            equipItems.add(new Pair((Object)EnumWrappers.ItemSlot.FEET, (Object)new ItemStack(matList[0])));
                            equipItems.add(new Pair((Object)EnumWrappers.ItemSlot.LEGS, (Object)new ItemStack(matList[2])));
                            equipItems.add(new Pair((Object)EnumWrappers.ItemSlot.CHEST, (Object)new ItemStack(matList[1])));
                            if (this.headHelmet) {
                                equipItems.add(new Pair((Object)EnumWrappers.ItemSlot.HEAD, (Object)this.getPlayerHead()));
                            } else {
                                equipItems.add(new Pair((Object)EnumWrappers.ItemSlot.HEAD, (Object)new ItemStack(matList[4])));
                            }
                            equipItems.add(new Pair((Object)EnumWrappers.ItemSlot.MAINHAND, (Object)new ItemStack(matList[3])));
                            if (this.getDragonSkull() != null) {
                                equipItems.add(new Pair((Object)EnumWrappers.ItemSlot.OFFHAND, (Object)this.getDragonSkull()));
                            }
                            PacketContainer equipmentPacket = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_EQUIPMENT);
                            equipmentPacket.getModifier().writeDefaults();
                            equipmentPacket.getIntegers().write(0, (Object)NPCStatue_id);
                            equipmentPacket.getSlotStackPairLists().write(0, equipItems);
                            packets[6] = equipmentPacket;
                        }
                    } else {
                        PacketContainer equipmentPacket = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_EQUIPMENT);
                        equipmentPacket.getIntegers().write(0, (Object)NPCStatue_id).write(1, (Object)1);
                        equipmentPacket.getItemModifier().write(0, (Object)new ItemStack(matList[0]));
                        packets[6] = equipmentPacket;
                        PacketContainer equipmentPacket2 = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_EQUIPMENT);
                        equipmentPacket2.getIntegers().write(0, (Object)NPCStatue_id).write(1, (Object)2);
                        equipmentPacket2.getItemModifier().write(0, (Object)new ItemStack(matList[2]));
                        packets[7] = equipmentPacket2;
                        PacketContainer equipmentPacket3 = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_EQUIPMENT);
                        equipmentPacket3.getIntegers().write(0, (Object)NPCStatue_id).write(1, (Object)3);
                        equipmentPacket3.getItemModifier().write(0, (Object)new ItemStack(matList[1]));
                        packets[8] = equipmentPacket3;
                        PacketContainer equipmentPacket4 = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_EQUIPMENT);
                        equipmentPacket4.getIntegers().write(0, (Object)NPCStatue_id).write(1, (Object)4);
                        if (this.headHelmet) {
                            equipmentPacket4.getItemModifier().write(0, (Object)this.getPlayerHead());
                        } else {
                            equipmentPacket4.getItemModifier().write(0, (Object)new ItemStack(matList[4]));
                        }
                        packets[9] = equipmentPacket4;
                        PacketContainer equipmentPacket5 = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_EQUIPMENT);
                        equipmentPacket5.getIntegers().write(0, (Object)NPCStatue_id).write(1, (Object)0);
                        equipmentPacket5.getItemModifier().write(0, (Object)new ItemStack(matList[3]));
                        packets[10] = equipmentPacket5;
                    }
                    this.showNPCPackets = packets;
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException e) {
                    if (this.configManager.debugOn()) {
                        e.printStackTrace();
                    }
                    break block33;
                }
            }
            return this.showNPCPackets;
        }
        return packets;
    }

    Object[] createNPCStatuePackets_2(Object NPCStatue) {
        Object[] packets;
        block20: {
            block21: {
                packets = new Object[3];
                if (NPCStatue == null) break block20;
                if (this.showNPCPackets2 != null) break block21;
                try {
                    float yaw_2;
                    int NPCStatue_id;
                    Entity ent_;
                    block23: {
                        block22: {
                            ent_ = this.getBukkitEntity(NPCStatue);
                            NPCStatue_id = ent_.getEntityId();
                            if (this.MinVersion117) break block22;
                            yaw_2 = ((Float)this.ENT_Class.getDeclaredField("yaw").get(NPCStatue)).floatValue();
                            break block23;
                        }
                        String yawMethodeName = "getYRot";
                        switch (DragonSlayer.getVersion(true)) {
                            case "v1_19_R1-2": {
                                yawMethodeName = "dq";
                                break;
                            }
                            case "v1_19_R1": {
                                yawMethodeName = "dr";
                                break;
                            }
                            case "v1_18_R2": {
                                yawMethodeName = "dn";
                                break;
                            }
                            case "v1_18_R1": {
                                yawMethodeName = "dm";
                            }
                        }
                        yaw_2 = ((Float)this.ENT_Class.getDeclaredMethod(yawMethodeName, new Class[0]).invoke(NPCStatue, new Object[0])).floatValue();
                    }
                    byte ent_rot_1 = (byte)(yaw_2 * 256.0f / 360.0f);
                    byte ent_rot_2 = (byte)(ent_.getLocation().getPitch() * 256.0f / 360.0f);
                    PacketContainer headRotationPacket = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_HEAD_ROTATION);
                    headRotationPacket.getIntegers().write(0, (Object)NPCStatue_id);
                    headRotationPacket.getBytes().write(0, (Object)ent_rot_1);
                    packets[0] = headRotationPacket;
                    if (this.MinVersion19) {
                        PacketContainer lookPacket = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_LOOK);
                        lookPacket.getIntegers().write(0, (Object)NPCStatue_id);
                        lookPacket.getBytes().write(0, (Object)ent_rot_1).write(1, (Object)ent_rot_2);
                        lookPacket.getBooleans().write(0, (Object)true);
                        packets[1] = lookPacket;
                    }
                    PacketContainer animationPacket = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ANIMATION);
                    animationPacket.getIntegers().write(0, (Object)NPCStatue_id).write(1, (Object)0);
                    packets[2] = animationPacket;
                    this.showNPCPackets2 = packets;
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException e) {
                    if (this.configManager.debugOn()) {
                        e.printStackTrace();
                    }
                    break block20;
                }
            }
            return this.showNPCPackets2;
        }
        return packets;
    }

    private Object[] createNPCStatueDestroyPacket(Object NPCStatue) {
        Object[] packets;
        block13: {
            packets = new Object[1];
            if (NPCStatue != null) {
                try {
                    PacketContainer destroyEntityPacket;
                    block12: {
                        Entity ent_ = this.getBukkitEntity(NPCStatue);
                        int NPCStatue_id = ent_.getEntityId();
                        int[] idArray = new int[]{NPCStatue_id};
                        destroyEntityPacket = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_DESTROY);
                        if (!this.MinVersion117) {
                            destroyEntityPacket.getIntegers().writeSafely(0, (Object)idArray.length);
                            destroyEntityPacket.getIntegerArrays().write(0, (Object)idArray);
                        } else {
                            try {
                                Class<?> intArrayClass = null;
                                try {
                                    intArrayClass = Class.forName("it.unimi.dsi.fastutil.ints.IntArrayList");
                                }
                                catch (ClassNotFoundException | NoClassDefFoundError er) {
                                    intArrayClass = Class.forName("org.bukkit.craftbukkit.libs.it.unimi.dsi.fastutil.ints.IntArrayList");
                                }
                                if (intArrayClass != null) {
                                    Object newArrayList = intArrayClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                                    intArrayClass.getDeclaredMethod("add", Integer.TYPE).invoke(newArrayList, NPCStatue_id);
                                    if (newArrayList != null) {
                                        destroyEntityPacket.getIntegers().writeSafely(0, (Object)idArray.length);
                                        destroyEntityPacket.getModifier().write(0, newArrayList);
                                    }
                                }
                            }
                            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError | NoSuchMethodException | RuntimeException | InvocationTargetException ee) {
                                if (DragonSlayer.getSubVersion() == 17) {
                                    destroyEntityPacket.getIntegers().writeSafely(0, (Object)NPCStatue_id);
                                }
                                if (!this.configManager.debugOn()) break block12;
                                ee.printStackTrace();
                            }
                        }
                    }
                    packets[0] = destroyEntityPacket;
                }
                catch (IllegalArgumentException | NullPointerException | SecurityException e) {
                    if (!this.configManager.debugOn()) break block13;
                    e.printStackTrace();
                }
            }
        }
        return packets;
    }

    Object[] createNPCStatueRemovePacket(Object NPCStatue) {
        Object[] packets;
        block3: {
            packets = new Object[1];
            if (NPCStatue != null) {
                try {
                    Entity ent_ = this.getBukkitEntity(NPCStatue);
                    PacketContainer removePlayerPacket = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_INFO);
                    removePlayerPacket.getPlayerInfoAction().writeSafely(0, (Object)EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
                    WrappedGameProfile wrappedGameprofile = WrappedGameProfile.fromPlayer((Player)((Player)ent_));
                    GameMode gM = ((Player)ent_).getGameMode() != null ? ((Player)ent_).getGameMode() : GameMode.SURVIVAL;
                    PlayerInfoData playerInfoData = new PlayerInfoData(wrappedGameprofile, 0, EnumWrappers.NativeGameMode.fromBukkit((GameMode)gM), WrappedChatComponent.fromText((String)ent_.getCustomName()));
                    removePlayerPacket.getPlayerInfoDataLists().write(0, Collections.singletonList(playerInfoData));
                    packets[0] = removePlayerPacket;
                }
                catch (IllegalArgumentException | SecurityException e) {
                    if (!this.configManager.debugOn()) break block3;
                    e.printStackTrace();
                }
            }
        }
        return packets;
    }

    void sendNPCClientPacket(Player p) {
        ArrayList<Player> col = new ArrayList<Player>();
        col.add(p);
        this.sendNPCClientPackets(col);
    }

    private void sendNPCClientPackets(Collection<? extends Player> p) {
        Object[] packets = this.createNPCStatuePackets(this.NPCStatue);
        for (Player player : p) {
            this.sendNPCStatue_PL_PacketsToOnePlayer(player, packets);
        }
        this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
            Object[] packets2 = this.createNPCStatuePackets_2(this.NPCStatue);
            for (Player pl : p) {
                this.sendNPCStatue_PL_PacketsToOnePlayer(pl, packets2);
            }
            this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                Object[] packets3 = this.createNPCStatueRemovePacket(this.NPCStatue);
                for (Player pl : p) {
                    this.sendNPCStatue_PL_PacketsToOnePlayer(pl, packets3);
                }
            }, 2L);
        }, 5L);
    }

    private void sendNPCStatue_PL_PacketsToOnePlayer(Player player, Object[] packets) {
        if (player != null) {
            Object[] objectArray = packets;
            int n = packets.length;
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    Object packet = objectArray[n2];
                    if (packet != null && packet instanceof PacketContainer) {
                        try {
                            ProtocolLibrary.getProtocolManager().sendServerPacket(player, (PacketContainer)packet);
                        }
                        catch (InvocationTargetException e) {
                            if (!this.configManager.debugOn()) break block5;
                            e.printStackTrace();
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private void refreshTextureArray(Player player, boolean forceAPI) {
        String[] tex2;
        String[] tex1;
        if (player != null && (tex1 = this.getPlayerTexture(player))[0] != null) {
            NPCtexture = tex1;
            this.saveTextureToConfig(tex1);
            return;
        }
        if (!forceAPI && (tex2 = this.getTextureFromConfig())[0] != null) {
            NPCtexture = tex2;
            return;
        }
        String[] tex3 = this.getApiTexture();
        if (tex3[0] != null) {
            NPCtexture = tex3;
            return;
        }
    }

    private String[] getPlayerTexture(Player player) {
        String[] texture_and_sig;
        block20: {
            texture_and_sig = new String[2];
            Object entityPlayer = this.getEntityPlayer(player);
            try {
                GameProfile profile;
                Collection property_col;
                String getProfile_name;
                block21: {
                    getProfile_name = "getProfile";
                    if (!this.MinVersion117) break block21;
                    switch (DragonSlayer.getVersion(true)) {
                        case "v1_19_R1-2": {
                            getProfile_name = "fy";
                            break;
                        }
                        case "v1_19_R1": {
                            getProfile_name = "fz";
                            break;
                        }
                        case "v1_18_R2": {
                            getProfile_name = "fq";
                            break;
                        }
                        case "v1_18_R1": {
                            getProfile_name = "fp";
                        }
                    }
                }
                if (this.enth_getProfile == null) {
                    Method method = this.enth_getProfile = !this.MinVersion117 ? Class.forName("net.minecraft.server." + DragonSlayer.getVersion() + ".EntityHuman").getDeclaredMethod(getProfile_name, new Class[0]) : Class.forName("net.minecraft.world.entity.player.EntityHuman").getDeclaredMethod(getProfile_name, new Class[0]);
                }
                if ((property_col = (profile = (GameProfile)this.enth_getProfile.invoke(entityPlayer, new Object[0])).getProperties().get((Object)"textures")) != null && !property_col.isEmpty()) {
                    Property property = (Property)property_col.iterator().next();
                    String texture = property.getValue();
                    String sig = property.getSignature();
                    texture_and_sig[0] = texture;
                    texture_and_sig[1] = sig;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                if (!this.configManager.debugOn()) break block20;
                e.printStackTrace();
            }
        }
        return texture_and_sig;
    }

    private String[] getApiTexture() {
        String[] texture_and_sig;
        block6: {
            texture_and_sig = new String[2];
            UUID uuid = this.getSlayerUUID();
            if (uuid != null) {
                try {
                    JsonElement textureProperty_;
                    URL url_1 = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false");
                    InputStreamReader reader_1 = new InputStreamReader(url_1.openStream());
                    try {
                        textureProperty_ = JsonParser.parseReader((Reader)reader_1);
                    }
                    catch (NoSuchMethodError e) {
                        textureProperty_ = new JsonParser().parse((Reader)reader_1);
                    }
                    if (textureProperty_ != null && textureProperty_.isJsonObject()) {
                        JsonObject textureProperty = textureProperty_.getAsJsonObject().get("properties").getAsJsonArray().get(0).getAsJsonObject();
                        String texture = textureProperty.get("value").getAsString();
                        String sig = textureProperty.get("signature").getAsString();
                        texture_and_sig[0] = texture;
                        texture_and_sig[1] = sig;
                    }
                }
                catch (IOException e) {
                    if (!this.configManager.debugOn()) break block6;
                    e.printStackTrace();
                }
            }
        }
        return texture_and_sig;
    }

    private void saveTextureToConfig(String[] texture_and_sig) {
        if (texture_and_sig != null && texture_and_sig[0] != null && texture_and_sig[1] != null) {
            String summ = Base64Coder.encodeString((String)(String.valueOf(texture_and_sig[0]) + "_SIG_" + texture_and_sig[1]));
            this.getConfig().set("armorstand.texture", (Object)summ);
            this.saveConfig();
        }
    }

    private String[] getTextureFromConfig() {
        String[] texture_and_sig = new String[2];
        String texture = this.getConfig().getString("armorstand.texture");
        if (texture != null) {
            String tex_uuid = null;
            String dec_tex = null;
            String dec_sig = null;
            try {
                texture = Base64Coder.decodeString((String)texture);
                int si = texture.indexOf("_SIG_");
                dec_tex = texture.substring(0, si);
                dec_sig = texture.substring(si + 5, texture.length());
                String dec = Base64Coder.decodeString((String)dec_tex);
                try {
                    tex_uuid = JsonParser.parseString((String)dec).getAsJsonObject().get("profileId").getAsString();
                }
                catch (NoSuchMethodError e) {
                    tex_uuid = new JsonParser().parse(dec).getAsJsonObject().get("profileId").getAsString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tex_uuid != null && tex_uuid.equalsIgnoreCase(this.getSlayerUUIDString().replaceAll("-", ""))) {
                texture_and_sig[0] = dec_tex;
                texture_and_sig[1] = dec_sig;
            } else {
                this.getConfig().set("armorstand.texture", null);
                this.saveConfig();
            }
        }
        return texture_and_sig;
    }

    private void removeNPCStatue() {
        block4: {
            if (this.NPCStatue != null) {
                try {
                    Object[] packets = this.createNPCStatueDestroyPacket(this.NPCStatue);
                    for (Player pl : this.getServer().getOnlinePlayers()) {
                        this.sendNPCStatue_PL_PacketsToOnePlayer(pl, packets);
                    }
                }
                catch (IllegalArgumentException | SecurityException e) {
                    if (!this.configManager.debugOn()) break block4;
                    e.printStackTrace();
                }
            }
        }
    }

    private void replaceNPCStatue() {
        block6: {
            if (this.NPCStatue != null) {
                try {
                    Entity ent_ = this.getBukkitEntity(this.NPCStatue);
                    if (ent_ != null) {
                        String oldUUID = this.getNPCStatueMeta(ent_);
                        if (!oldUUID.equals(this.getSlayerUUIDString())) {
                            NPCtexture = null;
                            this.refreshTextureArray(null, true);
                        }
                        this.showNPCPackets = null;
                        this.showNPCPackets2 = null;
                    }
                }
                catch (IllegalArgumentException | SecurityException e) {
                    if (!this.configManager.debugOn()) break block6;
                    e.printStackTrace();
                }
            }
        }
        this.removeNPCStatue();
        Location theArmorStandLoc = this.armorStandLoc(false);
        if (theArmorStandLoc != null) {
            this.setNPC_Stand(this.getDragonWorldFromString(theArmorStandLoc.getWorld().getName()), theArmorStandLoc.getX(), theArmorStandLoc.getY(), theArmorStandLoc.getZ(), theArmorStandLoc.getYaw());
            Collection p = this.getServer().getOnlinePlayers();
            this.sendNPCClientPackets(p);
        }
    }

    Object getEntityPlayer(Player player) {
        Object returnwert;
        block4: {
            returnwert = null;
            try {
                if (this.CraftPlayerClass == null) {
                    this.CraftPlayerClass = Class.forName("org.bukkit.craftbukkit." + DragonSlayer.getVersion() + ".entity.CraftPlayer");
                }
                if (this.CraftPlayerClass.isInstance(player)) {
                    Object craftPlayer = this.CraftPlayerClass.cast(player);
                    returnwert = this.CraftPlayerClass.getDeclaredMethod("getHandle", new Class[0]).invoke(craftPlayer, new Object[0]);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException e) {
                this.logger.warning("Unknown or unsupported Version :" + DragonSlayer.getVersion() + ", can't handle EntityPlayer...?");
                if (!this.configManager.debugOn()) break block4;
                e.printStackTrace();
            }
        }
        return returnwert;
    }

    private Entity getBukkitEntity(Object NPCStatue) {
        Entity ent_;
        block5: {
            ent_ = null;
            try {
                String getBukkitEntity_name = "getBukkitEntity";
                switch (DragonSlayer.getSubVersion()) {
                    case 18: 
                    case 19: {
                        getBukkitEntity_name = "getBukkitEntity";
                    }
                }
                ent_ = (Entity)this.ENT_Class.getDeclaredMethod(getBukkitEntity_name, new Class[0]).invoke(NPCStatue, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                if (!this.configManager.debugOn()) break block5;
                e.printStackTrace();
            }
        }
        return ent_;
    }

    private void checkUpdate() {
        HttpURLConnection con2;
        this.logger.info("Checking for updates...");
        String Resource = "36250";
        String NewSpigetULR = "http://api.spiget.org/v2/resources/" + Resource + "/versions/latest";
        String NewSpigotURL = "https://api.spigotmc.org/legacy/update.php?resource=" + Resource;
        String version = null;
        try {
            con2 = (HttpsURLConnection)new URL(NewSpigotURL).openConnection();
            con2.setConnectTimeout(1500);
            con2.setReadTimeout(1500);
            con2.setRequestMethod("GET");
            version = new BufferedReader(new InputStreamReader(con2.getInputStream())).readLine().replaceAll("[a-zA-Z_ ]", "");
        }
        catch (Exception con2) {
            // empty catch block
        }
        if (version == null) {
            try {
                con2 = (HttpURLConnection)new URL(NewSpigetULR).openConnection();
                JsonObject jsonObject = new JsonParser().parse((Reader)new InputStreamReader(con2.getInputStream())).getAsJsonObject();
                version = jsonObject.get("name").getAsString();
            }
            catch (Exception con3) {
                // empty catch block
            }
        }
        if (version == null) {
            this.logger.warning("Failed to connect for updatecheck to spigotmc.org and spiget.org");
            return;
        }
        String localVersion = this.getDescription().getVersion();
        if (localVersion.contains("_")) {
            localVersion = localVersion.substring(0, localVersion.indexOf("_"));
        }
        if (!version.equalsIgnoreCase(localVersion)) {
            int localVersion2;
            String split;
            int i = version.trim().replaceAll("[0-9]", "").length();
            while (i < localVersion.trim().replaceAll("[0-9]", "").length()) {
                version = String.valueOf(version) + ".0";
                ++i;
            }
            i = localVersion.trim().replaceAll("[0-9]", "").length();
            while (i < version.trim().replaceAll("[0-9]", "").length()) {
                localVersion = String.valueOf(localVersion) + ".0";
                ++i;
            }
            String vers2 = "";
            String locVers2 = "";
            String[] stringArray = version.split("\\.");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                split = stringArray[n2];
                vers2 = String.valueOf(vers2) + (split.length() == 2 ? split : "0" + split);
                ++n2;
            }
            stringArray = localVersion.split("[.]");
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                split = stringArray[n2];
                locVers2 = String.valueOf(locVers2) + (split.length() == 2 ? split : "0" + split);
                ++n2;
            }
            int version2 = Integer.parseInt(vers2);
            if (version2 > (localVersion2 = Integer.parseInt(locVers2))) {
                this.getServer().getConsoleSender().sendMessage("[" + this.getName() + "]" + ChatColor.GREEN + " A new update is available: version " + ChatColor.RED + version);
            } else if (localVersion2 > version2) {
                this.getServer().getConsoleSender().sendMessage("[" + this.getName() + "]" + ChatColor.RED + " Your version " + localVersion + " is newer than online version (" + ChatColor.GREEN + version + ChatColor.RED + ") ??");
            } else {
                this.logger.info("You're running the latest plugin version !");
            }
        } else {
            this.logger.info("You're running the latest plugin version!");
        }
    }

    private void StartRepeatingTimer() {
        if (!this.MinVersion19) {
            return;
        }
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
            if (DragonSlayer.getSubVersion() >= 13 && !this.MinVersion117) {
                this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> this.checkGWReverse(15));
            } else {
                this.checkGWReverse(15);
            }
        }, 15L, 3L);
    }

    private void checkGWReverse(int distance) {
        boolean bypassON = Boolean.parseBoolean(this.getConfig().getString("global.bypassdragongateway"));
        int bypassFunc = Integer.parseInt(this.getConfig().getString("global.bypassfunc", "1"));
        int n = bypassFunc = bypassFunc < 1 || bypassFunc > 2 ? 1 : bypassFunc;
        if (bypassON) {
            for (String mapname : this.configManager.getMaplist()) {
                World thisWorld = this.getDragonWorldFromString(mapname);
                if (thisWorld == null) continue;
                Collection dragons = null;
                try {
                    dragons = thisWorld.getEntitiesByClass(EnderDragon.class);
                }
                catch (ArrayIndexOutOfBoundsException | ConcurrentModificationException runtimeException) {
                    // empty catch block
                }
                if (dragons == null) continue;
                for (EnderDragon dragon : dragons) {
                    Location dragLoc = dragon.getLocation();
                    Block foundGateway = this.CheckGatewaysForDragon(thisWorld, dragLoc, distance);
                    if (foundGateway == null) continue;
                    if (bypassFunc == 1) {
                        double dragY = dragLoc.getY();
                        double gateY = foundGateway.getY();
                        double diffY = gateY - dragY;
                        diffY = diffY < 0.0 ? diffY - (double)distance * 1.2 : diffY + (double)distance * 1.2;
                        Location target = dragLoc.clone().add(0.0, diffY, 0.0);
                        this.syncTP(dragon, target);
                        continue;
                    }
                    if (bypassFunc != 2) continue;
                    this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                        block27: {
                            if (foundGateway.getType() != Material.END_GATEWAY) break block27;
                            try {
                                Object nbt_1;
                                Object blockPos;
                                Object worldServer;
                                block31: {
                                    Object tileEnt;
                                    block28: {
                                        block29: {
                                            worldServer = this.getWorldServer(thisWorld);
                                            blockPos = this.makeBlockPositionObject(foundGateway.getX(), foundGateway.getY(), foundGateway.getZ());
                                            tileEnt = null;
                                            if (this.getTileEntity == null) {
                                                String funcName = "getTileEntity";
                                                if (DragonSlayer.getSubVersion() > 17) {
                                                    funcName = "getBlockEntity";
                                                }
                                                try {
                                                    this.getTileEntity = Class.forName("net.minecraft.world.level.World").getDeclaredMethod(funcName, blockPos.getClass(), Boolean.TYPE);
                                                }
                                                catch (ClassNotFoundException | NoSuchMethodException nm) {
                                                    try {
                                                        this.getTileEntity = Class.forName("net.minecraft.server." + DragonSlayer.getVersion() + ".World").getDeclaredMethod("getTileEntity", blockPos.getClass(), Boolean.TYPE);
                                                    }
                                                    catch (ClassNotFoundException | NoSuchMethodException nm2) {
                                                        this.getTileEntity = Class.forName("net.minecraft.server." + DragonSlayer.getVersion() + ".World").getDeclaredMethod("getTileEntity", blockPos.getClass());
                                                    }
                                                }
                                            }
                                            try {
                                                this.getTileEntity.setAccessible(true);
                                                tileEnt = this.getTileEntity.invoke(worldServer, blockPos, false);
                                            }
                                            catch (IllegalArgumentException ia) {
                                                tileEnt = this.getTileEntity.invoke(worldServer, blockPos);
                                            }
                                            if (tileEnt == null) break block27;
                                            if (DragonSlayer.getSubVersion() <= 17) break block28;
                                            if (this.saveNBT != null) break block29;
                                            switch (DragonSlayer.getVersion(true)) {
                                                case "v1_19_R1-2": {
                                                    this.saveNBT = tileEnt.getClass().getDeclaredMethod("aa_", new Class[0]);
                                                    break;
                                                }
                                                case "v1_19_R1": {
                                                    this.saveNBT = tileEnt.getClass().getDeclaredMethod("ab_", new Class[0]);
                                                    break;
                                                }
                                                case "v1_18_R2": {
                                                    this.saveNBT = tileEnt.getClass().getDeclaredMethod("aa_", new Class[0]);
                                                    break;
                                                }
                                                case "v1_18_R1": {
                                                    this.saveNBT = tileEnt.getClass().getDeclaredMethod("Z_", new Class[0]);
                                                }
                                            }
                                        }
                                        nbt_1 = this.saveNBT.invoke(tileEnt, new Object[0]);
                                        break block31;
                                    }
                                    Object emptyNBTTagCompount = !this.MinVersion117 ? Class.forName("net.minecraft.server." + DragonSlayer.getVersion() + ".NBTTagCompound").newInstance() : Class.forName("net.minecraft.nbt.NBTTagCompound").newInstance();
                                    if (this.saveNBT == null) {
                                        this.saveNBT = tileEnt.getClass().getDeclaredMethod("save", emptyNBTTagCompount.getClass());
                                    }
                                    nbt_1 = this.saveNBT.invoke(tileEnt, emptyNBTTagCompount);
                                }
                                foundGateway.breakNaturally();
                                this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                                    block7: {
                                        foundGateway.setType(Material.END_GATEWAY);
                                        Object tileEnt2 = null;
                                        try {
                                            try {
                                                this.getTileEntity.setAccessible(true);
                                                tileEnt2 = this.getTileEntity.invoke(worldServer, blockPos, false);
                                            }
                                            catch (IllegalArgumentException ia) {
                                                tileEnt2 = this.getTileEntity.invoke(worldServer, blockPos);
                                            }
                                            if (tileEnt2 != null) {
                                                if (DragonSlayer.getSubVersion() > 17) {
                                                    tileEnt2.getClass().getDeclaredMethod("a", nbt_1.getClass()).invoke(tileEnt2, nbt_1);
                                                } else {
                                                    this.saveNBT.invoke(tileEnt2, nbt_1);
                                                }
                                            }
                                        }
                                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e2) {
                                            if (!this.configManager.debugOn()) break block7;
                                            this.logger.warning("Can not handle TileEntity/NBT recreate)");
                                            e2.printStackTrace();
                                        }
                                    }
                                }, 40L);
                            }
                            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException e) {
                                if (!this.configManager.debugOn()) break block27;
                                this.logger.warning("Can not handle TileEntity/NBT...)");
                                e.printStackTrace();
                            }
                        }
                    }, 0L);
                }
            }
        }
    }

    private void syncTP(EnderDragon ThisDragon, Location target) {
        this.getServer().getScheduler().runTaskLater((Plugin)this, () -> ThisDragon.teleport(target), 0L);
    }

    Block CheckGatewaysForDragon(World ThisWorld, Location DragLoc, int distance) {
        for (Location TestLoc : this.Endgateways) {
            Block testBlock;
            if (TestLoc.getWorld() != ThisWorld || (testBlock = TestLoc.getBlock()) == null || !testBlock.getChunk().isLoaded() || testBlock.getType() != Material.END_GATEWAY || !(DragLoc.distance(TestLoc) < (double)distance)) continue;
            return testBlock;
        }
        return null;
    }

    Location getClosestGateway(World thisWorld, Location testLoc) {
        double distance = -1.0;
        Location returnLoc = null;
        for (Location checkLoc : this.Endgateways) {
            Block testBlock;
            if (checkLoc.getWorld() != thisWorld || (testBlock = checkLoc.getBlock()) == null || !testBlock.getChunk().isLoaded() || testBlock.getType() != Material.END_GATEWAY) continue;
            double dist_ = testLoc.distance(checkLoc);
            if (distance != -1.0 && !(dist_ < distance)) continue;
            distance = dist_;
            returnLoc = checkLoc;
        }
        return returnLoc;
    }

    Object getCraftWorld(World ThisWorld) {
        block4: {
            try {
                if (this.CraftWorldClass == null) {
                    this.CraftWorldClass = Class.forName("org.bukkit.craftbukkit." + DragonSlayer.getVersion() + ".CraftWorld");
                }
                if (this.CraftWorldClass.isInstance(ThisWorld)) {
                    return this.CraftWorldClass.cast(ThisWorld);
                }
            }
            catch (ClassNotFoundException | IllegalArgumentException | NullPointerException | SecurityException ee) {
                if (!this.configManager.debugOn()) break block4;
                ee.printStackTrace();
            }
        }
        return null;
    }

    private Object getWorldServer(World ThisWorld) {
        try {
            Object castClass = this.getCraftWorld(ThisWorld);
            return this.CraftWorldClass.getDeclaredMethod("getHandle", new Class[0]).invoke(castClass, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException ee) {
            if (this.configManager.debugOn()) {
                ee.printStackTrace();
            }
            return null;
        }
    }

    private Object getMinecraftServer(World world) {
        try {
            Object worldServer = this.getWorldServer(world);
            String getMinecraftServer_name = "getMinecraftServer";
            switch (DragonSlayer.getVersion(true)) {
                case "v1_18_R1": 
                case "v1_18_R2": 
                case "v1_19_R1": 
                case "v1_19_R1-2": {
                    getMinecraftServer_name = "n";
                }
            }
            return worldServer.getClass().getDeclaredMethod(getMinecraftServer_name, new Class[0]).invoke(worldServer, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }

    void setDragonPosMeta(Entity dragon, Location location) {
        FixedMetadataValue MdV_DragonLocation = new FixedMetadataValue((Plugin)this, (Object)location);
        dragon.setMetadata("DSL-Location", (MetadataValue)MdV_DragonLocation);
    }

    Location getDragonPosMeta(Entity dragon) {
        List list;
        Location location = null;
        if (dragon.hasMetadata("DSL-Location") && (list = dragon.getMetadata("DSL-Location")) != null && list.size() != 0) {
            try {
                location = (Location)((MetadataValue)list.get(0)).value();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return location;
    }

    void setDragonIDMeta(EnderDragon dragon, int dragonId) {
        FixedMetadataValue MdV_DragonID = new FixedMetadataValue((Plugin)this, (Object)dragonId);
        dragon.setMetadata("DSL-dragID", (MetadataValue)MdV_DragonID);
        if (this.dId != null && dragonId >= 0 && !dragon.getPersistentDataContainer().has((NamespacedKey)this.dId, PersistentDataType.INTEGER)) {
            dragon.getPersistentDataContainer().set((NamespacedKey)this.dId, PersistentDataType.INTEGER, (Object)dragonId);
        }
    }

    int getDragonIDMeta(EnderDragon dragon) {
        int dragonId = -1;
        if (this.dId != null && dragon.getPersistentDataContainer().has((NamespacedKey)this.dId, PersistentDataType.INTEGER)) {
            dragonId = (Integer)dragon.getPersistentDataContainer().get((NamespacedKey)this.dId, PersistentDataType.INTEGER);
            if (!dragon.hasMetadata("DSL-Location") && dragonId >= 0) {
                this.setDragonPosMeta((Entity)dragon, dragon.getEyeLocation());
            }
            return dragonId;
        }
        if (dragon.hasMetadata("DSL-dragID")) {
            List list = dragon.getMetadata("DSL-dragID");
            if (list != null && list.size() != 0) {
                try {
                    dragonId = (Integer)((MetadataValue)list.get(0)).value();
                }
                catch (Exception exception) {}
            }
        } else if (dragon.isCustomNameVisible()) {
            String world = dragon.getWorld().getName().toLowerCase();
            dragonId = this.findDragonID(world, dragon.getCustomName());
            this.setDragonIDMeta(dragon, dragonId);
            if (dragonId >= 0) {
                this.setDragonPosMeta((Entity)dragon, dragon.getEyeLocation());
            }
        }
        return dragonId;
    }

    void setDragonDamageMeta(EnderDragon dragon, Player player, double damage) {
        String w = dragon.getWorld().getName().toLowerCase();
        if (this.checkWorld(w)) {
            List list;
            HashMap DragonMeta = new HashMap();
            DragonMeta.put(player, damage);
            if (dragon.hasMetadata("DSL-Damage") && (list = dragon.getMetadata("DSL-Damage")) != null && list.size() != 0) {
                try {
                    DragonMeta = (HashMap)((MetadataValue)list.get(0)).value();
                    double oldDamage = DragonMeta.get(player) != null ? (Double)DragonMeta.get(player) : 0.0;
                    DragonMeta.put(player, damage += oldDamage);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            FixedMetadataValue MdV_DragonDamage = new FixedMetadataValue((Plugin)this, DragonMeta);
            dragon.setMetadata("DSL-Damage", (MetadataValue)MdV_DragonDamage);
        }
    }

    private void StartSecondRepeatingTimer() {
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
            for (String mapname : this.configManager.getMaplist()) {
                Collection dragons;
                World thisWorld;
                boolean startHeal;
                if (!this.timerDisplays.containsKey(mapname)) {
                    this.addTimerDisplay(mapname);
                    if (!this.timerDisplays.containsKey("none")) {
                        this.addTimerDisplay("none");
                    }
                }
                this.updateTimerDisplay(mapname);
                if (!this.healTickCounterList.containsKey(mapname)) {
                    this.healTickCounterList.put(mapname, 0);
                }
                int secs = this.configManager.getRegenSecs(mapname);
                int healAmount = this.configManager.getRegenAmount(mapname);
                int mapCounter = this.healTickCounterList.get(mapname);
                boolean bl = secs > 0 ? mapCounter >= secs : (startHeal = false);
                if (startHeal && (thisWorld = this.getDragonWorldFromString(mapname)) != null && (dragons = thisWorld.getEntitiesByClass(EnderDragon.class)) != null) {
                    for (EnderDragon dragon : dragons) {
                        if (!dragon.isValid() || !this.checkDSLDragon(dragon)) continue;
                        double maxHealth = this.MinVersion19 ? dragon.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() : dragon.getMaxHealth();
                        double health = dragon.getHealth();
                        if (!(health < maxHealth)) continue;
                        double newHealth = health + (double)healAmount;
                        dragon.setHealth(newHealth > maxHealth ? maxHealth : newHealth);
                        this.setBossBarAmount(dragon);
                    }
                }
                this.healTickCounterList.put(mapname, startHeal ? 0 : mapCounter + 1);
            }
            switch (this.RunCounter) {
                case 15: {
                    this.checkForSleepingDragons();
                    this.RunCounter = 0;
                    break;
                }
                case 3: 
                case 7: 
                case 11: {
                    this.checkForSleepingDragons();
                    break;
                }
                case 2: {
                    this.cleanupDragons();
                    for (String Mapname : this.configManager.getMaplist()) {
                        World world = this.getServer().getWorld(Mapname);
                        if (world == null) continue;
                        this.handleBossbar(world);
                    }
                    break;
                }
            }
            ++this.RunCounter;
            if (++this.RunCounter2 > this.configManager.getTabListTime()) {
                this.RunCounter2 = 1;
                for (Player p : this.getServer().getOnlinePlayers()) {
                    this.setTabListName(p);
                }
            }
        }, 600L, 20L);
    }

    String[] getWorldsNextSpawnsOrReset(String Mapname, boolean spawn, boolean reset) {
        long checkTimer = -1L;
        if (spawn) {
            checkTimer = this.getNextRespawn(Mapname);
        }
        if (reset) {
            checkTimer = this.getResetTime(Mapname);
        }
        if (checkTimer >= 0L) {
            int rest = (int)(checkTimer /= 20L) % 86400;
            int days = (int)checkTimer / 86400;
            int hours = rest / 3600;
            int minutes = rest / 60 - hours * 60;
            int seconds = rest % 60;
            return String.format("%d,%02d,%02d,%02d", days, hours, minutes, seconds).split(",");
        }
        return null;
    }

    private void addTimerDisplay(String ThisWorld) {
        Objective ScoreObj;
        Scoreboard timerDisplay = this.getServer().getScoreboardManager().getNewScoreboard();
        try {
            ScoreObj = timerDisplay.registerNewObjective("DSL", "DSLTimer", ChatColor.GREEN + "Next Spawn Time");
        }
        catch (NoSuchMethodError e) {
            ScoreObj = timerDisplay.registerNewObjective("DSL", "DSLTimer");
            ScoreObj.setDisplayName(ChatColor.GREEN + "Next Spawn Time");
        }
        if (!ThisWorld.equals("none")) {
            ScoreObj.setDisplaySlot(DisplaySlot.SIDEBAR);
        } else {
            ScoreObj.setDisplayName("");
        }
        this.timerDisplays.put(ThisWorld, timerDisplay);
        Team team_spawn = timerDisplay.registerNewTeam("T-Spawn");
        Team team_reset = timerDisplay.registerNewTeam("T-Reset");
        team_spawn.addEntry(this.ScoreBoardName_1);
        team_reset.addEntry(this.ScoreBoardName_2);
        World world = Bukkit.getWorld((String)ThisWorld);
        if (world != null) {
            for (Player player : world.getPlayers()) {
                if (this.configManager.getTimerfunc(ThisWorld) == 0) continue;
                player.setScoreboard(timerDisplay);
            }
        }
    }

    private void updateTimerDisplay(String ThisWorld) {
        if (this.timerDisplays.containsKey(ThisWorld)) {
            Scoreboard sb = this.timerDisplays.get(ThisWorld);
            Objective ScoreObj = sb.getObjective("DSL");
            if (ScoreObj != null) {
                int timerFunc = this.configManager.getTimerfunc(ThisWorld);
                String[] times = this.getWorldsNextSpawnsOrReset(ThisWorld, true, false);
                String[] resTimes = this.getWorldsNextSpawnsOrReset(ThisWorld, false, true);
                if ((times != null || resTimes != null) && timerFunc > 0) {
                    String minutes;
                    String hours;
                    String days;
                    boolean showCount;
                    Score fakePlayScore1 = null;
                    Score fakePlayScore2 = null;
                    String seconds1 = "";
                    String seconds2 = "";
                    String spawnsuffix = "";
                    String resetsuffix = "";
                    int blahfixlength = DragonSlayer.getSubVersion() < 13 ? 16 : 64;
                    Team team_spawn = sb.getTeam("T-Spawn");
                    Team team_reset = sb.getTeam("T-Reset");
                    boolean titleset = false;
                    boolean bl = showCount = timerFunc == 2;
                    if (times != null) {
                        fakePlayScore1 = ScoreObj.getScore(this.ScoreBoardName_1);
                        days = times[0];
                        hours = times[1];
                        minutes = times[2];
                        seconds1 = times[3];
                        String timerline = this.configManager.getTimerline().replace('&', '\u00a7');
                        timerline = !timerline.trim().isEmpty() ? ChatColor.RED + timerline.replace("$days", days).replace("$hours", hours).replace("$minutes", minutes).replace("$seconds", seconds1) : (showCount ? ChatColor.RED + "Days:" + String.format("%02d", Integer.valueOf(days)) + " " + hours + ":" + minutes + ":" + ChatColor.RED + seconds1 + "  #:" : ChatColor.RED + "D:" + String.format("%02d", Integer.valueOf(days)) + " H:" + hours + " M:" + minutes + " " + ChatColor.RED + "S:");
                        if (timerline.length() > blahfixlength) {
                            if (timerline.length() > blahfixlength * 2) {
                                timerline = timerline.substring(0, blahfixlength * 2);
                            }
                            spawnsuffix = timerline.substring(blahfixlength);
                            timerline = timerline.substring(0, blahfixlength);
                        }
                        team_spawn.setPrefix(timerline);
                        team_spawn.setSuffix(spawnsuffix);
                        ScoreObj.setDisplayName(ChatColor.GREEN + this.configManager.getTimertext().replace("$days", String.valueOf(days)).replace("$hours", String.valueOf(hours)).replace("$minutes", String.valueOf(minutes)).replace("$seconds", String.valueOf(seconds1)).replace('&', '\u00a7'));
                        titleset = true;
                    }
                    if (resTimes != null) {
                        fakePlayScore2 = ScoreObj.getScore(this.ScoreBoardName_2);
                        days = resTimes[0];
                        hours = resTimes[1];
                        minutes = resTimes[2];
                        seconds2 = resTimes[3];
                        String resetline = this.configManager.getResetline().replace('&', '\u00a7');
                        resetline = !resetline.trim().isEmpty() ? ChatColor.RED + resetline.replace("$days", days).replace("$hours", hours).replace("$minutes", minutes).replace("$seconds", seconds2) : (showCount ? ChatColor.RED + "Days:" + String.format("%02d", Integer.valueOf(days)) + " " + hours + ":" + minutes + ":" + ChatColor.RED + seconds2 + "  #:" : ChatColor.RED + "D:" + String.format("%02d", Integer.valueOf(days)) + " H:" + hours + " M:" + minutes + " " + ChatColor.RED + "S:");
                        if (resetline.length() > blahfixlength) {
                            if (resetline.length() > blahfixlength * 2) {
                                resetline = resetline.substring(0, blahfixlength * 2);
                            }
                            resetsuffix = resetline.substring(blahfixlength);
                            resetline = resetline.substring(0, blahfixlength);
                        }
                        team_reset.setPrefix(resetline);
                        team_reset.setSuffix(resetsuffix);
                        if (!titleset) {
                            ScoreObj.setDisplayName(ChatColor.GREEN + this.configManager.getTimertext().replace("$days", String.valueOf(days)).replace("$hours", String.valueOf(hours)).replace("$minutes", String.valueOf(minutes)).replace("$seconds", String.valueOf(seconds2)).replace('&', '\u00a7'));
                        }
                    }
                    if (fakePlayScore1 != null) {
                        fakePlayScore1.setScore(showCount ? this.countRespawnTimers(ThisWorld) : Integer.valueOf(seconds1).intValue());
                    }
                    if (fakePlayScore2 != null) {
                        fakePlayScore2.setScore(showCount ? 0 : Integer.valueOf(seconds2));
                    } else {
                        sb.resetScores(this.ScoreBoardName_2);
                    }
                    return;
                }
                ScoreObj.setDisplayName(ChatColor.GREEN + "No Spawntimer");
                Set scoreSet = sb.getEntries();
                for (String score : scoreSet) {
                    sb.resetScores(score);
                }
            }
            if (this.getStatueVersion() != 1) {
                World NPCStatue_World = this.getArmorstandWorld();
                World thisWorld_ = this.getDragonWorldFromString(ThisWorld);
                if (NPCStatue_World != null && thisWorld_ != null && thisWorld_.equals(NPCStatue_World)) {
                    Team team2_NPC = sb.getTeam("DSL-NPCs");
                    if (team2_NPC == null) {
                        team2_NPC = sb.registerNewTeam("DSL-NPCs");
                    }
                    if (this.MinVersion19) {
                        team2_NPC.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
                    } else {
                        team2_NPC.setNameTagVisibility(NameTagVisibility.NEVER);
                    }
                    for (String ent : this.team_NPC.getEntries()) {
                        if (team2_NPC.hasEntry(ent)) continue;
                        team2_NPC.addEntry(ent);
                    }
                }
            }
        }
    }

    void setTimerdisplayToPlayer(Player player) {
        String ThisWorld = player.getWorld().getName().toLowerCase();
        if (!this.checkWorld(ThisWorld)) {
            return;
        }
        if (this.configManager.getTimerfunc(ThisWorld) == 0) {
            return;
        }
        Scoreboard TimerSB = this.timerDisplays.get(ThisWorld);
        if (TimerSB != null && TimerSB.getObjective("DSL") != null) {
            player.setScoreboard(TimerSB);
        }
    }

    void delTimerdisplayFromPlayer(Player player) {
        Scoreboard TimerSB = player.getScoreboard();
        if (TimerSB != null && TimerSB.getObjective("DSL") != null) {
            player.setScoreboard(this.getServer().getScoreboardManager().getMainScoreboard());
        }
    }
}

