/*
 * Decompiled with CFR 0.152.
 */
package de.jeppa.DragonSlayer;

import de.jeppa.DragonSlayer.DragonSlayer;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class DragonRespawn
implements Runnable {
    DragonSlayer plugin;
    public String Mapname = null;
    public long StartTime = System.currentTimeMillis() / 50L;
    public long OrigRuntime = 0L;
    public int taskId;

    public DragonRespawn(DragonSlayer instance) {
        this.plugin = instance;
        this.plugin.timerManager.RespawnList.add(this);
    }

    @Override
    public void run() {
        if (this.Mapname != null && this.plugin.getDragonCount(this.Mapname) < this.plugin.configManager.getMaxdragons(this.Mapname)) {
            boolean load;
            Location DragSpawnPos = this.plugin.configManager.getDragonSpawn(this.Mapname);
            World MyWorld = this.plugin.getDragonWorldFromString(this.Mapname);
            if (MyWorld == null) {
                return;
            }
            Chunk MyChunk = MyWorld.getChunkAt(DragSpawnPos);
            if (!MyChunk.isLoaded() && !(load = MyChunk.load())) {
                System.out.println("Failed to load Chunk: " + MyChunk.toString());
            }
            if (this.plugin.MinVersion19) {
                if (DragonSlayer.getSubVersion() >= 11) {
                    MyWorld.spawn(DragSpawnPos, EnderDragon.class, drag -> this.setWerte((EnderDragon)drag));
                } else {
                    try {
                        EnderDragon dragon = (EnderDragon)this.create(EntityType.ENDER_DRAGON, DragSpawnPos);
                        this.setWerte(dragon);
                        Object NMSDragon = this.plugin.getEntityEnderDragon(dragon);
                        Object CraftWorld_o = this.plugin.getCraftWorld(MyWorld);
                        CreatureSpawnEvent.SpawnReason spawnReason = CreatureSpawnEvent.SpawnReason.DEFAULT;
                        Class<?> entClass = Class.forName("net.minecraft.server." + DragonSlayer.getVersion() + ".Entity");
                        CraftWorld_o.getClass().getMethod("addEntity", entClass, spawnReason.getClass()).invoke(CraftWorld_o, NMSDragon, spawnReason);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException e) {
                        if (this.plugin.configManager.debugOn()) {
                            e.printStackTrace();
                        }
                        MyWorld.spawnEntity(DragSpawnPos, EntityType.ENDER_DRAGON);
                    }
                }
            } else {
                MyWorld.spawnEntity(DragSpawnPos, EntityType.ENDER_DRAGON);
            }
        }
        this.plugin.timerManager.RespawnList.remove(this);
    }

    public Entity create(EntityType entityType, Location location) {
        try {
            Object craftWorldObject = this.plugin.getCraftWorld(location.getWorld());
            Object entity = craftWorldObject.getClass().getMethod("createEntity", Location.class, Class.class).invoke(craftWorldObject, location, entityType.getEntityClass());
            return (Entity)entity.getClass().getMethod("getBukkitEntity", new Class[0]).invoke(entity, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException exception) {
            if (this.plugin.configManager.debugOn()) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    private void setWerte(EnderDragon drag) {
        drag.setPhase(EnderDragon.Phase.CIRCLING);
        this.plugin.setDragonPosMeta((Entity)drag, drag.getLocation());
    }
}

