/*
 * Decompiled with CFR 0.152.
 */
package de.jeppa.DragonSlayer;

import de.jeppa.DragonSlayer.DragonSlayer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.SkullType;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.ComplexEntityPart;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EnderDragonChangePhaseEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class DragonEvents
implements Listener {
    DragonSlayer plugin;
    Random random = new Random();

    public DragonEvents(DragonSlayer instance) {
        this.plugin = instance;
    }

    @EventHandler
    public void onDragonDeath(EntityDeathEvent event) {
        if (event.getEntity() instanceof Entity) {
            LivingEntity entity = event.getEntity();
            EntityDamageEvent e = entity.getLastDamageCause();
            World ThisWorld = entity.getWorld();
            String w = ThisWorld.getName().toLowerCase();
            if (this.plugin.checkWorld(w) && entity instanceof EnderDragon && this.plugin.checkDSLDragon((EnderDragon)entity)) {
                int DragonIDPortal;
                int dragID;
                Entity damager = null;
                String damageEventName = e.getEventName();
                if (damageEventName.equals("EntityDamageByEntityEvent")) {
                    try {
                        damager = ((EntityDamageByEntityEvent)e).getDamager();
                    }
                    catch (Exception exception) {}
                } else if (damageEventName.equals("EntityDamageByBlockEvent")) {
                    try {
                        Block damager_ = ((EntityDamageByBlockEvent)e).getDamager();
                        if (damager_ != null) {
                            damager = damager_.getType();
                        }
                        if (damager == null) {
                            damager = damager_;
                        }
                    }
                    catch (ClassCastException | NullPointerException damager_) {
                        // empty catch block
                    }
                }
                Player killer = null;
                if (damager != null) {
                    if (damager instanceof Player) {
                        killer = (Player)damager;
                    } else if (damager instanceof Projectile) {
                        Projectile p = (Projectile)damager;
                        if (p.getShooter() instanceof Player) {
                            killer = (Player)p.getShooter();
                        }
                    } else if (damager instanceof TNTPrimed && ((TNTPrimed)damager).getSource() instanceof Player) {
                        killer = (Player)((TNTPrimed)damager).getSource();
                    }
                }
                if (killer == null) {
                    killer = ((EnderDragon)entity).getKiller();
                }
                if ((dragID = this.plugin.getDragonIDMeta((EnderDragon)entity)) == -1) {
                    dragID = 0;
                }
                int n = DragonIDPortal = this.plugin.configManager.getMultiPortal() ? dragID : 0;
                if (!this.plugin.configManager.getEggItem(w)) {
                    this.dropDragonEgg(entity.getLocation(), DragonIDPortal);
                } else {
                    this.dropDragonEggItem(event, DragonIDPortal);
                }
                if (this.plugin.configManager.getSkullItem(w)) {
                    this.dropDragonHeadItem(event);
                }
                boolean slayerSet = false;
                if (this.plugin.configManager.getAlternativeReward(w)) {
                    if (entity.hasMetadata("DSL-Damage")) {
                        double allDamage = 0.0;
                        HashMap DragonMeta = new HashMap();
                        HashMap<Double, Player> orderList = new HashMap<Double, Player>();
                        List list = entity.getMetadata("DSL-Damage");
                        if (list != null && list.size() != 0) {
                            try {
                                DragonMeta = (HashMap)((MetadataValue)list.get(0)).value();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        List PlayerList = entity.getWorld().getPlayers();
                        for (Player player : DragonMeta.keySet()) {
                            allDamage += PlayerList.contains(player) && (Double)DragonMeta.get(player) > 0.0 ? (Double)DragonMeta.get(player) : 0.0;
                        }
                        for (Player player : PlayerList) {
                            if (DragonMeta.get(player) == null || !((Double)DragonMeta.get(player) > 0.0)) continue;
                            double percentage = (Double)DragonMeta.get(player) / allDamage;
                            orderList.put(percentage, player);
                            double playersDamageReward = percentage * (double)this.plugin.configManager.getDragonExp(w, dragID);
                            player.giveExp((int)playersDamageReward);
                            String RewardMessage = this.plugin.configManager.getXPRewardMessage(w, String.valueOf((int)playersDamageReward), dragID);
                            player.sendMessage(RewardMessage);
                            if (DragonSlayer.econ == null) continue;
                            double reward = percentage * this.plugin.configManager.getReward_double(w, dragID);
                            EconomyResponse r = DragonSlayer.econ.depositPlayer((OfflinePlayer)player, reward);
                            RewardMessage = this.plugin.configManager.getRewardMessage(w, String.valueOf((int)reward), dragID);
                            if (!r.transactionSuccess() || RewardMessage.equals("")) continue;
                            player.sendMessage(RewardMessage);
                        }
                        orderList = this.plugin.sortDamagersRanks(orderList);
                        for (Map.Entry entry : orderList.entrySet()) {
                            Player player = (Player)entry.getValue();
                            Double val = (Double)entry.getKey();
                            List<String> command = this.plugin.configManager.getRankCommand(w, val.intValue(), dragID);
                            if (command != null && !command.isEmpty()) {
                                String percentage = String.format("%d", (int)((Double)DragonMeta.get(player) / allDamage * 100.0 + 0.5));
                                command.replaceAll(com -> com.replace("$player", player.getName()).replace("$rank", String.valueOf(val.intValue())).replace("$percent", percentage));
                                this.plugin.myCommandsHandler(command, ThisWorld);
                            }
                            if (!this.plugin.configManager.getSlayerByPercent() || val.intValue() != 1) continue;
                            this.setSlayer(player, w, dragID);
                            slayerSet = true;
                        }
                    }
                } else {
                    int XPAmount = 12000;
                    if (this.plugin.EnderDragonPreviouslyKilled((EnderDragon)entity)) {
                        XPAmount = 500;
                    }
                    this.dropDragonXP((Entity)entity, XPAmount, dragID);
                }
                if (killer != null) {
                    double reward;
                    if (!slayerSet) {
                        this.setSlayer(killer, w, dragID);
                    }
                    if (DragonSlayer.econ != null && !this.plugin.configManager.getAlternativeReward(w) && (reward = this.plugin.configManager.getReward_double(w, dragID)) > 0.0) {
                        EconomyResponse r = DragonSlayer.econ.depositPlayer((OfflinePlayer)killer, reward);
                        String RewardMessage = this.plugin.configManager.getRewardMessage(w, String.valueOf(reward), dragID);
                        if (r.transactionSuccess() && !RewardMessage.equals("")) {
                            killer.sendMessage(RewardMessage);
                        }
                    }
                } else if (damager != null) {
                    String dName = "";
                    if (damager instanceof Entity) {
                        dName = damager.getName();
                    } else if (damager instanceof Block) {
                        dName = ((Block)damager).getType().name();
                    } else if (damager instanceof Material) {
                        dName = ((Material)damager).name();
                    }
                    Bukkit.getServer().broadcastMessage(this.plugin.replaceValues(String.valueOf(this.plugin.configManager.getDiedMessage()) + " " + dName, w));
                } else {
                    Bukkit.getServer().broadcastMessage(this.plugin.replaceValues(String.valueOf(this.plugin.configManager.getDiedMessage()) + " " + e.getCause(), w));
                }
                this.plugin.setEndGatewayPortals(entity.getWorld());
                DragonSlayer.resetDragonsBossbar((Entity)entity);
                Location DelPortLoc = null;
                double TempX = this.plugin.configManager.getPortalX(w, dragID);
                double TempZ = this.plugin.configManager.getPortalZ(w, dragID);
                if (this.plugin.configManager.getOldPortal(w)) {
                    DelPortLoc = this.plugin.findPosForPortal(TempX, TempZ, entity.getWorld(), Material.BEDROCK);
                    TempX = entity.getLocation().getX();
                    TempZ = entity.getLocation().getZ();
                }
                Location PortLoc2 = this.plugin.findPosForPortal(TempX, TempZ, entity.getWorld(), Material.BEDROCK);
                Location location = DelPortLoc;
                int i = 46;
                while (i <= 52) {
                    int i1 = i;
                    this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                        int endportal = 0;
                        if (i1 == 52) {
                            endportal = 1;
                        }
                        this.PortalDelAndSet(PortLoc2, DelPortLoc2, DragonIDPortal, endportal);
                    }, (long)i * 10L);
                    ++i;
                }
                if (this.plugin.configManager.getResetWorld(w) || this.plugin.configManager.getRespawnPlayer(w) || this.plugin.configManager.getRefreshWorld(w)) {
                    this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                        int aktCount = this.checkCount(w);
                        if (aktCount <= 0) {
                            this.plugin.StartWorldResetTimer(w, this.plugin.configManager.getResetDelay(w), this.plugin.configManager.getWarnTime(w));
                        }
                    });
                }
                int dragId = dragID;
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                    int delay = this.plugin.configManager.getDelay(w);
                    if (delay > 0 && !this.plugin.configManager.getNoAutoRespawn(w, dragId)) {
                        this.plugin.timerManager.StartTimer(w, delay);
                    }
                });
                this.plugin.replaceArmorStand();
                this.plugin.AtKillCommand(w, killer, (EnderDragon)entity);
            }
        }
    }

    private void setSlayer(Player slayer, String w, int dragID) {
        String oldSlayer = this.plugin.getSlayer();
        this.plugin.setSlayer(slayer);
        if (!slayer.getName().equals(oldSlayer)) {
            String KillMessage = this.plugin.configManager.getDragonKillMessage(w, dragID);
            if (!KillMessage.equals("")) {
                Bukkit.getServer().broadcastMessage(KillMessage);
            }
        } else {
            String ReKillMessage = this.plugin.configManager.getDragonReKillMessage(w, dragID);
            if (!ReKillMessage.equals("")) {
                Bukkit.getServer().broadcastMessage(ReKillMessage);
            }
        }
    }

    private int checkCount(String w) {
        return this.plugin.getDragonCount(w);
    }

    private void PortalDelAndSet(Location PortLoc2, Location DelPortLoc2, int DragonID, int endportal) {
        String w = PortLoc2.getWorld().getName().toLowerCase();
        if (DelPortLoc2 != null) {
            this.plugin.PlacePortal(DelPortLoc2, -1);
        }
        if (this.plugin.configManager.getCreatePortal(w, DragonID)) {
            if (PortLoc2.getWorld() == Bukkit.getServer().getWorld(w)) {
                this.plugin.PlacePortal(PortLoc2, endportal);
                if (endportal > 0 && !this.plugin.configManager.checkCreatePortalID(w, DragonID)) {
                    this.plugin.configManager.setCreatePortal(false, w);
                }
            } else if (this.plugin.configManager.getVerbosity()) {
                this.plugin.getLogger().warning("Portal timer was still running while world was new!");
            }
        }
    }

    private void dropDragonEgg(Location l, int DragonIDPortal) {
        String world = l.getWorld().getName().toLowerCase();
        int i = this.random.nextInt(100);
        if (i < this.plugin.configManager.getDragonEggChance(world) && (!this.plugin.configManager.getCreatePortal(world, DragonIDPortal) || this.plugin.configManager.getCreatePortal(world, DragonIDPortal) && this.plugin.configManager.getPortalEggChance(world) == 0)) {
            l.getBlock().setType(Material.DRAGON_EGG);
        }
    }

    private void dropDragonEggItem(EntityDeathEvent event, int DragonIDPortal) {
        String world = event.getEntity().getWorld().getName().toLowerCase();
        int i = this.random.nextInt(100);
        if (i < this.plugin.configManager.getDragonEggChance(world) && (!this.plugin.configManager.getCreatePortal(world, DragonIDPortal) || this.plugin.configManager.getCreatePortal(world, DragonIDPortal) && this.plugin.configManager.getPortalEggChance(world) == 0)) {
            ItemStack dragEggItem = new ItemStack(Material.DRAGON_EGG);
            event.getEntity().getWorld().dropItem(event.getEntity().getLocation(), dragEggItem);
        }
    }

    private void dropDragonHeadItem(EntityDeathEvent event) {
        String world = event.getEntity().getWorld().getName().toLowerCase();
        int i = this.random.nextInt(100);
        if (i < this.plugin.configManager.getSkullChance(world)) {
            HashSet<ItemStack> Reward = new HashSet<ItemStack>();
            ItemStack DragonSkull = null;
            try {
                Material SkullItem = Material.valueOf((String)"SKULL_ITEM");
                if (SkullItem != null) {
                    DragonSkull = new ItemStack(SkullItem, 1, (short)SkullType.DRAGON.ordinal());
                }
            }
            catch (Exception ex) {
                DragonSkull = new ItemStack(Material.DRAGON_HEAD);
            }
            Reward.add(DragonSkull);
            event.getDrops().addAll(Reward);
        }
    }

    private void dropDragonXP(Entity entity, int Amount, int dragID) {
        World world = entity.getWorld();
        int PlannedAmount = this.plugin.configManager.getDragonExp(world.getName().toLowerCase(), dragID);
        if (PlannedAmount > Amount) {
            PlannedAmount -= Amount;
            int div = this.plugin.spigot && Bukkit.spigot().getConfig().getDouble("world-settings.default.merge-radius.exp") == 0.0 ? 40 : 1;
            int i = 1;
            while (i <= div) {
                ((ExperienceOrb)world.spawn(entity.getLocation(), ExperienceOrb.class)).setExperience(PlannedAmount / div);
                ++i;
            }
        }
    }

    @EventHandler
    public void onDragonUseTransferportal(EntityTeleportEvent event) {
        Block check;
        Entity e = event.getEntity();
        if (e instanceof ComplexEntityPart) {
            e = ((ComplexEntityPart)e).getParent();
        }
        Location fromLoc = event.getFrom();
        World theWorld = fromLoc.getWorld();
        if (e instanceof EnderDragon && this.plugin.checkWorld(theWorld.getName().toLowerCase()) && (check = this.plugin.CheckGatewaysForDragon(theWorld, fromLoc, 14)) != null) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onOrbSpawn(EntityTargetLivingEntityEvent event) {
        Entity orb = event.getEntity();
        String w = orb.getWorld().getName().toString().toLowerCase();
        if (this.plugin.checkWorld(w) && orb.getWorld().getEnvironment() == World.Environment.THE_END && orb instanceof ExperienceOrb && this.plugin.configManager.getAlternativeReward(w) && ((ExperienceOrb)orb).getExperience() > 499) {
            event.setCancelled(true);
            orb.remove();
        }
    }

    @EventHandler
    public void onOrbGrab(PlayerExpChangeEvent event) {
        Player player = event.getPlayer();
        String w = player.getWorld().getName().toLowerCase();
        if (this.plugin.MinVersion117 && this.plugin.checkWorld(w) && player.getWorld().getEnvironment() == World.Environment.THE_END) {
            for (Entity orb : player.getNearbyEntities(2.0, 2.0, 2.0)) {
                if (!(orb instanceof ExperienceOrb) || !this.plugin.configManager.getAlternativeReward(w) || ((ExperienceOrb)orb).getExperience() <= 499 || event.getAmount() != ((ExperienceOrb)orb).getExperience()) continue;
                event.setAmount(0);
                orb.remove();
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDragonSpawn(CreatureSpawnEvent e) {
        LivingEntity ent = e.getEntity();
        if (ent.getTicksLived() > 10) {
            return;
        }
        World ThisWorld = ent.getWorld();
        String w = ThisWorld.getName().toLowerCase();
        if (this.plugin.checkWorld(w) && e.getEntityType() == EntityType.ENDER_DRAGON) {
            EnderDragon ThisDrag = (EnderDragon)ent;
            CreatureSpawnEvent.SpawnReason commandReason = null;
            try {
                commandReason = CreatureSpawnEvent.SpawnReason.COMMAND;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            if (this.plugin.checkDSLDragon(ThisDrag) || ThisWorld.getEnvironment() == World.Environment.THE_END && (commandReason != null && e.getSpawnReason().equals((Object)commandReason) || e.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.DEFAULT)) && this.plugin.checkOrigDragon(ThisDrag)) {
                this.plugin.OrigEnderDragonSetKilled(ThisDrag);
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (ThisDrag != null) {
                        this.plugin.OrigEnderDragonSetKilled(ThisDrag);
                    }
                }, 2L);
                if (this.plugin.ProtectResetWorlds.contains(ThisWorld)) {
                    this.plugin.ProtectResetWorlds.remove(ThisWorld);
                    if (this.plugin.configManager.getDisableOrigDragonRespawn(w)) {
                        e.setCancelled(true);
                        ThisDrag.remove();
                        return;
                    }
                }
                this.plugin.findAndUseEndgateways(w);
                int aktCountByCounting = this.plugin.getDragonCount(w);
                int maxCount = this.plugin.configManager.getOneByOne(w) ? 1 : this.plugin.configManager.getMaxdragons(w);
                int Delay = this.plugin.configManager.getDelay(w);
                if (aktCountByCounting >= maxCount && Delay != 0) {
                    e.setCancelled(true);
                    ThisDrag.remove();
                } else {
                    List<String> command;
                    int newHealth;
                    ThisDrag.setPhase(EnderDragon.Phase.CIRCLING);
                    String[] dragNameAndID = this.plugin.configManager.getDragonNameAndID(w);
                    String dragName = dragNameAndID[0];
                    int dragonId = Integer.parseInt(dragNameAndID[1]);
                    if (!dragName.isEmpty()) {
                        ThisDrag.setCustomName(dragName);
                    }
                    ThisDrag.setCustomNameVisible(this.plugin.configManager.getDisplayDragonName(w));
                    this.plugin.setDragonIDMeta(ThisDrag, dragonId);
                    if (this.plugin.getDragonPosMeta((Entity)ThisDrag) == null) {
                        this.plugin.setDragonPosMeta((Entity)ThisDrag, ThisDrag.getLocation());
                    }
                    if ((newHealth = this.plugin.configManager.getDragonHealth_n(w, dragonId)) > 0) {
                        ThisDrag.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue((double)newHealth);
                        ThisDrag.setHealth((double)newHealth);
                    }
                    if (!ThisDrag.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).getModifiers().isEmpty()) {
                        ThisDrag.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).removeModifier((AttributeModifier)ThisDrag.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).getModifiers().iterator().next());
                    }
                    int range = this.plugin.configManager.getDragonRange(w, dragonId);
                    ThisDrag.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue((double)range);
                    BossBar BossBar2 = this.plugin.findFreeBar(w);
                    if (BossBar2 != null) {
                        BossBar2.setTitle(ThisDrag.getName());
                        this.plugin.setBossBarAmountNOW(ThisDrag, BossBar2);
                        this.plugin.putBossBarToDragon(ThisDrag, BossBar2);
                        this.plugin.FindPlayerAndAddToBossBar(BossBar2, (Entity)ThisDrag);
                    }
                    this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.plugin.setDragonNavi(ThisDrag), 2L);
                    this.PlayDragonSound(ThisWorld);
                    String RespawnMessage = this.plugin.configManager.getRespawnMessage(w, dragonId);
                    if (!RespawnMessage.equals("")) {
                        Bukkit.getServer().broadcastMessage(RespawnMessage);
                    }
                    if (!(command = this.plugin.configManager.getSpawnCommand(w, dragonId)).isEmpty()) {
                        this.plugin.myCommandsHandler(command, ThisWorld);
                    }
                    this.plugin.stopResetTimer(w);
                }
            }
        }
    }

    private void PlayDragonSound(World ThisWorld) {
        Sound Ton = null;
        try {
            Ton = Sound.valueOf((String)"ENDERDRAGON_GROWL");
        }
        catch (IllegalArgumentException e) {
            try {
                Ton = Sound.valueOf((String)"ENTITY_ENDERDRAGON_GROWL");
            }
            catch (IllegalArgumentException e2) {
                try {
                    Ton = Sound.valueOf((String)"ENTITY_ENDER_DRAGON_GROWL");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (Ton == null || (!this.plugin.configManager.getNoSpawnSound() || !p.getWorld().equals(ThisWorld)) && this.plugin.configManager.getNoSpawnSound()) continue;
            p.playSound(p.getLocation(), Ton, 1.0f, 0.0f);
        }
    }

    @EventHandler
    public void stopDragonDamageOrCrystalExplosion(EntityExplodeEvent event) {
        Entity e = event.getEntity();
        String w = e.getWorld().getName();
        if (this.plugin.checkWorld(w)) {
            if (e instanceof ComplexEntityPart) {
                e = ((ComplexEntityPart)e).getParent();
            }
            if (e instanceof EnderDragon && !this.plugin.configManager.getBlockGrief(w.toLowerCase())) {
                event.setCancelled(true);
            }
            if (e instanceof EnderCrystal && this.plugin.configManager.getDenyCrystalExplosion(w.toLowerCase())) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onDragonDamage(EntityDamageByEntityEvent event) {
        String world;
        Entity e = event.getDamager();
        if (e instanceof EnderDragon && this.plugin.checkWorld(world = e.getWorld().getName())) {
            int dragonID = this.plugin.getDragonIDMeta((EnderDragon)e);
            if (!this.plugin.checkDSLDragon((EnderDragon)e)) {
                return;
            }
            double dam = this.plugin.configManager.getDragonDamage(world.toLowerCase(), dragonID);
            if (dam > 0.0) {
                event.setDamage(dam);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDragonMoves(EnderDragonChangePhaseEvent event) {
        EnderDragon ThisDrag = event.getEntity();
        EnderDragon.Phase NextPhase = event.getNewPhase();
        World ThisWorld = ThisDrag.getWorld();
        String w = ThisWorld.getName().toLowerCase();
        if (this.plugin.checkWorld(w)) {
            EnderDragon.Phase DragPhase;
            boolean setEDBforce = false;
            switch (NextPhase) {
                case FLY_TO_PORTAL: 
                case LAND_ON_PORTAL: 
                case LEAVE_PORTAL: 
                case BREATH_ATTACK: 
                case SEARCH_FOR_BREATH_ATTACK_TARGET: 
                case ROAR_BEFORE_ATTACK: 
                case DYING: {
                    setEDBforce = true;
                    break;
                }
                case HOVER: {
                    setEDBforce = false;
                    break;
                }
                default: {
                    setEDBforce = false;
                }
            }
            Collection DragonList = ThisWorld.getEntitiesByClass(EnderDragon.class);
            if (NextPhase != EnderDragon.Phase.DYING) {
                if (this.plugin.configManager.getMultiPortal() && !this.plugin.checkServerStarted() && NextPhase != EnderDragon.Phase.HOVER) {
                    event.setCancelled(true);
                    ThisDrag.setPhase(EnderDragon.Phase.HOVER);
                    return;
                }
            } else if (ThisDrag.isValid()) {
                for (EnderDragon Dragon : DragonList) {
                    if (Dragon.getEntityId() == ThisDrag.getEntityId() || !Dragon.isValid()) continue;
                    DragPhase = Dragon.getPhase();
                    if (DragPhase == EnderDragon.Phase.SEARCH_FOR_BREATH_ATTACK_TARGET || DragPhase == EnderDragon.Phase.ROAR_BEFORE_ATTACK || DragPhase == EnderDragon.Phase.BREATH_ATTACK) {
                        Dragon.setPhase(EnderDragon.Phase.LEAVE_PORTAL);
                        continue;
                    }
                    if (DragPhase != EnderDragon.Phase.FLY_TO_PORTAL && DragPhase != EnderDragon.Phase.LAND_ON_PORTAL && DragPhase != EnderDragon.Phase.HOVER) continue;
                    Dragon.setPhase(EnderDragon.Phase.CIRCLING);
                }
            }
            if (ThisDrag.getTicksLived() > 200) {
                for (EnderDragon Dragon : DragonList) {
                    if (Dragon.getEntityId() == ThisDrag.getEntityId() || !Dragon.isValid()) continue;
                    DragPhase = Dragon.getPhase();
                    if (!(ThisDrag.getLocation().distance(Dragon.getLocation()) < 128.0)) continue;
                    if (NextPhase == EnderDragon.Phase.FLY_TO_PORTAL && (DragPhase == EnderDragon.Phase.LAND_ON_PORTAL || DragPhase == EnderDragon.Phase.SEARCH_FOR_BREATH_ATTACK_TARGET || DragPhase == EnderDragon.Phase.ROAR_BEFORE_ATTACK || DragPhase == EnderDragon.Phase.BREATH_ATTACK)) {
                        event.setCancelled(true);
                        ThisDrag.setPhase(EnderDragon.Phase.CIRCLING);
                        continue;
                    }
                    if (NextPhase == EnderDragon.Phase.LAND_ON_PORTAL && (DragPhase == EnderDragon.Phase.LAND_ON_PORTAL || DragPhase == EnderDragon.Phase.SEARCH_FOR_BREATH_ATTACK_TARGET || DragPhase == EnderDragon.Phase.ROAR_BEFORE_ATTACK || DragPhase == EnderDragon.Phase.BREATH_ATTACK)) {
                        event.setCancelled(true);
                        ThisDrag.setPhase(EnderDragon.Phase.LEAVE_PORTAL);
                        continue;
                    }
                    if (NextPhase != EnderDragon.Phase.LAND_ON_PORTAL && NextPhase != EnderDragon.Phase.SEARCH_FOR_BREATH_ATTACK_TARGET || DragPhase != EnderDragon.Phase.FLY_TO_PORTAL) continue;
                    Dragon.setPhase(EnderDragon.Phase.CIRCLING);
                }
            }
            if (this.plugin.configManager.getOldPortal(w.toLowerCase())) {
                switch (NextPhase) {
                    case FLY_TO_PORTAL: 
                    case LAND_ON_PORTAL: {
                        event.setCancelled(true);
                        ThisDrag.setPhase(EnderDragon.Phase.CIRCLING);
                        break;
                    }
                    case CIRCLING: 
                    case STRAFING: 
                    case CHARGE_PLAYER: 
                    case DYING: 
                    case HOVER: {
                        break;
                    }
                }
            }
            this.plugin.WorldGenEndTrophyPositionSet(ThisDrag, setEDBforce);
        }
    }

    @EventHandler
    public void onDamageTheDragon(EntityDamageByEntityEvent event) {
        Entity e = event.getEntity();
        Entity damager = event.getDamager();
        double Schaden = event.getFinalDamage();
        if (e instanceof EnderDragon) {
            Projectile p;
            this.plugin.setBossBarAmount((EnderDragon)e);
            if (damager instanceof Player) {
                this.plugin.setDragonDamageMeta((EnderDragon)e, (Player)damager, Schaden);
            } else if (damager instanceof Projectile && (p = (Projectile)damager).getShooter() instanceof Player) {
                damager = (Player)p.getShooter();
                this.plugin.setDragonDamageMeta((EnderDragon)e, (Player)damager, Schaden);
            }
        }
    }

    @EventHandler
    public void onHealTheDragon(EntityRegainHealthEvent event) {
        Entity e = event.getEntity();
        if (e instanceof EnderDragon && this.plugin.checkDSLDragon((EnderDragon)e)) {
            this.plugin.setBossBarAmount((EnderDragon)e);
        }
    }
}

