/*
 * Decompiled with CFR 0.152.
 */
package de.jeppa.DragonSlayer;

import de.jeppa.DragonSlayer.DragonSlayer;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EnderDragon;

public class ConfigManager {
    DragonSlayer plugin;

    public ConfigManager(DragonSlayer instance) {
        this.plugin = instance;
    }

    public void loadConfiguration() {
        boolean headerSet = false;
        if (DragonSlayer.getSubVersion() >= 18) {
            try {
                this.plugin.getConfig().options().getHeader();
                this.plugin.saveDefaultConfig();
                this.plugin.getConfig().options().copyDefaults(true);
                List headerStrings = this.plugin.getConfig().options().getHeader();
                InputStreamReader reader_defConf = new InputStreamReader(this.plugin.getResource("config.yml"));
                YamlConfiguration defConf = YamlConfiguration.loadConfiguration((Reader)reader_defConf);
                List headerStrings_neu = defConf.options().getHeader();
                if (!headerStrings.equals(headerStrings_neu)) {
                    this.plugin.getConfig().options().setHeader(headerStrings_neu);
                }
                headerSet = true;
                for (String confPunkt : this.plugin.getConfig().getKeys(true)) {
                    List inl_comment_def;
                    List inl_comment;
                    List comment_def;
                    List comment = this.plugin.getConfig().getComments(confPunkt);
                    if (!comment.equals(comment_def = defConf.getComments(confPunkt)) && comment_def != null) {
                        this.plugin.getConfig().setComments(confPunkt, comment_def);
                    }
                    if ((inl_comment = this.plugin.getConfig().getInlineComments(confPunkt)).equals(inl_comment_def = defConf.getInlineComments(confPunkt)) || inl_comment_def == null) continue;
                    this.plugin.getConfig().setInlineComments(confPunkt, inl_comment_def);
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        if (!headerSet) {
            this.plugin.getConfig().options().copyDefaults(true);
            this.plugin.getConfig().options().copyHeader(true);
            this.plugin.saveDefaultConfig();
        }
        this.plugin.saveConfig();
    }

    private boolean getConfigBoolean(String Mapname, String var) {
        return Boolean.parseBoolean(this.getConfigString(Mapname, var));
    }

    private int getConfigInt(String Mapname, String var) {
        return Integer.parseInt(this.getConfigString(Mapname, var));
    }

    private double getConfigDouble(String Mapname, String var) {
        return Double.parseDouble(this.getConfigString(Mapname, var));
    }

    private String getConfigString(String Mapname, String var) {
        String TestWord = this.plugin.getConfig().getString("dragon." + Mapname + "." + var);
        if (TestWord == null) {
            this.plugin.getConfig().set("dragon." + Mapname + "." + var, (Object)this.plugin.getConfig().getString("dragon._default." + var));
        }
        return this.plugin.getConfig().getString("dragon." + Mapname + "." + var);
    }

    private List<String> getConfigStringList(String mapname, String var) {
        String str;
        List strList = this.plugin.getConfig().getStringList("dragon." + mapname + "." + var);
        if (strList.isEmpty() && (str = this.getConfigString(mapname, var)) != null) {
            String[] stringArray = str.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str2 = stringArray[n2];
                strList.add(str2);
                ++n2;
            }
            if (!strList.isEmpty()) {
                this.plugin.getConfig().set("dragon." + mapname + "." + var, (Object)strList);
                this.plugin.saveConfig();
                if (this.getVerbosity()) {
                    this.plugin.logger.info("Old command format found and converted...");
                }
            }
        }
        return strList;
    }

    int getDelay(String Mapname) {
        int delay = this.getConfigInt(Mapname, "respawndelay");
        if (delay == -1) {
            return 0;
        }
        if (delay == -2) {
            return -1;
        }
        if (delay < 1) {
            this.plugin.logger.warning("Invalid dragon respawn delay set, reverting to default: 360 minutes (6 hours)");
            this.plugin.getConfig().set("dragon." + Mapname + ".respawndelay", (Object)360);
            this.plugin.saveConfig();
            return 432000;
        }
        return delay * 1200;
    }

    boolean getNoAutoRespawn(String Mapname, int id) {
        String id_ = String.valueOf(id);
        String TestForRespawn = this.plugin.getConfig().getString("dragon." + Mapname + ".noautorespawn_" + id_);
        return TestForRespawn == null ? false : Boolean.parseBoolean(TestForRespawn);
    }

    boolean getResetWorld(String Mapname) {
        return this.getConfigBoolean(Mapname, "resetworld");
    }

    boolean getRefreshWorld(String Mapname) {
        return this.getConfigBoolean(Mapname, "resetcrystal");
    }

    int getResetDelay(String Mapname) {
        int delay = this.getConfigInt(Mapname, "resetworlddelay");
        if (delay < 1) {
            this.plugin.logger.warning("Invalid world reset delay set, reverting to default: 300 minutes (5 hours)");
            this.plugin.getConfig().set("dragon." + Mapname + ".resetworlddelay", (Object)300);
            this.plugin.saveConfig();
            return 360000;
        }
        return delay * 1200;
    }

    int getWarnTime(String Mapname) {
        return this.getConfigInt(Mapname, "resetwarntime") < 0 ? 1200 : this.getConfigInt(Mapname, "resetwarntime") * 1200;
    }

    boolean getRespawnPlayer(String Mapname) {
        return this.getConfigBoolean(Mapname, "respawnplayers");
    }

    boolean getSlayerByPercent() {
        return Boolean.parseBoolean(this.plugin.getConfig().getString("global.slayerbypercent"));
    }

    private boolean getAutofix() {
        return Boolean.parseBoolean(this.plugin.getConfig().getString("global.trydragonautofix"));
    }

    boolean getAutofix(String mapName) {
        return this.plugin.getConfig().getBoolean("dragon." + mapName + ".trydragonautofix", this.getAutofix());
    }

    boolean getDark(String Mapname) {
        return this.plugin.getConfig().getBoolean("dragon." + Mapname + ".darkness", this.plugin.getConfig().getBoolean("global.darkness"));
    }

    boolean getVerbosity() {
        return Boolean.parseBoolean(this.plugin.getConfig().getString("global.verbose"));
    }

    boolean debugOn() {
        return this.plugin.getConfig().getBoolean("global.debug", false);
    }

    boolean keepChunksLoaded() {
        return this.plugin.getConfig().getBoolean("global.keepchunks", true);
    }

    boolean getDragonTeleport(String mapName) {
        return this.plugin.getConfig().getBoolean("dragon." + mapName + ".teleportdragons", Boolean.parseBoolean(this.plugin.getConfig().getString("global.teleportdragons")));
    }

    boolean usePapiASName() {
        return Boolean.parseBoolean(this.plugin.getConfig().getString("global.armorstand_usepapi"));
    }

    String getAS_PapiPH() {
        return this.plugin.getConfig().getString("global.armorstand_placeholder");
    }

    String getAS_PapiFormat() {
        return this.plugin.getConfig().getString("global.armorstand_format").replace('&', '\u00a7');
    }

    String getSlayerPAPINick() {
        String playerDisplayName = this.getArmorstandPAPIname();
        return playerDisplayName != null ? playerDisplayName : this.plugin.getSlayer();
    }

    String getSlayerPAPIFormatNickString() {
        String playerDisplayName = this.getArmorstandPAPIname();
        return playerDisplayName != null ? this.getAS_PapiFormat().replace("%slayer%", playerDisplayName) : this.getAS_PapiFormat().replace("%slayer%", this.plugin.getSlayer() != null ? this.plugin.getSlayer() : "NONE");
    }

    String getArmorstandPAPIname() {
        String playerDisplayName;
        if (this.plugin.PAPIenabled && this.usePapiASName() && (playerDisplayName = this.getAS_PapiPH()) != null & !playerDisplayName.isEmpty()) {
            OfflinePlayer slayr = this.plugin.getOfflineSlayer();
            if (slayr != null) {
                playerDisplayName = PlaceholderAPI.setPlaceholders((OfflinePlayer)slayr, (String)playerDisplayName);
            }
            if (!playerDisplayName.isEmpty() && !playerDisplayName.contains("name%")) {
                return playerDisplayName;
            }
        }
        return null;
    }

    boolean getMultiPortal() {
        return Boolean.parseBoolean(this.plugin.getConfig().getString("global.multiportal"));
    }

    public Location getDragonSpawn(String Mapname) {
        return new Location(this.plugin.getDragonWorldFromString(Mapname), this.plugin.getConfig().getDouble("spawnpoint." + Mapname + ".x"), this.plugin.getConfig().getDouble("spawnpoint." + Mapname + ".y"), this.plugin.getConfig().getDouble("spawnpoint." + Mapname + ".z"));
    }

    int getPortalXdef(String Mapname) {
        double x = this.plugin.getConfig().getDouble("spawnpoint." + Mapname.toLowerCase() + ".x");
        if (x < 0.0) {
            x -= 1.0;
        }
        return this.getMultiPortal() && this.plugin.checkServerStarted() ? (int)x : 0;
    }

    int getPortalZdef(String Mapname) {
        double z = this.plugin.getConfig().getDouble("spawnpoint." + Mapname.toLowerCase() + ".z");
        if (z < 0.0) {
            z -= 1.0;
        }
        return this.getMultiPortal() && this.plugin.checkServerStarted() ? (int)z : 0;
    }

    int getPortalX(String Mapname, int id) {
        return this.getPortalX(Mapname, id, this.getMultiPortal(), this.plugin.checkServerStarted());
    }

    int getPortalZ(String Mapname, int id) {
        return this.getPortalZ(Mapname, id, this.getMultiPortal(), this.plugin.checkServerStarted());
    }

    int getPortalX(String Mapname, int id, boolean getMultiPortal, boolean checkServerStarted) {
        String testValue;
        double x = 0.0;
        String string = testValue = id > 0 ? this.plugin.getConfig().getString("spawnpoint." + Mapname.toLowerCase() + ".dragon_" + String.valueOf(id) + ".x") : null;
        if (testValue != null) {
            x = Double.parseDouble(testValue);
        }
        if (x < 0.0) {
            x -= 1.0;
        }
        return getMultiPortal && checkServerStarted ? (testValue != null ? (int)x : this.getPortalXdef(Mapname)) : 0;
    }

    int getPortalZ(String Mapname, int id, boolean getMultiPortal, boolean checkServerStarted) {
        String testValue;
        double z = 0.0;
        String string = testValue = id > 0 ? this.plugin.getConfig().getString("spawnpoint." + Mapname.toLowerCase() + ".dragon_" + String.valueOf(id) + ".z") : null;
        if (testValue != null) {
            z = Double.parseDouble(testValue);
        }
        if (z < 0.0) {
            z -= 1.0;
        }
        return getMultiPortal && checkServerStarted ? (testValue != null ? (int)z : this.getPortalZdef(Mapname)) : 0;
    }

    int getPortalAgression(boolean forceOff) {
        int i = Integer.parseInt(this.plugin.getConfig().getString("global.portalagression"));
        if (forceOff) {
            return 9999;
        }
        return i >= -2 ? i : 0;
    }

    boolean getNoSpawnSound() {
        return Boolean.parseBoolean(this.plugin.getConfig().getString("global.disable_global_spawnsound"));
    }

    boolean getDragonDeathFix(String mapName) {
        return this.plugin.getConfig().getBoolean("dragon." + mapName + ".fixdeathflight", Boolean.parseBoolean(this.plugin.getConfig().getString("global.fixdeathflight")));
    }

    public String getPrefix() {
        return this.plugin.getConfig().getString("prefix.prefix").replace('&', '\u00a7');
    }

    String getDragonDefaultName(String Mapname) {
        return this.plugin.getConfig().getString("dragon." + Mapname + ".name").replace('&', '\u00a7');
    }

    String getDragonDefaultName(String Mapname, Integer id) {
        String id_ = "";
        if (id != null && id != 0) {
            id_ = "_" + String.valueOf(id);
        }
        return this.plugin.getConfig().getString("dragon." + Mapname + ".name" + id_).replace('&', '\u00a7');
    }

    public String[] getDragonNameAndID(String Mapname) {
        int i;
        String retName;
        this.getConfigString(Mapname, "name");
        int maxD = this.getMaxdragons(Mapname);
        HashSet<String> NameDrags = new HashSet<String>();
        World MyWorld = this.plugin.getDragonWorldFromString(Mapname);
        Collection<EnderDragon> Testdrags = this.plugin.getDragonList(MyWorld, Mapname);
        if (this.debugOn()) {
            this.plugin.logger.info("Dragons found on " + Mapname + " :" + Testdrags.size());
        }
        for (EnderDragon Testdrag : Testdrags) {
            if (Testdrag.isDead() || this.plugin.MinVersion19 && (!this.plugin.MinVersion19 || Testdrag.getPhase() == EnderDragon.Phase.DYING)) continue;
            NameDrags.add(Testdrag.getName().replaceAll("\u00a7[f0r]", "").trim());
        }
        if (!this.getOneByOne(Mapname)) {
            int i2 = 1;
            while (i2 <= maxD) {
                retName = this.getDragonNameX(Mapname, i2, NameDrags);
                if (retName != null) {
                    return new String[]{retName, String.valueOf(i2)};
                }
                ++i2;
            }
        } else if (maxD > 0 && (retName = this.getDragonNameX(Mapname, i = new Random().nextInt(maxD) + 1, NameDrags)) != null) {
            return new String[]{retName, String.valueOf(i)};
        }
        return new String[]{this.getDragonDefaultName(Mapname), "0"};
    }

    private String getDragonNameX(String Mapname, int i, Set<String> NameDrags) {
        String Testname;
        String TestAddName = this.plugin.getConfig().getString("dragon." + Mapname + ".name_" + i);
        if (TestAddName != null && !NameDrags.contains(Testname = (TestAddName = TestAddName.replace('&', '\u00a7')).replaceAll("\u00a7[f0r]", ""))) {
            return TestAddName;
        }
        return null;
    }

    String getDragonKillMessage(String world, Integer dragonID) {
        return this.plugin.replaceValues(this.plugin.getConfig().getString("messages.onkill"), world, dragonID);
    }

    String getRespawnMessage(String world, Integer dragonID) {
        return this.plugin.replaceValues(this.plugin.getConfig().getString("messages.respawn"), world, dragonID);
    }

    String getSlayerMessage() {
        return this.plugin.replaceValues(this.plugin.getConfig().getString("messages.slayer"), null);
    }

    String getRewardMessage(String world, String value, Integer dragonID) {
        return this.plugin.replaceValues(this.plugin.getConfig().getString("messages.reward").replace("$reward", value), world, dragonID);
    }

    String getXPRewardMessage(String world, String value, Integer dragonID) {
        return this.plugin.replaceValues(this.plugin.getConfig().getString("messages.xpreward").replace("$reward", value), world, dragonID);
    }

    String getNoSlayerMessage() {
        return this.plugin.replaceValues(this.plugin.getConfig().getString("messages.noslayer"), null);
    }

    String getDragonReKillMessage(String world, Integer dragonID) {
        return this.plugin.replaceValues(this.plugin.getConfig().getString("messages.onrekill"), world, dragonID);
    }

    String getProtectMessage(String world) {
        return this.plugin.replaceValues(this.plugin.getConfig().getString("messages.protect"), world);
    }

    String getResetMessage(String world) {
        return this.plugin.replaceValues(this.plugin.getConfig().getString("messages.reset"), world);
    }

    String getPlayerRespawnMessage(String world) {
        return this.plugin.replaceValues(this.plugin.getConfig().getString("messages.playerrespawn"), world);
    }

    private List<String> getConfigCommand(String world, String commandName, Integer commandNumber, Integer dragonId) {
        List<String> commands = this.getConfigStringList(world, commandNumber != null && commandNumber != 0 ? String.valueOf(commandName) + "_" + commandNumber : commandName);
        if (commands.isEmpty()) {
            commands = this.getConfigStringList(world, commandName);
        }
        ArrayList<String> commands2 = new ArrayList<String>();
        commands2.addAll(commands);
        commands2.replaceAll(command -> this.plugin.replaceValues((String)command, world, dragonId));
        return commands2;
    }

    List<String> getDragonCommand(String world, int i) {
        return this.getConfigCommand(world, "command", i, i);
    }

    List<String> getRankCommand(String world, int rank, Integer dragonID) {
        return this.getConfigCommand(world, "rankcommand", rank, dragonID);
    }

    List<String> getSpawnCommand(String world, Integer dragonID) {
        return this.getConfigCommand(world, "spawncommand", dragonID, dragonID);
    }

    List<String> getRespawnCommand(String world) {
        return this.getConfigCommand(world, "respawncommand", null, null);
    }

    String getDiedMessage() {
        return this.plugin.getConfig().getString("messages.died");
    }

    String getTimertext() {
        return this.plugin.getConfig().getString("messages.timertext");
    }

    String getTimerline() {
        return this.plugin.getConfig().getString("messages.timerline", "");
    }

    String getResetline() {
        return this.plugin.getConfig().getString("messages.resetline", "");
    }

    String getNoTimerPlaceholder() {
        return this.plugin.getConfig().getString("messages.notimer_ph").replace('&', '\u00a7');
    }

    String getNoRankNamePlaceholder() {
        return this.plugin.getConfig().getString("messages.noname_ph").replace('&', '\u00a7');
    }

    String getUnknownNamePlaceholder() {
        return this.plugin.getConfig().getString("messages.unknownname_ph").replace('&', '\u00a7');
    }

    String getNoRankScorePlaceholder() {
        return this.plugin.getConfig().getString("messages.noscore_ph").replace('&', '\u00a7');
    }

    String getShowtime() {
        return this.plugin.getConfig().getString("messages.showtime").replace('&', '\u00a7');
    }

    String getShowreset() {
        return this.plugin.getConfig().getString("messages.showreset").replace('&', '\u00a7');
    }

    String getShowtimeN() {
        return this.plugin.getConfig().getString("messages.showtime_n").replace('&', '\u00a7');
    }

    String getScoreboardString() {
        return this.plugin.getConfig().getString("messages.scoreboard").replace('&', '\u00a7');
    }

    String getCrystalDenyString() {
        return this.plugin.getConfig().getString("messages.crystaldeny");
    }

    boolean getPrefixEnabled() {
        return this.plugin.getConfig().getBoolean("prefix.enabled");
    }

    boolean getPrefixAsSuffix() {
        return this.plugin.getConfig().getBoolean("prefix.assuffix");
    }

    boolean getForcePrefix() {
        return this.plugin.getConfig().getBoolean("prefix.force");
    }

    boolean getTabListEnable() {
        return this.plugin.getConfig().getBoolean("prefix.tablist");
    }

    int getTabListTime() {
        int t = this.plugin.getConfig().getInt("prefix.tablist_time");
        if ((double)t >= 1.0 && t <= 30) {
            return t;
        }
        this.plugin.logger.warning("Invalid tablist time set, reverting to default: 15 seconds");
        this.plugin.getConfig().set("prefix.tablist_time", (Object)15);
        this.plugin.saveConfig();
        return 15;
    }

    public Set<String> getMaplist() {
        Set<String> WorldsList = new HashSet<String>();
        if (this.plugin.getConfig().isConfigurationSection("spawnpoint")) {
            WorldsList = this.plugin.getConfig().getConfigurationSection("spawnpoint").getKeys(false);
        }
        if (WorldsList.contains("world")) {
            WorldsList.remove("world");
        }
        return WorldsList;
    }

    public int getMaxdragons(String Mapname) {
        return this.getConfigInt(Mapname, "maxdragons");
    }

    boolean getOneByOne(String Mapname) {
        return this.getConfigBoolean(Mapname, "onebyone");
    }

    private double getDragonHealth(String Mapname) {
        double h = this.getConfigDouble(Mapname, "health");
        double maxH = 2048.0;
        if (this.plugin.spigot) {
            maxH = Bukkit.spigot().getConfig().getInt("settings.attribute.maxHealth.max");
        }
        if (h >= 0.0 && h <= maxH) {
            return h;
        }
        this.plugin.logger.warning("Invalid dragon health set, reverting to default: 200 (100 hearts)");
        this.plugin.getConfig().set("dragon." + Mapname + ".health", (Object)200.0);
        this.plugin.saveConfig();
        return 200.0;
    }

    int getDragonHealth_n(String Mapname, int dragonId) {
        Integer health = (int)this.getDragonHealth(Mapname);
        String healthStr = this.plugin.getConfig().getString("dragon." + Mapname + ".health_" + dragonId);
        int health2 = healthStr != null ? (int)Double.parseDouble(healthStr) : -1;
        double maxH = 2048.0;
        if (this.plugin.spigot) {
            maxH = Bukkit.spigot().getConfig().getInt("settings.attribute.maxHealth.max");
        }
        if ((double)health2 >= 0.0 && (double)health2 <= maxH) {
            return health2;
        }
        return health;
    }

    int getRegenSecs(String Mapname) {
        return this.getConfigInt(Mapname, "regen_seconds");
    }

    int getRegenAmount(String Mapname) {
        return this.getConfigInt(Mapname, "regen_amount");
    }

    Double getDragonDamage(String Mapname, int id) {
        Double value = this.getConfigDouble(Mapname, "damage");
        String TestValue = id > 0 ? this.plugin.getConfig().getString("dragon." + Mapname + ".damage_" + id) : null;
        return TestValue != null ? Double.parseDouble(TestValue) : value;
    }

    int getDragonExp(String Mapname, int id) {
        String TestValue;
        int e = this.getConfigInt(Mapname, "exp");
        String string = TestValue = id > 0 ? this.plugin.getConfig().getString("dragon." + Mapname + ".exp_" + id) : null;
        if (TestValue != null) {
            e = Integer.parseInt(TestValue);
        }
        if (e >= 0 && e <= 1000000000) {
            return e;
        }
        this.plugin.logger.warning("Invalid dragon exp set, reverting to default: 12000");
        this.plugin.getConfig().set("dragon." + Mapname + ".exp" + (id > 0 ? "_" + String.valueOf(id) : ""), (Object)12000);
        this.plugin.saveConfig();
        return 12000;
    }

    double getReward_double(String Mapname, int id) {
        Double value = this.getConfigDouble(Mapname, "reward");
        String TestValue = id > 0 ? this.plugin.getConfig().getString("dragon." + Mapname + ".reward_" + id) : null;
        return TestValue != null ? Double.parseDouble(TestValue) : value;
    }

    int getDragonRange(String Mapname, int id) {
        String TestValue;
        int e = this.getConfigInt(Mapname, "range");
        String string = TestValue = id > 0 ? this.plugin.getConfig().getString("dragon." + Mapname + ".range_" + id) : null;
        if (TestValue != null) {
            e = Integer.parseInt(TestValue);
        }
        if (e >= 0 && e <= 2048) {
            return e;
        }
        this.plugin.logger.warning("Invalid dragon range set, reverting to default: 16");
        this.plugin.getConfig().set("dragon." + Mapname + ".range" + (id > 0 ? "_" + String.valueOf(id) : ""), (Object)16);
        this.plugin.saveConfig();
        return 16;
    }

    int getBossbarDistance(String Mapname) {
        int e = this.getConfigInt(Mapname, "bossbar_distance");
        if (e >= 60) {
            return e;
        }
        this.plugin.logger.warning("Invalid dragon distance set, minimum is : 60");
        this.plugin.getConfig().set("dragon." + Mapname + ".bossbar_distance", (Object)60);
        this.plugin.saveConfig();
        return 60;
    }

    int getDragonEggChance(String Mapname) {
        double chance = this.getConfigDouble(Mapname, "eggchance") * 100.0;
        if (chance >= 0.0 && chance <= 100.0) {
            return (int)chance;
        }
        this.plugin.logger.warning("Invalid dragon egg chance set, reverting to default: 0.3");
        this.plugin.getConfig().set("dragon." + Mapname + ".eggchance", (Object)0.3);
        this.plugin.saveConfig();
        return 30;
    }

    int getPortalEggChance(String Mapname) {
        double chance = this.getConfigDouble(Mapname, "portaleggchance") * 100.0;
        if (chance >= 0.0 && chance <= 100.0) {
            return (int)chance;
        }
        this.plugin.logger.warning("Invalid portal egg chance set, reverting to default: 1.0");
        this.plugin.getConfig().set("dragon." + Mapname + ".portaleggchance", (Object)1.0);
        this.plugin.saveConfig();
        return 100;
    }

    boolean getEggItem(String Mapname) {
        return this.getConfigBoolean(Mapname, "eggasitem");
    }

    int getSkullChance(String Mapname) {
        double chance = this.getConfigDouble(Mapname, "skullchance") * 100.0;
        if (chance >= 0.0 && chance <= 100.0) {
            return (int)chance;
        }
        this.plugin.logger.warning("Invalid dragon skull chance set, reverting to default: 0.03");
        this.plugin.getConfig().set("dragon." + Mapname + ".skullchance", (Object)0.03);
        this.plugin.saveConfig();
        return 3;
    }

    boolean getSkullItem(String Mapname) {
        return this.getConfigBoolean(Mapname, "skullitem");
    }

    boolean getEggCancel(String Mapname) {
        return this.getConfigBoolean(Mapname, "cancelegg");
    }

    private boolean getCreatePortalDefault(String Mapname) {
        String TestForPortal = this.plugin.getConfig().getString("dragon." + Mapname + ".createportal");
        if (TestForPortal == null) {
            this.plugin.getConfig().set("dragon." + Mapname + ".createportal", (Object)true);
        }
        return this.getConfigBoolean(Mapname, "createportal");
    }

    boolean getCreatePortal(String Mapname, Integer id) {
        String TestForPortal;
        String id_ = "";
        if (id != null && id != 0) {
            id_ = "_" + String.valueOf(id);
        }
        if ((TestForPortal = this.plugin.getConfig().getString("dragon." + Mapname + ".createportal" + id_)) == null) {
            return this.getCreatePortalDefault(Mapname);
        }
        return Boolean.parseBoolean(TestForPortal);
    }

    boolean checkCreatePortalID(String Mapname, int id) {
        String id_ = String.valueOf(id);
        String TestForPortal = this.plugin.getConfig().getString("dragon." + Mapname + ".createportal_" + id_);
        return TestForPortal != null;
    }

    void setCreatePortal(boolean b, String Mapname) {
        this.plugin.getConfig().set("dragon." + Mapname + ".createportal", (Object)b);
        this.plugin.saveConfig();
    }

    boolean getAlternativeReward(String Mapname) {
        return this.getConfigBoolean(Mapname, "alternativereward");
    }

    boolean getDisplayDragonName(String Mapname) {
        return this.getConfigBoolean(Mapname, "displaydragonname");
    }

    boolean getCreateGateways(String Mapname) {
        return this.getConfigBoolean(Mapname, "creategateways");
    }

    boolean getFixGateways(String Mapname) {
        return this.getConfigBoolean(Mapname, "fixgateways");
    }

    boolean getOldPortal(String Mapname) {
        return this.getConfigBoolean(Mapname, "oldportals");
    }

    boolean getCrystalDeny(String Mapname) {
        return this.getConfigBoolean(Mapname, "denycrystalplace");
    }

    boolean getDenyCrystalExplosion(String Mapname) {
        return this.getConfigBoolean(Mapname, "denycrystalexplode");
    }

    boolean getDenyBedExplosion(String Mapname) {
        return this.getConfigBoolean(Mapname, "denybedexplode");
    }

    boolean getDisableOrigDragonRespawn(String Mapname) {
        return this.getConfigBoolean(Mapname, "nomcdragonrespawn");
    }

    boolean getBlockGrief(String mapName) {
        return this.plugin.getConfig().getBoolean("dragon." + mapName + ".blockgrief", Boolean.parseBoolean(this.plugin.getConfig().getString("global.blockgrief")));
    }

    int getTimerfunc(String w) {
        return this.getConfigInt(w, "timerfunc");
    }

    void setDragonDefaults() {
        for (String Mapname : this.getMaplist()) {
            if (Bukkit.getWorld((String)Mapname) == null) continue;
            this.getDragonNameAndID(Mapname);
            this.getDragonDamage(Mapname, 0);
            this.getDragonHealth(Mapname);
            this.getRegenSecs(Mapname);
            this.getRegenAmount(Mapname);
            this.getDragonRange(Mapname, 0);
            this.getBossbarDistance(Mapname);
            this.getDragonExp(Mapname, 0);
            this.getReward_double(Mapname, 0);
            this.getDragonEggChance(Mapname);
            this.getPortalEggChance(Mapname);
            this.getEggItem(Mapname);
            this.getSkullChance(Mapname);
            this.getSkullItem(Mapname);
            this.getEggCancel(Mapname);
            this.getDelay(Mapname);
            this.getCreatePortal(Mapname, null);
            this.getOldPortal(Mapname);
            this.getCrystalDeny(Mapname);
            this.getDenyCrystalExplosion(Mapname);
            this.getDenyBedExplosion(Mapname);
            this.getCreateGateways(Mapname);
            this.getFixGateways(Mapname);
            this.getAlternativeReward(Mapname);
            this.getDisplayDragonName(Mapname);
            this.getResetWorld(Mapname);
            this.getRefreshWorld(Mapname);
            this.getResetDelay(Mapname);
            this.getWarnTime(Mapname);
            this.getTimerfunc(Mapname);
            this.getRespawnPlayer(Mapname);
            this.getRespawnCommand(Mapname);
            this.getSpawnCommand(Mapname, null);
            this.getDragonCommand(Mapname, 0);
            this.getRankCommand(Mapname, 1, 0);
            this.getRankCommand(Mapname, 2, 0);
            this.getDisableOrigDragonRespawn(Mapname);
        }
        this.plugin.saveConfig();
    }

    void checkOldConfig() {
        String[] oldConfVars = new String[]{"name", "damage", "health", "exp", "reward", "eggchance", "eggasitem", "skullchance", "skullitem", "cancelegg", "alternativereward", "respawndelay", "maxdragons", "oldportals", "creategateways", "resetworld", "resetcrystal", "resetworlddelay", "respawnplayers", "nomcdragonrespawn", "command", "respawncommand", "timerfunc"};
        this.checkOldConfig_sub(oldConfVars, "dragon._default.");
        oldConfVars = new String[]{"blockgrief", "slayer", "trydragonautofix", "bypassdragongateway", "teleportdragons"};
        this.checkOldConfig_sub(oldConfVars, "global.");
    }

    private void checkOldConfig_sub(String[] oldConfVars, String section) {
        boolean found = false;
        int i = 0;
        while (i < oldConfVars.length) {
            String test = this.plugin.getConfig().getString("dragon." + oldConfVars[i]);
            if (test != null) {
                if (!found) {
                    this.plugin.reloadConfig();
                }
                found = true;
                this.plugin.getConfig().set(String.valueOf(section) + oldConfVars[i], (Object)test);
                this.plugin.getConfig().set("dragon." + oldConfVars[i], null);
            }
            ++i;
        }
        if (found) {
            this.plugin.saveConfig();
        }
    }
}

