/*
 * Decompiled with CFR 0.152.
 */
package me.Dutchwilco.dragonrewards.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import me.Dutchwilco.dragonrewards.DragonRewards;
import me.Dutchwilco.dragonrewards.util.Config;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;

public class DragonDamageListener
implements Listener {
    private final Map<EnderDragon, Map<Player, Double>> damagers = new HashMap<EnderDragon, Map<Player, Double>>();
    private DragonRewards plugin;

    public DragonDamageListener(DragonRewards plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler
    public void onDamage(EntityDamageByEntityEvent e) {
        Player player;
        if (!(e.getEntity() instanceof EnderDragon)) return;
        if (e.getDamager() instanceof Player) {
            player = (Player)e.getDamager();
        } else {
            if (!(e.getDamager() instanceof Projectile)) return;
            Projectile projectile = (Projectile)e.getDamager();
            if (!(projectile.getShooter() instanceof Player)) return;
            player = (Player)projectile.getShooter();
        }
        double damage = e.getDamage();
        EnderDragon dragon = (EnderDragon)e.getEntity();
        this.addDamage(dragon, player, damage);
    }

    private void addDamage(EnderDragon dragon, Player player, double damage) {
        Map<Player, Double> players = this.damagers.get(dragon);
        if (players == null) {
            players = new HashMap<Player, Double>();
            this.damagers.put(dragon, players);
        }
        if (!players.containsKey(player)) {
            players.put(player, damage);
        } else {
            players.put(player, players.get(player) + damage);
        }
    }

    @EventHandler
    public void onDragonDeath(EntityDeathEvent e) {
        if (e.getEntity() instanceof EnderDragon) {
            EnderDragon dragon = (EnderDragon)e.getEntity();
            if (!this.damagers.containsKey(dragon)) {
                return;
            }
            Map<String, Integer> players = this.getTopDamagers(dragon);
            if (players.size() == 0) {
                return;
            }
            Config config = this.plugin.getConfiguration();
            String format = config.getColorizedString("announcement.format");
            for (String str : config.getStringList("announcement.header")) {
                Bukkit.broadcastMessage((String)config.colorize(str));
            }
            ArrayList<String> names = new ArrayList<String>();
            for (String name : players.keySet()) {
                names.add(name);
            }
            int max = 3 > names.size() ? names.size() : 3;
            int i = 0;
            while (i < max) {
                String name = (String)names.get(i);
                int percentage = players.get(name);
                int count = i + 1;
                Bukkit.broadcastMessage((String)format.replace("%place%", Integer.toString(count)).replace("%player%", name).replace("%percent%", String.valueOf(percentage)));
                for (String command : config.getStringList("rewards." + count)) {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("%player%", name));
                }
                ++i;
            }
        }
    }

    private Map<String, Integer> getTopDamagers(EnderDragon dragon) {
        Map<Player, Double> dams = this.damagers.get(dragon);
        if (dams.size() == 0) {
            return new HashMap<String, Integer>();
        }
        double sum = 0.0;
        for (Double damage : dams.values()) {
            sum += damage.doubleValue();
        }
        dams = this.sortByValue(dams);
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Player player : dams.keySet()) {
            int percent = (int)(dams.get(player) / sum * 100.0);
            if (percent == 0) {
                percent = 1;
            }
            result.put(player.getName(), percent);
        }
        return result;
    }

    private Map<Player, Double> sortByValue(Map<Player, Double> unsortMap) {
        LinkedList<Map.Entry<Player, Double>> list = new LinkedList<Map.Entry<Player, Double>>(unsortMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Player, Double>>(){

            @Override
            public int compare(Map.Entry<Player, Double> o1, Map.Entry<Player, Double> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        LinkedHashMap<Player, Double> sortedMap = new LinkedHashMap<Player, Double>();
        for (Map.Entry entry : list) {
            sortedMap.put((Player)entry.getKey(), (Double)entry.getValue());
        }
        return sortedMap;
    }
}

