/*
 * Decompiled with CFR 0.152.
 */
package me.lianecx.discordlinker;

import java.util.Arrays;
import me.lianecx.discordlinker.DiscordLinker;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class LinkerCommand
implements CommandExecutor {
    DiscordLinker PLUGIN = DiscordLinker.getPlugin();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            return false;
        }
        if (!sender.hasPermission("discordlinker.linker")) {
            sender.sendMessage(ChatColor.RED + "You do not have permission to use this command.");
            return true;
        }
        switch (args[0]) {
            case "reload": {
                this.PLUGIN.reloadConfig();
                int port = this.PLUGIN.getConfig().getInt("port") != 0 ? this.PLUGIN.getConfig().getInt("port") : 11111;
                this.restartServer(port);
                sender.sendMessage(ChatColor.GREEN + "Successfully reloaded config.");
                break;
            }
            case "port": {
                int newPort;
                if (args.length == 1) {
                    sender.sendMessage(ChatColor.GREEN + "The current port is " + this.PLUGIN.getConfig().getInt("port") + ".");
                    return true;
                }
                try {
                    newPort = Integer.parseInt(args[1]);
                }
                catch (IndexOutOfBoundsException | NumberFormatException err) {
                    sender.sendMessage(ChatColor.RED + "Please specify a valid port!");
                    return true;
                }
                this.PLUGIN.getConfig().set("port", (Object)newPort);
                this.PLUGIN.saveConfig();
                this.restartServer(newPort);
                sender.sendMessage(ChatColor.GREEN + "Successfully set port to " + ChatColor.DARK_AQUA + newPort + ChatColor.GREEN + ".");
                break;
            }
            case "private_message": 
            case "message": {
                if (args.length == 1) {
                    sender.sendMessage(ChatColor.GREEN + "The current " + args[0] + " is " + this.PLUGIN.getConfig().getString(args[0]) + ".");
                    return true;
                }
                String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                this.PLUGIN.getConfig().set(args[0], (Object)message);
                this.PLUGIN.saveConfig();
                sender.sendMessage(ChatColor.GREEN + "Successfully set " + args[0] + " to " + ChatColor.RESET + ChatColor.translateAlternateColorCodes((char)'&', (String)message) + ChatColor.GREEN + ".");
            }
        }
        return true;
    }

    public void restartServer(int port) {
        DiscordLinker.getApp().stop();
        DiscordLinker.getApp().listen(() -> this.PLUGIN.getLogger().info("Listening on port " + port), port);
    }
}

