/*
 * Decompiled with CFR 0.152.
 */
package me.lianecx.discordlinker;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import me.lianecx.discordlinker.DiscordLinker;
import org.bukkit.ChatColor;

public class HttpConnection {
    private static final int BOT_PORT = 3100;
    private static final String BOT_URL = "http://smpbot.duckdns.org:3100";
    private static final String PLUGIN_VERSION = DiscordLinker.getPlugin().getDescription().getVersion();

    private static boolean shouldChat() {
        if (DiscordLinker.getConnJson() == null || DiscordLinker.getConnJson().get("channels") == null) {
            return false;
        }
        return DiscordLinker.getConnJson().getAsJsonArray("channels").size() > 0;
    }

    private static JsonArray getChannels(String type) {
        if (!HttpConnection.shouldChat()) {
            return null;
        }
        JsonArray allChannels = DiscordLinker.getConnJson().getAsJsonArray("channels");
        JsonArray filteredChannels = new JsonArray();
        for (JsonElement channel : allChannels) {
            try {
                JsonArray types = channel.getAsJsonObject().getAsJsonArray("types");
                if (!types.contains((JsonElement)new JsonPrimitive(type))) continue;
                filteredChannels.add(channel);
            }
            catch (Exception err) {
                allChannels.remove(channel);
                try {
                    DiscordLinker.getPlugin().updateConn();
                }
                catch (IOException iOException) {}
            }
        }
        return filteredChannels;
    }

    public static void send(String message, String type, String player) {
        JsonArray channels = HttpConnection.getChannels(type);
        if (channels == null || channels.size() == 0) {
            return;
        }
        try {
            JsonObject chatJson = new JsonObject();
            chatJson.addProperty("type", type);
            chatJson.addProperty("player", player);
            chatJson.addProperty("message", ChatColor.stripColor((String)message));
            chatJson.add("channels", (JsonElement)channels);
            chatJson.add("id", DiscordLinker.getConnJson().get("id"));
            chatJson.add("ip", DiscordLinker.getConnJson().get("ip"));
            HttpURLConnection conn = (HttpURLConnection)new URL("http://smpbot.duckdns.org:3100/chat").openConnection();
            byte[] out = chatJson.toString().getBytes(StandardCharsets.UTF_8);
            int length = out.length;
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-type", "application/json");
            conn.setFixedLengthStreamingMode(length);
            conn.setDoOutput(true);
            conn.connect();
            try (OutputStream os = conn.getOutputStream();){
                os.write(out);
            }
            if (conn.getResponseCode() == 403) {
                DiscordLinker.getPlugin().disconnect();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void checkVersion() {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL("http://smpbot.duckdns.org:3100/version").openConnection();
            InputStream inputStream = conn.getInputStream();
            String latestVersion = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
            if (!latestVersion.equals(PLUGIN_VERSION)) {
                DiscordLinker.getPlugin().getLogger().info(ChatColor.AQUA + "Please update to the latest Discord-Linker version (" + latestVersion + ") for a bug-free and feature-rich experience.");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

