/*
 * Decompiled with CFR 0.152.
 */
package me.lianecx.discordlinker;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import express.Express;
import express.utils.Status;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lianecx.discordlinker.ChatListeners;
import me.lianecx.discordlinker.ConsoleLogger;
import me.lianecx.discordlinker.HttpConnection;
import me.lianecx.discordlinker.LinkerCommand;
import me.lianecx.discordlinker.LinkerTabCompleter;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class DiscordLinker
extends JavaPlugin {
    private static Express app;
    private static JsonObject connJson;
    private static DiscordLinker plugin;
    private static final ConsoleLogger cmdLogger;
    private static String verifyCode;
    private static final Gson gson;
    FileConfiguration config = this.getConfig();

    public void onEnable() {
        plugin = this;
        this.config.options().copyDefaults(true);
        this.saveConfig();
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListeners(), (Plugin)this);
        this.getCommand("linker").setExecutor((CommandExecutor)new LinkerCommand());
        this.getCommand("linker").setTabCompleter((TabCompleter)new LinkerTabCompleter());
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            HttpConnection.checkVersion();
            try (BufferedReader connReader = Files.newBufferedReader(Paths.get(this.getDataFolder() + "/connection.conn", new String[0]));){
                JsonElement parser = new JsonParser().parse((Reader)connReader);
                connJson = parser.isJsonObject() ? parser.getAsJsonObject() : new JsonObject();
                HttpConnection.send("", "start", null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        Logger log = (Logger)LogManager.getRootLogger();
        log.addAppender(cmdLogger);
        app = this.startServer();
        this.getLogger().info(ChatColor.GREEN + "Plugin enabled.");
    }

    public void onDisable() {
        HttpConnection.send("", "close", null);
        this.getLogger().info(ChatColor.RED + "Plugin disabled.");
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        app.stop();
    }

    public static JsonObject getConnJson() {
        return connJson;
    }

    public static DiscordLinker getPlugin() {
        return plugin;
    }

    public static Express getApp() {
        return app;
    }

    public Express startServer() {
        JsonObject invalidHash = new JsonObject();
        invalidHash.addProperty("message", "Invalid Hash");
        JsonObject invalidPath = new JsonObject();
        invalidPath.addProperty("message", "Invalid Path");
        JsonObject invalidJson = new JsonObject();
        invalidJson.addProperty("message", "Invalid JSON");
        JsonObject invalidConnection = new JsonObject();
        invalidConnection.addProperty("message", "Invalid connection");
        JsonObject success = new JsonObject();
        success.addProperty("message", "Success");
        Express app = new Express();
        app.get("/file/get", (req, res) -> {
            if (this.wrongHash(req.getAuthorization().get(0).getData())) {
                res.setStatus(Status._401);
                res.send(invalidHash.toString());
                return;
            }
            try {
                Path file = Paths.get(URLDecoder.decode(req.getQuery("path"), "utf-8"), new String[0]);
                if (!res.sendAttachment(file)) {
                    res.setStatus(Status._404);
                    res.send(invalidPath.toString());
                }
            }
            catch (InvalidPathException err) {
                res.setStatus(Status._404);
                res.send(invalidPath.toString());
            }
            catch (UnsupportedEncodingException err) {
                res.setStatus(Status._500);
                JsonObject error = new JsonObject();
                error.addProperty("message", err.toString());
                res.send(error.toString());
            }
        });
        app.post("/file/put", (req, res) -> {
            if (this.wrongHash(req.getAuthorization().get(0).getData())) {
                res.setStatus(Status._401);
                res.send(invalidHash.toString());
                return;
            }
            try (FileOutputStream outputStream = new FileOutputStream(URLDecoder.decode(req.getQuery("path"), "utf-8"));){
                int length;
                byte[] buf = new byte[8192];
                while ((length = req.getBody().read(buf)) > 0) {
                    outputStream.write(buf, 0, length);
                }
                res.send(success.toString());
            }
            catch (IOException err) {
                res.setStatus(Status._500);
                res.send(err.toString());
            }
        });
        app.get("/file/list", (req, res) -> {
            if (this.wrongHash(req.getAuthorization().get(0).getData())) {
                res.setStatus(Status._401);
                res.send(invalidHash.toString());
                return;
            }
            try {
                Path folder = Paths.get(URLDecoder.decode(req.getQuery("folder"), "utf-8"), new String[0]);
                JsonArray content = new JsonArray();
                Stream<Path> stream = Files.list(folder);
                stream.map(path -> {
                    JsonObject object = new JsonObject();
                    object.addProperty("name", path.toFile().getName());
                    object.addProperty("isDirectory", Boolean.valueOf(path.toFile().isDirectory()));
                    return object;
                }).forEach(arg_0 -> ((JsonArray)content).add(arg_0));
                stream.close();
                res.send(content.toString());
            }
            catch (InvalidPathException err) {
                res.setStatus(Status._404);
                res.send(invalidPath.toString());
            }
            catch (IOException err) {
                res.send("[]");
            }
        });
        app.get("/verify", (req, res) -> {
            if (this.wrongIp(req.getIp())) {
                res.setStatus(Status._401);
                res.send(invalidConnection.toString());
                return;
            }
            if (connJson != null) {
                res.setStatus(Status._409);
                JsonObject alreadyConnected = new JsonObject();
                alreadyConnected.addProperty("message", "This plugin is already connected");
                res.send(alreadyConnected.toString());
                return;
            }
            verifyCode = RandomStringUtils.randomAlphanumeric((int)6);
            this.getLogger().info(ChatColor.YELLOW + "Verification Code: " + verifyCode);
            this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                verifyCode = null;
            }, 3600L);
            res.send(success.toString());
        });
        app.get("/command", (req, res) -> {
            if (this.wrongHash(req.getAuthorization().get(0).getData())) {
                res.setStatus(Status._401);
                res.send(invalidHash.toString());
                return;
            }
            JsonObject responseJson = new JsonObject();
            this.getServer().getScheduler().runTask((Plugin)this, () -> {
                try {
                    String cmd = URLDecoder.decode(req.getQuery("cmd"), "utf-8");
                    this.getLogger().info(ChatColor.AQUA + "Command from Discord: /" + cmd);
                    cmdLogger.startLogging();
                    this.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), cmd);
                }
                catch (UnsupportedEncodingException err) {
                    responseJson.addProperty("message", err.toString());
                    res.setStatus(Status._500);
                    res.send(responseJson.toString());
                    return;
                }
                catch (IllegalArgumentException | CommandException err) {
                    res.setStatus(Status._500);
                    responseJson.addProperty("message", err.toString());
                    res.send(responseJson.toString());
                }
                finally {
                    cmdLogger.stopLogging();
                }
                String data = String.join((CharSequence)"\n", cmdLogger.getData());
                String colorCodeRegex = "(?i)\\x7F([\\dA-FK-OR])";
                ChatColor firstColor = null;
                Pattern pattern = Pattern.compile(colorCodeRegex);
                Matcher matcher = pattern.matcher(data);
                if (matcher.find()) {
                    firstColor = ChatColor.getByChar((String)matcher.group(1));
                }
                responseJson.addProperty("message", matcher.replaceAll(""));
                if (firstColor != null) {
                    responseJson.addProperty("color", Character.valueOf(firstColor.getChar()));
                }
                res.send(responseJson.toString());
                cmdLogger.clearData();
            });
        });
        app.post("/chat", (req, res) -> {
            boolean privateMsg;
            String username;
            String msg;
            if (this.wrongHash(req.getAuthorization().get(0).getData())) {
                res.setStatus(Status._401);
                res.send(invalidHash.toString());
                return;
            }
            JsonObject parser = new JsonParser().parse((Reader)new InputStreamReader(req.getBody())).getAsJsonObject();
            String targetUsername = "";
            try {
                msg = parser.get("msg").getAsString();
                username = parser.get("username").getAsString();
                privateMsg = parser.get("private").getAsBoolean();
                if (privateMsg) {
                    targetUsername = parser.get("target").getAsString();
                }
            }
            catch (ClassCastException err) {
                res.setStatus(Status._400);
                res.send(invalidJson.toString());
                return;
            }
            String chatMessage = this.getConfig().getString(privateMsg ? "private_message" : "message");
            chatMessage = chatMessage.replaceAll("%message%", this.markdownToColorCodes(msg));
            chatMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)chatMessage);
            chatMessage = chatMessage.replaceAll("%username%", username);
            String urlRegex = "https?://[-\\w_.]{2,}\\.[a-z]{2,4}/\\S*?";
            String mdUrlRegex = "(?i)\\[([^]]+)]\\((" + urlRegex + ")\\)";
            Pattern mdUrlPattern = Pattern.compile(mdUrlRegex);
            ComponentBuilder chatBuilder = new ComponentBuilder("");
            StringBuilder tempMessage = new StringBuilder();
            for (String word : chatMessage.split(" ")) {
                if (word.matches(urlRegex)) {
                    if (tempMessage.length() != 0) {
                        chatBuilder.append(tempMessage.toString(), ComponentBuilder.FormatRetention.NONE);
                    }
                    tempMessage.setLength(0);
                    chatBuilder.append(word);
                    chatBuilder.event(new ClickEvent(ClickEvent.Action.OPEN_URL, word));
                    chatBuilder.underlined(true);
                    tempMessage.append(" ");
                    continue;
                }
                if (word.matches(mdUrlRegex)) {
                    if (tempMessage.length() != 0) {
                        chatBuilder.append(tempMessage.toString(), ComponentBuilder.FormatRetention.NONE);
                    }
                    tempMessage.setLength(0);
                    Matcher matcher = mdUrlPattern.matcher(word);
                    matcher.find();
                    chatBuilder.append(matcher.group(1));
                    chatBuilder.event(new ClickEvent(ClickEvent.Action.OPEN_URL, matcher.group(2)));
                    chatBuilder.underlined(true);
                    tempMessage.append(" ");
                    continue;
                }
                tempMessage.append(word).append(" ");
            }
            if (tempMessage.length() != 0) {
                chatBuilder.append(tempMessage.toString(), ComponentBuilder.FormatRetention.NONE);
            }
            if (privateMsg) {
                Player player = this.getServer().getPlayer(targetUsername);
                if (player == null) {
                    res.setStatus(Status._422);
                    JsonObject invalidPlayer = new JsonObject();
                    invalidPlayer.addProperty("message", "Target player does not exist or is not online");
                    res.send(invalidPlayer.toString());
                    return;
                }
                player.spigot().sendMessage(chatBuilder.create());
            } else {
                this.getServer().spigot().broadcast(chatBuilder.create());
            }
            res.send(success.toString());
        });
        app.get("/disconnect", (req, res) -> {
            if (this.wrongHash(req.getAuthorization().get(0).getData())) {
                res.setStatus(Status._401);
                res.send(invalidHash.toString());
                return;
            }
            boolean deleted = this.disconnect();
            if (deleted) {
                this.getLogger().info("Disconnected from discord...");
                res.send(success.toString());
            } else {
                res.setStatus(Status._500);
                JsonObject error = new JsonObject();
                error.addProperty("message", "Could not delete connection file");
                res.send(error.toString());
            }
        });
        app.post("/connect", (req, res) -> {
            this.getLogger().info("Connection request...");
            JsonObject parser = new JsonParser().parse((Reader)new InputStreamReader(req.getBody())).getAsJsonObject();
            String hash = req.getAuthorization().get(0).getData();
            String code = req.getAuthorization().get(1).getData();
            if (this.wrongConnection(req.getIp(), hash)) {
                this.getLogger().info("Connection unsuccessful");
                res.setStatus(Status._400);
                res.send(invalidConnection.toString());
                return;
            }
            if (!req.hasAuthorization() || !code.equals(verifyCode)) {
                this.getLogger().info("Connection unsuccessful");
                res.setStatus(Status._401);
                JsonObject invalidCode = new JsonObject();
                invalidCode.addProperty("message", "Invalid verification");
                res.send(invalidCode.toString());
                return;
            }
            try {
                connJson = new JsonObject();
                connJson.addProperty("hash", this.createHash(hash));
                connJson.add("channels", (JsonElement)new JsonArray());
                connJson.add("id", parser.get("id"));
                connJson.add("ip", parser.get("ip"));
                this.updateConn();
                this.getLogger().info("Successfully connected with discord server. ID: " + parser.get("id"));
                JsonObject botConnJson = new JsonObject();
                botConnJson.addProperty("hash", hash);
                botConnJson.add("id", parser.get("id"));
                botConnJson.add("ip", parser.get("ip"));
                botConnJson.addProperty("version", this.getServer().getBukkitVersion().split("-")[0]);
                botConnJson.addProperty("online", Boolean.valueOf(this.getServer().getOnlineMode()));
                botConnJson.addProperty("path", this.getWorldPath());
                res.send(botConnJson.toString());
            }
            catch (IOException | NoSuchAlgorithmException err) {
                this.getLogger().info("Connection unsuccessful");
                res.setStatus(Status._500);
                res.send(err.toString());
            }
            finally {
                verifyCode = null;
            }
        });
        app.post("/channel/:method", (req, res) -> {
            String hash = req.getAuthorization().get(0).getData();
            if (this.wrongHash(hash)) {
                res.setStatus(Status._401);
                res.send(invalidHash.toString());
                return;
            }
            JsonObject newChannel = new JsonParser().parse((Reader)new InputStreamReader(req.getBody())).getAsJsonObject();
            try {
                JsonArray oldChannels = new JsonArray();
                if (connJson != null && connJson.get("channels") != null) {
                    oldChannels = connJson.getAsJsonArray("channels");
                }
                JsonArray channels = new JsonArray();
                for (JsonElement oldChannel : oldChannels) {
                    if (oldChannel.getAsJsonObject().get("id").equals(newChannel.get("id"))) continue;
                    channels.add(oldChannel);
                }
                if (req.getParam("method").equals("add")) {
                    channels.add((JsonElement)newChannel);
                } else if (!req.getParam("method").equals("remove")) {
                    res.setStatus(Status._400);
                    JsonObject invalidParam = new JsonObject();
                    invalidParam.addProperty("message", "Invalid method parameter");
                    res.send(invalidParam.toString());
                    return;
                }
                connJson.add("channels", (JsonElement)channels);
                this.updateConn();
                res.send(channels.toString());
            }
            catch (IOException err) {
                res.setStatus(Status._500);
                JsonObject error = new JsonObject();
                error.addProperty("message", err.toString());
                res.send(error.toString());
            }
        });
        app.get("/players", (req, res) -> {
            if (this.wrongHash(req.getAuthorization().get(0).getData())) {
                res.setStatus(Status._401);
                res.send(invalidHash.toString());
                return;
            }
            List onlinePlayers = this.getServer().getOnlinePlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList());
            res.send(gson.toJson(onlinePlayers));
        });
        app.get("/", (req, res) -> res.send("To invite MC Linker, open this link: https://top.gg/bot/712759741528408064"));
        int port = this.config.getInt("port") != 0 ? this.config.getInt("port") : 11111;
        app.listen(() -> this.getLogger().info("Listening on port " + port), port);
        return app;
    }

    public boolean disconnect() {
        connJson = null;
        File connection = new File(this.getDataFolder() + "/connection.conn");
        return connection.delete();
    }

    public String getWorldPath() throws IOException {
        Properties serverProperties = new Properties();
        serverProperties.load(Files.newInputStream(Paths.get("server.properties", new String[0]), new OpenOption[0]));
        String worldName = serverProperties.getProperty("level-name");
        String path = this.getServer().getWorldContainer().getCanonicalPath() + "/" + worldName;
        return URLEncoder.encode(path, "utf-8");
    }

    public void updateConn() throws IOException {
        FileWriter writer = new FileWriter(this.getDataFolder() + "/connection.conn");
        writer.write(connJson.toString());
        writer.close();
    }

    public String markdownToColorCodes(String markdown) {
        markdown = markdown.replaceAll("\\*\\*(.+?)\\*\\*", "&l$1&r");
        markdown = markdown.replaceAll("__(.+?)__", "&n$1&r");
        markdown = markdown.replaceAll("_(.+?)_|\\*(.+?)\\*", "&o$1$2&r");
        markdown = markdown.replaceAll("~~(.+?)~~", "&m$1&r");
        markdown = markdown.replaceAll("\\?\\?(.+?)\\?\\?", "&k$1&r");
        markdown = markdown.replaceAll("(?s)```[^\\n]*\\n(.+)```|```(.+)```", "&7&n$1$2&r");
        markdown = markdown.replaceAll("`(.+?)`", "&7&n$1&r");
        markdown = markdown.replaceAll("\\|\\|(.+?)\\|\\|", "&8$1&r");
        markdown = markdown.replaceAll(">+ (.+)", "&7| $1&r");
        return markdown;
    }

    public boolean wrongHash(String hash) {
        try {
            if (connJson.get("hash") == null) {
                return true;
            }
            String correctHash = connJson.get("hash").getAsString();
            return !correctHash.equals(this.createHash(hash));
        }
        catch (NoSuchAlgorithmException err) {
            return true;
        }
    }

    public boolean wrongConnection(String Ip, String hash) {
        return this.wrongIp(Ip) || !hash.matches("^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)?$") || hash.length() < 30;
    }

    public boolean wrongIp(String Ip) {
        try {
            String correctIp = InetAddress.getByName("smpbot.duckdns.org").getHostAddress();
            return !Ip.equals(correctIp);
        }
        catch (UnknownHostException ignored) {
            return true;
        }
    }

    public String createHash(String originalString) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hashBytes = digest.digest(originalString.getBytes(StandardCharsets.UTF_8));
        StringBuilder hexString = new StringBuilder(2 * hashBytes.length);
        for (byte hashByte : hashBytes) {
            String hex = Integer.toHexString(0xFF & hashByte);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    static {
        cmdLogger = new ConsoleLogger();
        verifyCode = null;
        gson = new Gson();
    }
}

