/*
 * Decompiled with CFR 0.152.
 */
package me.lianecx.discordlinker;

import me.lianecx.discordlinker.DiscordLinker;
import me.lianecx.discordlinker.HttpConnection;
import org.bukkit.ChatColor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;

public class ChatListeners
implements Listener {
    private static final DiscordLinker PLUGIN = DiscordLinker.getPlugin();

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onChatMessage(AsyncPlayerChatEvent event) {
        String replacedMessage = ChatColor.stripColor((String)event.getMessage().replaceAll("(?i)&[0-9A-FK-OR]", ""));
        PLUGIN.getServer().getScheduler().runTaskAsynchronously((Plugin)PLUGIN, () -> HttpConnection.send(replacedMessage, "chat", event.getPlayer().getName()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onPlayerJoin(PlayerJoinEvent event) {
        PLUGIN.getServer().getScheduler().runTaskAsynchronously((Plugin)PLUGIN, () -> HttpConnection.send(event.getJoinMessage(), "join", event.getPlayer().getName()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onPlayerQuit(PlayerQuitEvent event) {
        PLUGIN.getServer().getScheduler().runTaskAsynchronously((Plugin)PLUGIN, () -> HttpConnection.send(event.getQuitMessage(), "quit", event.getPlayer().getName()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onAdvancement(PlayerAdvancementDoneEvent event) {
        if (event.getAdvancement().getKey().toString().startsWith("minecraft:recipes/")) {
            return;
        }
        PLUGIN.getServer().getScheduler().runTaskAsynchronously((Plugin)PLUGIN, () -> HttpConnection.send(event.getAdvancement().getKey().toString(), "advancement", event.getPlayer().getName()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onPlayerDeath(PlayerDeathEvent event) {
        PLUGIN.getServer().getScheduler().runTaskAsynchronously((Plugin)PLUGIN, () -> HttpConnection.send(event.getDeathMessage(), "death", event.getEntity().getName()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        PLUGIN.getServer().getScheduler().runTaskAsynchronously((Plugin)PLUGIN, () -> HttpConnection.send(event.getMessage(), "player_command", event.getPlayer().getName()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onConsoleCommand(ServerCommandEvent event) {
        PLUGIN.getServer().getScheduler().runTaskAsynchronously((Plugin)PLUGIN, () -> {
            String commandType = event.getSender() instanceof ConsoleCommandSender ? "console_command" : "block_command";
            HttpConnection.send(event.getCommand(), commandType, event.getSender().getName());
        });
    }
}

