/*
 * Decompiled with CFR 0.152.
 */
package express.utils;

import express.utils.MediaType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class Utils {
    private Utils() {
    }

    public static String streamToString(InputStream is) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            return sb.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static MediaType getContentType(Path file) {
        String ex = Utils.getExtension(file);
        MediaType contentType = MediaType.getByExtension(ex);
        if (contentType == null) {
            return MediaType._bin;
        }
        return contentType;
    }

    public static String randomToken(int byteLength, int radix) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] token = new byte[byteLength];
        secureRandom.nextBytes(token);
        return new BigInteger(1, token).toString(radix);
    }

    public static String getYourIp() throws UnknownHostException {
        return Inet4Address.getLocalHost().getHostAddress();
    }

    public static String getExtension(Path file) {
        String path = file.getFileName().toString();
        int indx = path.lastIndexOf(46) + 1;
        if (indx == 0) {
            return null;
        }
        return path.substring(indx);
    }

    public static String getGMTDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy MMM dd HH:mm:ss zzz");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf.format(date);
    }
}

