/*
 * Decompiled with CFR 0.152.
 */
package me.itsalfie.digitalauth.Events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.itsalfie.digitalauth.DigitalAuth;
import me.itsalfie.digitalauth.Utils.Lang;
import me.itsalfie.digitalauth.Utils.Sound;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class InventoryHandlers
implements Listener {
    private DigitalAuth digitalAuth;
    private Map<UUID, String> enteredPin = new HashMap<UUID, String>();
    private ArrayList<Player> enteringBackupCode = new ArrayList();
    private static final String ALPHA_NUMERIC_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public InventoryHandlers(DigitalAuth digitalAuth) {
        this.digitalAuth = digitalAuth;
    }

    @EventHandler
    public void inventoryClick(InventoryClickEvent e) {
        if (e.getClickedInventory() == null || e.getClickedInventory().getName() == null) {
            return;
        }
        if (e.getClick().isShiftClick() || e.getCurrentItem().getType() == Material.AIR || e.getCurrentItem().getType() == Material.STAINED_GLASS_PANE) {
            return;
        }
        if (!e.getClickedInventory().getName().equals(this.c(this.digitalAuth.getConfig().getString("guis.enter-code-title")))) {
            return;
        }
        Player player = (Player)e.getWhoClicked();
        UUID playerUUID = player.getUniqueId();
        String number = String.valueOf(e.getCurrentItem().getAmount());
        if (!this.enteredPin.containsKey(playerUUID)) {
            this.enteredPin.put(playerUUID, number);
        } else {
            this.enteredPin.put(playerUUID, this.enteredPin.get(playerUUID) + number);
        }
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BASS.playSound(), 10.0f, 29.0f);
        if (e.getCurrentItem().getType() == Material.LAVA_BUCKET) {
            this.enteringBackupCode.add(player);
            player.sendMessage(this.c(this.digitalAuth.getConfig().getString("messages.enter-backup-code")));
            player.closeInventory();
            this.enteredPin.remove(playerUUID);
            return;
        }
        if (this.enteredPin.get(playerUUID).length() != 4) {
            return;
        }
        String code = String.valueOf(this.digitalAuth.getAuthenticationCode(player));
        if (!this.digitalAuth.hasAuthenticationData(player)) {
            this.digitalAuth.setAuthenticationCode(player, Integer.valueOf(this.enteredPin.get(playerUUID)));
            this.digitalAuth.setBackupCode(player, InventoryHandlers.BackupCodeCreator());
            this.digitalAuth.getAuthenticatedPlayers().add(player);
            this.enteredPin.remove(playerUUID);
            player.closeInventory();
            this.digitalAuth.saveUserdata();
            player.sendMessage(this.c(Lang.NEW_CODE_CREATED.get().replaceAll("%backup-code%", this.digitalAuth.getBackupCode(player))));
            this.digitalAuth.getTitleUtil().sendTitle(player, this.digitalAuth.getConfig().getString("titles.code-created-title"), this.digitalAuth.getConfig().getString("titles.code-created-subtitle").replaceAll("%code%", String.valueOf(this.digitalAuth.getAuthenticationCode(player))));
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP.playSound(), 10.0f, 29.0f);
            return;
        }
        if (this.enteredPin.get(playerUUID).equals(code)) {
            this.digitalAuth.getAuthenticatedPlayers().add(player);
            this.digitalAuth.getTitleUtil().sendTitle(player, this.digitalAuth.getConfig().getString("titles.successfully-authenticated-title"), this.digitalAuth.getConfig().getString("titles.successfully-authenticated-subtitle"));
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP.playSound(), 10.0f, 29.0f);
        } else {
            player.sendMessage(this.c(Lang.INCORRECT_AUTHENTICATION_CODE.get()));
            this.digitalAuth.getTitleUtil().sendTitle(player, this.digitalAuth.getConfig().getString("titles.incorrect-authentication-code-title"), this.digitalAuth.getConfig().getString("titles.incorrect-authentication-code-subtitle"));
            player.playSound(player.getLocation(), Sound.ANVIL_USE.playSound(), 10.0f, 29.0f);
        }
        this.enteredPin.remove(playerUUID);
        player.closeInventory();
    }

    @EventHandler
    public void onDefaultInventory(InventoryClickEvent e) {
        if (e.getInventory() == null || e.getInventory().getName() == null) {
            return;
        }
        if (!e.getInventory().getName().equals(this.c(this.digitalAuth.getConfig().getString("guis.enter-code-title")))) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent e) {
        Player player = e.getPlayer();
        if ((e.getPlayer().hasPermission("digitalauth.requireauthentication") || e.getPlayer().isOp()) && !this.digitalAuth.getAuthenticatedPlayers().contains(e.getPlayer())) {
            if (this.enteringBackupCode.contains(player)) {
                if (e.getMessage().equalsIgnoreCase(this.digitalAuth.getBackupCode(player))) {
                    player.sendMessage(this.c(this.digitalAuth.getConfig().getString("messages.correct-backup-code")));
                    this.digitalAuth.getUserData().set("players." + player.getUniqueId(), null);
                    this.digitalAuth.saveUserdata();
                    this.digitalAuth.getUserAuthenticateGUI().createAuthenticationGUI(player);
                    this.enteringBackupCode.remove(player);
                    return;
                }
                player.sendMessage(this.c(this.digitalAuth.getConfig().getString("messages.incorrect-backup-code")));
                return;
            }
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onChatReceive(AsyncPlayerChatEvent e) {
        for (Player target : e.getRecipients()) {
            if (!target.hasPermission("digitalauth.requireauthentication") && !target.isOp() || this.digitalAuth.getAuthenticatedPlayers().contains(target)) continue;
            e.getRecipients().remove(target);
        }
    }

    @EventHandler
    public void onCloseInv(InventoryCloseEvent e) {
        if (e.getInventory() == null || e.getInventory().getName() == null) {
            return;
        }
        if (!e.getInventory().getName().equals(this.c(this.digitalAuth.getConfig().getString("guis.enter-code-title")))) {
            return;
        }
        if (this.enteredPin == null || !this.enteredPin.containsKey(e.getPlayer().getUniqueId())) {
            return;
        }
        this.enteredPin.remove(e.getPlayer().getUniqueId());
    }

    private String c(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    private static String BackupCodeCreator() {
        StringBuilder builder = new StringBuilder();
        int length = 8;
        while (length-- != 0) {
            int character = (int)(Math.random() * (double)ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }
}

