/*
 * Decompiled with CFR 0.152.
 */
package me.itsalfie.digitalauth.Events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.itsalfie.digitalauth.DigitalAuth;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;

public class InventoryClickEvent
implements Listener {
    private DigitalAuth digitalAuth;
    private Map<UUID, String> enteredPin = new HashMap<UUID, String>();
    private ArrayList<Player> enteringBackupCode = new ArrayList();
    private static final String ALPHA_NUMERIC_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public InventoryClickEvent(DigitalAuth digitalAuth) {
        this.digitalAuth = digitalAuth;
    }

    @EventHandler
    public void inventoryClick(org.bukkit.event.inventory.InventoryClickEvent e) {
        ItemStack item = e.getCurrentItem();
        Material material = item.getType();
        Player player = (Player)e.getWhoClicked();
        UUID playerUUID = player.getUniqueId();
        String code = String.valueOf(this.digitalAuth.getAuthenticationCode(player));
        if (e.getClickedInventory() == null || e.getClickedInventory().getName() == null) {
            return;
        }
        if (e.getClick().isShiftClick() || item.getType() == Material.AIR || item.getType() == Material.STAINED_GLASS_PANE) {
            return;
        }
        String number = String.valueOf(e.getCurrentItem().getAmount());
        if (!this.enteredPin.containsKey(playerUUID)) {
            this.enteredPin.put(playerUUID, number);
        } else {
            this.enteredPin.put(playerUUID, this.enteredPin.get(playerUUID) + number);
        }
        if (e.getClickedInventory().getName().equals(this.digitalAuth.getConfig().getString("guis.enter-code-title")) || e.getClickedInventory().getName().equals(this.digitalAuth.getConfig().getString("guis.enter-code-title"))) {
            e.setCancelled(true);
        }
        if (!material.equals((Object)Material.LAVA_BUCKET)) {
            if (this.enteredPin.get(playerUUID).length() == 4) {
                if (e.getClickedInventory().getName().equals(this.c("Enter Auth Code"))) {
                    if (this.enteredPin.get(playerUUID).equals(code)) {
                        this.digitalAuth.getAuthenticatedPlayers().add(player);
                        this.enteredPin.remove(playerUUID);
                        player.closeInventory();
                        this.enteredPin.remove(playerUUID);
                        this.digitalAuth.getAuthenticatedPlayers().add(player);
                        this.digitalAuth.getTitleUtil().sendTitle(player, this.digitalAuth.getConfig().getString("titles.successfully-authenticated-title"), this.digitalAuth.getConfig().getString("titles.successfully-authenticated-subtitle"));
                        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 10.0f, 29.0f);
                        this.enteredPin.remove(player.getUniqueId());
                    } else {
                        player.sendMessage(this.c(this.digitalAuth.getConfig().getString("messages.incorrect-authentication-code")));
                        this.enteredPin.remove(playerUUID);
                        player.closeInventory();
                        this.enteredPin.remove(player.getUniqueId());
                    }
                } else if (e.getClickedInventory().getName().equals(this.c(this.digitalAuth.getConfig().getString("guis.create-code-title")))) {
                    this.digitalAuth.setAuthenticationCode(player, Integer.valueOf(this.enteredPin.get(playerUUID)));
                    this.digitalAuth.setBackupCode(player, InventoryClickEvent.BackupCodeCreator());
                    this.digitalAuth.getAuthenticatedPlayers().add(player);
                    this.enteredPin.remove(playerUUID);
                    player.closeInventory();
                    this.digitalAuth.saveUserdata();
                    player.sendMessage(this.c(this.digitalAuth.getConfig().getString("messages.new-code-created").replaceAll("%backup-code%", this.digitalAuth.getBackupCode(player))));
                    this.digitalAuth.getTitleUtil().sendTitle(player, this.digitalAuth.getConfig().getString("titles.code-created-title"), this.digitalAuth.getConfig().getString("titles.code-created-subtitle").replaceAll("%code%", String.valueOf(this.digitalAuth.getAuthenticationCode(player))));
                    player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 10.0f, 29.0f);
                    this.enteredPin.remove(player.getUniqueId());
                }
            }
        } else {
            this.enteringBackupCode.add(player);
            player.sendMessage(this.c(this.digitalAuth.getConfig().getString("messages.enter-backup-code")));
            player.closeInventory();
            this.enteredPin.remove(player.getUniqueId());
        }
    }

    @EventHandler
    public void onDefaultInventory(org.bukkit.event.inventory.InventoryClickEvent e) {
        if (e.getInventory() == null || e.getInventory().getName() == null) {
            return;
        }
        if (!e.getInventory().getName().equals(this.c("Enter Auth Code"))) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent e) {
        Player player = e.getPlayer();
        if ((e.getPlayer().hasPermission("digitalauth.requireauthentication") || e.getPlayer().isOp()) && !this.digitalAuth.getAuthenticatedPlayers().contains(e.getPlayer())) {
            if (this.enteringBackupCode.contains(player)) {
                if (e.getMessage().equalsIgnoreCase(this.digitalAuth.getBackupCode(player))) {
                    player.sendMessage(this.c(this.digitalAuth.getConfig().getString("messages.correct-backup-code")));
                    this.digitalAuth.getUserAuthenticateGUI().createAuthenticationGUI(player);
                    return;
                }
                player.sendMessage(this.c(this.digitalAuth.getConfig().getString("messages.incorrect-backup-code")));
                return;
            }
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onChatReceive(AsyncPlayerChatEvent e) {
        for (Player target : e.getRecipients()) {
            if (!target.hasPermission("digitalauth.requireauthentication") && !target.isOp() || this.digitalAuth.getAuthenticatedPlayers().contains(target)) continue;
            e.getRecipients().remove(target);
        }
    }

    private String c(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    private static String BackupCodeCreator() {
        StringBuilder builder = new StringBuilder();
        int length = 8;
        while (length-- != 0) {
            int character = (int)(Math.random() * (double)ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }
}

