/*
 * Decompiled with CFR 0.152.
 */
package me.itsalfie.digitalauth;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import me.itsalfie.digitalauth.Commands.AuthCommand;
import me.itsalfie.digitalauth.Commands.DACommand;
import me.itsalfie.digitalauth.Events.CancelledEvents;
import me.itsalfie.digitalauth.Events.InventoryHandlers;
import me.itsalfie.digitalauth.Events.JLEvent;
import me.itsalfie.digitalauth.GUIs.UserAuthenticateGUI;
import me.itsalfie.digitalauth.Utils.TitleUtil;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DigitalAuth
extends JavaPlugin {
    private InventoryHandlers inventoryClickEvent;
    private UserAuthenticateGUI userAuthenticateGUI;
    private TitleUtil titleUtil;
    private File userdata;
    private FileConfiguration userdataConfig;
    private ArrayList<Player> authenticatedPlayers = new ArrayList();

    public void onEnable() {
        this.inventoryClickEvent = new InventoryHandlers(this);
        this.userAuthenticateGUI = new UserAuthenticateGUI(this);
        this.titleUtil = new TitleUtil();
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
        this.createFiles();
        this.saveUserdata();
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryHandlers(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CancelledEvents(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JLEvent(this), (Plugin)this);
        this.getCommand("auth").setExecutor((CommandExecutor)new AuthCommand(this));
        this.getCommand("da").setExecutor((CommandExecutor)new DACommand(this));
    }

    public void onDisable() {
    }

    private void createFiles() {
        this.userdata = new File(this.getDataFolder(), "users.yml");
        if (!this.userdata.exists()) {
            this.userdata.getParentFile().mkdirs();
            this.saveResource("users.yml", false);
        }
        this.userdataConfig = new YamlConfiguration();
        try {
            this.userdataConfig.load(this.userdata);
        }
        catch (IOException | InvalidConfigurationException exception) {
            this.getLogger().warning("Cannot load users.yml configuration file.");
        }
    }

    public void saveUserdata() {
        try {
            this.userdataConfig.save(this.userdata);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public InventoryHandlers getInventoryClickEvent() {
        return this.inventoryClickEvent;
    }

    public FileConfiguration getUserData() {
        return this.userdataConfig;
    }

    public UserAuthenticateGUI getUserAuthenticateGUI() {
        return this.userAuthenticateGUI;
    }

    public TitleUtil getTitleUtil() {
        return this.titleUtil;
    }

    public ArrayList<Player> getAuthenticatedPlayers() {
        return this.authenticatedPlayers;
    }

    public boolean hasAuthenticationData(Player player) {
        return this.getUserData().getString("players." + player.getUniqueId()) != null;
    }

    public int getAuthenticationCode(Player player) {
        return this.getUserData().getInt("players." + player.getUniqueId() + ".code");
    }

    public String getBackupCode(Player player) {
        return this.getUserData().getString("players." + player.getUniqueId() + ".backup-code");
    }

    public void setAuthenticationCode(Player player, int code) {
        this.getUserData().set("players." + player.getUniqueId() + ".code", (Object)code);
        this.saveUserdata();
    }

    public void setBackupCode(Player player, String backupCode) {
        this.getUserData().set("players." + player.getUniqueId() + ".backup-code", (Object)backupCode);
        this.saveUserdata();
    }

    public void resetPlayerData(Player player) {
        this.getUserData().set("players." + player.getUniqueId(), null);
    }
}

