/*
 * Decompiled with CFR 0.152.
 */
package me.itsalfie.digitalauth.Commands;

import me.itsalfie.digitalauth.DigitalAuth;
import me.itsalfie.digitalauth.Utils.Lang;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class DACommand
implements CommandExecutor {
    private DigitalAuth digitalAuth;

    public DACommand(DigitalAuth digitalAuth) {
        this.digitalAuth = digitalAuth;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length >= 1) {
            Player commandTarget = Bukkit.getPlayer((String)args[1]);
            switch (args[0].toLowerCase()) {
                default: {
                    sender.sendMessage(Lang.INCORRECT_USAGE.get());
                    break;
                }
                case "resetcode": {
                    if (!(sender.hasPermission("digitalauth.resetcode.others") || sender.isOp() || sender instanceof ConsoleCommandSender)) {
                        sender.sendMessage(Lang.NO_PERMISSION.get());
                        return false;
                    }
                    if (commandTarget == null) {
                        sender.sendMessage(Lang.PLAYER_NOT_ONLINE.get());
                        return false;
                    }
                    if (!commandTarget.hasPermission("digtialauth.requireauthentication") && !commandTarget.isOp()) {
                        sender.sendMessage(Lang.PLAYER_DOES_NOT_NEED_AUTHENTICATION.get());
                        return false;
                    }
                    this.digitalAuth.getAuthenticatedPlayers().remove(commandTarget);
                    this.digitalAuth.resetPlayerData(commandTarget);
                    this.digitalAuth.saveUserdata();
                    sender.sendMessage(Lang.ADMIN_SENT_CODE_RESET.get().replaceAll("%player%", args[1]));
                    commandTarget.sendMessage(Lang.ADMIN_RESET_PLAYER_CODE.get());
                    break;
                }
                case "info": {
                    if (!(sender.hasPermission("digitalauth.viewinfo.others") || sender.isOp() || sender instanceof ConsoleCommandSender)) {
                        sender.sendMessage(Lang.NO_PERMISSION.get());
                        return false;
                    }
                    if (commandTarget == null) {
                        sender.sendMessage(Lang.PLAYER_NOT_ONLINE.get().replaceAll("%player%", args[1]));
                        return false;
                    }
                    if (!this.digitalAuth.hasAuthenticationData(commandTarget)) {
                        sender.sendMessage(Lang.PLAYER_HAS_NO_AUTH_DATA.get());
                        return false;
                    }
                    String authCode = String.valueOf(this.digitalAuth.getAuthenticationCode(commandTarget));
                    String backupCode = this.digitalAuth.getBackupCode(commandTarget);
                    String commandTargetInfo = Lang.PLAYER_INFO.get().replaceAll("%player%", commandTarget.getName()).replaceAll("%code%", authCode).replaceAll("%backup-code%", backupCode);
                    sender.sendMessage(commandTargetInfo);
                }
            }
            return false;
        }
        this.helpMessage(sender);
        return false;
    }

    private void helpMessage(CommandSender sender) {
        sender.sendMessage(this.colour("&8&l&m--|--------------[&r &c&lDigitalAuth &8&l&m]--------------|--"));
        sender.sendMessage("");
        sender.sendMessage(this.colour("&c- &7Aliases: &cda, digitalauth, digitalauthentication"));
        sender.sendMessage(this.colour("&c- &7Author: &cItsAlfie"));
        sender.sendMessage(this.colour(""));
        sender.sendMessage(this.colour("&c- &7/da help"));
        sender.sendMessage(this.colour("&c- &7/da resetcode (player)"));
        sender.sendMessage(this.colour("&c- &7/da info (player)"));
        sender.sendMessage(this.colour(""));
        sender.sendMessage(this.colour("&8&l&m--|----------------------------------------|--"));
    }

    private String colour(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }
}

