/*
 * Decompiled with CFR 0.152.
 */
package me.olipulse.deathtotems.EventListeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import me.olipulse.deathtotems.DeathTotem.DeathTotem;
import me.olipulse.deathtotems.DeathTotems;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class EventListenerClass
implements Listener {
    private static DeathTotems plugin;
    private static BukkitScheduler scheduler;
    private static HashMap<UUID, Inventory> pendingInventories;
    private static HashMap<UUID, Integer> pendingTimers;
    private static HashMap<UUID, DeathTotem> pendingDeathTotems;
    private static Material deathTotemMaterial;
    private static List<Particle> particles;
    private static Random random;
    private String customPrefix;

    public EventListenerClass(DeathTotems plugin) {
        EventListenerClass.plugin = plugin;
        this.customPrefix = plugin.getConfig().getString("chat-prefix");
        pendingInventories = new HashMap();
        pendingTimers = new HashMap();
        pendingDeathTotems = new HashMap();
        scheduler = plugin.getServer().getScheduler();
        String materialString = plugin.getConfig().getString("death-totem-material");
        if (materialString != null) {
            deathTotemMaterial = Material.getMaterial((String)materialString);
        }
        particles = new ArrayList<Particle>();
        random = new Random();
        EventListenerClass.setupParticles();
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent e) {
        Player player = e.getEntity();
        if (!player.hasPermission("deathtotems.bypass")) {
            PlayerInventory inventory = player.getInventory();
            UUID playerUUID = player.getUniqueId();
            if (!pendingDeathTotems.containsKey(playerUUID) && this.inventoryHasItems((Inventory)player.getInventory())) {
                FileConfiguration config = plugin.getConfig();
                String deathMessage = config.getString("death-message");
                String customPrefix = config.getString("chat-prefix");
                if (deathMessage != null) {
                    deathMessage = deathMessage.replaceAll("%POSITION_X%", (int)player.getLocation().getX() + "");
                    deathMessage = deathMessage.replaceAll("%POSITION_Y%", (int)player.getLocation().getY() + "");
                    deathMessage = deathMessage.replaceAll("%POSITION_Z%", (int)player.getLocation().getZ() + "");
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(customPrefix + deathMessage)));
                    String hologram = config.getString("death-totem-hologram");
                    if (hologram != null) {
                        hologram = ChatColor.translateAlternateColorCodes((char)'&', (String)hologram.replaceAll("%PLAYER%", player.getName()));
                    }
                    DeathTotem deathTotem = new DeathTotem(e.getEntity().getLocation(), (Inventory)inventory, player, deathTotemMaterial, hologram);
                    pendingDeathTotems.put(playerUUID, deathTotem);
                    Inventory pendingInventory = Bukkit.createInventory((InventoryHolder)inventory.getHolder(), (InventoryType)inventory.getType());
                    pendingInventory.setContents(inventory.getContents());
                    pendingInventories.put(playerUUID, pendingInventory);
                    this.startTimer(player);
                    inventory.clear();
                }
            }
        }
    }

    @EventHandler
    public void onDeathTotemInteract(PlayerInteractEvent e) {
        DeathTotem deathTotem;
        if (e.getHand() != null && e.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        if (e.getClickedBlock() != null && e.getClickedBlock().getType() == deathTotemMaterial && (deathTotem = EventListenerClass.getPendingDeathTotems(e.getClickedBlock().getLocation())) != null) {
            FileConfiguration config = plugin.getConfig();
            Player player = e.getPlayer();
            if (deathTotem.getPlayer() == player) {
                if (e.useInteractedBlock() == Event.Result.DENY) {
                    e.setUseInteractedBlock(Event.Result.ALLOW);
                }
                String deathTotemMessage = config.getString("death-totem-message");
                String customPrefix = config.getString("chat-prefix");
                if (deathTotemMessage != null) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(customPrefix + deathTotemMessage)));
                    deathTotem.delete();
                    deathTotem.dropItems();
                    UUID playerUUID = player.getUniqueId();
                    pendingDeathTotems.remove(playerUUID);
                    pendingInventories.remove(playerUUID);
                    EventListenerClass.stopPlayersCurrentTimer(player);
                    pendingTimers.remove(playerUUID);
                    e.setCancelled(true);
                    EventListenerClass.playAnimationAndSound(player, deathTotem.getLocation());
                }
            } else {
                String invalidDeathTotemMessage = config.getString("invalid-death-totem-message");
                if (invalidDeathTotemMessage != null) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.customPrefix + invalidDeathTotemMessage)));
                }
                e.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        UUID playerUUID = player.getUniqueId();
        if (pendingDeathTotems.containsKey(playerUUID)) {
            EventListenerClass.removePlayerFromPendingHashMaps(player);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onDeathTotemExplode(EntityExplodeEvent e) {
        ArrayList<Block> deathTotems = new ArrayList<Block>();
        for (DeathTotem deathTotem : pendingDeathTotems.values()) {
            for (Block block : e.blockList()) {
                if (!deathTotem.isDeathTotem(block.getLocation())) continue;
                deathTotems.add(block);
            }
        }
        e.blockList().removeAll(deathTotems);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onDeathTotemExtendedByPiston(BlockPistonExtendEvent e) {
        for (DeathTotem deathTotem : pendingDeathTotems.values()) {
            for (Block block : e.getBlocks()) {
                if (!deathTotem.isDeathTotem(block.getLocation())) continue;
                e.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onDeathTotemRetractedByPiston(BlockPistonRetractEvent e) {
        for (DeathTotem deathTotem : pendingDeathTotems.values()) {
            for (Block block : e.getBlocks()) {
                if (!deathTotem.isDeathTotem(block.getLocation())) continue;
                e.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onDeathTotemBurn(BlockBurnEvent e) {
        for (DeathTotem deathTotem : pendingDeathTotems.values()) {
            if (!deathTotem.isDeathTotem(e.getBlock().getLocation())) continue;
            e.setCancelled(true);
            return;
        }
    }

    public boolean inventoryHasItems(Inventory inventory) {
        for (ItemStack item : inventory) {
            if (item == null) continue;
            return true;
        }
        return false;
    }

    public void startTimer(Player player) {
        FileConfiguration config = plugin.getConfig();
        Runnable runnable = () -> this.lambda$startTimer$0(player, (Configuration)config);
        long time = config.getLong("recover-timer") * 20L;
        int id = scheduler.runTaskLater((Plugin)plugin, runnable, time).getTaskId();
        UUID playerUUID = player.getUniqueId();
        pendingTimers.put(playerUUID, id);
    }

    public static boolean removePlayerFromPendingHashMaps(Player player) {
        boolean deleted = false;
        UUID playerUUID = player.getUniqueId();
        pendingInventories.remove(playerUUID);
        EventListenerClass.stopPlayersCurrentTimer(player);
        pendingTimers.remove(playerUUID);
        if (pendingDeathTotems.containsKey(playerUUID)) {
            deleted = pendingDeathTotems.get(playerUUID).delete();
        }
        pendingDeathTotems.remove(playerUUID);
        return deleted;
    }

    public static void stopPlayersCurrentTimer(Player player) {
        UUID playerUUID = player.getUniqueId();
        if (pendingTimers.get(playerUUID) != null && scheduler.isQueued(pendingTimers.get(playerUUID).intValue())) {
            scheduler.cancelTask(pendingTimers.get(playerUUID).intValue());
        }
    }

    public static HashMap<UUID, Inventory> getPendingInventories() {
        return pendingInventories;
    }

    public static HashMap<UUID, Integer> getPendingTimers() {
        return pendingTimers;
    }

    public static HashMap<UUID, DeathTotem> getPendingDeathTotems() {
        return pendingDeathTotems;
    }

    public static DeathTotem getPendingDeathTotems(Location location) {
        for (DeathTotem deathTotem : pendingDeathTotems.values()) {
            if (!deathTotem.isDeathTotem(location)) continue;
            return deathTotem;
        }
        return null;
    }

    public static void setupParticles() {
        particles.add(Particle.TOTEM);
        particles.add(Particle.SMOKE_LARGE);
        particles.add(Particle.END_ROD);
        particles.add(Particle.FLAME);
        particles.add(Particle.NAUTILUS);
        particles.add(Particle.PORTAL);
        particles.add(Particle.FIREWORKS_SPARK);
        particles.add(Particle.SPELL_WITCH);
        particles.add(Particle.SPELL);
        particles.add(Particle.VILLAGER_HAPPY);
        particles.add(Particle.EXPLOSION_NORMAL);
        particles.add(Particle.CLOUD);
        particles.add(Particle.LAVA);
        particles.add(Particle.SQUID_INK);
    }

    public static void playAnimationAndSound(Player player, Location totemLocation) {
        player.playSound(player.getLocation(), Sound.ITEM_TOTEM_USE, 0.1f, random.nextFloat() + 0.5f);
        World world = totemLocation.getWorld();
        Location location = new Location(world, totemLocation.getX(), totemLocation.getY() + 0.5, totemLocation.getZ());
        if (world != null) {
            Particle particle = particles.get(random.nextInt(particles.size()));
            for (int i = 0; i < 10; ++i) {
                world.spawnParticle(particle, location, 3, 1.0, 0.5, 1.0, 0.1, null, false);
            }
        }
    }

    private /* synthetic */ void lambda$startTimer$0(Player player, Configuration config) {
        String timeUpMessage;
        if (EventListenerClass.removePlayerFromPendingHashMaps(player) && (timeUpMessage = config.getString("time-up-message")) != null) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.customPrefix + timeUpMessage)));
        }
    }
}

