/*
 * Decompiled with CFR 0.152.
 */
package me.olipulse.deathtotems;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Logger;
import me.olipulse.deathtotems.Commands.CommandClass;
import me.olipulse.deathtotems.EventListeners.EventListenerClass;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class DeathTotems
extends JavaPlugin {
    private static final Logger log = Logger.getLogger("Minecraft");
    private static Economy economy = null;
    private static CommandClass commandClass;
    private static EventListenerClass eventListenerClass;

    public void onEnable() {
        this.saveDefaultConfig();
        if (!this.setupEconomy()) {
            log.severe(String.format("[%s] - Disabled due to no Vault dependency found!", this.getDescription().getName()));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        commandClass = new CommandClass(this, economy);
        Objects.requireNonNull(this.getCommand("dt")).setExecutor((CommandExecutor)commandClass);
        Objects.requireNonNull(this.getCommand("restore")).setExecutor((CommandExecutor)commandClass);
        eventListenerClass = new EventListenerClass(this);
        this.getServer().getPluginManager().registerEvents((Listener)eventListenerClass, (Plugin)this);
        for (World world : Bukkit.getWorlds()) {
            world.setGameRule(GameRule.KEEP_INVENTORY, (Object)true);
        }
        this.getServer().getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("Enabled &b[&3DeathTotems&b] &8v" + this.getDescription().getVersion() + "&r - by &9OliPulse")));
    }

    public void onDisable() {
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        economy = (Economy)rsp.getProvider();
        return true;
    }

    public void reloadPlugin() {
        commandClass = new CommandClass(this, economy);
        ArrayList pendingPlayerUUIDs = Lists.newArrayList(EventListenerClass.getPendingDeathTotems().keySet());
        String timeUpMessage = this.getConfig().getString("time-up-message");
        for (UUID playerUUID : pendingPlayerUUIDs) {
            Player player = Bukkit.getPlayer((UUID)playerUUID);
            if (player == null) continue;
            if (timeUpMessage != null) {
                String customPrefix = this.getConfig().getString("chat-prefix");
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(customPrefix + timeUpMessage)));
            }
            EventListenerClass.removePlayerFromPendingHashMaps(player);
        }
        eventListenerClass = new EventListenerClass(this);
        for (World world : Bukkit.getWorlds()) {
            world.setGameRule(GameRule.KEEP_INVENTORY, (Object)true);
        }
    }
}

