/*
 * Decompiled with CFR 0.152.
 */
package me.olipulse.deathtotems.DeathTotem;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class DeathTotem {
    private Location location;
    private Inventory inventory;
    private List<ItemStack> items;
    private Player player;
    private Material material;
    private ArmorStand marker;
    private BlockData previousBlock;

    public DeathTotem(Location location, Inventory inventory, Player player, Material material, String hologram) {
        if (location.getX() < 0.0) {
            location.setX(location.getX() - 1.0);
        }
        if (location.getZ() < 0.0) {
            location.setZ(location.getZ() - 1.0);
        }
        this.location = new Location(location.getWorld(), (double)((int)location.getX()), (double)((int)location.getY()), (double)((int)location.getZ()));
        this.previousBlock = this.location.getBlock().getBlockData().clone();
        this.inventory = inventory;
        this.items = Arrays.asList(inventory.getContents());
        this.items = this.items.stream().filter(Objects::nonNull).collect(Collectors.toList());
        this.player = player;
        this.material = material;
        this.spawn(hologram);
    }

    public void spawn(String hologram) {
        this.location.getBlock().setType(this.material);
        this.displayMarker(hologram);
    }

    public boolean isDeathTotem(Location location) {
        return location.equals((Object)this.location);
    }

    public boolean delete() {
        this.restoreReplacedBlocks();
        this.deleteMarker();
        return true;
    }

    public void dropItems() {
        World world = this.location.getWorld();
        if (world != null) {
            for (ItemStack item : this.items) {
                world.dropItemNaturally(this.location, item);
            }
        }
    }

    public void displayMarker(String hologram) {
        this.marker = (ArmorStand)Objects.requireNonNull(this.location.getWorld()).spawnEntity(new Location(this.location.getWorld(), this.location.getX() + 0.5, this.location.getY() + 0.9, this.location.getZ() + 0.5), EntityType.ARMOR_STAND);
        this.marker.setVisible(false);
        this.marker.setCustomName(hologram);
        this.marker.setCustomNameVisible(true);
        this.marker.setSmall(true);
        this.marker.setInvulnerable(true);
        this.marker.setGravity(false);
        this.marker.setBasePlate(false);
        this.marker.setMarker(true);
    }

    public void deleteMarker() {
        this.marker.remove();
        Collection entities = Objects.requireNonNull(this.location.getWorld()).getNearbyEntities(new Location(this.location.getWorld(), this.location.getX() + 0.5, this.location.getY() + 0.9, this.location.getZ() + 0.5), 0.1, 0.1, 0.1);
        for (Entity entity : entities) {
            if (!(entity instanceof ArmorStand) || !((ArmorStand)entity).isMarker()) continue;
            entity.remove();
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public void restoreReplacedBlocks() {
        this.location.getBlock().setType(Material.AIR);
        this.location.getBlock().setBlockData(this.previousBlock);
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public Location getLocation() {
        return this.location;
    }
}

