/*
 * Decompiled with CFR 0.152.
 */
package com.monstersacrifice;

import com.monstersacrifice.DeathItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class DeathSignsManager
implements Listener,
CommandExecutor {
    HashMap<UUID, List<ItemStack>> signs = new HashMap();
    HashMap<Block, UUID> locations = new HashMap();
    HashMap<UUID, UUID> players = new HashMap();
    HashMap<UUID, Long> deathTime = new HashMap();
    HashMap<UUID, Integer> xpDrops = new HashMap();
    DeathItems plugin;
    List<String> allowedWorlds = new ArrayList<String>();
    int timeout = 0;
    int protection_timeout = 0;
    int xp_drop_percentage = 0;

    public DeathSignsManager(DeathItems p) {
        this.plugin = p;
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        String worldName = event.getEntity().getLocation().getWorld().getName();
        if (this.allowedWorlds.contains(worldName)) {
            Location loc = event.getEntity().getLocation();
            if (loc.getY() < (double)loc.getWorld().getMinHeight()) {
                loc.setY((double)loc.getWorld().getMinHeight());
            }
            Block block = loc.getBlock();
            boolean found = true;
            if (loc.getBlock().getType() != Material.AIR) {
                found = false;
                int cx = loc.getBlockX() & 0xF;
                int cz = loc.getBlockZ() & 0xF;
                for (int i = block.getY(); i < loc.getWorld().getMaxHeight(); ++i) {
                    Block b = loc.getChunk().getBlock(cx, i, cz);
                    if (b.getType() != Material.AIR) continue;
                    block = b;
                    found = true;
                    break;
                }
            }
            if (found && event.getDrops().size() > 0) {
                Player player = event.getEntity().getPlayer();
                UUID signID = UUID.randomUUID();
                int xpAmount = event.getDroppedExp();
                event.setDroppedExp(0);
                this.signs.put(signID, new ArrayList(event.getDrops()));
                this.locations.put(block, signID);
                this.players.put(signID, player.getUniqueId());
                this.deathTime.put(signID, System.currentTimeMillis() / 1000L);
                this.xpDrops.put(signID, xpAmount);
                this.createSign(block.getWorld(), player.getName(), block);
                System.out.println("creating new sign location: " + loc.getX() + " " + loc.getY() + " " + loc.getZ() + " and id: " + signID);
                event.getDrops().clear();
            }
        }
    }

    public void createSign(World world, String name, Block block) {
        block.setType(Material.OAK_SIGN);
        Sign sign = (Sign)block.getState();
        sign.setLine(0, "DeathSign");
        sign.setLine(2, name);
        sign.update();
        block.getDrops().clear();
    }

    public void removeSign(UUID signID) {
        this.players.remove(signID);
        this.signs.remove(signID);
        this.deathTime.remove(signID);
        this.xpDrops.remove(signID);
        for (Block i : this.locations.keySet()) {
            if (!this.locations.get(i).equals(signID)) continue;
            i.setType(Material.AIR);
            this.locations.remove(i);
            break;
        }
    }

    public void check_delete() {
        for (Block block : this.locations.keySet()) {
            UUID signID = this.locations.get(block);
            if (System.currentTimeMillis() / 1000L - this.deathTime.get(signID) <= (long)this.timeout) continue;
            this.removeSign(signID);
            System.out.println("losing sign " + signID + ";" + block.getX() + " " + block.getY() + " " + block.getZ());
        }
    }

    private String adminSignClick(UUID signID) {
        String msg = ChatColor.BLUE + "===============Death Sign===============\n" + ChatColor.WHITE;
        msg = msg + "sign id: " + signID + "\n";
        float xpDrop = (float)this.xpDrops.get(signID).intValue() / 100.0f * (float)this.xp_drop_percentage;
        msg = msg + "xp amount: " + xpDrop;
        List<ItemStack> items = this.signs.get(signID);
        for (ItemStack i : items) {
            if (i == null) continue;
            msg = msg + "\n" + i.getType() + " \u00d7 " + i.getAmount();
        }
        return msg;
    }

    public void collect(Player player, UUID signID) {
        float xpDrop = (float)this.xpDrops.get(signID).intValue() / 100.0f * (float)this.xp_drop_percentage;
        player.giveExp((int)xpDrop);
        this.xpDrops.remove(signID);
        this.xpDrops.put(signID, 0);
        List<ItemStack> items = this.signs.get(signID);
        ArrayList<ItemStack> newInv = new ArrayList<ItemStack>();
        for (ItemStack i : items) {
            HashMap response;
            if (i == null || (response = player.getInventory().addItem(new ItemStack[]{i})).size() <= 0) continue;
            newInv.add((ItemStack)response.get(0));
        }
        if (newInv.size() == 0) {
            this.removeSign(signID);
        } else {
            this.signs.remove(signID);
            this.signs.put(signID, newInv);
        }
    }

    @EventHandler
    public void onSignClick(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        boolean admin = event.getPlayer().hasPermission("deathsigns.manage");
        if (event.getAction() == Action.LEFT_CLICK_BLOCK && block.getType() == Material.OAK_SIGN) {
            UUID signID = this.getUuidByBlock(block);
            if (signID != null && (player.getUniqueId().toString().equals(this.players.get(signID).toString()) || this.deathTime.get(signID) + (long)this.protection_timeout < System.currentTimeMillis() / 1000L)) {
                this.collect(player, signID);
            }
        } else if (event.getAction() == Action.RIGHT_CLICK_BLOCK && block.getType() == Material.OAK_SIGN && admin) {
            UUID signID = this.getUuidByBlock(block);
            player.sendMessage(this.adminSignClick(signID));
            TextComponent msg = new TextComponent("[Delete]");
            msg.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/remove-sign " + signID.toString()));
            msg.setColor(ChatColor.RED);
            player.spigot().sendMessage((BaseComponent)msg);
            msg = new TextComponent("[Collect]");
            msg.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/collect-sign " + signID.toString()));
            msg.setColor(ChatColor.GREEN);
            player.spigot().sendMessage((BaseComponent)msg);
            String s = ChatColor.BLUE + "========================================\n";
            player.sendMessage(s);
        }
    }

    @EventHandler
    public void onPhysicsEvent(BlockPhysicsEvent event) {
        if (this.breakCheck(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    public boolean breakCheck(Block block) {
        for (Block b : this.locations.keySet()) {
            Block target = b.getRelative(BlockFace.DOWN);
            if ((double)target.getX() != block.getLocation().getX() || (double)target.getY() != block.getLocation().getY() || (double)target.getZ() != block.getLocation().getZ()) continue;
            return true;
        }
        return false;
    }

    public UUID getUuidByBlock(Block b) {
        UUID signID = null;
        for (Block i : this.locations.keySet()) {
            if (b.getLocation().getX() != i.getLocation().getX() || b.getLocation().getY() != i.getLocation().getY() || b.getLocation().getZ() != i.getLocation().getZ() || b.getWorld() != i.getLocation().getWorld()) continue;
            signID = this.locations.get(i);
            break;
        }
        return signID;
    }

    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        if (strings.length > 0 && commandSender.hasPermission("deathsigns.manage")) {
            return this.onAdminCommand(commandSender, strings[0]);
        }
        ArrayList<UUID> signIDs = new ArrayList<UUID>();
        if (commandSender instanceof Player) {
            for (UUID i : this.players.keySet()) {
                if (!this.players.get(i).toString().equals(((Player)commandSender).getUniqueId().toString())) continue;
                signIDs.add(i);
            }
            Object returnString = ChatColor.BLUE + "===============Death Signs===============\n" + ChatColor.WHITE;
            if (signIDs.size() > 0) {
                for (UUID signID : signIDs) {
                    for (Block b : this.locations.keySet()) {
                        if (this.locations.get(b) != signID) continue;
                        Location loc = b.getLocation();
                        String timeLeft = this.plugin.get_string_from_time(this.deathTime.get(signID) + (long)this.timeout - System.currentTimeMillis() / 1000L);
                        returnString = (String)returnString + loc.getWorld().getName() + ": " + loc.getX() + " " + loc.getY() + " " + loc.getZ() + " --- time left: " + timeLeft + "\n";
                    }
                }
            } else {
                returnString = "you have no death signs";
            }
            commandSender.sendMessage((String)returnString);
            return true;
        }
        commandSender.sendMessage("you must be a player to view your own deathsigns");
        return false;
    }

    public boolean onAdminCommand(CommandSender commandSender, String playername) {
        Player p = Bukkit.getPlayer((String)playername);
        ArrayList<UUID> signIDs = new ArrayList<UUID>();
        for (UUID i : this.players.keySet()) {
            if (!this.players.get(i).toString().equals(p.getUniqueId().toString())) continue;
            signIDs.add(i);
        }
        Object returnString = ChatColor.BLUE + "===============Death Signs===============\n" + ChatColor.WHITE;
        if (signIDs.size() > 0) {
            for (UUID signID : signIDs) {
                for (Block b : this.locations.keySet()) {
                    if (this.locations.get(b) != signID) continue;
                    Location loc = b.getLocation();
                    String timeLeft = this.plugin.get_string_from_time(this.deathTime.get(signID) + (long)this.timeout - System.currentTimeMillis() / 1000L);
                    returnString = (String)returnString + loc.getWorld().getName() + ": " + loc.getX() + " " + loc.getY() + " " + loc.getZ() + " --- time left: " + timeLeft + "\n";
                }
            }
        } else {
            returnString = "they have no death signs";
        }
        commandSender.sendMessage((String)returnString);
        return true;
    }
}

