/*
 * Decompiled with CFR 0.152.
 */
package com.monstersacrifice;

import com.monstersacrifice.Collect;
import com.monstersacrifice.DeathSignsManager;
import com.monstersacrifice.Remove;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DeathItems
extends JavaPlugin {
    DeathSignsManager deathSignsManager = null;
    Remove remove = new Remove();
    Collect collect = new Collect();

    public void onEnable() {
        try {
            this.deathSignsManager = this.loadManager();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.remove.deathSignsManager = this.deathSignsManager;
        this.collect.deathSignsManager = this.deathSignsManager;
        this.getServer().getPluginManager().registerEvents((Listener)this.deathSignsManager, (Plugin)this);
        Objects.requireNonNull(this.getCommand("deathsigns")).setExecutor((CommandExecutor)this.deathSignsManager);
        Objects.requireNonNull(this.getCommand("remove-sign")).setExecutor((CommandExecutor)this.remove);
        Objects.requireNonNull(this.getCommand("collect-sign")).setExecutor((CommandExecutor)this.collect);
        this.saveDefaultConfig();
        try {
            this.load_config();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
            this.deathSignsManager.check_delete();
            this.onDisable();
        }, 0L, 20L);
        System.out.println("Death signs enabled");
    }

    public DeathSignsManager loadManager() throws IOException {
        File f = new File(this.getDataFolder() + File.separator + "config.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)f);
        boolean do_offline_count = Boolean.parseBoolean(String.valueOf(config.get("countdown-while-offline")));
        this.deathSignsManager = new DeathSignsManager(this);
        File file = new File(this.getDataFolder() + File.separator + "deathsigns.yml");
        YamlConfiguration deathsigns = YamlConfiguration.loadConfiguration((File)file);
        long addTime = 0L;
        if (deathsigns.getConfigurationSection("last-online") != null && !do_offline_count) {
            addTime = System.currentTimeMillis() / 1000L - (long)Integer.parseInt(String.valueOf(Objects.requireNonNull(deathsigns.getConfigurationSection("last-online")).get("seconds")));
            System.out.println("offline for " + addTime + " seconds");
        }
        if (deathsigns.getConfigurationSection("data") != null) {
            long finalAddTime = addTime;
            deathsigns.getConfigurationSection("data").getKeys(false).forEach(arg_0 -> this.lambda$loadManager$1((FileConfiguration)deathsigns, finalAddTime, arg_0));
        }
        return this.deathSignsManager;
    }

    public void onDisable() {
        File file = new File(this.getDataFolder() + File.separator + "deathsigns.yml");
        YamlConfiguration deathsigns = YamlConfiguration.loadConfiguration((File)file);
        for (String key : deathsigns.getKeys(false)) {
            deathsigns.set(key, null);
        }
        deathsigns.set("last-online.seconds", (Object)(System.currentTimeMillis() / 1000L));
        for (Block b : this.deathSignsManager.locations.keySet()) {
            UUID u = this.deathSignsManager.locations.get(b);
            UUID PlayerU = this.deathSignsManager.players.get(u);
            List<ItemStack> i = this.deathSignsManager.signs.get(u);
            String worldString = Objects.requireNonNull(b.getLocation().getWorld()).getUID() + "," + (int)b.getLocation().getX() + "," + (int)b.getLocation().getY() + "," + (int)b.getLocation().getZ();
            String key = u.toString() + "," + PlayerU + "," + worldString;
            key = key + "," + this.deathSignsManager.deathTime.get(u).toString() + "," + this.deathSignsManager.xpDrops.get(u);
            deathsigns.set("data." + key, i);
        }
        try {
            deathsigns.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load_config() throws IOException {
        File file = new File(this.getDataFolder() + File.separator + "config.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        for (String key : this.getConfig().getDefaults().getKeys(false)) {
            if (config.getKeys(false).contains(key)) continue;
            config.set(key, this.getConfig().getDefaults().get(key));
        }
        config.save(file);
        this.deathSignsManager.allowedWorlds.addAll((Collection)this.getConfig().get("allowed-worlds"));
        int timeoutTime = this.get_time_from_string(Objects.requireNonNull(this.getConfig().get("expire-time")).toString());
        int protTime = this.get_time_from_string(Objects.requireNonNull(this.getConfig().get("protection-time")).toString());
        int xpDropPer = 0;
        if (this.getConfig().get("drop-xp").toString().strip().equalsIgnoreCase("true")) {
            xpDropPer = 100;
        }
        this.deathSignsManager.xp_drop_percentage = xpDropPer;
        this.deathSignsManager.timeout = timeoutTime;
        this.deathSignsManager.protection_timeout = protTime;
    }

    public int get_time_from_string(String timeString) {
        int timeSignature = timeString.charAt(timeString.length() - 1);
        if (DeathItems.isNumeric(String.valueOf((char)timeSignature))) {
            return Integer.parseInt(timeString.strip());
        }
        int time = Integer.parseInt(timeString.substring(0, timeString.length() - 1));
        if (timeSignature == 104) {
            time *= 60;
            timeSignature = 109;
        }
        if (timeSignature == 109) {
            time *= 60;
        }
        return time;
    }

    public String get_string_from_time(Long timeLong) {
        Object time = "";
        time = (String)time + Math.floorDiv((long)timeLong, 3600) + "h ";
        timeLong = timeLong % 3600L;
        time = (String)time + Math.floorDiv((long)timeLong, 60) + "m ";
        timeLong = timeLong % 60L;
        time = (String)time + timeLong + "s";
        return time;
    }

    public static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private /* synthetic */ void lambda$loadManager$1(FileConfiguration deathsigns, long finalAddTime, String key) {
        String[] kSplit = key.split(",");
        UUID u = UUID.fromString(kSplit[0]);
        UUID playerID = UUID.fromString(kSplit[1]);
        List i = (List)deathsigns.get("data." + key);
        Block b = Objects.requireNonNull(Bukkit.getWorld((UUID)UUID.fromString(kSplit[2]))).getBlockAt(Integer.parseInt(kSplit[3]), Integer.parseInt(kSplit[4]), Integer.parseInt(kSplit[5]));
        long time = Long.parseLong(kSplit[6]);
        int xpdrops = Integer.parseInt(kSplit[7]);
        this.deathSignsManager.locations.put(b, u);
        this.deathSignsManager.signs.put(u, i);
        this.deathSignsManager.players.put(u, playerID);
        this.deathSignsManager.deathTime.put(u, time + finalAddTime);
        this.deathSignsManager.xpDrops.put(u, xpdrops);
    }
}

