/*
 * Decompiled with CFR 0.152.
 */
package mc.alessandroch.darkauction.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mc.alessandroch.darkauction.DarkAuction;
import mc.alessandroch.darkauction.api.DarkAuctionAPI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class GuiManager {
    public List<String> guinames = new ArrayList<String>();

    public GuiManager() {
        this.registerGuiName("DarkAuction [Menu]");
        this.registerGuiName("DarkAuction [Menu->Item List]");
        this.registerGuiName("DarkAuction [Menu->Add item]");
        this.registerGuiName("DarkAuction [Menu->Delete item List]");
        this.registerGuiName("DarkAuction [Menu->Give item List]");
    }

    public void openMainGui(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)9, (String)"DarkAuction [Menu]");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)DarkAuction.get(), () -> {
            inv.setItem(0, GuiManager.createGuiItem(Material.PAPER, "\u00a7eItem list", "\u00a77Open Item list page"));
            inv.setItem(1, GuiManager.createGuiItem(Material.LIME_DYE, "\u00a7eAdd new item", "\u00a77Add a new item into the", "\u00a77list by pressing an item", "\u00a77in your inventory"));
            inv.setItem(2, GuiManager.createGuiItem(Material.BARRIER, "\u00a7cRemove an item", "\u00a77Remove the item", "\u00a77you click in the list"));
            inv.setItem(3, GuiManager.createGuiItem(Material.ARROW, "\u00a7eGive an item", "\u00a77Give the item", "\u00a77you click in the list"));
            inv.setItem(4, GuiManager.createGuiItem(Material.OAK_SLAB, "\u00a7eSet location", "\u00a77Set the location", "\u00a77of the hologram"));
            inv.setItem(5, GuiManager.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, "\u00a77", new String[0]));
            inv.setItem(6, GuiManager.createGuiItem(Material.GREEN_DYE, "\u00a7aForce start", "\u00a77Force start the", "\u00a77auction"));
            inv.setItem(7, GuiManager.createGuiItem(Material.RED_DYE, "\u00a7cForce stop", "\u00a77Force stop the", "\u00a77auction"));
            inv.setItem(8, GuiManager.createGuiItem(Material.OAK_SIGN, "\u00a7eInformations", "\u00a77Plugin version: " + this.checkVersion(), "\u00a77Server version: \u00a7e" + Bukkit.getVersion(), "\u00a77API version: \u00a7e" + DarkAuction.get().apiversion));
        });
        player.openInventory(inv);
    }

    private String checkVersion() {
        if (DarkAuction.get().updater.updateCheckNewAvailable()) {
            return "\u00a7c" + DarkAuction.get().version + "\u00a7e\u00a7l NEW UPDATE AVAILABLE";
        }
        return "\u00a7a" + DarkAuction.get().version;
    }

    public void openAddGui(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)9, (String)"DarkAuction [Menu->Add item]");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)DarkAuction.get(), () -> {
            inv.setItem(0, GuiManager.createGuiItem(Material.BARRIER, "\u00a7cBack", new String[0]));
            inv.setItem(1, GuiManager.createGuiItem(Material.LIME_DYE, "\u00a7eAdd an item", "\u00a77Add an item by pressing", "\u00a77it in your inventory"));
        });
        player.openInventory(inv);
    }

    public void openListGui(Player player, int p) {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)"DarkAuction [Menu->Item List]");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)DarkAuction.get(), () -> {
            inv.setItem(this.getLoc(0, 2), GuiManager.createGuiItem(Material.PAPER, "\u00a7ePage back", new String[0]));
            inv.setItem(this.getLoc(4, 2), GuiManager.createGuiItem(Material.LIME_DYE, "\u00a7ePage number", "" + p));
            inv.setItem(this.getLoc(5, 2), GuiManager.createGuiItem(Material.BARRIER, "\u00a7cBack", new String[0]));
            inv.setItem(this.getLoc(8, 2), GuiManager.createGuiItem(Material.PAPER, "\u00a7ePage forward", new String[0]));
            int page = p - 1;
            int count = 18;
            int i = 0;
            while (i < 18) {
                try {
                    if (DarkAuction.get().allItems.size() >= i + count * page) {
                        ItemStack is = DarkAuction.get().allItems.get(i + count * page);
                        inv.setItem(i, is);
                    } else {
                        inv.setItem(i, GuiManager.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, "\u00a77", new String[0]));
                    }
                }
                catch (Exception e) {
                    inv.setItem(i, GuiManager.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, "\u00a77", new String[0]));
                }
                ++i;
            }
        });
        player.openInventory(inv);
    }

    public void openDeleteListGui(Player player, int p) {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)"DarkAuction [Menu->Delete item List]");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)DarkAuction.get(), () -> {
            inv.setItem(this.getLoc(0, 2), GuiManager.createGuiItem(Material.PAPER, "\u00a7ePage back", new String[0]));
            inv.setItem(this.getLoc(4, 2), GuiManager.createGuiItem(Material.LIME_DYE, "\u00a7ePage number", "" + p));
            inv.setItem(this.getLoc(5, 2), GuiManager.createGuiItem(Material.BARRIER, "\u00a7cBack", new String[0]));
            inv.setItem(this.getLoc(8, 2), GuiManager.createGuiItem(Material.PAPER, "\u00a7ePage forward", new String[0]));
            int page = p - 1;
            int count = 18;
            int i = 0;
            while (i < 18) {
                try {
                    if (DarkAuction.get().allItems.size() >= i + count * page) {
                        ItemStack is = DarkAuction.get().allItems.get(i + count * page);
                        inv.setItem(i, is);
                    } else {
                        inv.setItem(i, GuiManager.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, "\u00a77", new String[0]));
                    }
                }
                catch (Exception e) {
                    inv.setItem(i, GuiManager.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, "\u00a77", new String[0]));
                }
                ++i;
            }
        });
        player.openInventory(inv);
    }

    public void openGiveListGui(Player player, int p) {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)"DarkAuction [Menu->Give item List]");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)DarkAuction.get(), () -> {
            inv.setItem(this.getLoc(0, 2), GuiManager.createGuiItem(Material.PAPER, "\u00a7ePage back", new String[0]));
            inv.setItem(this.getLoc(4, 2), GuiManager.createGuiItem(Material.LIME_DYE, "\u00a7ePage number", "" + p));
            inv.setItem(this.getLoc(5, 2), GuiManager.createGuiItem(Material.BARRIER, "\u00a7cBack", new String[0]));
            inv.setItem(this.getLoc(8, 2), GuiManager.createGuiItem(Material.PAPER, "\u00a7ePage forward", new String[0]));
            int page = p - 1;
            int count = 18;
            int i = 0;
            while (i < 18) {
                try {
                    if (DarkAuction.get().allItems.size() >= i + count * page) {
                        ItemStack is = DarkAuction.get().allItems.get(i + count * page);
                        inv.setItem(i, is);
                    } else {
                        inv.setItem(i, GuiManager.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, "\u00a77", new String[0]));
                    }
                }
                catch (Exception e) {
                    inv.setItem(i, GuiManager.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, "\u00a77", new String[0]));
                }
                ++i;
            }
        });
        player.openInventory(inv);
    }

    public boolean checkPageAvailable(int pg, boolean forward) {
        if (forward) {
            int pgg = pg - 1;
            if (DarkAuction.get().allItems.size() > 18 * pgg) {
                return true;
            }
        } else if (pg > 1) {
            return true;
        }
        return false;
    }

    public int getLoc(int x, int y) {
        return 9 * y + x;
    }

    public void registerGuiName(String name) {
        this.guinames.add(name);
    }

    public void guiClick(String guiname, Player player, ItemStack item, Inventory inv) {
        String itemname = item.getItemMeta().getDisplayName();
        if (guiname.equals("DarkAuction [Menu]")) {
            if (itemname.equals("\u00a7eItem list")) {
                this.openListGui(player, 1);
            }
            if (itemname.equals("\u00a7eAdd new item")) {
                this.openAddGui(player);
            }
            if (itemname.equals("\u00a7cRemove an item")) {
                this.openDeleteListGui(player, 1);
            }
            if (itemname.equals("\u00a7eGive an item")) {
                this.openGiveListGui(player, 1);
            }
            if (itemname.equals("\u00a7eSet location")) {
                player.sendMessage("\u00a7eLocation changed correctly in your position!");
                DarkAuction.get().loc = player.getLocation().clone();
            }
            if (itemname.equals("\u00a7aForce start")) {
                player.closeInventory();
                if (!DarkAuction.get().isStarted) {
                    DarkAuctionAPI.startAuction();
                }
            }
            if (itemname.equals("\u00a7cForce stop")) {
                player.closeInventory();
                if (DarkAuction.get().isStarted) {
                    DarkAuctionAPI.stopAuction();
                }
            }
        } else if (guiname.equals("DarkAuction [Menu->Item List]")) {
            int pagenumber;
            if (itemname.equals("\u00a7cBack")) {
                this.openMainGui(player);
            }
            if (itemname.equals("\u00a7ePage back") && this.checkPageAvailable(pagenumber = Integer.parseInt((String)inv.getItem(this.getLoc(4, 2)).getItemMeta().getLore().get(0)), false)) {
                this.openListGui(player, pagenumber - 1);
            }
            if (itemname.equals("\u00a7ePage forward") && this.checkPageAvailable((pagenumber = Integer.parseInt((String)inv.getItem(this.getLoc(4, 2)).getItemMeta().getLore().get(0))) + 1, true)) {
                this.openListGui(player, pagenumber + 1);
            }
        } else if (guiname.equals("DarkAuction [Menu->Add item]")) {
            if (itemname.equals("\u00a7cBack")) {
                this.openMainGui(player);
            } else if (!itemname.equals("\u00a7eAdd an item")) {
                DarkAuction.get().allItems.add(item);
                player.sendMessage("\u00a7aItem added correctly!");
                this.openListGui(player, 1);
            }
        } else if (guiname.equals("DarkAuction [Menu->Delete item List]")) {
            if (itemname.equals("\u00a7cBack")) {
                this.openMainGui(player);
            } else if (itemname.equals("\u00a7ePage back")) {
                int pagenumber = Integer.parseInt((String)inv.getItem(this.getLoc(4, 2)).getItemMeta().getLore().get(0));
                if (this.checkPageAvailable(pagenumber, false)) {
                    this.openDeleteListGui(player, pagenumber - 1);
                }
            } else if (itemname.equals("\u00a7ePage forward")) {
                int pagenumber = Integer.parseInt((String)inv.getItem(this.getLoc(4, 2)).getItemMeta().getLore().get(0));
                if (this.checkPageAvailable(pagenumber + 1, true)) {
                    this.openDeleteListGui(player, pagenumber + 1);
                }
            } else if (!itemname.equals("\u00a7ePage number") && !itemname.equals("\u00a77")) {
                ItemMeta meta = item.getItemMeta();
                NamespacedKey pos = new NamespacedKey((Plugin)DarkAuction.get(), "position");
                int pagenumber = Integer.parseInt((String)inv.getItem(this.getLoc(4, 2)).getItemMeta().getLore().get(0));
                DarkAuction.get().allItems.remove(item);
                player.sendMessage("\u00a7cItem removed!");
                this.openDeleteListGui(player, pagenumber);
            }
        } else if (guiname.equals("DarkAuction [Menu->Give item List]")) {
            if (itemname.equals("\u00a7cBack")) {
                this.openMainGui(player);
            } else if (itemname.equals("\u00a7ePage back")) {
                int pagenumber = Integer.parseInt((String)inv.getItem(this.getLoc(4, 2)).getItemMeta().getLore().get(0));
                if (this.checkPageAvailable(pagenumber, false)) {
                    this.openGiveListGui(player, pagenumber - 1);
                }
            } else if (itemname.equals("\u00a7ePage forward")) {
                int pagenumber = Integer.parseInt((String)inv.getItem(this.getLoc(4, 2)).getItemMeta().getLore().get(0));
                if (this.checkPageAvailable(pagenumber + 1, true)) {
                    this.openGiveListGui(player, pagenumber + 1);
                }
            } else if (!itemname.equals("\u00a7ePage number") && !itemname.equals("\u00a77")) {
                ItemMeta meta = item.getItemMeta();
                NamespacedKey pos = new NamespacedKey((Plugin)DarkAuction.get(), "position");
                int pagenumber = Integer.parseInt((String)inv.getItem(this.getLoc(4, 2)).getItemMeta().getLore().get(0));
                player.getInventory().addItem(new ItemStack[]{item});
                player.sendMessage("\u00a7aItem gived!");
                this.openGiveListGui(player, pagenumber);
            }
        }
    }

    public static ItemStack createGuiItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(Arrays.asList(lore));
        item.setItemMeta(meta);
        return item;
    }
}

