/*
 * Decompiled with CFR 0.152.
 */
package mc.alessandroch.darkauction;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import mc.alessandroch.darkauction.EconomyHelper;
import mc.alessandroch.darkauction.HologramAPI;
import mc.alessandroch.darkauction.Offer;
import mc.alessandroch.darkauction.events.AuctionEndEvent;
import mc.alessandroch.darkauction.events.AuctionStartEvent;
import mc.alessandroch.darkauction.events.ModifyOfferEvent;
import mc.alessandroch.darkauction.events.NewOfferEvent;
import mc.alessandroch.darkauction.events.SetHologramAPIEvent;
import mc.alessandroch.darkauction.gui.GuiManager;
import mc.alessandroch.darkauction.itemsender.ItemSender;
import mc.alessandroch.darkauction.itemsender.ItemSender_1_13_R2;
import mc.alessandroch.darkauction.itemsender.ItemSender_1_14_R1;
import mc.alessandroch.darkauction.itemsender.ItemSender_1_15_R1;
import mc.alessandroch.darkauction.itemsender.ItemSender_1_16_R2;
import mc.alessandroch.darkauction.itemsender.ItemSender_1_16_R3;
import mc.alessandroch.darkauction.itemsender.ItemSender_1_17_R1;
import mc.alessandroch.darkauction.itemsender.ItemSender_1_18_R1;
import mc.alessandroch.darkauction.itemsender.ItemSender_1_18_R2;
import mc.alessandroch.darkauction.itemsender.ItemSender_1_19_R1;
import mc.alessandroch.darkauction.metrics.Metrics;
import mc.alessandroch.darkauction.updater.UpdateChecker;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class DarkAuction
extends JavaPlugin
implements Listener {
    public Location loc;
    public List<ItemStack> allItems = new ArrayList<ItemStack>();
    public ItemStack currentlyItem;
    private static DarkAuction instance;
    public boolean isStarted = false;
    public Economy econ = null;
    public int time = 3600;
    public int initialCost = 2000;
    public ItemSender itemSender;
    public String version = "beta1.3.3_3";
    public String apiversion = "v??";
    public String materialname = "";
    public UpdateChecker updater;
    public Sound sound;
    public List<Offer> offers = new ArrayList<Offer>();
    public GuiManager guiManager;
    public HologramAPI hologramAPI;
    public boolean debug = false;
    FileConfiguration config;
    Inventory inv = Bukkit.createInventory(null, (int)54, (String)"");

    public static DarkAuction get() {
        return instance;
    }

    public void onDisable() {
        if (this.hologramAPI == null) {
            return;
        }
        for (Player plr : this.getServer().getOnlinePlayers()) {
            this.itemSender.removeItem(plr, this.currentlyItem, this.loc);
        }
        this.save();
    }

    public void setUpMessages() {
        this.setup("MESSAGES.not-started-auction-msg", "&0Auction not started");
        this.inv = Bukkit.createInventory(null, (int)54, (String)this.getString("MESSAGES.not-started-auction-msg"));
        this.setup("MESSAGES.offer-msg-gui", "&cOffer");
        this.setup("MESSAGES.darkauction-prefix", "&9[DarkAuction]");
        this.setup("MESSAGES.remaining-time-msg", "&fRemaining ");
        this.setup("MESSAGES.dark-auction-endin", "&eAuction ends in ");
        this.setup("MESSAGES.no-money-for-offer", "&CYou do not have enough money to make the offer");
        this.setup("MESSAGES.no-money-for-raise-offer", "&cYou don't have enough money to raise the offer");
        this.setup("MESSAGES.initialOffer-hologram-msg", "Initial offer:");
        this.setup("MESSAGES.currentOffer-hologram-msg", "Current offer:");
        this.setup("MESSAGES.method-for-see-theitem-hologram-msg", "Run /openauction to see the item");
        this.setup("MESSAGES.auctionstarts-in-hologram-msg", "&fThe auction starts in");
        this.setup("MESSAGES.auctionend-winner", "The auction has ended! the winner is &e{playername} &f for offering &a${offer}");
        this.setup("MESSAGES.auctionend-nowinner", "The auction has ended! Nobody won the item because there were no bids!");
        this.setup("MESSAGES.auctionstartednew", "A new illegal auction has started!");
        this.setup("MESSAGES.newbid", "&c{playername}&f has bid &a${offer}&f for the auction item!");
        this.setup("MESSAGES.bidincreased", "&c{playername}&f has increased the bid to &a${offer}&f for the auction item!");
        this.setup("MESSAGES.currencysymbol", "$");
    }

    public String getString(String string) {
        return this.config.getString(string).replace("&", "\u00a7");
    }

    private void setup(String string, String string2) {
        File file = new File(this.getDataFolder(), "messages.yml");
        this.config = YamlConfiguration.loadConfiguration((File)file);
        if (this.config.get(string) == null) {
            this.config.set(string, (Object)string2);
            try {
                this.config.save(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean getItemEconomy() {
        if (this.getConfig().get("item-economy") == null) {
            this.getConfig().set("item-economy", (Object)false);
            this.getConfig().set("item-material-economy", (Object)Material.EMERALD.name());
            this.materialname = this.getConfig().getString("item-material-economy");
            this.saveConfig();
        }
        return this.getConfig().getBoolean("item-economy");
    }

    public Material getMaterialEco() {
        return Material.getMaterial((String)this.materialname);
    }

    public void onEnable() {
        this.itemSender = this.setupItemSender();
        this.updater = new UpdateChecker(this);
        if (this.itemSender == null) {
            return;
        }
        Metrics metrics = new Metrics(this, 12953);
        instance = this;
        if (!this.setupEconomy() && !this.getItemEconomy()) {
            this.getLogger().severe(String.format("[%s] - Disabled due to no Vault dependency found!", this.getDescription().getName()));
            this.getLogger().severe(String.format("If you are not using Vault, enable item economy from config!", new Object[0]));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (this.getItemEconomy()) {
            this.getLogger().info(String.format("Enabling with Item Based Economy ", new Object[0]));
            this.getLogger().info(String.format("This Economy is still in BETA", new Object[0]));
        } else {
            EconomyHelper.vaultversion = this.getServer().getPluginManager().getPlugin("Vault").getDescription().getVersion();
            this.getLogger().info(String.format("Enabling with Vault Economy system", new Object[0]));
        }
        SetHologramAPIEvent event = new SetHologramAPIEvent();
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.getAPI() != null) {
            this.hologramAPI = event.getAPI();
            try {
                event.getAPI().start();
            }
            catch (Exception e) {
                this.hologramAPI = null;
                this.getLogger().severe("Error while starting custom hologram system:");
                this.getLogger().severe(e.getMessage());
                this.disableCustom();
                return;
            }
        } else {
            this.hologramAPI = HologramAPI.newAPI();
            if (this.hologramAPI == null) {
                this.getLogger().severe(String.format("[%s] - Disabled due to no Holographic plugin dependency found!", this.getDescription().getName()));
                this.disableCustom();
                return;
            }
            this.hologramAPI.start();
        }
        this.setUpMessages();
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                if (DarkAuction.this.loc != null) {
                    DarkAuction.this.updateHologram();
                }
                if (!DarkAuction.this.isStarted) {
                    --DarkAuction.this.time;
                    DarkAuction.this.inv = Bukkit.createInventory(null, (int)54, (String)DarkAuction.this.getString("MESSAGES.not-started-auction-msg"));
                    DarkAuction.setupInv(DarkAuction.this.inv);
                    if (DarkAuction.this.time < 1) {
                        DarkAuction.this.startAuction();
                    }
                } else {
                    --DarkAuction.this.time;
                    DarkAuction.this.offerChecker();
                    DarkAuction.this.addOffering();
                    if (DarkAuction.this.time < 1) {
                        DarkAuction.this.finishAuction();
                    }
                }
            }
        }.runTaskTimer((Plugin)this, 20L, 20L);
        BukkitTask task2 = new BukkitRunnable(){

            public void run() {
                try {
                    DarkAuction.this.loadAll();
                    DarkAuction.this.updater.startUpdateCheck(null);
                    if (DarkAuction.this.loc != null && DarkAuction.this.isStarted) {
                        DarkAuction.this.itemSender.createItm(DarkAuction.this.currentlyItem, DarkAuction.this.loc);
                    }
                    for (Player plr : DarkAuction.this.getServer().getOnlinePlayers()) {
                        if (DarkAuction.this.loc == null || !DarkAuction.this.isStarted) continue;
                        DarkAuction.this.itemSender.sendItem(plr, DarkAuction.this.currentlyItem, DarkAuction.this.loc);
                    }
                    DarkAuction.setupInv(DarkAuction.this.inv);
                }
                catch (Exception e) {
                    e.getStackTrace();
                }
            }
        }.runTaskLaterAsynchronously((Plugin)this, 50L);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("darkauction").setExecutor((CommandExecutor)this);
        this.getCommand("openauction").setExecutor((CommandExecutor)this);
    }

    private ItemSender setupItemSender() {
        String version;
        ItemSender sender = null;
        try {
            version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        }
        catch (ArrayIndexOutOfBoundsException whatVersionAreYouUsingException) {
            this.getLogger().severe("Disabling DarkAuction cause:");
            this.getLogger().severe("Unable to get minecraft server version");
            this.getLogger().severe("Use at least v1_13_R2");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return null;
        }
        this.getLogger().info("Your server is running version " + version);
        if (version.equals("v1_20_R1")) {
            sender = new ItemSender_1_19_R1();
            this.apiversion = "v1_20_R1";
            this.sound = Sound.BLOCK_METAL_PRESSURE_PLATE_CLICK_ON;
        } else if (version.equals("v1_19_R4")) {
            sender = new ItemSender_1_19_R1();
            this.apiversion = "v1_19_R4";
            this.sound = Sound.BLOCK_METAL_PRESSURE_PLATE_CLICK_ON;
        } else if (version.equals("v1_19_R3")) {
            sender = new ItemSender_1_19_R1();
            this.apiversion = "v1_19_R3";
            this.sound = Sound.BLOCK_METAL_PRESSURE_PLATE_CLICK_ON;
        } else if (version.equals("v1_19_R2")) {
            sender = new ItemSender_1_19_R1();
            this.apiversion = "v1_19_R2";
            this.sound = Sound.BLOCK_METAL_PRESSURE_PLATE_CLICK_ON;
        } else if (version.equals("v1_19_R1")) {
            sender = new ItemSender_1_19_R1();
            this.apiversion = "v1_19_R1";
            this.sound = Sound.BLOCK_METAL_PRESSURE_PLATE_CLICK_ON;
        } else if (version.equals("v1_18_R2")) {
            sender = new ItemSender_1_18_R2();
            this.apiversion = "v1_18_R2";
            this.sound = Sound.BLOCK_METAL_PRESSURE_PLATE_CLICK_ON;
        } else if (version.equals("v1_18_R1")) {
            sender = new ItemSender_1_18_R1();
            this.apiversion = "v1_18_R1";
            this.sound = Sound.BLOCK_METAL_PRESSURE_PLATE_CLICK_ON;
        } else if (version.equals("v1_17_R1")) {
            sender = new ItemSender_1_17_R1();
            this.apiversion = "v1_17_R1";
            this.sound = Sound.BLOCK_METAL_PRESSURE_PLATE_CLICK_ON;
        } else if (version.equals("v1_16_R3")) {
            sender = new ItemSender_1_16_R3();
            this.apiversion = "v1_16_R3";
            this.sound = Sound.BLOCK_METAL_PRESSURE_PLATE_CLICK_ON;
        } else if (version.equals("v1_16_R2")) {
            sender = new ItemSender_1_16_R2();
            this.apiversion = "v1_16_R2";
            this.sound = Sound.BLOCK_METAL_PRESSURE_PLATE_CLICK_ON;
        } else if (version.equals("v1_15_R1")) {
            sender = new ItemSender_1_15_R1();
            this.apiversion = "v1_15_R1";
            this.sound = Sound.BLOCK_METAL_PRESSURE_PLATE_CLICK_ON;
        } else if (version.equals("v1_14_R1")) {
            sender = new ItemSender_1_14_R1();
            this.apiversion = "v1_14_R1";
            this.sound = Sound.BLOCK_METAL_PRESSURE_PLATE_CLICK_ON;
        } else if (version.equals("v1_13_R2")) {
            this.apiversion = "v1_13_R2";
            this.sound = Sound.ENTITY_EXPERIENCE_ORB_PICKUP;
            sender = new ItemSender_1_13_R2();
        } else {
            this.getLogger().severe("Version " + version + " isn't supported for ItemSender");
            this.getLogger().severe("Disabling DarkAuction cause:");
            this.getLogger().severe("Unsupported Minecraft version, please update to at least");
            this.getLogger().severe("version 1_13_R2 (1.13.2)");
            this.apiversion = version;
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return null;
        }
        this.guiManager = new GuiManager();
        return sender;
    }

    private void loadAll() {
        File file = new File(this.getDataFolder(), "config.yml");
        try {
            this.getConfig().load(file);
        }
        catch (Exception e) {
            return;
        }
        if (this.getConfig().get("isStarted") != null) {
            this.isStarted = this.getConfig().getBoolean("isStarted");
        }
        if (this.getConfig().get("time") != null) {
            this.time = this.getConfig().getInt("time");
        }
        if (this.getConfig().get("currentlyItem") != null) {
            this.currentlyItem = this.getConfig().getItemStack("currentlyItem");
        }
        if (this.getConfig().get("loc") != null) {
            this.loc = this.getConfig().getLocation("loc");
        }
        if (this.getConfig().get("allItems") != null) {
            this.allItems = this.getConfig().getList("allItems");
        }
        this.setUpMessages();
        if (this.getConfig().get("initialCost") == null) {
            this.getConfig().set("initialCost", (Object)2000);
            this.initialCost = this.getConfig().getInt("initialCost");
            this.saveConfig();
        } else {
            this.initialCost = this.getConfig().getInt("initialCost");
        }
        this.materialname = this.getConfig().getString("item-material-economy");
        if (this.getConfig().get("durationauction-in-seconds") == null) {
            this.getConfig().set("durationauction-in-seconds", (Object)300);
            this.saveConfig();
        }
        if (this.getConfig().get("startauction-in-seconds") == null) {
            this.getConfig().set("startauction-in-seconds", (Object)1200);
            this.time = this.getConfig().getInt("startauction-in-seconds");
            this.saveConfig();
        }
        if (this.getConfig().get("debug-mode") == null) {
            this.getConfig().set("debug-mode", (Object)this.debug);
            this.debug = this.getConfig().getBoolean("debug-mode");
        }
    }

    public void disableCustom() {
        this.setEnabled(false);
    }

    public void reload() {
        if (!this.isEnabled()) {
            try {
                this.setEnabled(true);
            }
            catch (Exception e) {
                this.disableCustom();
            }
        } else {
            File file = new File(this.getDataFolder(), "config.yml");
            try {
                this.getConfig().load(file);
                this.initialCost = this.getConfig().getInt("initialCost");
                this.materialname = this.getConfig().getString("item-material-economy");
                this.debug = this.getConfig().getBoolean("debug-mode");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InvalidConfigurationException e) {
                e.printStackTrace();
            }
            file = new File(this.getDataFolder(), "messages.yml");
            this.config = YamlConfiguration.loadConfiguration((File)file);
        }
    }

    public void save() {
        this.getConfig().set("isStarted", (Object)this.isStarted);
        this.getConfig().set("time", (Object)this.time);
        this.getConfig().set("currentlyItem", (Object)this.currentlyItem);
        this.getConfig().set("loc", (Object)this.loc);
        this.getConfig().set("allItems", this.allItems);
        this.getConfig().set("debug-mode", (Object)this.debug);
        this.saveConfig();
    }

    private void addOffering() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)DarkAuction.get(), () -> {
            Offer offer = this.getHigherOffer();
            double money = 0.0;
            if (offer == null) {
                money = this.initialCost;
            }
            if (offer != null) {
                money = offer.offer + (double)this.initialCost;
            }
            this.inv.setItem(4, this.currentlyItem);
            this.inv.setItem(5, this.makeTime());
            this.inv.setItem(31, DarkAuction.createGuiItem(Material.GOLD_INGOT, this.getString("MESSAGES.offer-msg-gui"), "\u00a7a" + money + this.getString("MESSAGES.currencysymbol")));
        });
    }

    private ItemStack makeTime() {
        int p1 = this.time % 60;
        int p2 = this.time / 60;
        int p3 = p2 % 60;
        return DarkAuction.createGuiItem(Material.CLOCK, String.valueOf(this.getString("MESSAGES.remaining-time-msg")) + " \u00a7f" + (p2 /= 60) + "h " + p3 + "m " + p1 + "s", new String[0]);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        ItemStack clickedItem = e.getCurrentItem();
        Inventory inventory = e.getInventory();
        if (clickedItem == null || clickedItem.getType().equals((Object)Material.AIR)) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        String name = "null";
        if (this.currentlyItem != null) {
            name = this.getName(this.currentlyItem);
        }
        double actualoffer = 0.0;
        Offer offer = this.getHigherOffer();
        if (offer != null) {
            actualoffer = offer.offer;
        }
        if (e.getView().getTitle().equals("\u00a70" + name) || e.getView().getTitle().equals(this.getString("MESSAGES.not-started-auction-msg"))) {
            e.setCancelled(true);
            p.playSound(p.getLocation(), this.sound, 1.0f, 1.0f);
            if (clickedItem.getItemMeta().getDisplayName().equals(this.getString("MESSAGES.offer-msg-gui"))) {
                this.makeAction(p, actualoffer + (double)this.initialCost);
            }
        } else if (this.guiManager.guinames.contains(e.getView().getTitle())) {
            e.setCancelled(true);
            p.playSound(p.getLocation(), this.sound, 1.0f, 1.0f);
            this.guiManager.guiClick(e.getView().getTitle(), p, clickedItem, inventory);
        }
    }

    protected static ItemStack createGuiItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(Arrays.asList(lore));
        item.setItemMeta(meta);
        return item;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String CommandLabel, String[] args) {
        Player player = (Player)sender;
        if (cmd.getName().equalsIgnoreCase("darkauction")) {
            if (args.length > 0) {
                if (args[0].equals("additem") && player.hasPermission("darkauction.admin")) {
                    this.allItems.add(new ItemStack(player.getInventory().getItemInMainHand().clone()));
                    player.sendMessage("\u00a7aItem added to auction");
                    return true;
                }
                if (args[0].equals("removeitem") && player.hasPermission("darkauction.admin")) {
                    if (args.length > 1) {
                        try {
                            int i = Integer.parseInt(args[1]);
                            this.allItems.remove(i);
                            player.sendMessage("\u00a7aItem removed! check the modified list with /darkauction info");
                        }
                        catch (Exception e) {
                            player.sendMessage("\u00a7cAn error occured. Are you sure you put a number or maybe the list is too short?");
                        }
                    } else {
                        player.sendMessage("\u00a7cUsage: /darkauction removeitem (number)");
                    }
                    return true;
                }
                if (args[0].equals("giveitem") && player.hasPermission("darkauction.admin")) {
                    if (args.length > 1) {
                        try {
                            int i = Integer.parseInt(args[1]);
                            ItemStack stack = this.allItems.get(i).clone();
                            player.getInventory().addItem(new ItemStack[]{stack});
                            player.sendMessage("\u00a7aItem gived!");
                        }
                        catch (Exception e) {
                            player.sendMessage("\u00a7cAn error occured. Are you sure you put a number or maybe the list is too short?");
                        }
                    } else {
                        player.sendMessage("\u00a7cUsage: /darkauction giveitem (number)");
                    }
                    return true;
                }
                if (args[0].equals("info") && player.hasPermission("darkauction.admin")) {
                    player.sendMessage("Items:");
                    int i = -1;
                    for (ItemStack stack : this.allItems) {
                        player.sendMessage("(" + ++i + ") " + this.getName(stack));
                    }
                    return true;
                }
                if (args[0].equals("setlocation") && player.hasPermission("darkauction.admin")) {
                    this.loc = player.getLocation();
                    player.sendMessage("Location changed");
                    return true;
                }
                if (args[0].equals("reload") && player.hasPermission("darkauction.admin")) {
                    this.reload();
                    player.sendMessage("Config and messages reloaded");
                    return true;
                }
                if (args[0].equals("forcestart") && player.hasPermission("darkauction.admin")) {
                    player.sendMessage("Force start...");
                    if (!this.isStarted) {
                        this.startAuction();
                    }
                    return true;
                }
                if (args[0].equals("forcestop") && player.hasPermission("darkauction.admin")) {
                    player.sendMessage("Force stop...");
                    if (this.isStarted) {
                        this.finishAuction();
                    }
                    return true;
                }
                if (args[0].equals("checkforupdate") && player.hasPermission("darkauction.admin")) {
                    player.sendMessage("DarkAuction Actual version is " + this.version);
                    this.updater.startUpdateCheck(player);
                    return true;
                }
                if (args[0].equals("gui") && player.hasPermission("darkauction.admin")) {
                    this.guiManager.openMainGui(player);
                    return true;
                }
                player.sendMessage("\u00a7cUnknown sub command. Type /darkauction for a list of sub commands.");
            } else {
                player.sendMessage("\u00a7eDarkAuction all sub commands:");
                player.sendMessage("\u00a7e/darkauction additem - Add into the random list the item in your hand");
                player.sendMessage("\u00a7e/darkauction removeitem (number)");
                player.sendMessage("\u00a7e/darkauction giveitem (number)");
                player.sendMessage("\u00a7e/darkauction info - Get the list of all the items in the random list");
                player.sendMessage("\u00a7e/darkauction setlocation - Set the hologram location in your position");
                player.sendMessage("\u00a7e/darkauction reload - Reload config and messages of the plugin");
                player.sendMessage("\u00a7e/darkauction forcestart");
                player.sendMessage("\u00a7e/darkauction forcestop");
                player.sendMessage("\u00a7e/darkauction checkforupdate");
                player.sendMessage("\u00a7e/darkauction gui - [BETA (Made in 1.16)] Open a gui management for darkauction");
            }
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("openauction")) {
            player.openInventory(this.inv);
            return true;
        }
        return false;
    }

    private String getName(ItemStack stack) {
        if (stack.getType().name() == null) {
            return "unknown";
        }
        if (stack.getItemMeta().getDisplayName().length() > 0) {
            return stack.getItemMeta().getDisplayName();
        }
        return stack.getType().name();
    }

    public void startAuction() {
        if (this.allItems.size() < 2) {
            return;
        }
        AuctionStartEvent event = new AuctionStartEvent();
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            this.isStarted = false;
            this.time = this.getConfig().getInt("startauction-in-seconds");
            return;
        }
        this.currentlyItem = this.allItems.get(new Random().nextInt(this.allItems.size() - 1));
        this.time = this.getConfig().getInt("durationauction-in-seconds");
        this.isStarted = true;
        this.notifyPlayers(String.valueOf(this.getString("MESSAGES.auctionstartednew")));
        if (this.loc != null) {
            this.itemSender.createItm(this.currentlyItem, this.loc);
        }
        for (Player plr : this.getServer().getOnlinePlayers()) {
            if (this.loc == null) continue;
            this.itemSender.sendItem(plr, this.currentlyItem, this.loc);
        }
        this.inv = Bukkit.createInventory(null, (int)54, (String)("\u00a70" + this.getName(this.currentlyItem)));
        DarkAuction.setupInv(this.inv);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player plr = event.getPlayer();
        if (this.loc != null && this.isStarted) {
            this.itemSender.sendItem(plr, this.currentlyItem, this.loc);
        }
        if (plr.hasPermission("darkauction.updatechecker")) {
            this.updater.startUpdateCheck(plr);
        }
    }

    public void notifyPlayers(String message) {
        for (Player plr : this.getServer().getOnlinePlayers()) {
            plr.sendMessage(String.valueOf(this.getString("MESSAGES.darkauction-prefix")) + "\u00a7f " + message);
        }
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        if (EconomyHelper.isOlder(EconomyHelper.vaultversion)) {
            RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
            if (rsp == null) {
                return false;
            }
            this.econ = (Economy)rsp.getProvider();
            this.getLogger().severe(String.format("You are using an old version of Vault that support Minecraft 1.12.2", new Object[0]));
            this.getLogger().severe(String.format("Make sure to use new Vault version!", new Object[0]));
            return this.econ != null;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.econ = (Economy)rsp.getProvider();
        return this.econ != null;
    }

    public void offerChecker() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)DarkAuction.get(), () -> {
            int i = 0;
            while (i < this.offers.size()) {
                Offer offer = this.offers.get(i);
                Player plr = this.getServer().getPlayer(offer.playername);
                if (plr == null || EconomyHelper.getMoney(offer.playername) < offer.offer) {
                    this.offers.remove(offer);
                }
                ++i;
            }
        });
    }

    public void finishAuction() {
        block7: {
            try {
                for (HumanEntity entity : this.inv.getViewers()) {
                    entity.closeInventory();
                }
            }
            catch (Exception e) {
                if (!this.debug) break block7;
                this.getLogger().severe("An error occured while closing inventory: " + e.getMessage());
            }
        }
        this.isStarted = false;
        this.time = this.getConfig().getInt("startauction-in-seconds");
        Offer offer = this.getHigherOffer();
        AuctionEndEvent event = new AuctionEndEvent(offer);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (offer != null) {
            String msg = this.getString("MESSAGES.auctionend-winner").replace("{playername}", offer.playername);
            msg = msg.replace("{offer}", "" + offer.offer);
            this.notifyPlayers(msg);
            Player player = this.getServer().getPlayer(offer.playername);
            if (!event.isCancelled()) {
                player.getInventory().addItem(new ItemStack[]{this.currentlyItem.clone()});
                EconomyHelper.withdraw(offer.playername, offer.offer);
            }
        } else {
            this.notifyPlayers(this.getString("MESSAGES.auctionend-nowinner"));
        }
        this.offers.clear();
        for (Player plr : this.getServer().getOnlinePlayers()) {
            if (this.loc == null) continue;
            this.itemSender.removeItem(plr, this.currentlyItem, this.loc);
        }
    }

    public void makeAction(Player plr, double prizenew) {
        if (!this.isStarted) {
            return;
        }
        if (!this.isStarted) {
            return;
        }
        if (!this.isStarted) {
            return;
        }
        if (!this.isStarted) {
            return;
        }
        if (!this.isStarted) {
            return;
        }
        Offer offer = this.getOffer(plr);
        if (offer == null) {
            if (EconomyHelper.getMoney(plr.getName()) >= prizenew) {
                offer = new Offer(plr.getName(), prizenew);
                NewOfferEvent event = new NewOfferEvent(offer);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.offers.add(offer);
                    if (this.time < 10) {
                        this.time = 10;
                    }
                }
            } else {
                plr.sendMessage(this.getString("MESSAGES.no-money-for-offer"));
            }
        } else {
            Offer off = this.getHigherOffer();
            if (off.offer != offer.offer) {
                if (EconomyHelper.getMoney(plr.getName()) >= prizenew) {
                    ModifyOfferEvent event = new ModifyOfferEvent(offer);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled()) {
                        offer.addOffer(prizenew);
                        if (this.time < 10) {
                            this.time = 10;
                        }
                    }
                } else {
                    plr.sendMessage(this.getString("MESSAGES.no-money-for-raise-offer"));
                }
            }
        }
    }

    public Offer getOffer(Player plr) {
        for (Offer offer : this.offers) {
            if (!offer.playername.equals(plr.getName())) continue;
            return offer;
        }
        return null;
    }

    public void updateHologram() {
        NumberFormat defaultFormat = NumberFormat.getCurrencyInstance();
        int p1 = this.time % 60;
        int p2 = this.time / 60;
        int p3 = p2 % 60;
        p2 /= 60;
        if (this.loc == null) {
            return;
        }
        this.hologramAPI.teleport(this.loc.clone().add(new Location(this.loc.getWorld(), 0.0, 0.75, 0.0)));
        this.hologramAPI.clearLines();
        if (this.isStarted) {
            this.hologramAPI.appendTextLine("\u00a7b" + this.getName(this.currentlyItem));
            if (this.offers.size() < 1) {
                this.hologramAPI.appendTextLine(String.valueOf(this.getString("MESSAGES.initialOffer-hologram-msg")) + " \u00a7a" + defaultFormat.format(this.initialCost) + this.getString("MESSAGES.currencysymbol"));
            } else {
                Offer offer = this.getHigherOffer();
                this.hologramAPI.appendTextLine(String.valueOf(this.getString("MESSAGES.currentOffer-hologram-msg")) + " \u00a7a" + defaultFormat.format(offer.offer) + this.getString("MESSAGES.currencysymbol"));
                this.hologramAPI.appendTextLine("\u00a76" + offer.playername);
            }
            this.hologramAPI.appendTextLine(String.valueOf(this.getString("MESSAGES.dark-auction-endin")) + " \u00a7e" + p2 + "h " + p3 + "m " + p1 + "s");
            this.hologramAPI.appendTextLine("\u00a7e" + this.getString("MESSAGES.method-for-see-theitem-hologram-msg"));
        } else if (this.time < 0) {
            if (this.debug) {
                this.hologramAPI.appendTextLine("\u00a7cAn error occured? DarkAuction seem to not start the auction...");
                this.hologramAPI.appendTextLine("\u00a7cTry to see if the auction list is empty");
                this.hologramAPI.appendTextLine("\u00a7cAnd make sure the list is not lower than 2/3 items");
            } else {
                this.hologramAPI.appendTextLine("\u00a7cAn error occured while starting...");
            }
        } else {
            this.hologramAPI.appendTextLine(String.valueOf(this.getString("MESSAGES.auctionstarts-in-hologram-msg")) + " \u00a7e" + p2 + "h " + p3 + "m " + p1 + "s");
        }
    }

    public Offer getHigherOffer() {
        double actual = 0.0;
        Offer selected = null;
        for (Offer offer : this.offers) {
            if (!(offer.offer > actual)) continue;
            actual = offer.offer;
            selected = offer;
        }
        return selected;
    }

    public static void setupInv(Inventory inv) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)DarkAuction.get(), () -> {
            int i = 0;
            while (i < inv.getSize()) {
                inv.setItem(i, GuiManager.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, "\u00a77", new String[0]));
                ++i;
            }
        });
    }
}

