/*
 * Decompiled with CFR 0.152.
 */
package com.github.onyxiansoul.damagepotioneffects.utils;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.PluginManager;

public class MessageUtil {
    private static final ConsoleCommandSender CONSOLE_SENDER = Bukkit.getConsoleSender();
    private static final String WARNING_PREFIX = System.lineSeparator() + ChatColor.GOLD + "[WARNING][DamagePotionEffects] ";
    private static final String ERROR_PREFIX = System.lineSeparator() + ChatColor.RED + "[ERROR][DamagePotionEffects] ";
    private static final String ERROR_SUFIX = System.lineSeparator() + ChatColor.RED + "Disabling DamagePotionEffects!";
    private static boolean debugEnabled = false;

    public static void sendWarning(String warningMessage) {
        CONSOLE_SENDER.sendMessage(WARNING_PREFIX + warningMessage);
    }

    public static void sendWarning(Exception e) {
        String warningMessage = MessageUtil.getFormattedException(e);
        MessageUtil.sendWarning(warningMessage);
    }

    public static void errorDisable(String errorMessage) {
        CONSOLE_SENDER.sendMessage(ERROR_PREFIX + errorMessage + ERROR_SUFIX);
        PluginManager pluginManager = Bukkit.getServer().getPluginManager();
        pluginManager.disablePlugin(pluginManager.getPlugin("DamagePotionEffects"));
    }

    public static void errorDisable(Exception e) {
        String errorMessage = MessageUtil.getFormattedException(e);
        MessageUtil.errorDisable(errorMessage);
    }

    private static String getFormattedException(Throwable ex) {
        StringBuilder sb = new StringBuilder();
        if (ex.getMessage() != null) {
            sb.append(ex.getMessage());
        } else {
            sb.append(ex.getClass().getSimpleName());
        }
        sb.append(" ");
        if (debugEnabled) {
            sb.append(System.lineSeparator());
            sb.append(ChatColor.GOLD);
            sb.append("-------------------------------------");
            sb.append(System.lineSeparator());
            sb.append(ChatColor.DARK_GRAY);
            sb.append(ex.getClass().getName());
            sb.append(System.lineSeparator());
            for (StackTraceElement element : ex.getStackTrace()) {
                sb.append(" at: ");
                sb.append(element);
                sb.append(System.lineSeparator());
            }
            sb.append(ChatColor.GOLD);
            sb.append("-------------------------------------");
        }
        if (ex.getCause() != null) {
            sb.append(System.lineSeparator());
            sb.append("Caused By: ");
            sb.append(ChatColor.GOLD);
            sb.append(System.lineSeparator());
            sb.append(MessageUtil.getFormattedException(ExceptionUtils.getCause((Throwable)ex)));
        } else {
            sb.append(System.lineSeparator());
            sb.append("---------------------------------------------------------");
        }
        return sb.toString();
    }

    public static void setDebug(boolean debug) {
        debugEnabled = debug;
    }
}

