/*
 * Decompiled with CFR 0.152.
 */
package com.github.onyxiansoul.damagepotioneffects.utils;

import com.google.common.collect.LinkedHashMultimap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;

public final class ConfigurationUtil {
    public static String getSectionName(ConfigurationSection configSection) {
        String sectionPath = configSection.getCurrentPath();
        if (sectionPath.equals("")) {
            sectionPath = "MAIN_CONFIG_SECTION";
        }
        return sectionPath;
    }

    public static String getHumanFieldName(String fieldName) {
        String[] fieldWords = StringUtils.splitByCharacterTypeCamelCase((String)fieldName);
        StringBuilder humanNameBuilder = new StringBuilder();
        for (String word : fieldWords) {
            humanNameBuilder.append(word.toLowerCase());
            humanNameBuilder.append(" ");
        }
        humanNameBuilder.deleteCharAt(humanNameBuilder.length() - 1);
        return humanNameBuilder.toString();
    }

    public static boolean isLocalReferenceAttempt(String stringToCheck) {
        String homogeniezedStringToCheck = StringUtils.strip((String)stringToCheck.toUpperCase());
        return homogeniezedStringToCheck.startsWith("(LOCAL:") && homogeniezedStringToCheck.endsWith(")");
    }

    public static boolean isCopyAttempt(String stringToCheck) {
        String homogeniezedStringToCheck = StringUtils.strip((String)stringToCheck.toUpperCase());
        return homogeniezedStringToCheck.startsWith("(COPY:") && homogeniezedStringToCheck.endsWith(")");
    }

    private ConfigurationUtil() {
    }

    public static LinkedHashMultimap<String, LinkedHashMultimap<String, Object>> transformSectionToMap(ConfigurationSection configSection) {
        LinkedHashMultimap nameValuesMap = LinkedHashMultimap.create();
        LinkedHashMultimap multimapEquivalent = LinkedHashMultimap.create();
        nameValuesMap.put((Object)configSection.getName(), (Object)multimapEquivalent);
        for (Map.Entry entry : configSection.getValues(false).entrySet()) {
            String entryKey = (String)entry.getKey();
            Object valueToPut = entry.getValue();
            if (valueToPut instanceof ConfigurationSection) {
                ConfigurationSection valueToPutAsSection = (ConfigurationSection)valueToPut;
                LinkedHashMultimap<String, LinkedHashMultimap<String, Object>> valueToPutSectionAsMap = ConfigurationUtil.transformSectionToMap(valueToPutAsSection);
                valueToPut = valueToPutSectionAsMap.get((Object)entryKey);
            }
            multimapEquivalent.put((Object)((String)entry.getKey()), valueToPut);
        }
        return nameValuesMap;
    }
}

