/*
 * Decompiled with CFR 0.152.
 */
package com.github.onyxiansoul.damagepotioneffects.utils;

import com.github.onyxiansoul.damagepotioneffects.configuration.configurable.structural.Creator;
import com.google.common.collect.LinkedListMultimap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;

public class CollectionUtils {
    public static LinkedList<Map.Entry<String, Object>> createNamedListFromMap(Map<String, Object> baseMap) {
        LinkedList<Map.Entry<String, Object>> namedList = new LinkedList<Map.Entry<String, Object>>();
        namedList.addAll(baseMap.entrySet());
        for (Map.Entry entry : namedList) {
            if (!(entry.getValue() instanceof ConfigurationSection)) continue;
            ConfigurationSection entryAsConfigurationSection = (ConfigurationSection)entry.getValue();
            entry.setValue(CollectionUtils.createNamedListFromMap(entryAsConfigurationSection.getValues(false)));
        }
        return namedList;
    }

    public static <K, V> HashMap<K, V> safelyCastMap(Map mapToCast, Class<K> keyClass, Class<V> valueClass) {
        Set entriesToCast = mapToCast.entrySet();
        HashMap<K, V> newMap = new HashMap<K, V>();
        for (Map.Entry entry : entriesToCast) {
            K key = keyClass.cast(entry.getKey());
            V value = valueClass.cast(entry.getValue());
            newMap.put(key, value);
        }
        return newMap;
    }

    public static <K, V1 extends Creator<V2>, V2> LinkedListMultimap<K, V2> getMapWithCreatedsValues(LinkedListMultimap<K, V1> creatablesMap) {
        LinkedListMultimap createdsMap = LinkedListMultimap.create();
        Set keys = creatablesMap.keySet();
        for (Object key : keys) {
            List creators = creatablesMap.get(key);
            for (Creator v1 : creators) {
                createdsMap.put(key, v1.create());
            }
        }
        return createdsMap;
    }
}

